/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dom;

import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.composant.IWComposant;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.src.ISrcNode;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XString;
import eu.scenari.fw.log.LogMgr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ZXPathIdNode
extends ZXPath {
    protected Expression fArgNode = null;

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum != 1) {
            throw new WrongNumberArgsException("1");
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        if (0 != pArgNum) {
            throw new WrongNumberArgsException("1");
        }
        this.fArgNode = pArg;
    }

    public XObject xExecute(XPathContext pCtx) throws Exception {
        ISrcNode vSource = null;
        IWUnivers vUnivers = null;
        Object vObjContext = null;
        XObject vXObjContext = pCtx.getVariable(QNAME_VCOMP);
        if (vXObjContext != null) {
            IWComposant vComp = (IWComposant)vXObjContext.object();
            vObjContext = vComp;
            vUnivers = vComp.hGetUnivers();
            vSource = vComp.hGetDocSource();
        } else {
            vXObjContext = pCtx.getVariable(QNAME_VAGENT);
            if (vXObjContext != null) {
                vObjContext = vXObjContext.object();
                vUnivers = ((IWAgent)vObjContext).hGetInstance().hGetPrescription().hGetUnivers();
                vSource = ((IWAgent)vObjContext).hGetComposant().hGetDocSource();
            } else {
                throw LogMgr.newException("Cette fonction XPath doit \u00eatre utilis\u00e9e dans un contexte de niveau 'statique' ou 'dynamique' disposant d'un param\u00e8tre 'vComp' ou 'vAgent'.", new String[0]);
            }
        }
        XObject vXObj = this.fArgNode.execute(pCtx);
        Node vNode = vXObj.nodeset().nextNode();
        if (vNode != null) {
            String vResult = ZXPathIdNode.xGetId(vNode, vSource, vUnivers, vObjContext);
            return new XString(vResult);
        }
        return XString.EMPTYSTRING;
    }

    public static String xGetId(Node pNode, ISrcNode pSource, IWUnivers pUnivers, Object pObjContext) throws Exception {
        String vResult = pUnivers.hGetContenuMgr().hGetIdSrcFromUri(pSource.getSrcUri(), pObjContext);
        String vId = null;
        if (pNode.getNodeType() == 1 && pNode.getOwnerDocument().getDocumentElement() != pNode && (vId = ((Element)pNode).getAttribute("id")) != null) {
            StringBuilder vBuf = new StringBuilder(vResult.length() + vId.length() + 2);
            vBuf.append(vResult).append('_').append('N').append(vId);
            vResult = vBuf.toString();
        }
        if (vId == null) {
            int vCount = 0;
            Node vPrec = pNode;
            Element vRoot = pNode.getOwnerDocument().getDocumentElement();
            while (vPrec != null && vPrec != vRoot) {
                ++vCount;
                if (vPrec.getPreviousSibling() != null) {
                    vPrec = vPrec.getPreviousSibling();
                    while (vPrec.hasChildNodes()) {
                        vPrec = vPrec.getLastChild();
                    }
                    continue;
                }
                vPrec = vPrec.getParentNode();
            }
            if (vCount != 0) {
                StringBuilder vBuf = new StringBuilder(vResult.length() + 10);
                vBuf.append(vResult).append('_').append(HCharSeqUtil.hGetIntToString(vCount));
                vResult = vBuf.toString();
            }
        }
        return vResult;
    }
}

