/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dom;

import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.s.fw.util.xml.HEncodingXml;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XString;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.pools.PoolBuffers;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class ZXPathListXml
extends ZXPath {
    public static TracePoint sTrace = TraceMgr.register(ZXPathListXml.class.getName());
    protected Expression fArgList = null;
    protected Expression fArgPrefix = null;
    protected Expression fArgSuffix = null;

    public static void parseList(String pXmlList, List pListToAppend) {
        int vBegin = pXmlList.indexOf("<item>") + 6;
        int vEnd = pXmlList.indexOf("</item>", vBegin > 0 ? vBegin : 0);
        while (vBegin >= 6 && vEnd > vBegin) {
            pListToAppend.add(pXmlList.substring(vBegin, vEnd));
            vBegin = pXmlList.indexOf("<item>", vEnd + 6) + 6;
            vEnd = pXmlList.indexOf("</item>", vBegin > 0 ? vBegin : 0);
        }
    }

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum == 0 || pArgNum > 3) {
            throw new WrongNumberArgsException("1, 2 or 3");
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        if (0 == pArgNum) {
            this.fArgList = pArg;
        } else if (1 == pArgNum) {
            this.fArgPrefix = pArg;
        } else if (2 == pArgNum) {
            this.fArgSuffix = pArg;
        } else {
            throw new WrongNumberArgsException("1, 2 or 3");
        }
    }

    public XObject xExecute(XPathContext pXPathCtx) throws Exception {
        XObject vList;
        XString vResult = null;
        String vContentNode = null;
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        vBuf.append("<liste>");
        String vPrefix = "";
        if (this.fArgPrefix != null) {
            vPrefix = this.fArgPrefix.execute(pXPathCtx).str();
        }
        String vSuffix = "";
        if (this.fArgSuffix != null) {
            vSuffix = this.fArgSuffix.execute(pXPathCtx).str();
        }
        if ((vList = this.fArgList.execute(pXPathCtx)).getType() == 4) {
            NodeIterator vIt = ((XNodeSet)vList).nodeset();
            Node vNode = vIt.nextNode();
            while (vNode != null) {
                vContentNode = DOMHelper.getNodeData(vNode);
                if (vContentNode != null) {
                    vBuf.append("<item>");
                    HEncodingXml.hWriteTextValue(vBuf, vPrefix);
                    HEncodingXml.hWriteTextValue(vBuf, vContentNode);
                    HEncodingXml.hWriteTextValue(vBuf, vSuffix);
                    vBuf.append("</item>");
                }
                vNode = vIt.nextNode();
            }
            vIt.detach();
        }
        vBuf.append("</liste>");
        vResult = new XString(vBuf.substring(0));
        if (sTrace.isEnabled()) {
            sTrace.publishDebug("XPath List = '" + vResult + "'.", new String[0]);
        }
        PoolBuffers.freeStringBuilder(vBuf);
        return vResult;
    }
}

