/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dom;

import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.IWServiceAvecResultat;
import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XNumber;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XString;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class ZXPathMax
extends ZXPath {
    public static TracePoint sTrace = TraceMgr.register(ZXPathMax.class.getName());
    protected List fListParam = new ArrayList(3);

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum == 0) {
            throw new WrongNumberArgsException("1 or more");
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        this.fListParam.add(pArg);
    }

    public XObject xExecute(XPathContext pCtx) throws Exception {
        IHDialog vDialog = null;
        double vMax = Double.NEGATIVE_INFINITY;
        double vCurentDouble = Double.MIN_VALUE;
        if (this.fListParam != null) {
            for (int i = 0; i < this.fListParam.size(); ++i) {
                XObject vXObj = ((Expression)this.fListParam.get(i)).execute(pCtx);
                vCurentDouble = Double.MIN_VALUE;
                if (vXObj != null) {
                    if (vXObj instanceof XNodeSet) {
                        NodeIterator vIt = ((XNodeSet)vXObj).nodeset();
                        Node vNode = vIt.nextNode();
                        while (vNode != null) {
                            String vVal;
                            if (vNode instanceof IWAgentComputor) {
                                if (vDialog == null) {
                                    vDialog = this.wGetDialogFromCtx(pCtx);
                                }
                                vVal = ((IWAgentComputor)((Object)vNode)).computeAsString(vDialog, null);
                                vCurentDouble = XString.castToNum(vVal);
                            } else {
                                vVal = ZXPathMax.hGetNodeToString(vNode);
                                vCurentDouble = XString.castToNum(vVal);
                            }
                            if (vCurentDouble > vMax) {
                                vMax = vCurentDouble;
                            }
                            vNode = vIt.nextNode();
                        }
                    } else if (vXObj instanceof XNumber) {
                        vCurentDouble = ((XNumber)vXObj).num();
                    } else {
                        String vVal;
                        Object vObj = vXObj.object();
                        if (vObj instanceof IWAgentComputor) {
                            if (vDialog == null) {
                                vDialog = this.wGetDialogFromCtx(pCtx);
                            }
                            vVal = ((IWAgentComputor)vObj).computeAsString(vDialog, null);
                            vCurentDouble = XString.castToNum(vVal);
                        } else if (vObj instanceof IWServiceAvecResultat) {
                            if (vDialog == null) {
                                vDialog = this.wGetDialogFromCtx(pCtx);
                            }
                            vVal = ((IWServiceAvecResultat)vObj).hGetResultat(vDialog, null).getString();
                            vCurentDouble = XString.castToNum(vVal);
                        } else {
                            vCurentDouble = XString.castToNum(vObj.toString());
                        }
                    }
                }
                if (!(vCurentDouble > vMax)) continue;
                vMax = vCurentDouble;
            }
        }
        if (!Double.isInfinite(vMax)) {
            if (sTrace.isEnabled()) {
                LogMgr.publishTrace("XPath Max result : " + vMax, new String[0]);
            }
            return new XNumber(vMax);
        }
        if (sTrace.isEnabled()) {
            LogMgr.publishTrace("XPath Max result : NaN", new String[0]);
        }
        return NUMBER_NAN;
    }
}

