/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dom;

import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.IWServiceAvecResultat;
import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XNumber;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XString;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class ZXPathSomme
extends ZXPath {
    public static TracePoint sTrace = TraceMgr.register(ZXPathSomme.class.getName(), "Trace la fonction XPath qui calcule une somme.");
    protected List fListParam = new ArrayList(3);

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum == 0) {
            throw new WrongNumberArgsException("1 or more");
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        this.fListParam.add(pArg);
    }

    public XObject xExecute(XPathContext pCtx) throws Exception {
        double vSum = 0.0;
        IHDialog vDialog = null;
        int vCount = 0;
        if (this.fListParam != null) {
            for (int i = 0; i < this.fListParam.size(); ++i) {
                String vVal;
                XObject vXObj = ((Expression)this.fListParam.get(i)).execute(pCtx);
                if (vXObj == null) continue;
                if (vXObj instanceof XNodeSet) {
                    NodeIterator vIt = ((XNodeSet)vXObj).nodeset();
                    Node vNode = vIt.nextNode();
                    while (vNode != null) {
                        String vVal2;
                        if (vNode instanceof IWAgentComputor) {
                            if (vDialog == null) {
                                vDialog = this.wGetDialogFromCtx(pCtx);
                            }
                            vVal2 = ((IWAgentComputor)((Object)vNode)).computeAsString(vDialog, null);
                            vSum += XString.castToNum(vVal2);
                            ++vCount;
                        } else {
                            vVal2 = ZXPathSomme.hGetNodeToString(vNode);
                            vSum += XString.castToNum(vVal2);
                            ++vCount;
                        }
                        vNode = vIt.nextNode();
                    }
                    continue;
                }
                if (vXObj instanceof XNumber) {
                    vSum += ((XNumber)vXObj).num();
                    ++vCount;
                    continue;
                }
                Object vObj = vXObj.object();
                if (vObj instanceof IWAgentComputor) {
                    if (vDialog == null) {
                        vDialog = this.wGetDialogFromCtx(pCtx);
                    }
                    vVal = ((IWAgentComputor)vObj).computeAsString(vDialog, null);
                    vSum += XString.castToNum(vVal);
                    ++vCount;
                    continue;
                }
                if (vObj instanceof IWServiceAvecResultat) {
                    if (vDialog == null) {
                        vDialog = this.wGetDialogFromCtx(pCtx);
                    }
                    vVal = ((IWServiceAvecResultat)vObj).hGetResultat(vDialog, null).getString();
                    vSum += XString.castToNum(vVal);
                    ++vCount;
                    continue;
                }
                vSum += XString.castToNum(vObj.toString());
                ++vCount;
            }
        }
        if (vCount > 0) {
            if (sTrace.isEnabled()) {
                sTrace.publishDebug("XPath Resultat de la somme sur " + vCount + " items : " + vSum, new String[0]);
            }
            return new XNumber(vSum);
        }
        if (sTrace.isEnabled()) {
            sTrace.publishDebug("XPath Resultat de la somme : 0 (aucun item trouv\u00e9). CurrentNode=" + pCtx.getCurrentNode(), new String[0]);
        }
        return new XNumber(0.0);
    }
}

