/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dtm;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.agent.IWAgentLinker;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.IWSDialog;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.xpath.dtm.XAgent;
import com.scenari.xsldtm.xml.utils.QName;
import com.scenari.xsldtm.xpath.Expression;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.compiler.FuncLoader;
import com.scenari.xsldtm.xpath.compiler.FunctionTable;
import com.scenari.xsldtm.xpath.functions.Function;
import com.scenari.xsldtm.xpath.objects.XNull;
import com.scenari.xsldtm.xpath.objects.XNumber;
import com.scenari.xsldtm.xpath.objects.XObject;
import eu.scenari.fw.log.LogMgr;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public abstract class ZXPath
extends Function {
    public static final QName QNAME_VDIALOG = QName.getQNameFromString("vDialog");
    public static final QName QNAME_VAGENT = QName.getQNameFromString("vAgent");
    public static final QName QNAME_VSERVICE = QName.getQNameFromString("vService");
    public static final QName QNAME_VARGUMENTS = QName.getQNameFromString("vArguments");
    public static final XNumber NUMBER_NAN = new XNumber(Double.NaN);
    public static final XNull XOBJECT_NULL = new XNull();
    private static final long serialVersionUID = -1097989806212570434L;
    private int fIdxDefaultDialog = 0;
    private int fIdxDefaultAgentService = 0;

    public static synchronized void hInstallFunction(String pName, Expression pFunc) {
        int vFuncId = FunctionTable.installFunction(pName, pFunc);
        FunctionTable.m_functions[vFuncId] = new XFuncLoader(pFunc.getClass().getName(), vFuncId);
    }

    public static final double hGetStringToNumber(String pString) {
        double vResult = Double.NaN;
        if (null == pString) {
            vResult = 0.0;
        } else {
            try {
                vResult = Double.valueOf(pString.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return vResult;
    }

    public XObject execute(XPathContext pCtx) throws TransformerException {
        try {
            XObject vResult = this.xExecute(pCtx);
            return vResult == null ? XOBJECT_NULL : vResult;
        }
        catch (Exception e) {
            XObject vObjDial = null;
            if (!this.wIsUseDefaultDialog() || (vObjDial = pCtx.getVarStack().getGlobalVariable(pCtx, this.fIdxDefaultDialog)) != null) {
                LogMgr.addMessage((Throwable)e, "Echec au calcul d'une fonction XPath dans le dialogue " + vObjDial, new String[0]);
            }
            throw (TransformerException)LogMgr.addMessage(new TransformerException("Echec \u00e0 l'execution d'une fonction XPath (dtm) : " + this.getClass().getName()), LogMgr.getMessage(e));
        }
    }

    public IWAgent wGetAgent(XPathContext pCtx, XObject pXObj) throws Exception {
        if (pXObj == null) {
            return null;
        }
        if (pXObj.getType() == 0) {
            Object vObj = pXObj.object();
            if (vObj instanceof XAgent) {
                return ((XAgent)vObj).fAgent;
            }
            if (vObj instanceof IWAgent) {
                return (IWAgent)vObj;
            }
        }
        return null;
    }

    public IWAgent wGetRefAgent(XPathContext pCtx, XObject pXObj) throws Exception {
        if (pXObj == null) {
            return null;
        }
        switch (pXObj.getType()) {
            case 3: {
                String vPath = pXObj.str();
                return this.wGetAgentFromCtx(pCtx).hGetAgentParRef(vPath);
            }
            case 0: {
                Object vObj = pXObj.object();
                if (vObj instanceof XAgent) {
                    return ((XAgent)vObj).fAgent;
                }
                if (vObj instanceof IWAgent) {
                    return (IWAgent)vObj;
                }
                if (vObj instanceof IWADialog) {
                    return ((IWADialog)vObj).hGetAgent();
                }
                if (!(vObj instanceof String)) break;
                return this.wGetAgentFromCtx(pCtx).hGetAgentParRef((String)vObj);
            }
        }
        return null;
    }

    public IWAgent wGetRefAgentDefault(XPathContext pCtx, XObject pXObj) throws Exception {
        IWAgent vAgent = this.wGetRefAgent(pCtx, pXObj);
        if (vAgent == null) {
            vAgent = this.wGetAgentFromCtx(pCtx);
        }
        return vAgent;
    }

    public IWAgentLinker wGetRefAgentAvecLiens(XPathContext pCtx, XObject pXObj) throws Exception {
        IWAgent vAgent;
        for (vAgent = this.wGetRefAgent(pCtx, pXObj); vAgent != null && !(vAgent instanceof IWAgentLinker); vAgent = vAgent.hGetAgentPere()) {
        }
        return (IWAgentLinker)((Object)vAgent);
    }

    public IWAgentComputor wGetRefAgentAvecResultat(XPathContext pCtx, XObject pXObj) throws Exception {
        IWAgent vAgent;
        for (vAgent = this.wGetRefAgent(pCtx, pXObj); vAgent != null && !(vAgent instanceof IWAgentComputor); vAgent = vAgent.hGetAgentPere()) {
        }
        return (IWAgentComputor)((Object)vAgent);
    }

    public IHDialog wGetDialog(XPathContext pCtx, XObject pXObj) throws Exception {
        Object vObj;
        if (pXObj == null) {
            return null;
        }
        if (pXObj.getType() == 0 && (vObj = pXObj.object()) != null && vObj instanceof IHDialog) {
            return (IHDialog)vObj;
        }
        return null;
    }

    public IHDialog wGetRefDialog(XPathContext pCtx, XObject pXObj) throws Exception {
        if (pXObj == null) {
            return null;
        }
        switch (pXObj.getType()) {
            case 3: {
                String vPath = pXObj.str();
                return this.wGetDialogFromCtx(pCtx).hGoTo(vPath);
            }
            case 0: {
                Object vObj = pXObj.object();
                if (vObj != null && vObj instanceof IHDialog) {
                    return (IHDialog)vObj;
                }
                return null;
            }
        }
        return null;
    }

    public IHDialog wGetRefDialogDefault(XPathContext pCtx, XObject pXObj) throws Exception {
        IHDialog vDialog = this.wGetRefDialog(pCtx, pXObj);
        if (vDialog == null) {
            vDialog = this.wGetDialogFromCtx(pCtx);
        }
        return vDialog;
    }

    public IWService wGetService(XPathContext pCtx, XObject pXObj) throws Exception {
        Object vObj;
        if (pXObj == null) {
            return null;
        }
        if (pXObj.getType() == 0 && (vObj = pXObj.object()) instanceof IWService) {
            return (IWService)vObj;
        }
        return null;
    }

    public IWService wGetRefService(XPathContext pCtx, XObject pXObj) throws Exception {
        if (pXObj == null) {
            return null;
        }
        switch (pXObj.getType()) {
            case 3: {
                String vPath = pXObj.str();
                IHDialog vResDialog = this.wGetDialogFromCtx(pCtx).hGoTo(vPath);
                if (vResDialog != null && vResDialog instanceof IWSDialog) {
                    return ((IWSDialog)vResDialog).hGetService();
                }
            }
            case 0: {
                IHDialog vResDialog;
                Object vObj = pXObj.object();
                if (vObj instanceof IWService) {
                    return (IWService)vObj;
                }
                if (vObj instanceof IWSDialog) {
                    return ((IWSDialog)vObj).hGetService();
                }
                if (!(vObj instanceof String) || (vResDialog = this.wGetDialogFromCtx(pCtx).hGoTo((String)vObj)) == null || !(vResDialog instanceof IWSDialog)) break;
                return ((IWSDialog)vResDialog).hGetService();
            }
        }
        return null;
    }

    public IWService wGetRefServiceDefault(XPathContext pCtx, XObject pXObj) throws Exception {
        IWService vService = this.wGetRefService(pCtx, pXObj);
        if (vService == null) {
            vService = this.wGetServiceFromCtx(pCtx);
        }
        return vService;
    }

    public int wGetAsNode(XPathContext pCtx, XObject pXObj) throws Exception {
        return pXObj == null ? pCtx.getContextNode() : pXObj.asNode(pCtx);
    }

    public double wGetAsNumber(XPathContext pCtx, XObject pXObj) throws Exception {
        return pXObj == null ? NUMBER_NAN.num() : pXObj.num();
    }

    public String wGetAsString(XPathContext pCtx, XObject pXObj) throws Exception {
        return pXObj == null ? "" : pXObj.str();
    }

    public IHDialog wGetDialogFromCtx(XPathContext pCtx) throws Exception {
        XObject vObjDial = pCtx.getVarStack().getGlobalVariable(pCtx, this.fIdxDefaultDialog);
        if (vObjDial == null) {
            throw LogMgr.newException("Cette fonction XPath doit \u00eatre utilis\u00e9e dans un contexte de niveau 'dynamique' disposant d'un param\u00e8tre 'vDialog'.", new String[0]);
        }
        return (IHDialog)vObjDial.object();
    }

    public IWAgent wGetAgentFromCtx(XPathContext pCtx) throws Exception {
        XObject vObjAgt = pCtx.getVarStack().getGlobalVariable(pCtx, this.fIdxDefaultAgentService);
        if (vObjAgt == null) {
            throw LogMgr.newException("Cette fonction XPath doit \u00eatre utilis\u00e9e dans un contexte de niveau 'dynamique' disposant d'un param\u00e8tre 'vAgent'.", new String[0]);
        }
        return ((XAgent)vObjAgt.object()).fAgent;
    }

    public IWService wGetServiceFromCtx(XPathContext pCtx) throws Exception {
        XObject vObjServ = pCtx.getVarStack().getGlobalVariable(pCtx, this.fIdxDefaultAgentService);
        if (vObjServ == null) {
            throw LogMgr.newException("Cette fonction XPath doit \u00eatre utilis\u00e9e dans un contexte disposant d'un param\u00e8tre 'vService'.", new String[0]);
        }
        return (IWService)vObjServ.object();
    }

    public abstract XObject xExecute(XPathContext var1) throws Exception;

    public void fixupVariables(Vector pVars, int pGlobalsSize) {
        boolean vUseDialog = this.wIsUseDefaultDialog();
        boolean vUseAgent = this.wIsUseDefaultAgent();
        boolean vUseService = this.wIsUseDefaultService();
        int vFind = (vUseDialog ? 1 : 0) + (vUseAgent || vUseService ? 1 : 0);
        if (vFind > 0) {
            for (int i = pGlobalsSize - 1; i >= 0 && vFind > 0; --i) {
                QName vQName = (QName)pVars.elementAt(i);
                if (vUseDialog && vQName.equals(QNAME_VDIALOG)) {
                    this.fIdxDefaultDialog = i;
                    --vFind;
                }
                if (vUseAgent && vQName.equals(QNAME_VAGENT)) {
                    this.fIdxDefaultAgentService = i;
                    --vFind;
                }
                if (!vUseService || !vQName.equals(QNAME_VSERVICE)) continue;
                this.fIdxDefaultAgentService = i;
                --vFind;
            }
        }
    }

    protected boolean wIsUseDefaultDialog() {
        return false;
    }

    protected boolean wIsUseDefaultAgent() {
        return false;
    }

    protected boolean wIsUseDefaultService() {
        return false;
    }

    public static class XFuncLoader
    extends FuncLoader {
        public XFuncLoader(String pFuncName, int pFuncID) {
            super(pFuncName, pFuncID);
        }

        public Function getFunction() throws TransformerException {
            try {
                Class<?> function;
                if (this.getName().indexOf(".") < 0) {
                    String classname = "org.apache.xpath.functions." + this.getName();
                    function = Class.forName(classname);
                } else {
                    function = Class.forName(this.getName());
                }
                Function func = (Function)function.newInstance();
                return func;
            }
            catch (ClassNotFoundException e) {
                throw new TransformerException(e);
            }
            catch (IllegalAccessException e) {
                throw new TransformerException(e);
            }
            catch (InstantiationException e) {
                throw new TransformerException(e);
            }
        }
    }
}

