/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dtm;

import com.scenari.m.co.xpath.dtm.ZXPath;
import com.scenari.s.fw.util.xml.HEncodingXml;
import com.scenari.xsldtm.xml.dtm.DTMIterator;
import com.scenari.xsldtm.xpath.Expression;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldtm.xpath.objects.XNodeSet;
import com.scenari.xsldtm.xpath.objects.XObject;
import com.scenari.xsldtm.xpath.objects.XString;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.pools.PoolBuffers;
import java.util.Vector;

public class ZXPathListXml
extends ZXPath {
    public static TracePoint sTrace = TraceMgr.register(ZXPathListXml.class.getName());
    protected Expression fArgList = null;
    protected Expression fArgPrefix = null;
    protected Expression fArgSuffix = null;
    private static final long serialVersionUID = -2056144456043594452L;

    public boolean canTraverseOutsideSubtree() {
        return this.fArgList.canTraverseOutsideSubtree() || this.fArgPrefix == null ? false : (this.fArgPrefix.canTraverseOutsideSubtree() || this.fArgSuffix == null ? false : this.fArgSuffix.canTraverseOutsideSubtree());
    }

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum == 0 || pArgNum > 3) {
            throw new WrongNumberArgsException("1, 2 or 3");
        }
    }

    public void fixupVariables(Vector pVars, int pGlobalsSize) {
        super.fixupVariables(pVars, pGlobalsSize);
        this.fArgList.fixupVariables(pVars, pGlobalsSize);
        if (this.fArgPrefix != null) {
            this.fArgPrefix.fixupVariables(pVars, pGlobalsSize);
        }
        if (this.fArgSuffix != null) {
            this.fArgSuffix.fixupVariables(pVars, pGlobalsSize);
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        if (0 == pArgNum) {
            this.fArgList = pArg;
        } else if (1 == pArgNum) {
            this.fArgPrefix = pArg;
        } else if (2 == pArgNum) {
            this.fArgSuffix = pArg;
        } else {
            throw new WrongNumberArgsException("1, 2 or 3");
        }
    }

    public XObject xExecute(XPathContext pCtx) throws Exception {
        XObject vList;
        XString vResult = null;
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        vBuf.append("<liste>");
        String vPrefix = "";
        if (this.fArgPrefix != null) {
            vPrefix = this.fArgPrefix.execute(pCtx).str();
        }
        String vSuffix = "";
        if (this.fArgSuffix != null) {
            vSuffix = this.fArgSuffix.execute(pCtx).str();
        }
        if ((vList = this.fArgList.execute(pCtx)).getType() == 4) {
            DTMIterator vIt = ((XNodeSet)vList).asIterator(pCtx, pCtx.getCurrentNode());
            int vNode = vIt.nextNode();
            while (vNode >= 0) {
                String vContentNode = pCtx.getDTM(vNode).getNodeValue(vNode);
                if (vContentNode != null) {
                    vBuf.append("<item>");
                    HEncodingXml.hWriteTextValue(vBuf, vPrefix);
                    HEncodingXml.hWriteTextValue(vBuf, vContentNode);
                    HEncodingXml.hWriteTextValue(vBuf, vSuffix);
                    vBuf.append("</item>");
                }
                vNode = vIt.nextNode();
            }
            vIt.detach();
        }
        vBuf.append("</liste>");
        vResult = new XString(vBuf.substring(0));
        if (sTrace.isEnabled()) {
            sTrace.publishDebug("XPath List = '" + vResult + "'.", new String[0]);
        }
        PoolBuffers.freeStringBuilder(vBuf);
        return vResult;
    }
}

