/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dtm;

import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.IWServiceAvecResultat;
import com.scenari.m.co.xpath.dtm.XAgent;
import com.scenari.m.co.xpath.dtm.ZXPath;
import com.scenari.xsldtm.xml.dtm.DTMIterator;
import com.scenari.xsldtm.xpath.Expression;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldtm.xpath.objects.XNumber;
import com.scenari.xsldtm.xpath.objects.XObject;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ZXPathMax
extends ZXPath {
    public static TracePoint sTrace = TraceMgr.register(ZXPathMax.class.getName());
    protected List fListParam = new ArrayList(3);
    private static final long serialVersionUID = -266086884950889389L;

    public boolean canTraverseOutsideSubtree() {
        for (int i = 0; i < this.fListParam.size(); ++i) {
            if (!((Expression)this.fListParam.get(i)).canTraverseOutsideSubtree()) continue;
            return true;
        }
        return false;
    }

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum == 0) {
            throw new WrongNumberArgsException("1 or more");
        }
    }

    public void fixupVariables(Vector pVars, int pGlobalsSize) {
        super.fixupVariables(pVars, pGlobalsSize);
        for (int i = 0; i < this.fListParam.size(); ++i) {
            ((Expression)this.fListParam.get(i)).fixupVariables(pVars, pGlobalsSize);
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        this.fListParam.add(pArg);
    }

    public XObject xExecute(XPathContext pCtx) throws Exception {
        IHDialog vDialog = null;
        double vMax = Double.NEGATIVE_INFINITY;
        double vCurentDouble = Double.MIN_VALUE;
        if (this.fListParam != null) {
            for (int i = 0; i < this.fListParam.size(); ++i) {
                XObject vXObj = ((Expression)this.fListParam.get(i)).execute(pCtx);
                vCurentDouble = Double.MIN_VALUE;
                if (vXObj != null) {
                    if (vXObj.getType() == 4) {
                        DTMIterator vIt = vXObj.asIterator(pCtx, pCtx.getCurrentNode());
                        int vNode = vIt.nextNode();
                        while (vNode >= 0) {
                            vCurentDouble = ZXPathMax.hGetStringToNumber(((Object)pCtx.getDTM(vNode).getStringValue(vNode)).toString());
                            if (vCurentDouble > vMax) {
                                vMax = vCurentDouble;
                            }
                            vNode = vIt.nextNode();
                        }
                    } else if (vXObj.getType() == 0) {
                        Object vObj = vXObj.object();
                        if (vObj instanceof XAgent) {
                            vObj = ((XAgent)vObj).fAgent;
                        }
                        if (vObj instanceof IWAgentComputor) {
                            if (vDialog == null) {
                                vDialog = this.wGetDialogFromCtx(pCtx);
                            }
                            String vVal = ((IWAgentComputor)vObj).computeAsString(vDialog, null);
                            vCurentDouble = ZXPathMax.hGetStringToNumber(vVal);
                        } else if (vObj instanceof IWServiceAvecResultat) {
                            if (vDialog == null) {
                                vDialog = this.wGetDialogFromCtx(pCtx);
                            }
                            String vVal = ((IWServiceAvecResultat)vObj).hGetResultat(vDialog, null).getString();
                            vCurentDouble = ZXPathMax.hGetStringToNumber(vVal);
                        } else {
                            vCurentDouble = ZXPathMax.hGetStringToNumber(vObj.toString());
                        }
                    } else {
                        try {
                            vCurentDouble = ((XNumber)vXObj).num();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (!(vCurentDouble > vMax)) continue;
                vMax = vCurentDouble;
            }
        }
        if (!Double.isInfinite(vMax)) {
            if (sTrace.isEnabled()) {
                LogMgr.publishTrace("XPath Max result : " + vMax, new String[0]);
            }
            return new XNumber(vMax);
        }
        if (sTrace.isEnabled()) {
            LogMgr.publishTrace("XPath Max result : NaN", new String[0]);
        }
        return NUMBER_NAN;
    }

    protected boolean wIsUseDefaultDialog() {
        return true;
    }
}

