/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dtm;

import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.IWServiceAvecResultat;
import com.scenari.m.co.xpath.dtm.XAgent;
import com.scenari.m.co.xpath.dtm.ZXPath;
import com.scenari.xsldtm.xml.dtm.DTMIterator;
import com.scenari.xsldtm.xpath.Expression;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldtm.xpath.objects.XNumber;
import com.scenari.xsldtm.xpath.objects.XObject;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ZXPathSomme
extends ZXPath {
    public static TracePoint sTrace = TraceMgr.register(ZXPathSomme.class.getName(), "Trace la fonction XPath qui calcule une somme.");
    protected List fListParam = new ArrayList(3);
    private static final long serialVersionUID = -7457547547L;

    public boolean canTraverseOutsideSubtree() {
        for (int i = 0; i < this.fListParam.size(); ++i) {
            if (!((Expression)this.fListParam.get(i)).canTraverseOutsideSubtree()) continue;
            return true;
        }
        return false;
    }

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum == 0) {
            throw new WrongNumberArgsException("1 or more");
        }
    }

    public void fixupVariables(Vector pVars, int pGlobalsSize) {
        super.fixupVariables(pVars, pGlobalsSize);
        for (int i = 0; i < this.fListParam.size(); ++i) {
            ((Expression)this.fListParam.get(i)).fixupVariables(pVars, pGlobalsSize);
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        this.fListParam.add(pArg);
    }

    public XObject xExecute(XPathContext pCtx) throws Exception {
        double vSum = 0.0;
        IHDialog vDialog = null;
        int vCount = 0;
        if (this.fListParam != null) {
            for (int i = 0; i < this.fListParam.size(); ++i) {
                XObject vXObj = ((Expression)this.fListParam.get(i)).execute(pCtx);
                if (vXObj == null) continue;
                if (vXObj.getType() == 4) {
                    DTMIterator vIt = vXObj.asIterator(pCtx, pCtx.getCurrentNode());
                    int vNode = vIt.nextNode();
                    while (vNode >= 0) {
                        vSum += ZXPathSomme.hGetStringToNumber(((Object)pCtx.getDTM(vNode).getStringValue(vNode)).toString());
                        ++vCount;
                        vNode = vIt.nextNode();
                    }
                    continue;
                }
                if (vXObj.getType() == 0) {
                    Object vObj = vXObj.object();
                    if (vObj instanceof XAgent) {
                        vObj = ((XAgent)vObj).fAgent;
                    }
                    if (vObj instanceof IWAgentComputor) {
                        if (vDialog == null) {
                            vDialog = this.wGetDialogFromCtx(pCtx);
                        }
                        String vVal = ((IWAgentComputor)vObj).computeAsString(vDialog, null);
                        vSum += ZXPathSomme.hGetStringToNumber(vVal);
                        ++vCount;
                        continue;
                    }
                    if (vObj instanceof IWServiceAvecResultat) {
                        if (vDialog == null) {
                            vDialog = this.wGetDialogFromCtx(pCtx);
                        }
                        String vVal = ((IWServiceAvecResultat)vObj).hGetResultat(vDialog, null).getString();
                        vSum += ZXPathSomme.hGetStringToNumber(vVal);
                        ++vCount;
                        continue;
                    }
                    vSum += ZXPathSomme.hGetStringToNumber(vObj.toString());
                    ++vCount;
                    continue;
                }
                try {
                    vSum += ((XNumber)vXObj).num();
                    ++vCount;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (vCount > 0) {
            if (sTrace.isEnabled()) {
                sTrace.publishDebug("XPath Resultat de la somme sur " + vCount + " items : " + vSum, new String[0]);
            }
            return new XNumber(vSum);
        }
        if (sTrace.isEnabled()) {
            sTrace.publishDebug("XPath Resultat de la somme : 0 (aucun item trouv\u00e9). CurrentNode=" + pCtx.getCurrentNode(), new String[0]);
        }
        return new XNumber(0.0);
    }

    protected boolean wIsUseDefaultDialog() {
        return true;
    }
}

