/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.agent;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.agent.IWAgentLinker;
import com.scenari.m.ge.agent.IWAgentOutline;
import java.util.ArrayList;
import java.util.List;

public class OutlineWalker {
    public static final int NO_LIMIT = 0x3FFFFFFF;
    public static final short DIR_NONE = 0;
    public static final short DIR_UP_DOWN = 1;
    public static final short DIR_DOWN_UP = 2;
    public static final short FROM_CURRENT = 4;
    public static final short FROM_STARTINGPOINT = 8;
    public static final String POS_ROOT = "root";
    public static final String POS_ANC = "ancestor";
    public static final String POS_PARENT = "parent";
    public static final String POS_UNCLE = "uncle";
    public static final String POS_COUSIN = "cousin";
    public static final String POS_CURRENT = "current";
    public static final String POS_SIBLING = "sibling";
    public static final String POS_CHILD = "child";
    public static final String POS_DESC = "descendant";
    protected static final String POS_SKIPPED = "skipped";
    protected static final IWAgent[] NO_CHILD = new IWAgent[0];
    protected boolean fRestrictToMaterializedNode = false;
    protected short fStartingPointDir = 1;
    protected int fStartingPointOffset = 0;
    protected boolean fStartingPointInclude = true;
    protected List fStartingPointStops = null;
    protected int fEndingPointDepth = 0x3FFFFFFF;
    protected short fEndingPointDepthFrom = (short)8;
    protected List fEndingPointStops = null;
    protected short fUncleFromDir = 0;
    protected int fUncleFromOffset = 0;
    protected List fUncleFromStops = null;
    protected short fUncleToDir = 0;
    protected int fUncleToOffset = 0;
    protected List fUncleToStops = null;
    protected int fUncleDescDepth = 0;
    protected short fUncleDescDepthFrom = (short)8;
    protected List fUncleDescStops = null;
    protected int fCurrDescDepth = 0;
    protected short fCurrDescDepthFrom = (short)4;
    protected List fCurrDescStops = null;
    protected IWADialog fCurrentDialog = null;
    protected String fCurrentUrl = null;
    protected StringBuilder fXCursorUrl = new StringBuilder(128);
    protected int fXCursorIdx = -1;
    protected IWAgent[] fXCursorStackAgent = new IWAgent[12];
    protected IWAgent[][] fXCursorStackChildren = new IWAgent[12][];
    protected String[] fXCursorStackPos = new String[12];
    protected String fXPrefixStartPUrl = null;
    protected boolean fXStartingPointIncluded = true;
    protected IWAgent[] fXAgentsStartP2Curr = null;
    protected int fXOffsetCurrentFromStartP = 0;
    protected int fXIdxAgentParent = -1;
    protected boolean fXIsInitialized = false;

    public void setCurrentDialog(IWADialog pDialog) throws Exception {
        this.xResetIfNeeded();
        this.fCurrentDialog = pDialog;
    }

    public IWADialog getCurrentDialog() {
        return this.fCurrentDialog;
    }

    public void setStartingPoint(short pDirection, int pOffset, boolean pIncludeInScope) throws Exception {
        this.xResetIfNeeded();
        this.fStartingPointDir = pDirection;
        this.fStartingPointOffset = pOffset;
        this.fStartingPointInclude = pIncludeInScope;
    }

    public void addStartingPointStopOnCompType(String pCodeCompType, boolean pIncludeInScope) throws Exception {
        this.xResetIfNeeded();
        if (this.fStartingPointStops == null) {
            this.fStartingPointStops = new ArrayList(3);
        }
        this.fStartingPointStops.add(new StopOnCompType(pCodeCompType, pIncludeInScope));
    }

    public void setEndingPoint(int pDepth, short pDepthFrom) {
        this.xResetIfNeeded();
        this.fEndingPointDepthFrom = pDepthFrom;
        this.fEndingPointDepth = pDepth;
    }

    public void addEndingPointStopOnCompType(String pCodeCompType, boolean pIncludeInScope) throws Exception {
        this.xResetIfNeeded();
        if (this.fEndingPointStops == null) {
            this.fEndingPointStops = new ArrayList(3);
        }
        this.fEndingPointStops.add(new StopOnCompType(pCodeCompType, pIncludeInScope));
    }

    public void setUncleFrom(short pDirection, int pOffset) {
        this.xResetIfNeeded();
        this.fUncleFromDir = pDirection;
        this.fUncleFromOffset = pOffset;
    }

    public void addUncleFromStopOnCompType(String pCodeCompType, boolean pIncludeInScope) throws Exception {
        this.xResetIfNeeded();
        if (this.fUncleFromStops == null) {
            this.fUncleFromStops = new ArrayList(3);
        }
        this.fUncleFromStops.add(new StopOnCompType(pCodeCompType, pIncludeInScope));
    }

    public void setUncleTo(short pDirection, int pOffset) {
        this.xResetIfNeeded();
        this.fUncleToDir = pDirection;
        this.fUncleToOffset = pOffset;
    }

    public void addUncleToStopOnCompType(String pCodeCompType, boolean pIncludeInScope) throws Exception {
        this.xResetIfNeeded();
        if (this.fUncleToStops == null) {
            this.fUncleToStops = new ArrayList(3);
        }
        this.fUncleToStops.add(new StopOnCompType(pCodeCompType, pIncludeInScope));
    }

    public void setUncleDesc(int pDepth, short pDepthFrom) {
        this.xResetIfNeeded();
        this.fUncleDescDepthFrom = pDepthFrom;
        this.fUncleDescDepth = pDepth;
    }

    public void addUncleDescStopOnCompType(String pCodeCompType, boolean pIncludeInScope) throws Exception {
        this.xResetIfNeeded();
        if (this.fUncleDescStops == null) {
            this.fUncleDescStops = new ArrayList(3);
        }
        this.fUncleDescStops.add(new StopOnCompType(pCodeCompType, pIncludeInScope));
    }

    public void setCurrDesc(int pDepth, short pDepthFrom) {
        this.xResetIfNeeded();
        this.fCurrDescDepthFrom = pDepthFrom;
        this.fCurrDescDepth = pDepth;
    }

    public void addCurrDescStopOnCompType(String pCodeCompType, boolean pIncludeInScope) throws Exception {
        this.xResetIfNeeded();
        if (this.fCurrDescStops == null) {
            this.fCurrDescStops = new ArrayList(3);
        }
        this.fCurrDescStops.add(new StopOnCompType(pCodeCompType, pIncludeInScope));
    }

    public void gotoRoot() throws Exception {
        this.xInitIfNeeded();
        this.xResetCursorStack();
        this.fXCursorUrl.append(this.fXPrefixStartPUrl);
    }

    public void gotoCurrent() throws Exception {
        this.xInitIfNeeded();
        this.xResetCursorStack();
        this.xEnsureStackSize(this.fXAgentsStartP2Curr.length);
        this.fXCursorUrl.append(this.fCurrentUrl);
        for (int i = this.fXAgentsStartP2Curr.length - 1; i >= 0; --i) {
            this.fXCursorStackAgent[i] = this.fXAgentsStartP2Curr[i];
            this.fXCursorStackPos[i] = this.xGetPosMainAxis(i);
        }
        this.fXCursorIdx = this.fXAgentsStartP2Curr.length - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean gotoFirstChild() throws Exception {
        IWAgent[] vChildren;
        this.xInitIfNeeded();
        if (this.fXCursorIdx == -1) {
            if (this.fXAgentsStartP2Curr.length <= 0) return false;
            if (this.fXStartingPointIncluded) {
                vChildren = new IWAgent[]{this.fXAgentsStartP2Curr[0]};
                return this.xSearchFirstChild(vChildren);
            } else {
                this.xPush(this.fXAgentsStartP2Curr[0], this.xGetPosMainAxis(0));
                vChildren = this.xGetCursorChildren();
            }
            return this.xSearchFirstChild(vChildren);
        } else {
            vChildren = this.xGetCursorChildren();
        }
        return this.xSearchFirstChild(vChildren);
    }

    protected boolean xSearchFirstChild(IWAgent[] pChildren) throws Exception {
        IWAgent vParent = this.xGetCursorVisibleAgent();
        int vParentOffset = this.getOffsetFromStartingPoint();
        String vVisibleParentPos = this.xGetCursorVisiblePos();
        for (int i = 0; i < pChildren.length; ++i) {
            String vNewPos;
            IWAgent vAgt = pChildren[i];
            if (vAgt == null) continue;
            if (vAgt instanceof IWAgentOutline) {
                IWAgentOutline vAgtOutline = (IWAgentOutline)vAgt;
                if (vAgtOutline.isRejected(this.fCurrentDialog)) continue;
                if (vAgtOutline.isSkipped(this.fCurrentDialog)) {
                    if (!this.xIsInScope(vAgt, this.xGetNewPos(vVisibleParentPos, vAgt, this.fXCursorIdx + 1), vParentOffset + 1, vParent)) continue;
                    this.xPush(vAgt, POS_SKIPPED);
                    if (this.xSearchFirstChild(this.xGetCursorChildren())) {
                        return true;
                    }
                    this.xPop();
                    continue;
                }
            }
            if (!this.xIsInScope(vAgt, vNewPos = this.xGetNewPos(vVisibleParentPos, vAgt, this.fXCursorIdx + 1), vParentOffset + 1, vParent)) continue;
            this.xPush(vAgt, vNewPos);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean gotoLastChild() throws Exception {
        IWAgent[] vChildren;
        this.xInitIfNeeded();
        if (this.fXCursorIdx == -1) {
            if (this.fXAgentsStartP2Curr.length <= 0) return false;
            if (this.fXStartingPointIncluded) {
                vChildren = new IWAgent[]{this.fXAgentsStartP2Curr[0]};
                return this.xSearchLastChild(vChildren);
            } else {
                this.xPush(this.fXAgentsStartP2Curr[0], this.xGetPosMainAxis(0));
                vChildren = this.xGetCursorChildren();
            }
            return this.xSearchLastChild(vChildren);
        } else {
            vChildren = this.xGetCursorChildren();
        }
        return this.xSearchLastChild(vChildren);
    }

    protected boolean xSearchLastChild(IWAgent[] pChildren) throws Exception {
        IWAgent vParent = this.xGetCursorVisibleAgent();
        int vParentOffset = this.getOffsetFromStartingPoint();
        String vVisibleParentPos = this.xGetCursorVisiblePos();
        for (int i = pChildren.length - 1; i >= 0; --i) {
            String vNewPos;
            IWAgent vAgt = pChildren[i];
            if (vAgt == null) continue;
            if (vAgt instanceof IWAgentOutline) {
                IWAgentOutline vAgtOutline = (IWAgentOutline)vAgt;
                if (vAgtOutline.isRejected(this.fCurrentDialog)) continue;
                if (vAgtOutline.isSkipped(this.fCurrentDialog)) {
                    if (!this.xIsInScope(vAgt, this.xGetNewPos(vVisibleParentPos, vAgt, this.fXCursorIdx + 1), vParentOffset + 1, vParent)) continue;
                    this.xPush(vAgt, POS_SKIPPED);
                    if (this.xSearchLastChild(this.xGetCursorChildren())) {
                        return true;
                    }
                    this.xPop();
                    continue;
                }
            }
            if (!this.xIsInScope(vAgt, vNewPos = this.xGetNewPos(vVisibleParentPos, vAgt, this.fXCursorIdx + 1), vParentOffset + 1, vParent)) continue;
            this.xPush(vAgt, vNewPos);
            return true;
        }
        return false;
    }

    public boolean gotoNextSibling() throws Exception {
        this.xInitIfNeeded();
        if (this.fXCursorIdx < 0) {
            return false;
        }
        IWAgent vCurAgt = this.fXCursorStackAgent[this.fXCursorIdx];
        this.xPop();
        if (this.fXCursorIdx < 0) {
            return false;
        }
        IWAgent[] vSiblings = this.xGetCursorChildren();
        int vStart = Integer.MAX_VALUE;
        for (int i = vSiblings.length - 1; i >= 0; --i) {
            if (vCurAgt != vSiblings[i]) continue;
            vStart = i + 1;
            break;
        }
        if (this.xSearchNextSibling(vSiblings, vStart)) {
            return true;
        }
        if (this.xIsSkipped(this.getAgent())) {
            return this.gotoNextSibling();
        }
        return false;
    }

    protected boolean xSearchNextSibling(IWAgent[] pSiblings, int pStart) throws Exception {
        IWAgent vParent = this.xGetCursorVisibleAgent();
        int vParentOffset = this.getOffsetFromStartingPoint();
        String vVisibleParentPos = this.xGetCursorVisiblePos();
        for (int i = pStart; i < pSiblings.length; ++i) {
            String vNewPos;
            IWAgent vSibling = pSiblings[i];
            if (vSibling == null) continue;
            if (vSibling instanceof IWAgentOutline) {
                IWAgentOutline vAgtOutline = (IWAgentOutline)vSibling;
                if (vAgtOutline.isRejected(this.fCurrentDialog)) continue;
                if (vAgtOutline.isSkipped(this.fCurrentDialog) && this.xIsInScope(vSibling, this.xGetNewPos(vVisibleParentPos, vSibling, this.fXCursorIdx + 1), vParentOffset + 1, vParent)) {
                    this.xPush(vSibling, POS_SKIPPED);
                    if (this.xSearchNextSibling(this.xGetCursorChildren(), 0)) {
                        return true;
                    }
                    this.xPop();
                    continue;
                }
            }
            if (!this.xIsInScope(vSibling, vNewPos = this.xGetNewPos(vVisibleParentPos, vSibling, this.fXCursorIdx + 1), vParentOffset + 1, vParent)) continue;
            this.xPush(vSibling, vNewPos);
            return true;
        }
        return false;
    }

    public boolean gotoPreviousSibling() throws Exception {
        this.xInitIfNeeded();
        if (this.fXCursorIdx < 0) {
            return false;
        }
        IWAgent vCurAgt = this.fXCursorStackAgent[this.fXCursorIdx];
        this.xPop();
        if (this.fXCursorIdx < 0) {
            return false;
        }
        IWAgent[] vSiblings = this.xGetCursorChildren();
        int vStart = -2;
        for (int i = 0; i < vSiblings.length; ++i) {
            if (vCurAgt != vSiblings[i]) continue;
            vStart = i - 1;
            break;
        }
        if (this.xSearchPreviousSibling(vSiblings, vStart)) {
            return true;
        }
        if (this.xIsSkipped(this.getAgent())) {
            return this.gotoPreviousSibling();
        }
        return false;
    }

    protected boolean xSearchPreviousSibling(IWAgent[] pSiblings, int pStart) throws Exception {
        IWAgent vParent = this.xGetCursorVisibleAgent();
        int vParentOffset = this.getOffsetFromStartingPoint();
        String vVisibleParentPos = this.xGetCursorVisiblePos();
        for (int i = pStart; i >= 0; --i) {
            String vNewPos;
            IWAgent vSibling = pSiblings[i];
            if (vSibling == null) continue;
            if (vSibling instanceof IWAgentOutline) {
                IWAgentOutline vAgtOutline = (IWAgentOutline)vSibling;
                if (vAgtOutline.isRejected(this.fCurrentDialog)) continue;
                if (vAgtOutline.isSkipped(this.fCurrentDialog) && this.xIsInScope(vSibling, this.xGetNewPos(vVisibleParentPos, vSibling, this.fXCursorIdx + 1), vParentOffset + 1, vParent)) {
                    this.xPush(vSibling, POS_SKIPPED);
                    IWAgent[] vCh = this.xGetCursorChildren();
                    if (this.xSearchPreviousSibling(vCh, vCh.length - 1)) {
                        return true;
                    }
                    this.xPop();
                    continue;
                }
            }
            if (!this.xIsInScope(vSibling, vNewPos = this.xGetNewPos(vVisibleParentPos, vSibling, this.fXCursorIdx + 1), vParentOffset + 1, vParent)) continue;
            this.xPush(vSibling, vNewPos);
            return true;
        }
        return false;
    }

    public boolean gotoParent() throws Exception {
        this.xInitIfNeeded();
        if (this.fXCursorIdx < 0) {
            return false;
        }
        this.xPop();
        return true;
    }

    public boolean gotoNext() throws Exception {
        if (this.gotoFirstChild()) {
            return true;
        }
        while (this.getPosition() != POS_ROOT) {
            if (!this.gotoNextSibling()) continue;
            return true;
        }
        return false;
    }

    public boolean gotoPrevious() throws Exception {
        if (this.gotoPreviousSibling()) {
            while (this.gotoLastChild()) {
            }
            return true;
        }
        return this.getPosition() != POS_ROOT;
    }

    public boolean gotoChildAncestor() throws Exception {
        this.xInitIfNeeded();
        if (this.fXCursorIdx < 0 || this.fXCursorIdx >= this.fXIdxAgentParent) {
            return false;
        }
        if (!this.xIsInMainAxis(this.fXCursorStackAgent[this.fXCursorIdx], this.fXCursorIdx)) {
            return false;
        }
        String vVisibleParentPos = this.xGetCursorVisiblePos();
        while (this.fXCursorIdx < this.fXIdxAgentParent) {
            IWAgentOutline vAgtOutline;
            IWAgent vAgt = this.fXCursorStackAgent[this.fXCursorIdx + 1];
            if (vAgt instanceof IWAgentOutline && (vAgtOutline = (IWAgentOutline)vAgt).isSkipped(this.fCurrentDialog)) {
                this.xPush(vAgt, POS_SKIPPED);
                continue;
            }
            String vNewPos = this.xGetNewPos(vVisibleParentPos, vAgt, this.fXCursorIdx + 1);
            this.xPush(vAgt, vNewPos);
            return true;
        }
        return false;
    }

    public String getPosition() throws Exception {
        this.xInitIfNeeded();
        return this.fXCursorIdx >= 0 ? this.fXCursorStackPos[this.fXCursorIdx] : POS_ROOT;
    }

    public IWAgent getAgent() throws Exception {
        this.xInitIfNeeded();
        return this.fXCursorIdx >= 0 ? this.fXCursorStackAgent[this.fXCursorIdx] : null;
    }

    public String getDialogUrl() throws Exception {
        this.xInitIfNeeded();
        return this.fXCursorUrl.substring(0, this.fXCursorUrl.length());
    }

    public CharSequence getDialogUrlAsCharSeq() throws Exception {
        this.xInitIfNeeded();
        return this.fXCursorUrl;
    }

    public int getOffsetFromStartingPoint() throws Exception {
        int i;
        this.xInitIfNeeded();
        if (this.fXCursorIdx < 0) {
            return 0;
        }
        int vOffset = 0;
        int n = i = this.fXStartingPointIncluded ? 0 : 1;
        while (i <= this.fXCursorIdx) {
            if (this.fXCursorStackPos[i] != POS_SKIPPED) {
                ++vOffset;
            }
            ++i;
        }
        return vOffset;
    }

    public int getOffsetFromCurrent() throws Exception {
        this.xInitIfNeeded();
        return this.getOffsetFromStartingPoint() - this.fXOffsetCurrentFromStartP;
    }

    protected void xResetIfNeeded() {
        if (this.fXIsInitialized) {
            this.xResetCursorStack();
            this.fXPrefixStartPUrl = null;
            this.fXStartingPointIncluded = true;
            this.fXAgentsStartP2Curr = null;
            this.fXIsInitialized = false;
            this.fXOffsetCurrentFromStartP = 0;
        }
    }

    protected void xResetCursorStack() {
        this.fXCursorUrl.setLength(0);
        this.fXCursorIdx = -1;
        for (int i = 0; i < this.fXCursorStackAgent.length; ++i) {
            this.fXCursorStackAgent[i] = null;
            this.fXCursorStackChildren[i] = null;
            this.fXCursorStackPos[i] = null;
        }
    }

    protected void xInitIfNeeded() throws Exception {
        if (!this.fXIsInitialized) {
            int vOffset;
            IWAgent vLastAgt;
            int i;
            this.fXPrefixStartPUrl = null;
            this.fXIdxAgentParent = -1;
            this.fXStartingPointIncluded = this.fStartingPointInclude;
            List vHier = this.fCurrentDialog.hGetHier();
            ArrayList vMainAxis = new ArrayList(vHier.size() + 1);
            int vSize = vHier.size();
            for (i = 0; i < vSize; ++i) {
                vMainAxis.add(vHier.get(i));
            }
            vMainAxis.add(this.fCurrentDialog.hGetAgent());
            while (vMainAxis.size() > 0 && this.xIsRejected(vLastAgt = (IWAgent)vMainAxis.get(vMainAxis.size() - 1))) {
                vMainAxis.remove(vMainAxis.size() - 1);
            }
            for (i = 0; i < vMainAxis.size(); ++i) {
                this.fXCursorUrl.append('/');
                this.fXCursorUrl.append(((IWAgent)vMainAxis.get(i)).hGetAgentPath());
            }
            this.fCurrentUrl = this.fXCursorUrl.substring(0);
            this.fXCursorUrl.setLength(0);
            if (this.fStartingPointDir == 1) {
                int vIdxPrefixUrl = 0;
                int vVisibleOffset = 0;
                int vMaxSearch = vMainAxis.size() - 1;
                if (vVisibleOffset < this.fStartingPointOffset) {
                    IWAgent vAgent;
                    for (vOffset = 0; vOffset <= vMaxSearch && (this.xIsSkipped(vAgent = (IWAgent)vMainAxis.get(vOffset)) || ++vVisibleOffset < this.fStartingPointOffset); ++vOffset) {
                        StopOnCompType vStopModel = this.xSearchStop(vAgent.hGetComposant().hGetComposantPrincipal().hGetComposantType().hGetCode(), this.fStartingPointStops);
                        if (vStopModel != null) {
                            this.fXStartingPointIncluded = vStopModel.fIncludeInScope;
                            break;
                        }
                        vIdxPrefixUrl = this.fCurrentUrl.indexOf("/@", vIdxPrefixUrl + 2);
                    }
                }
                if (vOffset < vMaxSearch) {
                    this.fXPrefixStartPUrl = vIdxPrefixUrl == 0 ? "" : this.fCurrentUrl.substring(0, vIdxPrefixUrl);
                    this.fXAgentsStartP2Curr = new IWAgent[vMainAxis.size() - vOffset];
                    for (int i2 = this.fXAgentsStartP2Curr.length - 1; i2 >= 0; --i2) {
                        this.fXAgentsStartP2Curr[i2] = (IWAgent)vMainAxis.get(i2 + vOffset);
                        if (!this.fXStartingPointIncluded && i2 <= 0 || this.xIsSkipped(this.fXAgentsStartP2Curr[i2])) continue;
                        if (this.fXIdxAgentParent < 0 && i2 < this.fXAgentsStartP2Curr.length - 1) {
                            this.fXIdxAgentParent = i2;
                        }
                        ++this.fXOffsetCurrentFromStartP;
                    }
                }
            } else if (this.fStartingPointDir == 2 && vMainAxis.size() > 0) {
                int vMax;
                int vIdxUrl = this.fCurrentUrl.lastIndexOf("/@");
                int vVisibleOffset = 0;
                if (vVisibleOffset < this.fStartingPointOffset) {
                    IWAgent vAgent;
                    for (vOffset = vMainAxis.size() - 1; vOffset > 0 && (this.xIsSkipped(vAgent = (IWAgent)vMainAxis.get(vOffset)) || ++vVisibleOffset < this.fStartingPointOffset); --vOffset) {
                        StopOnCompType vStop = this.xSearchStop(vAgent.hGetComposant().hGetComposantPrincipal().hGetComposantType().hGetCode(), this.fStartingPointStops);
                        if (vStop != null) {
                            this.fXStartingPointIncluded = vStop.fIncludeInScope;
                            break;
                        }
                        vIdxUrl = this.fCurrentUrl.lastIndexOf("/@", vIdxUrl - 1);
                    }
                }
                this.fXPrefixStartPUrl = vIdxUrl == 0 ? "" : this.fCurrentUrl.substring(0, vIdxUrl);
                this.fXAgentsStartP2Curr = new IWAgent[vMainAxis.size() - vOffset];
                for (int i3 = vMax = this.fXAgentsStartP2Curr.length - 1; i3 >= 0; --i3) {
                    this.fXAgentsStartP2Curr[i3] = (IWAgent)vMainAxis.get(i3 + vOffset);
                    if (!this.fXStartingPointIncluded && i3 <= 0 || this.xIsSkipped(this.fXAgentsStartP2Curr[i3])) continue;
                    if (this.fXIdxAgentParent < 0 && i3 < this.fXAgentsStartP2Curr.length - 1) {
                        this.fXIdxAgentParent = i3;
                    }
                    ++this.fXOffsetCurrentFromStartP;
                }
            }
            if (this.fXPrefixStartPUrl == null) {
                this.fXPrefixStartPUrl = this.fCurrentUrl.substring(0, this.fCurrentUrl.lastIndexOf("/@"));
                this.fXAgentsStartP2Curr = new IWAgent[1];
                this.fXAgentsStartP2Curr[0] = (IWAgent)vMainAxis.get(vMainAxis.size() - 1);
                if (this.fXStartingPointIncluded && !this.xIsSkipped(this.fXAgentsStartP2Curr[0])) {
                    ++this.fXOffsetCurrentFromStartP;
                }
            }
            this.fXCursorUrl.append(this.fXPrefixStartPUrl);
            this.fXIsInitialized = true;
        }
    }

    protected StopOnCompType xSearchStop(String pCodeCompType, List pStops) {
        if (pStops != null) {
            for (int i = 0; i < pStops.size(); ++i) {
                StopOnCompType vStop = (StopOnCompType)pStops.get(i);
                if (!pCodeCompType.equals(vStop.fCodeCompType)) continue;
                return vStop;
            }
        }
        return null;
    }

    protected boolean xIsStopped(IWAgent pAgt, IWAgent pVisibleParentAgt, List pStops) {
        if (pStops != null) {
            String vCd = pAgt.hGetComposant().hGetComposantPrincipal().hGetComposantType().hGetCode();
            String vCdParent = pVisibleParentAgt != null ? pVisibleParentAgt.hGetComposant().hGetComposantPrincipal().hGetComposantType().hGetCode() : null;
            for (int i = 0; i < pStops.size(); ++i) {
                StopOnCompType vStop = (StopOnCompType)pStops.get(i);
                if (!(vStop.fIncludeInScope ? vCdParent != null && vCdParent.equals(vStop.fCodeCompType) : vCd.equals(vStop.fCodeCompType))) continue;
                return true;
            }
        }
        return false;
    }

    protected void xEnsureStackSize(int pSize) {
        if (pSize >= this.fXCursorStackAgent.length) {
            int vNewSize = pSize + 12;
            IWAgent[] vNewAgent = new IWAgent[vNewSize];
            System.arraycopy(this.fXCursorStackAgent, 0, vNewAgent, 0, this.fXCursorStackAgent.length);
            this.fXCursorStackAgent = vNewAgent;
            String[] vNewPos = new String[vNewSize];
            System.arraycopy(this.fXCursorStackPos, 0, vNewPos, 0, this.fXCursorStackPos.length);
            this.fXCursorStackPos = vNewPos;
            IWAgent[][] vNewSiblings = new IWAgent[vNewSize][];
            System.arraycopy(this.fXCursorStackChildren, 0, vNewSiblings, 0, this.fXCursorStackChildren.length);
            this.fXCursorStackChildren = vNewSiblings;
        }
    }

    protected void xPush(IWAgent pAgt, String pPos) {
        ++this.fXCursorIdx;
        this.xEnsureStackSize(this.fXCursorIdx);
        this.fXCursorStackAgent[this.fXCursorIdx] = pAgt;
        this.fXCursorStackPos[this.fXCursorIdx] = pPos;
        this.fXCursorUrl.append('/');
        this.fXCursorUrl.append(pAgt.hGetAgentPath());
    }

    protected void xPop() {
        this.fXCursorStackAgent[this.fXCursorIdx] = null;
        this.fXCursorStackPos[this.fXCursorIdx] = null;
        this.fXCursorStackChildren[this.fXCursorIdx] = null;
        --this.fXCursorIdx;
        this.fXCursorUrl.setLength(this.fXCursorUrl.lastIndexOf("/@"));
    }

    protected IWAgent[] xGetCursorChildren() throws Exception {
        IWAgent[] vChildren = this.fXCursorStackChildren[this.fXCursorIdx];
        if (vChildren == null) {
            IWAgentOutline vAgtOutline;
            IWAgent vCurrAgt = this.fXCursorStackAgent[this.fXCursorIdx];
            if (vCurrAgt instanceof IWAgentOutline && !(vAgtOutline = (IWAgentOutline)vCurrAgt).isRejected(this.fCurrentDialog) && !vAgtOutline.isSkipped(this.fCurrentDialog)) {
                for (int i = 0; i < this.fXCursorIdx; ++i) {
                    if (this.fXCursorStackAgent[i] != vCurrAgt) continue;
                    vChildren = IWAgentLinker.NOCHILDREN;
                    this.fXCursorStackChildren[this.fXCursorIdx] = vChildren;
                    return vChildren;
                }
            }
            vChildren = vCurrAgt instanceof IWAgentLinker ? ((IWAgentLinker)((Object)vCurrAgt)).hGetAgentsLies(this.fCurrentDialog, null) : NO_CHILD;
            this.fXCursorStackChildren[this.fXCursorIdx] = vChildren;
        }
        return vChildren;
    }

    protected boolean xIsSkipped(IWAgent pAgt) throws Exception {
        if (pAgt instanceof IWAgentOutline) {
            return ((IWAgentOutline)pAgt).isSkipped(this.fCurrentDialog) || this.fRestrictToMaterializedNode && !((IWAgentOutline)pAgt).isMaterialized(this.fCurrentDialog);
        }
        return false;
    }

    protected boolean xIsRejected(IWAgent pAgt) throws Exception {
        return pAgt instanceof IWAgentOutline && ((IWAgentOutline)pAgt).isRejected(this.fCurrentDialog);
    }

    protected boolean xIsInScope(IWAgent pAgt, String pPos, int pVisibleOffsetFromStartingPoint, IWAgent pVisibleParentAgt) throws Exception {
        if (pPos == POS_ANC || pPos == POS_PARENT || pPos == POS_CURRENT) {
            if (pVisibleOffsetFromStartingPoint > (this.fEndingPointDepthFrom == 8 ? this.fEndingPointDepth : this.fXOffsetCurrentFromStartP - this.fEndingPointDepth)) {
                return false;
            }
            return !this.xIsStopped(pAgt, pVisibleParentAgt, this.fEndingPointStops);
        }
        if (pPos == POS_UNCLE || pPos == POS_SIBLING) {
            if (this.fUncleFromDir == 0 || this.fUncleToDir == 0) {
                return false;
            }
            if (pVisibleOffsetFromStartingPoint < (this.fUncleFromDir == 1 ? this.fUncleFromOffset : this.fXOffsetCurrentFromStartP - this.fUncleFromOffset)) {
                return false;
            }
            if (pVisibleOffsetFromStartingPoint > (this.fUncleToDir == 1 ? this.fUncleToOffset : this.fXOffsetCurrentFromStartP - this.fUncleToOffset)) {
                return false;
            }
            return !this.xIsStopped(pAgt, pVisibleParentAgt, this.fUncleFromStops) && !this.xIsStopped(pAgt, pVisibleParentAgt, this.fUncleToStops);
        }
        if (pPos == POS_COUSIN) {
            if (pVisibleOffsetFromStartingPoint > (this.fUncleDescDepthFrom == 8 ? this.fUncleDescDepth : this.fXOffsetCurrentFromStartP + this.fUncleDescDepth)) {
                return false;
            }
            return !this.xIsStopped(pAgt, pVisibleParentAgt, this.fUncleDescStops);
        }
        if (pPos == POS_CHILD || pPos == POS_DESC) {
            if (pVisibleOffsetFromStartingPoint > (this.fCurrDescDepthFrom == 8 ? this.fCurrDescDepth : this.fXOffsetCurrentFromStartP + this.fCurrDescDepth)) {
                return false;
            }
            return !this.xIsStopped(pAgt, pVisibleParentAgt, this.fCurrDescStops);
        }
        return true;
    }

    protected String xGetPosMainAxis(int pIdx) throws Exception {
        if (this.xIsSkipped(this.fXAgentsStartP2Curr[pIdx])) {
            return POS_SKIPPED;
        }
        if (!this.fXStartingPointIncluded && pIdx == 0) {
            return POS_ROOT;
        }
        return this.fXIdxAgentParent > pIdx ? POS_ANC : (this.fXIdxAgentParent == pIdx ? POS_PARENT : POS_CURRENT);
    }

    protected String xGetCursorVisiblePos() {
        String vPos;
        int vIdx = this.fXCursorIdx;
        String string = vPos = vIdx >= 0 ? this.fXCursorStackPos[vIdx] : POS_ROOT;
        while (vPos == POS_SKIPPED) {
            vPos = vIdx > 0 ? this.fXCursorStackPos[--vIdx] : POS_ROOT;
        }
        return vPos;
    }

    protected IWAgent xGetCursorVisibleAgent() {
        String vPos;
        int vIdx = this.fXCursorIdx;
        String string = vPos = vIdx >= 0 ? this.fXCursorStackPos[vIdx] : POS_ROOT;
        while (vPos == POS_SKIPPED) {
            vPos = vIdx > 0 ? this.fXCursorStackPos[--vIdx] : POS_ROOT;
        }
        return vPos == POS_ROOT ? null : this.fXCursorStackAgent[vIdx];
    }

    protected boolean xIsInMainAxis(IWAgent pAgt, int pIdx) {
        if (pIdx >= this.fXAgentsStartP2Curr.length) {
            return false;
        }
        return pAgt == this.fXAgentsStartP2Curr[pIdx];
    }

    protected String xGetNewPos(String pVisibleParentPos, IWAgent pNewAgt, int pNewIdx) throws Exception {
        String vPos = pVisibleParentPos == POS_ANC ? (this.xIsInMainAxis(pNewAgt, pNewIdx) ? this.xGetPosMainAxis(pNewIdx) : POS_UNCLE) : (pVisibleParentPos == POS_CHILD ? POS_DESC : (pVisibleParentPos == POS_COUSIN ? POS_COUSIN : (pVisibleParentPos == POS_CURRENT ? POS_CHILD : (pVisibleParentPos == POS_DESC ? POS_DESC : (pVisibleParentPos == POS_PARENT ? (this.xIsInMainAxis(pNewAgt, pNewIdx) ? POS_CURRENT : POS_SIBLING) : (pVisibleParentPos == POS_ROOT ? (this.xIsInMainAxis(pNewAgt, pNewIdx) ? this.xGetPosMainAxis(pNewIdx) : (this.fXOffsetCurrentFromStartP == 0 ? POS_CHILD : (this.fXIdxAgentParent >= 0 ? POS_UNCLE : POS_SIBLING))) : (pVisibleParentPos == POS_SIBLING ? POS_COUSIN : POS_COUSIN)))))));
        return vPos;
    }

    public boolean isRestrictToMaterializedNode() {
        return this.fRestrictToMaterializedNode;
    }

    public void setRestrictToMaterializedNode(boolean pRestrictToMaterializedNode) {
        this.fRestrictToMaterializedNode = pRestrictToMaterializedNode;
    }

    protected static class StopOnCompType {
        protected String fCodeCompType;
        protected boolean fIncludeInScope = true;

        public StopOnCompType(String pCodeCompType, boolean pIncludeInScope) {
            this.fCodeCompType = pCodeCompType;
            this.fIncludeInScope = pIncludeInScope;
        }
    }
}

