/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.ant.ftp;

import java.io.IOException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.Retryable;

public class RetryHandler {
    private int retriesAllowed = 0;
    private long fTimeToSleep = 0L;
    private Task task;

    public RetryHandler(int pRetriesAllowed, Task pTask) {
        this.retriesAllowed = pRetriesAllowed;
        this.task = pTask;
    }

    public RetryHandler(int pRetriesAllowed, Task pTask, long pTimeToSleep) {
        this.retriesAllowed = pRetriesAllowed;
        this.task = pTask;
        this.fTimeToSleep = pTimeToSleep;
    }

    public void execute(Retryable exe, String desc) throws IOException {
        int retries = 0;
        while (true) {
            try {
                exe.execute();
            }
            catch (IOException e) {
                if (++retries > this.retriesAllowed && this.retriesAllowed > -1) {
                    this.task.log("try #" + retries + ": IO error (" + desc + "), number of maximum retries reached (" + this.retriesAllowed + "), giving up", 1);
                    throw e;
                }
                this.task.log("try #" + retries + ": IO error (" + desc + "), retrying", 1);
                if (this.fTimeToSleep <= 0L) continue;
                try {
                    Thread.sleep(this.fTimeToSleep);
                }
                catch (Exception ee) {}
                continue;
            }
            break;
        }
    }
}

