/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.generator;

import com.scenari.m.ge.generator.DestInfo;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import java.util.HashMap;
import java.util.Map;

public class DestLockMgr {
    protected static DestLockMgr sSingleton = new DestLockMgr();
    protected Map<Object, DestLock> fLocks = new HashMap<Object, DestLock>();

    public static DestLockMgr get() {
        return sSingleton;
    }

    public synchronized boolean isDestWriteLocked(ISrcNode pDest) throws Exception {
        Object vKey = this.xGetKey(pDest);
        DestLock vLock = this.fLocks.get(vKey);
        if (vLock == null) {
            return false;
        }
        return vLock.fLockedForRead == 0;
    }

    public synchronized DestInfo getLockedGenInfo(ISrcNode pDest) throws Exception {
        Object vKey = this.xGetKey(pDest);
        DestLock vLock = this.fLocks.get(vKey);
        if (vLock != null) {
            return vLock.fGen.getDestInfos();
        }
        return null;
    }

    public synchronized Object lockOrGetGenInfo(IGenerator pGen) throws Exception {
        Object vKey = this.xGetKey(pGen.getDestRoot());
        DestLock vLock = this.fLocks.get(vKey);
        if (vLock != null) {
            if (vLock.fGen == pGen) {
                assert (vLock.fLockedForRead != 0);
                ++vLock.fLockedForRead;
                return vLock;
            }
            return vLock.fGen.getDestInfos();
        }
        vLock = new DestLock(pGen, vKey, false);
        this.fLocks.put(vKey, vLock);
        return vLock;
    }

    public synchronized DestLock tryLockDest(IGenerator pGen, boolean pForWrite) throws Exception {
        Object vKey = this.xGetKey(pGen.getDestRoot());
        DestLock vLockDest = this.fLocks.get(vKey);
        if (vLockDest != null) {
            if (vLockDest.fLockedForRead == 0) {
                return null;
            }
            if (pForWrite) {
                while (vLockDest.fLockedForRead != -1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        vLockDest = new DestLock(pGen, vKey, pForWrite);
        this.fLocks.put(vKey, vLockDest);
        return vLockDest;
    }

    protected Object xGetKey(ISrcNode pDest) throws Exception {
        String vKey = SrcFeatureAlternateUrl.getFilePath(pDest);
        if (vKey == null) {
            vKey = pDest.getSrcUri();
        }
        return vKey;
    }

    public class DestLock {
        protected Object fKey;
        protected IGenerator fGen;
        protected int fLockedForRead;

        protected DestLock(IGenerator pGen, Object pKey, boolean pForWrite) {
            this.fGen = pGen;
            this.fKey = pKey;
            this.fLockedForRead = pForWrite ? 0 : 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            DestLockMgr destLockMgr = DestLockMgr.this;
            synchronized (destLockMgr) {
                switch (this.fLockedForRead) {
                    case 0: {
                        DestLockMgr.this.fLocks.remove(this.fKey);
                        break;
                    }
                    case 1: {
                        this.fLockedForRead = -1;
                        DestLockMgr.this.notifyAll();
                        DestLockMgr.this.fLocks.remove(this.fKey);
                        break;
                    }
                    default: {
                        --this.fLockedForRead;
                    }
                }
            }
        }
    }
}

