/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.generator.ant;

import com.scenari.m.ge.generator.IGenerator;
import eu.scenari.fw.log.ILogMsg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.util.StringUtils;

public class AntLogger
extends DefaultLogger {
    IGenerator fGenerator;

    public AntLogger(IGenerator pGenerator) {
        this.fGenerator = pGenerator;
    }

    public void buildFinished(BuildEvent event) {
        Throwable vError = event.getException();
        StringBuffer vMessage = new StringBuffer();
        if (vError == null) {
            vMessage.append(StringUtils.LINE_SEP);
            vMessage.append(this.getBuildSuccessfulMessage());
        } else {
            vMessage.append(StringUtils.LINE_SEP);
            vMessage.append(this.getBuildFailedMessage());
            vMessage.append(StringUtils.LINE_SEP);
            if (3 <= this.msgOutputLevel || !(vError instanceof BuildException)) {
                vMessage.append(StringUtils.getStackTrace((Throwable)vError));
            } else {
                vMessage.append(vError.toString()).append(lSep);
            }
        }
        if (vError == null) {
            this.fGenerator.addTrace(vMessage.toString(), ILogMsg.LogType.Info, new String[0]);
        } else {
            this.fGenerator.addTrace(vMessage.toString(), ILogMsg.LogType.Error, new String[0]);
        }
    }

    public void messageLogged(BuildEvent pEvent) {
        int vPriority = pEvent.getPriority();
        if (vPriority <= this.msgOutputLevel) {
            StringBuffer vMessage = new StringBuffer();
            if (pEvent.getTask() != null && !this.emacsMode) {
                String name = pEvent.getTask().getTaskName();
                String label = "[" + name + "] ";
                int size = 12 - label.length();
                StringBuffer tmp = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    tmp.append(" ");
                }
                tmp.append(label);
                label = tmp.toString();
                Pattern vNoAlphaNum = Pattern.compile("\\W");
                try {
                    BufferedReader r = new BufferedReader(new StringReader(pEvent.getMessage()));
                    String line = r.readLine();
                    boolean first = true;
                    do {
                        if (first) {
                            if (line == null) {
                                vMessage.append(label);
                                break;
                            }
                        } else {
                            vMessage.append(StringUtils.LINE_SEP);
                        }
                        first = false;
                        if (vNoAlphaNum.matcher(line).replaceAll("").length() <= 0) continue;
                        vMessage.append(label).append(line);
                    } while ((line = r.readLine()) != null);
                }
                catch (IOException e) {
                    vMessage.append(label).append(pEvent.getMessage());
                }
            } else {
                vMessage.append(pEvent.getMessage());
            }
            Throwable ex = pEvent.getException();
            if (4 <= this.msgOutputLevel && ex != null) {
                vMessage.append(StringUtils.getStackTrace((Throwable)ex));
            }
            if (vPriority != 0) {
                this.fGenerator.addTrace(vMessage.toString(), ILogMsg.LogType.Info, new String[0]);
            } else {
                this.fGenerator.addTrace(vMessage.toString(), ILogMsg.LogType.Error, new String[0]);
            }
        }
    }
}

