/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.generator.base;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.DataFromSource;
import com.scenari.m.co.donnee.HDonneeUtils;
import com.scenari.m.co.donnee.IComputedData;
import com.scenari.m.co.instance.IWInstFormation;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.xpath.dtm.XAgent;
import com.scenari.m.ge.agent.IWADialogExport;
import com.scenari.m.ge.agent.pages.HDialogPages;
import com.scenari.m.ge.composant.pages.XPage;
import com.scenari.m.ge.generator.DestInfo;
import com.scenari.m.ge.generator.DestLockMgr;
import com.scenari.m.ge.generator.IDynamicFile;
import com.scenari.m.ge.generator.IFileModel;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.m.ge.generator.IScriptableFunctions;
import com.scenari.m.ge.generator.IScripter;
import com.scenari.m.ge.generator.ISkin;
import com.scenari.m.ge.generator.base.DestLockException;
import com.scenari.m.ge.generator.base.ScripterDefault;
import com.scenari.m.ge.pages.DynamicInclWriter;
import com.scenari.m.ge.pages.IProducerPage;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.s.fw.utils.HLinkedList;
import com.scenari.s.fw.utils.HUrl;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.serializer.simple.XmlWriterAppendable;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.paths.ISrcAliasResolver;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.feature.relocate.SrcFeatureRelocate;
import com.scenari.src.helpers.util.ZipperSrc;
import com.scenari.xsldtm.xalan.processor.TransformerFactoryImpl;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.ILogMsgHandlerAsObject;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.LogMsg;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.mime.MimeMgr;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.fw.stream.bytes.InputStreamByteStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorBase
implements IGenerator,
ILogMsgHandlerAsObject,
ISrcAliasResolver {
    public static final String KEYPROPERTY_DESTSTATUSFILE = "destination.status.filepath";
    public static final String KEYPROPERTY_DESTSTATUSFILE_DEL = "destination.status.deletefile";
    public static final String KEYPROPERTY_DESTLASTUPDATEFILE = "destination.lastupdates.filepath";
    public static final String KEYPROPERTY_DESTSONESTREAM_MIMETYPE = "destination.onestream.mimetype";
    public static final String KEYPROPERTY_SOURCETEMPLATELIST = "source.templatelist.filepath";
    public static final String KEYPROPERTY_DESTSONESTREAM_BUILDER = "destination.onestream.builder";
    public static final String PREFIX_PUBFOLDER = "pub:";
    public static final String PREFIX_SKINSRC = "skin:";
    public static final String PREFIX_DESTFOLDER = "dest:";
    protected static final char[] ID_ENCODER = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static long sLockGenDuration = 1200000L;
    public static String sInitFileName = "init.properties";
    public static String sTemplatesListPath = "templateList.xml";
    public static String sUrlLastUpdatesFiles = "meta/~LastUpdatesFiles.obj";
    public static String sTraceFileName = "meta/~Traces.xml";
    public static String sStatusFileName = "meta/~Status.txt";
    public static boolean sCheckPublishFilesUpdates = false;
    public static TracePoint sTraceLink = TraceMgr.register(GeneratorBase.class.getName().concat(".Link"), "Trace les dialogues d'origine et de destination pour chaque page g\u00e9n\u00e9r\u00e9e.");
    public static SimpleDateFormat sFormatDate = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
    protected boolean fModeGenerateByDiff = false;
    protected DataOutputStream fTimeStampsSourceFiles = null;
    protected List fFilesAlreadyExported = null;
    protected ISrcNode fDestRoot = null;
    protected ISrcContent fDestStatusFile = null;
    protected long fDestLastGen = -1L;
    protected int fDestLastStatus = 0;
    protected String fDestLastUser = null;
    protected String fDestLastMode = null;
    protected String fDestLastSkin = null;
    protected String fDestLastLang = null;
    protected ISrcNode fPubRoot = null;
    protected long fPubRootLastModif = -1L;
    protected boolean fPubRootInitOk = false;
    protected Map<String, ISkin> fMapSkins = null;
    protected Map fProperties = new HashMap();
    protected Properties fPubProperties = null;
    protected Map fModelPages = new HashMap();
    protected IScripter fScripter = null;
    protected ISrcContent fTraceFile = null;
    protected StringBuilder fTraceTemp = null;
    protected IXmlWriter fTraceWriter = null;
    protected HLinkedList fDialogStack = new HLinkedList();
    protected ArrayList<IWAgent> fUniqueIds = new ArrayList();
    protected Map fTemplates = new HashMap();
    protected XScriptableFunctions fScriptableFunctions;
    protected ISkin fSkin = null;
    protected volatile DestLockMgr.DestLock fLockDest = null;
    protected ISrcNode fCurrentPubFile = null;
    protected IHDialog fCurrentDialog = null;
    protected String fCurrentDestUri = null;
    protected String fUrlEncoding = "UTF-8";

    public static String buildRelativeUrl(String pUrlFrom, String pUrlTo) throws Exception {
        return GeneratorBase.buildRelativeUrl(pUrlFrom, pUrlTo, null);
    }

    public static String buildRelativeUrl(String pUrlFrom, String pUrlTo, String pEncodingForUrlEncoding) throws Exception {
        String vUrlSrc = pUrlFrom == null ? "" : pUrlFrom;
        String vUrlDst = pUrlTo;
        int vSlashSrc = vUrlSrc.indexOf(47, 1);
        int vSlashDest = vUrlDst.indexOf(47, 1);
        int vPreviousSlash = 0;
        while (vSlashDest == vSlashSrc && vSlashSrc >= 0 && vUrlSrc.regionMatches(vPreviousSlash, vUrlDst, vPreviousSlash, vSlashSrc - vPreviousSlash)) {
            vPreviousSlash = vSlashSrc;
            vSlashSrc = vUrlSrc.indexOf(47, vSlashSrc + 1);
            vSlashDest = vUrlDst.indexOf(47, vSlashDest + 1);
        }
        StringBuilder vBuf = new StringBuilder(vUrlDst.length());
        int vIdx = vSlashSrc;
        while (vIdx > 0) {
            vBuf.append("../");
            vIdx = vUrlSrc.indexOf(47, vIdx + 1);
        }
        vSlashDest = vSlashDest < 0 ? vUrlDst.lastIndexOf(47) : vUrlDst.lastIndexOf(47, vSlashDest - 1);
        vBuf.append(vUrlDst.substring(vSlashDest + 1));
        return pEncodingForUrlEncoding != null ? HUrl.hEncode(vBuf, pEncodingForUrlEncoding) : vBuf.toString();
    }

    public static String transformNameWithOneExt(String pUrl) throws Exception {
        int vLastPt;
        int vOffsetLastName = pUrl.lastIndexOf(47);
        int vFirstPt = pUrl.indexOf(46, vOffsetLastName);
        if (vFirstPt != (vLastPt = pUrl.lastIndexOf(46)) && vLastPt > vOffsetLastName) {
            int i;
            StringBuilder vBuf = new StringBuilder(pUrl.length());
            for (i = 0; i < vFirstPt; ++i) {
                vBuf.append(pUrl.charAt(i));
            }
            vBuf.append('_');
            for (i = vFirstPt + 1; i < vLastPt; ++i) {
                char vCar = pUrl.charAt(i);
                if (vCar == '.') {
                    vBuf.append('_');
                    continue;
                }
                vBuf.append(vCar);
            }
            int vLen = pUrl.length();
            for (int i2 = vLastPt; i2 < vLen; ++i2) {
                vBuf.append(pUrl.charAt(i2));
            }
            return vBuf.toString();
        }
        return pUrl;
    }

    @Override
    public boolean initDestination() throws Exception {
        DestLockMgr.DestLock vLockDest = DestLockMgr.get().tryLockDest(this, true);
        if (vLockDest == null) {
            return false;
        }
        try {
            this.fLockDest = vLockDest;
            this.fDestLastStatus = 1;
            this.fDestLastGen = -1L;
            this.fDestLastLang = null;
            this.fDestLastMode = null;
            this.fDestLastSkin = null;
            this.fDestLastUser = null;
            this.fTraceFile = SrcFeaturePaths.findContentByPath(this.fDestRoot, (String)this.getProperty("destination.trace.filepath"), false);
            return true;
        }
        catch (Exception e) {
            this.closeDestination(true);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeDestination(boolean pForceInStatusFailed) throws Exception {
        try {
            if (pForceInStatusFailed && this.fDestLastStatus < 4) {
                this.fDestLastStatus = 4;
            } else if (this.fDestLastStatus < 2) {
                this.fDestLastStatus = 2;
            }
            if (this.fTraceFile != null) {
                String vTraceDelete = (String)this.getProperty("destination.trace.deletefile");
                if (vTraceDelete == null || vTraceDelete.equals("never") || vTraceDelete.equals("ifStatusOk") && this.fDestLastStatus > 2) {
                    if (this.fTraceTemp != null) {
                        OutputStreamWriter vWriter = new OutputStreamWriter(this.fTraceFile.newOutputStream(false), "UTF-8");
                        vWriter.write(this.fTraceTemp.toString());
                        this.fTraceWriter = new XmlWriterAppendable(vWriter);
                    }
                    this.fTraceWriter.writeStartTag("end");
                    this.fTraceWriter.writeAttribute("t", sFormatDate.format(new Date()));
                    this.fTraceWriter.writeEndEmptyTag();
                    this.fTraceWriter.writeCloseTag("trace");
                    this.fTraceWriter.close();
                } else {
                    this.fTraceWriter.close();
                    this.fTraceFile.removeSrc();
                }
            }
            this.fTraceTemp = null;
            this.fTraceWriter = null;
            String vStatusFileDelete = (String)this.getProperty(KEYPROPERTY_DESTSTATUSFILE_DEL);
            if (vStatusFileDelete == null || vStatusFileDelete.equals("never") || vStatusFileDelete.equals("ifStatusOk") && this.fDestLastStatus > 2) {
                this.saveStatusLastGen();
            }
            this.fProperties.clear();
        }
        finally {
            if (this.fLockDest != null) {
                this.fLockDest.release();
                this.fLockDest = null;
            }
        }
    }

    @Override
    public int getDestStatus() throws Exception {
        if (this.fLockDest != null) {
            return 1;
        }
        this.loadStatusLastGen();
        return this.fDestLastStatus;
    }

    @Override
    public long getDestLastGen() throws Exception {
        this.loadStatusLastGen();
        return this.fDestLastGen;
    }

    @Override
    public String getDestUser() throws Exception {
        this.loadStatusLastGen();
        return this.fDestLastUser;
    }

    @Override
    public String getDestMode() throws Exception {
        this.loadStatusLastGen();
        return this.fDestLastMode;
    }

    @Override
    public String getDestSkin() throws Exception {
        this.loadStatusLastGen();
        return this.fDestLastSkin;
    }

    @Override
    public String getDestLang() throws Exception {
        this.loadStatusLastGen();
        return this.fDestLastLang;
    }

    @Override
    public DestInfo getDestInfos() throws Exception {
        DestInfo vDestInfo = this.loadStatusLastGen();
        if (vDestInfo == null) {
            vDestInfo = new DestInfo();
            vDestInfo.setDestLang(this.fDestLastLang);
            vDestInfo.setDestMode(this.fDestLastMode);
            vDestInfo.setDestRoot(this.fDestRoot);
            vDestInfo.setDestSkin(this.fDestLastSkin);
            vDestInfo.setDestStatus(this.fLockDest != null ? 1 : this.fDestLastStatus);
            vDestInfo.setDestUser(this.fDestLastUser);
            vDestInfo.setDestHomePath(this.getDestHomePath());
            vDestInfo.setDestLastGen(this.fDestLastGen);
            vDestInfo.setDestMimeDownload(this.getDestOneStreamContentType());
            vDestInfo.setDestTraceFilePath((String)this.getProperty("destination.trace.filepath"));
            vDestInfo.setMapSkins(this.fMapSkins);
        }
        return vDestInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DestInfo loadStatusLastGen() throws Exception {
        block23: {
            if (this.fLockDest != null) {
                return null;
            }
            Object vResult = DestLockMgr.get().lockOrGetGenInfo(this);
            if (vResult instanceof DestInfo) {
                DestInfo vDestInfo = (DestInfo)vResult;
                this.fDestLastGen = -1L;
                this.fDestLastStatus = 1;
                this.fDestLastLang = vDestInfo.getDestLang();
                this.fDestLastMode = vDestInfo.getDestMode();
                this.fDestLastSkin = vDestInfo.getDestSkin();
                this.fDestLastUser = vDestInfo.getDestUser();
                return vDestInfo;
            }
            try {
                boolean vReadStatusFile;
                if (this.fDestStatusFile == null) {
                    String vStatusPath = (String)this.getProperty(KEYPROPERTY_DESTSTATUSFILE);
                    this.fDestStatusFile = vStatusPath != null && vStatusPath.length() > 0 ? SrcFeaturePaths.findContentByPath(this.fDestRoot, vStatusPath, false) : null;
                    vReadStatusFile = this.fDestStatusFile != null && this.fDestStatusFile.getContentStatus() == 1;
                } else {
                    vReadStatusFile = SrcFeatureRefresh.isUpdatedOrUnknown(this.fDestStatusFile, this.fDestLastGen);
                }
                if (!vReadStatusFile) break block23;
                this.fDestLastGen = this.fDestStatusFile.getLastModif();
                DataInputStream vIn = new DataInputStream(this.fDestStatusFile.newInputStream(true));
                try {
                    int vC = vIn.read();
                    this.fDestLastStatus = vC == 50 ? 2 : (vC == 51 ? 3 : (vC == 52 ? 4 : (vC == 53 ? 5 : 0)));
                    try {
                        String vKey = vIn.readUTF();
                        while (vKey.length() > 0) {
                            String vValue = vIn.readUTF();
                            if (vKey.equals("skin")) {
                                this.fDestLastSkin = vValue;
                            } else if (vKey.equals("mode")) {
                                this.fDestLastMode = vValue;
                            } else if (vKey.equals("user")) {
                                this.fDestLastUser = vValue;
                            } else if (vKey.equals("lang")) {
                                this.fDestLastLang = vValue;
                            }
                            vKey = vIn.readUTF();
                        }
                    }
                    catch (EOFException e) {
                        // empty catch block
                    }
                }
                finally {
                    if (vIn != null) {
                        vIn.close();
                    }
                }
            }
            catch (Exception e) {
                this.fDestLastGen = 0L;
                this.fDestLastStatus = 0;
                this.fDestLastLang = null;
                this.fDestLastMode = null;
                this.fDestLastSkin = null;
                this.fDestLastUser = null;
            }
            finally {
                ((DestLockMgr.DestLock)vResult).release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveStatusLastGen() throws Exception {
        if (this.fDestStatusFile == null) {
            String vStatusPath = (String)this.getProperty(KEYPROPERTY_DESTSTATUSFILE);
            ISrcContent iSrcContent = this.fDestStatusFile = vStatusPath != null && vStatusPath.length() > 0 ? SrcFeaturePaths.findContentByPath(this.fDestRoot, vStatusPath, false) : null;
        }
        if (this.fDestStatusFile != null) {
            DataOutputStream vWriter = new DataOutputStream(this.fDestStatusFile.newOutputStream(true));
            try {
                vWriter.write(this.fDestLastStatus + 48);
                if (this.fDestLastUser != null) {
                    vWriter.writeUTF("user");
                    vWriter.writeUTF(this.fDestLastUser);
                }
                if (this.fDestLastMode != null) {
                    vWriter.writeUTF("mode");
                    vWriter.writeUTF(this.fDestLastMode);
                }
                if (this.fDestLastSkin != null) {
                    vWriter.writeUTF("skin");
                    vWriter.writeUTF(this.fDestLastSkin);
                }
                if (this.fDestLastLang != null) {
                    vWriter.writeUTF("lang");
                    vWriter.writeUTF(this.fDestLastLang);
                }
            }
            finally {
                vWriter.close();
            }
        }
    }

    @Override
    public void generate(IWInstFormation pInstance, IUser pUser, String pMode, String pSkin, String pLang) throws Exception {
        assert (this.fLockDest != null);
        LogMgr.subscribeAsObject(this, true);
        try {
            this.fDestLastLang = pLang;
            this.fDestLastMode = pMode;
            String string = this.fDestLastUser = pUser != null ? pUser.getAccount() : null;
            if (pUser != null) {
                this.setProperty("user", pUser);
            }
            if (pMode != null) {
                this.setProperty("mode", pMode);
            }
            if (pSkin != null) {
                this.setProperty("skin", pSkin);
            }
            if (pLang != null) {
                this.setProperty("lang", pLang);
            }
            if (!this.fPubRootInitOk || sCheckPublishFilesUpdates && SrcFeatureRefresh.isUpdatedOrUnknown(this.fPubRoot, this.fPubRootLastModif)) {
                this.wSetPubRoot(this.fPubRoot);
                if (!this.fPubRootInitOk) {
                    throw new Exception("Init generator failed.");
                }
            }
            this.initSkin(pInstance, pUser, pMode, pSkin, pLang);
            this.initGenerateByDiff(pInstance, pUser, pMode, pSkin, pLang);
            if (this.fTraceFile != null) {
                OutputStreamWriter vWriter = new OutputStreamWriter(this.fTraceFile.newOutputStream(false), "UTF-8");
                if (this.fTraceTemp != null) {
                    vWriter.write(this.fTraceTemp.toString());
                    this.fTraceWriter = new XmlWriterAppendable(vWriter);
                    this.fTraceTemp = null;
                } else {
                    this.fTraceWriter = new XmlWriterAppendable(vWriter);
                    this.fTraceWriter.writeHeaderXml("UTF-8");
                    this.fTraceWriter.writeOpenTag("trace");
                }
            } else {
                this.fTraceWriter = new XmlWriterAppendable(new StringBuilder());
                this.fTraceWriter.writeOpenTag("trace");
            }
            this.fTraceWriter.writeStartTag("start");
            this.fTraceWriter.writeAttribute("t", sFormatDate.format(new Date()));
            this.fTraceWriter.writeEndEmptyTag();
            if (this.fScripter == null) {
                this.fScripter = this.wNewScripter();
            }
            this.xGenerate(pInstance, pUser, pMode, pSkin, pLang);
            if (this.fModeGenerateByDiff && this.fFilesAlreadyExported != null) {
                int i;
                ArrayList<String> vFoldersToRemove = null;
                for (i = 0; i < this.fFilesAlreadyExported.size(); ++i) {
                    WFileIhmExported vFile = (WFileIhmExported)this.fFilesAlreadyExported.get(i);
                    if (vFile.fReexported) continue;
                    this.xRemoveDst(this.fDestRoot.findContentByUri(vFile.fUriDest));
                    int vOffset = vFile.fUriDest.lastIndexOf(47);
                    if (vOffset <= 0) continue;
                    String vFolder = vFile.fUriDest.substring(0, vOffset);
                    if (vFoldersToRemove == null) {
                        vFoldersToRemove = new ArrayList<String>();
                        continue;
                    }
                    if (!vFoldersToRemove.contains(vFolder)) continue;
                    vFoldersToRemove.add(vFolder);
                }
                if (vFoldersToRemove != null) {
                    for (i = 0; i < vFoldersToRemove.size(); ++i) {
                        String vFolder = (String)vFoldersToRemove.get(i);
                        while (vFolder != null) {
                            ISrcContent vElem = SrcFeaturePaths.findContentByPath(this.fDestRoot, vFolder, false);
                            List<String> vChilds = vElem.listChildrenNames(null, 0);
                            if (vChilds == null || vChilds.size() == 0) {
                                vElem.removeSrc();
                                int vOffset = vFolder.lastIndexOf(47);
                                if (vOffset > 0) {
                                    vFolder = vFolder.substring(0, vOffset);
                                    continue;
                                }
                                vFolder = null;
                                continue;
                            }
                            vFolder = null;
                        }
                    }
                }
            }
        }
        catch (DestLockException e) {
            this.fDestLastStatus = 5;
            this.addTrace(ILogMsg.LogType.FatalError, LogMgr.getMessage(e));
            throw e;
        }
        catch (Exception e) {
            this.addTrace(ILogMsg.LogType.FatalError, LogMgr.getMessage(e));
            throw (Exception)LogMgr.addMessage((Throwable)e, "Generation failed.", new String[0]);
        }
        catch (Error e) {
            this.addTrace(ILogMsg.LogType.FatalError, LogMgr.getMessage(e));
            throw (Error)LogMgr.addMessage((Throwable)e, "Generation failed.", new String[0]);
        }
        finally {
            if (this.fTimeStampsSourceFiles != null) {
                this.fTimeStampsSourceFiles.writeUTF("");
                this.fTimeStampsSourceFiles.close();
                this.fTimeStampsSourceFiles = null;
            }
            LogMgr.unsubscribeAsObject(this, true);
            this.wResetAfterGenerate();
        }
    }

    protected void initSkin(IWInstFormation pInstance, IUser pActeur, String pMode, String pSkin, String pLangue) throws Exception {
        if (this.fMapSkins != null) {
            String vSkinCd = pSkin != null && pSkin.length() > 0 ? pSkin : "default";
            this.fSkin = this.fMapSkins.get(vSkinCd);
            if (this.fSkin == null) {
                this.fSkin = this.fMapSkins.get("default");
            }
        } else {
            this.fSkin = null;
        }
        this.fDestLastSkin = this.fSkin != null ? this.fSkin.getCode() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initGenerateByDiff(IWInstFormation pInstance, IUser pActeur, String pMode, String pSkin, String pLangue) throws Exception, DestLockException {
        String vModeGenByDiff = (String)this.getProperty("generate.by.difference");
        this.fModeGenerateByDiff = vModeGenByDiff != null ? HDonneeUtils.hGetBooleanEvalTrue(vModeGenByDiff) : false;
        if (this.fModeGenerateByDiff) {
            this.fFilesAlreadyExported = null;
            InputStream vInput = SrcFeaturePaths.findContentByPath(this.fDestRoot, (String)this.getProperty(KEYPROPERTY_DESTLASTUPDATEFILE), false).newInputStream(false);
            if (vInput != null) {
                this.fFilesAlreadyExported = new ArrayList(128);
                DataInputStream vDataInput = new DataInputStream(vInput);
                try {
                    String vUriDest = vDataInput.readUTF();
                    while (vUriDest.length() != 0) {
                        WFileIhmExported vFile = new WFileIhmExported(vDataInput.readUTF(), vDataInput.readLong(), vUriDest);
                        this.fFilesAlreadyExported.add(vFile);
                        vUriDest = vDataInput.readUTF();
                    }
                    Collections.sort(this.fFilesAlreadyExported);
                }
                catch (Exception e) {
                    this.fFilesAlreadyExported = null;
                    LogMgr.publishException((Throwable)e, "Echec \u00e0 la r\u00e9cup\u00e9ration de la liste des url export\u00e9es.", ILogMsg.LogType.Info, new String[0]);
                }
                finally {
                    vDataInput.close();
                }
                try {
                    this.wDeleteDynamicFiles(pInstance, pActeur, pMode, pSkin, pLangue);
                }
                catch (DestLockException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw (Exception)LogMgr.addMessage(new DestLockException(e), LogMgr.getMessage(e));
                }
            }
            this.wResetDestination(pInstance, pActeur, pMode, pSkin, pLangue);
            this.fTimeStampsSourceFiles = new DataOutputStream(SrcFeaturePaths.findContentByPath(this.fDestRoot, (String)this.getProperty(KEYPROPERTY_DESTLASTUPDATEFILE), false).newOutputStream(false));
        } else {
            this.wResetDestination(pInstance, pActeur, pMode, pSkin, pLangue);
        }
    }

    @Override
    public ISrcNode getDestRoot() {
        return this.fDestRoot;
    }

    @Override
    public ISrcNode getPubRoot() {
        return this.fPubRoot;
    }

    @Override
    public String getDestHomePath() {
        String vPathIndex = (String)this.getProperty("destination.root.filepath");
        if ((vPathIndex = this.xResolveFirstMatchFile(vPathIndex)) == null) {
            return "";
        }
        if (!"#null".equals(vPathIndex)) {
            return vPathIndex;
        }
        return null;
    }

    @Override
    public Object getProperty(String pKey) {
        Object vResult = this.fProperties.get(pKey);
        if (vResult == null && this.fPubProperties != null) {
            vResult = this.fPubProperties.get(pKey);
        }
        return vResult;
    }

    @Override
    public Iterator getProperties() {
        return new Iterator(){
            Iterator fDynIt;
            Iterator fPubIt;
            Map.Entry fNextPubEntry;
            {
                this.fDynIt = GeneratorBase.this.fProperties != null ? GeneratorBase.this.fProperties.entrySet().iterator() : null;
                this.fPubIt = GeneratorBase.this.fPubProperties.entrySet().iterator();
                this.fNextPubEntry = this.xGetNextPubEntry();
            }

            public boolean hasNext() {
                if (this.fDynIt != null) {
                    if (this.fDynIt.hasNext()) {
                        return true;
                    }
                    this.fDynIt = null;
                }
                return this.fNextPubEntry != null;
            }

            public Object next() {
                if (this.fDynIt != null) {
                    return this.fDynIt.next();
                }
                if (this.fNextPubEntry != null) {
                    Map.Entry vRes = this.fNextPubEntry;
                    this.fNextPubEntry = this.xGetNextPubEntry();
                    return vRes;
                }
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            protected Map.Entry xGetNextPubEntry() {
                while (this.fPubIt.hasNext()) {
                    Map.Entry vNextPubIt = (Map.Entry)this.fPubIt.next();
                    if (GeneratorBase.this.fProperties != null && GeneratorBase.this.fProperties.containsKey(vNextPubIt.getKey())) continue;
                    return vNextPubIt;
                }
                return null;
            }
        };
    }

    @Override
    public void setDestRoot(ISrcNode pDocServeur) throws Exception {
        this.fDestRoot = pDocServeur.getSrcUri().equals("") ? pDocServeur : SrcFeatureRelocate.relocateAsRoot(pDocServeur);
        this.fDestStatusFile = null;
    }

    @Override
    public void setPubRoot(ISrcNode pPubRoot) throws Exception {
        if (pPubRoot.getSrcUri().equals("")) {
            this.wSetPubRoot(pPubRoot);
        } else {
            this.wSetPubRoot(SrcFeatureRelocate.relocateAsRoot(pPubRoot));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wSetPubRoot(ISrcNode pPubRoot) throws Exception {
        block21: {
            this.initBeforeSettingPubRoot();
            this.fPubRoot = pPubRoot;
            int vLastStatus = this.fDestLastStatus;
            this.fDestLastStatus = 1;
            try {
                String vListTemplatesSource;
                if (this.fPubRoot.getContentStatus() != 2) {
                    this.addTrace("Le dossier de l'IHM source n'existe pas ou n'est pas un dossier : " + pPubRoot, ILogMsg.LogType.Error, new String[0]);
                    break block21;
                }
                InputStream vInput = SrcFeaturePaths.findContentByPath(this.fPubRoot, sInitFileName, false).newInputStream(false);
                if (vInput != null) {
                    try {
                        this.fPubProperties.load(vInput);
                    }
                    catch (Exception e) {
                        throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la lecture du fichier d'initialisation de l'IHM : " + sInitFileName, new String[0]);
                    }
                    finally {
                        vInput.close();
                    }
                }
                if ((vListTemplatesSource = (String)this.getProperty(KEYPROPERTY_SOURCETEMPLATELIST)) != null && vListTemplatesSource.length() > 0 && (vInput = SrcFeaturePaths.findContentByPath(this.fPubRoot, vListTemplatesSource, false).newInputStream(false)) != null) {
                    XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                    try {
                        vReader.setContentHandler(new TemplatesListContentHandler());
                        vReader.parse(new InputSource(vInput));
                    }
                    catch (SAXException e) {
                        throw (Exception)LogMgr.addMessage((Throwable)e.getException(), "Echec \u00e0 la lecture du fichier d\u00e9finissant la liste des templates : " + vListTemplatesSource, new String[0]);
                    }
                    catch (Exception e) {
                        throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la lecture du fichier d\u00e9finissant la liste des templates : " + vListTemplatesSource, new String[0]);
                    }
                    finally {
                        HPoolXmlReader.hGet().hFreeXmlReader(vReader);
                        vInput.close();
                    }
                }
                this.initAfterSettingPubRoot();
            }
            catch (Exception e) {
                this.addTrace(ILogMsg.LogType.Error, LogMgr.getMessage(e));
            }
            finally {
                if (this.fDestLastStatus == 1) {
                    this.fDestLastStatus = vLastStatus;
                    this.fPubRootLastModif = this.fPubRoot.getLastModifWithChildren();
                    this.fPubRootInitOk = true;
                } else {
                    this.fDestLastStatus = vLastStatus;
                    this.fPubRootInitOk = false;
                }
            }
        }
    }

    protected void initBeforeSettingPubRoot() throws Exception {
        this.fPubProperties = new Properties();
        this.fPubProperties.put("destination.trace.filepath", sTraceFileName);
        this.fPubProperties.put(KEYPROPERTY_DESTSTATUSFILE, sStatusFileName);
        this.fPubProperties.put(KEYPROPERTY_DESTLASTUPDATEFILE, sUrlLastUpdatesFiles);
        this.fPubProperties.put(KEYPROPERTY_SOURCETEMPLATELIST, sTemplatesListPath);
        this.fTemplates.clear();
        this.fScripter = null;
    }

    protected boolean initAfterSettingPubRoot() throws Exception {
        return true;
    }

    @Override
    public Map<String, ISkin> getMapSkins() {
        return this.fMapSkins;
    }

    @Override
    public void setMapSkins(Map<String, ISkin> pMapSkins) throws Exception {
        this.fMapSkins = pMapSkins;
    }

    @Override
    public void setProperty(String pKey, Object pValue) throws Exception {
        this.fProperties.put(pKey, pValue);
    }

    public WFileIhmExported wIsFileAlreadyExported(String pUrlSource, String pUrslDst) throws Exception {
        int vOffset;
        if (this.fModeGenerateByDiff && this.fFilesAlreadyExported != null && (vOffset = GeneratorBase.searchExporteFiles(this.fFilesAlreadyExported, pUrlSource, pUrslDst)) >= 0) {
            return (WFileIhmExported)this.fFilesAlreadyExported.get(vOffset);
        }
        return null;
    }

    public WFileIhmExported wIsSourceAlreadyExported(String pUrlSource) throws Exception {
        int vOffset;
        if (this.fModeGenerateByDiff && this.fFilesAlreadyExported != null && (vOffset = GeneratorBase.searchExporteFilesOnSrc(this.fFilesAlreadyExported, pUrlSource)) >= 0) {
            return (WFileIhmExported)this.fFilesAlreadyExported.get(vOffset);
        }
        return null;
    }

    public WFileIhmExported wIsDestUriAlreadyExported(String pDestUri) throws Exception {
        int vOffset;
        if (this.fModeGenerateByDiff && this.fFilesAlreadyExported != null && (vOffset = GeneratorBase.searchExporteFilesOnDst(this.fFilesAlreadyExported, pDestUri)) >= 0) {
            return (WFileIhmExported)this.fFilesAlreadyExported.get(vOffset);
        }
        return null;
    }

    public void wAddFileExported(String pUrlSource, long pLastModifSource, String pUrlDest) throws Exception {
        if (this.fModeGenerateByDiff && this.fTimeStampsSourceFiles != null) {
            this.fTimeStampsSourceFiles.writeUTF(pUrlDest);
            this.fTimeStampsSourceFiles.writeUTF(pUrlSource);
            this.fTimeStampsSourceFiles.writeLong(pLastModifSource);
        }
    }

    @Override
    public void wAddDialog(IWADialogExport pDialog) throws Exception {
        this.fDialogStack.addLast(pDialog);
        if (sTraceLink.isEnabled()) {
            StringBuilder vBuf = new StringBuilder(500);
            vBuf.append("<lienpage>");
            vBuf.append("<dest>");
            vBuf.append(pDialog);
            vBuf.append("</dest>");
            for (IHDialog vDial = pDialog.hGetDialogPrec(); vDial != null && vDial != this.fCurrentDialog; vDial = vDial.hGetDialogPrec()) {
                vBuf.append("<inter>");
                vBuf.append(vDial);
                vBuf.append("</inter>");
            }
            vBuf.append("<ori>");
            vBuf.append(this.fCurrentDialog);
            vBuf.append("</ori>");
            vBuf.append("</lienpage>");
            sTraceLink.publishDebug(vBuf.toString(), new String[0]);
        }
        pDialog.hFreezeForAsynch();
    }

    @Override
    public boolean wTreatDialogInSynch(IWADialogExport pDialog, boolean pFromStack) throws Exception {
        if (pFromStack) {
            ListIterator vIt = this.fDialogStack.listIterator();
            while (vIt.hasNext()) {
                IWADialogExport vDialog = (IWADialogExport)vIt.next();
                if (vDialog != pDialog) continue;
                vIt.remove();
                IHDialog vDialogResult = vDialog.hExecuteRetourUser();
                if (vDialogResult != null && vDialogResult instanceof IWADialogExport) {
                    this.xProduceDynamicFile((IWADialogExport)vDialogResult);
                }
                return true;
            }
            return false;
        }
        IHDialog vDialogResult = pDialog.hExecuteRetourUser();
        if (vDialogResult != null && vDialogResult instanceof IWADialogExport) {
            this.xProduceDynamicFile((IWADialogExport)vDialogResult);
        }
        return true;
    }

    public void wTreatStackPages() throws Exception {
        ArrayList<IWADialogExport> vStackWithStep = null;
        block2: while (this.fDialogStack.size() > 0) {
            while (this.fDialogStack.size() > 0) {
                IWADialogExport vDialog = (IWADialogExport)this.fDialogStack.removeFirst();
                if (vDialog.hGetStep() > 0) {
                    if (vStackWithStep == null) {
                        vStackWithStep = new ArrayList<IWADialogExport>();
                    }
                    vStackWithStep.add(vDialog);
                    continue;
                }
                IHDialog vDialogResult = vDialog.hExecuteRetourUser();
                if (vDialogResult == null || !(vDialogResult instanceof IWADialogExport)) continue;
                this.xProduceDynamicFile((IWADialogExport)vDialogResult);
            }
            if (vStackWithStep == null || vStackWithStep.size() <= 0) continue;
            Collections.sort(vStackWithStep, new Comparator(){

                public int compare(Object p1, Object p2) {
                    int v2;
                    int v1;
                    try {
                        v1 = ((IWADialogExport)p1).hGetStep();
                    }
                    catch (Exception e) {
                        v1 = 0;
                    }
                    try {
                        v2 = ((IWADialogExport)p2).hGetStep();
                    }
                    catch (Exception e) {
                        v2 = 0;
                    }
                    return v1 - v2;
                }
            });
            for (int i = 0; i < vStackWithStep.size(); ++i) {
                IWADialogExport vDialog = (IWADialogExport)vStackWithStep.get(i);
                IHDialog vDialogResult = vDialog.hExecute();
                if (vDialogResult == null || !(vDialogResult instanceof IWADialogExport)) continue;
                this.xProduceDynamicFile((IWADialogExport)vDialogResult);
                if (this.fDialogStack.size() <= 0) continue;
                int vStepFrom = vDialog.hGetStep();
                for (int j = 0; j < this.fDialogStack.size(); ++j) {
                    IWADialogExport vDialog2 = (IWADialogExport)this.fDialogStack.get(j);
                    try {
                        if (vDialog2.hGetStep() >= vStepFrom) continue;
                    }
                    catch (Exception e) {}
                    continue block2;
                }
            }
            vStackWithStep.clear();
        }
    }

    public ISkin getSkin() {
        return this.fSkin;
    }

    public ISrcNode getSkinSrc() throws Exception {
        return this.fSkin != null ? this.fSkin.getSkinSrc() : ISrcNode.NULL;
    }

    @Override
    public void addTrace(ILogMsg.LogType pType, ILogMsg pMessage) {
        try {
            ILogMsg.LogType vType;
            ILogMsg.LogType logType = vType = pType == null ? pMessage.getMsgType() : pType;
            if (this.fDestLastStatus < 4 && this.fDestLastStatus < 4) {
                if (vType == ILogMsg.LogType.FatalError || vType == ILogMsg.LogType.Exception) {
                    this.fDestLastStatus = 4;
                } else if (vType == ILogMsg.LogType.Error || vType == ILogMsg.LogType.Warning) {
                    this.fDestLastStatus = 3;
                }
            }
            if (this.fTraceWriter == null) {
                this.fTraceTemp = new StringBuilder(256);
                this.fTraceWriter = new XmlWriterAppendable(this.fTraceTemp);
                this.fTraceWriter.writeHeaderXml("UTF-8");
                this.fTraceWriter.writeOpenTag("trace");
                this.fTraceWriter.writeStartTag("start");
                this.fTraceWriter.writeAttribute("t", sFormatDate.format(new Date()));
                this.fTraceWriter.writeEndEmptyTag();
            }
            this.fTraceWriter.writeStartTag("l");
            this.fTraceWriter.writeAttribute("t", vType.name());
            this.fTraceWriter.writeAttribute("d", sFormatDate.format(new Date()));
            this.fTraceWriter.writeEndOpenTag();
            pMessage.writeAsXmlFormat(this.fTraceWriter, true);
            this.fTraceWriter.writeCloseTag("l");
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
    }

    @Override
    public void addTrace(String pTraceText, ILogMsg.LogType pType, String ... pVariables) {
        this.addTrace(pType, new LogMsg(pTraceText, pType, pVariables));
    }

    protected void xPrepareLog(ILogMsg.LogType pType) throws Exception {
    }

    public IScripter wNewScripter() throws Exception {
        ScripterDefault vScripter = new ScripterDefault();
        vScripter.init(this);
        return vScripter;
    }

    @Override
    public ISrcNode wGetCurrentPubFile() throws Exception {
        if (this.fCurrentPubFile != null) {
            return this.fCurrentPubFile;
        }
        return this.fPubRoot;
    }

    @Override
    public Templates wGetXslFromSrcPath(String pSrcPath, IHDialog pDialog) throws Exception {
        String vXslUri = this.resolvePubPath2PubUri(pSrcPath);
        Templates vTemplate = (Templates)this.fTemplates.get(vXslUri);
        if (vTemplate == null) {
            try {
                TransformerFactoryImpl vTransFact = new TransformerFactoryImpl();
                SrcFeaturePaths.SrcNodeResolver vResolver = SrcFeaturePaths.newSrcNodeResolver(this.getPubRoot().findNodeByUri(vXslUri), this);
                ((TransformerFactory)vTransFact).setURIResolver(vResolver);
                XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                vXmlReader.setEntityResolver(vResolver);
                InputStream vStream = vResolver.newInputStream(false);
                if (vStream == null) {
                    throw LogMgr.newException("Le fichier template XSL '" + vXslUri + "' est introuvable.", new String[0]);
                }
                InputSource vInputSource = new InputSource(vStream);
                vInputSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vResolver));
                vTemplate = ((TransformerFactory)vTransFact).newTemplates(new SAXSource(vXmlReader, vInputSource));
                this.fTemplates.put(vXslUri, vTemplate);
                HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la compilation du template XSL : " + vXslUri, new String[0]);
            }
        }
        return vTemplate;
    }

    @Override
    public void wSetCurrentPubFile(ISrcNode pSource) {
        this.fCurrentPubFile = pSource;
    }

    @Override
    public void wSetCurrentDialog(IHDialog pDialog) {
        this.fCurrentDialog = pDialog;
    }

    @Override
    public void wSetCurrentDestUri(String pCurrentDestUrl) {
        this.fCurrentDestUri = pCurrentDestUrl;
    }

    @Override
    public void wAddInclResolver(DynamicInclWriter pDynWriter) {
    }

    @Override
    public IComputedData copySrcPath2DataInMem(String pUrlLogique, IHDialog pDialog, Object pContext) throws Exception {
        try {
            HUrl vUrl = new HUrl(pUrlLogique);
            String vUrlSrc = vUrl.hGetUrlWithoutParams();
            IGenerator.IXxxUri vXxxUri = this.resolveXxxPath(vUrlSrc, pDialog, pContext);
            ISrcNode vOri = this.getSourceFromXxxUri(vXxxUri, pDialog);
            HTransformParams vTransform = vUrl.hGetValue("transform") != null ? HTransformParams.hNewParamsTransformByUrl(vUrl) : null;
            return new DataFromSource(vOri, vUrl.hGetValue("contenttype"), vTransform);
        }
        catch (Exception e) {
            LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation de la ressource '" + pUrlLogique + "' dans " + pDialog + ".", new String[0]);
            this.addTrace(ILogMsg.LogType.Warning, LogMgr.getMessage(e));
            return IComputedData.NULL;
        }
    }

    @Override
    public String wGetIdUnique(IWAgent pAgent) throws Exception {
        for (int i = 0; i < this.fUniqueIds.size(); ++i) {
            if (this.fUniqueIds.get(i) != pAgent) continue;
            return this.xEncodeId(i);
        }
        this.fUniqueIds.add(pAgent);
        return this.xEncodeId(this.fUniqueIds.size() - 1);
    }

    @Override
    public String resolvePubPath2PubUri(String pPubPath) throws Exception {
        if (pPubPath == null) {
            return null;
        }
        if (this.fCurrentPubFile != null && !pPubPath.startsWith("/")) {
            return SrcFeaturePaths.resolvePath2Uri(pPubPath, this.fCurrentPubFile.getSrcUri(), true);
        }
        return pPubPath;
    }

    @Override
    public IGenerator.IXxxUri resolveXxxPath(String pXxxPath, IHDialog pDialog, Object pOwner) throws Exception {
        if (pXxxPath == null || pXxxPath.length() == 0) {
            return null;
        }
        if (pXxxPath.startsWith(PREFIX_PUBFOLDER)) {
            return new XxxUri(1, pXxxPath.substring(PREFIX_PUBFOLDER.length()));
        }
        if (pXxxPath.startsWith(PREFIX_DESTFOLDER)) {
            return new XxxUri(2, pXxxPath.substring(PREFIX_DESTFOLDER.length()));
        }
        if (pXxxPath.startsWith(PREFIX_SKINSRC)) {
            return new XxxUri(3, pXxxPath.substring(PREFIX_SKINSRC.length()));
        }
        return new XxxUri(0, pDialog.hGetUnivers().hGetContenuMgr().hResolveUrl(pXxxPath, pOwner));
    }

    @Override
    public String resolveDestUri2DestUrl(String pDestUri) throws Exception {
        if (pDestUri == null || pDestUri.length() == 0) {
            return "";
        }
        return GeneratorBase.buildRelativeUrl(this.fCurrentDestUri, pDestUri, "UTF-8");
    }

    @Override
    public String resolveDestPath2DestUri(String pDestPath) throws Exception {
        return pDestPath;
    }

    @Override
    public IScripter wGetScripter() {
        return this.fScripter;
    }

    protected String xEncodeId(int pId) {
        int vVal = pId;
        StringBuilder vBuf = new StringBuilder(5);
        do {
            vBuf.append(ID_ENCODER[vVal % 26]);
        } while ((vVal /= 26) != 0);
        return vBuf.toString();
    }

    protected abstract void xGenerate(IWInstFormation var1, IUser var2, String var3, String var4, String var5) throws Exception;

    @Override
    public void handleLogMsgAsObject(ILogMsg pObjetMessage) {
        this.addTrace(pObjetMessage.getMsgType(), pObjetMessage);
    }

    @Override
    public String resolveAlias(String pPubPath) throws Exception {
        return pPubPath;
    }

    protected abstract void wDeleteDynamicFiles(IWInstFormation var1, IUser var2, String var3, String var4, String var5) throws Exception;

    protected void wResetDestination(IWInstFormation pInstance, IUser pActeur, String pMode, String pSupport, String pLangue) throws Exception {
        this.xRemoveDst(this.fDestRoot);
        List<String> vList = this.fDestRoot.listChildrenNames(null, 0);
        if (vList != null && vList.size() > 0) {
            throw new DestLockException("Tous les fichiers n'ont pu \u00eatre supprim\u00e9s avant la g\u00e9n\u00e9ration dans le dossier de destination : " + this.fDestRoot);
        }
    }

    protected void wResetAfterGenerate() {
        this.fTimeStampsSourceFiles = null;
        this.fFilesAlreadyExported = null;
        this.fCurrentDestUri = null;
        this.fCurrentPubFile = null;
        this.fCurrentDialog = null;
        this.fDialogStack.clear();
        this.fUniqueIds.clear();
        this.fSkin = null;
    }

    @Override
    public void reset() throws Exception {
        this.fTraceTemp = null;
        this.fTraceWriter = null;
        this.fDestRoot = null;
        this.fDestLastGen = 0L;
        this.fDestLastLang = null;
        this.fDestLastMode = null;
        this.fDestLastSkin = null;
        this.fDestLastStatus = 0;
        this.fDestLastUser = null;
        this.fLockDest = null;
        this.fTraceFile = null;
        this.fModeGenerateByDiff = true;
        this.fProperties.clear();
    }

    @Override
    public String getDestOneStreamContentType() throws Exception {
        Object vMime = this.getProperty(KEYPROPERTY_DESTSONESTREAM_MIMETYPE);
        return vMime != null ? vMime.toString() : null;
    }

    @Override
    public String getDestOneStreamName() throws Exception {
        String vFileName;
        String vBuilder = this.getProperty(KEYPROPERTY_DESTSONESTREAM_BUILDER).toString();
        if (vBuilder != null && (vFileName = (vBuilder = vBuilder.substring((vBuilder = this.xResolveFirstMatchFile(vBuilder)).lastIndexOf(":") > -1 ? vBuilder.lastIndexOf(":") + 1 : 0)).substring(vBuilder.lastIndexOf("/") + 1)).lastIndexOf(".") > 0) {
            return vFileName;
        }
        return null;
    }

    @Override
    public IByteStream getDestOneStream(Object pOptions) throws Exception {
        String vBuilder = this.getProperty(KEYPROPERTY_DESTSONESTREAM_BUILDER).toString();
        if (vBuilder != null) {
            if ((vBuilder = this.xResolveFirstMatchFile(vBuilder)).startsWith("file:")) {
                String vPath = vBuilder.substring("file:".length());
                if (vPath != null) {
                    ISrcContent vSrc = SrcFeaturePaths.findContentByPath(this.fDestRoot, vPath, false);
                    InputStream vIn = null;
                    vIn = vSrc.newInputStream(false);
                    if (vIn != null) {
                        return new InputStreamByteStream(vIn);
                    }
                }
            } else if (vBuilder.startsWith("zip:")) {
                ISrcNode vSrc = this.fDestRoot;
                if (vBuilder.length() > "zip:".length()) {
                    vSrc = SrcFeaturePaths.findNodeByPath(this.fDestRoot, vBuilder.substring("zip:".length()), false);
                }
                ZipperSrc vZipper = new ZipperSrc();
                vZipper.setSrcNode(vSrc);
                return vZipper;
            }
        }
        return null;
    }

    protected String xResolveFirstMatchFile(String vMatchPath) {
        if (vMatchPath != null && vMatchPath.indexOf("matchextension:") > -1) {
            String vPath = vMatchPath.substring(vMatchPath.indexOf("matchextension:") + "matchextension:".length());
            String vPrefix = vMatchPath.substring(0, vMatchPath.indexOf("matchextension:"));
            String vParentFolder = vPath.substring(0, Math.max(vPath.lastIndexOf("*") - 1, 0));
            String vFileExt = vPath.substring(vPath.lastIndexOf("*.") + "*.".length());
            try {
                List<String> vFileList;
                if (this.fDestRoot != null && (vFileList = SrcFeaturePaths.findNodeByPath(this.fDestRoot, vParentFolder, false).listChildrenNames(null, 1)) != null) {
                    for (int i = 0; i < vFileList.size(); ++i) {
                        String vFileName = vFileList.get(i);
                        String vPrefixFolder = vPrefix + vParentFolder;
                        if (!vFileName.endsWith(vFileExt)) continue;
                        return (vPrefixFolder.length() > 0 ? vPrefixFolder + "/" : "") + vFileName;
                    }
                }
                return vPrefix + vParentFolder;
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Echec \u00e0 la r\u00e9solution du path dynamique : " + vMatchPath, new String[0]);
            }
        }
        return vMatchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xProduceDynamicFile(IWADialogExport pDialog) throws Exception {
        IDynamicFile vPage = pDialog.getResultFile();
        if (vPage != null && vPage.getDestFile() != null) {
            IFileModel vModel = vPage.getFileModel();
            if (vModel != null && vModel instanceof IProducerPage) {
                ((IProducerPage)vModel).producePage(pDialog);
            } else if (pDialog instanceof HDialogPages) {
                HDialogPages vDialogPage = (HDialogPages)pDialog;
                XPage vCurrentPage = vDialogPage.hGetPageCourante();
                String vContentType = vDialogPage.hGetZone("content-type");
                String vEncoding = "UTF-8";
                if (vContentType != null && vContentType.length() > 0 && (vEncoding = MimeMgr.extractCharsetFromContentType(vContentType)) == null) {
                    vEncoding = "UTF-8";
                }
                this.fCurrentPubFile = null;
                this.fCurrentDestUri = vPage.getDestUri();
                this.fCurrentDialog = pDialog;
                OutputStream vStream = vPage.getDestFile().newOutputStream(false);
                if (vStream != null) {
                    OutputStreamWriter vWriter = null;
                    try {
                        vWriter = new OutputStreamWriter(vStream, vEncoding);
                        vCurrentPage.hGetZone("mainZone").writeValue(vWriter, vDialogPage, vDialogPage.hGetAgent(), vDialogPage.hGetParam());
                    }
                    finally {
                        if (vWriter != null) {
                            ((Writer)vWriter).close();
                        } else {
                            vStream.close();
                        }
                    }
                }
            }
        }
    }

    public void wAddProducerPage(IProducerPage pPage) {
        this.fModelPages.put(pPage.hGetUrn(), pPage);
    }

    @Override
    public IFileModel wGetFileModel(String pUrn) throws Exception {
        IFileModel vResult;
        if (pUrn == null) {
            pUrn = "";
        }
        if ((vResult = (IFileModel)this.fModelPages.get(pUrn)) == null) {
            throw LogMgr.newException("Le mod\u00e8le de page '" + pUrn + "' est inconnu dans ce g\u00e9n\u00e9rateur.", new String[0]);
        }
        return vResult;
    }

    @Override
    public String translateSrcUri2DestUri(String pSrcUri) throws Exception {
        return pSrcUri;
    }

    @Override
    public String translatePubUri2DestUri(String pPubUri) throws Exception {
        return pPubUri;
    }

    @Override
    public IScriptableFunctions wGetScriptableFunctions() {
        if (this.fScriptableFunctions == null) {
            this.fScriptableFunctions = new XScriptableFunctions();
        }
        return this.fScriptableFunctions;
    }

    @Override
    public boolean wIsEqualExport(IWADialogExport pDialog1, IWADialogExport pDialog2) {
        return true;
    }

    @Override
    public ISrcNode getSourceFromXxxUri(IGenerator.IXxxUri pXxxUri, IHDialog pDialog) throws Exception {
        switch (pXxxUri.getSpace()) {
            case 0: {
                return pDialog.hGetUnivers().hGetEspaceSources().findNodeByUri(pXxxUri.getUriWoQS());
            }
            case 1: {
                return this.getPubRoot().findNodeByUri(pXxxUri.getUriWoQS());
            }
            case 2: {
                return this.getDestRoot().findNodeByUri(pXxxUri.getUriWoQS());
            }
            case 3: {
                return SrcFeaturePaths.findNodeByPath(this.getSkinSrc(), pXxxUri.getUriWoQS(), false);
            }
        }
        return null;
    }

    protected ISrcNode xLookForFreeDst(ISrcNode pDst) throws Exception {
        if (pDst.getContentStatus() != -1) {
            String vPrefix = pDst.getSrcName();
            String vSuffix = "";
            int vPoint = vPrefix.lastIndexOf(46);
            if (vPoint > 0) {
                vSuffix = vPrefix.substring(vPoint);
                vPrefix = vPrefix.substring(0, vPoint);
            }
            int vCount = 1;
            do {
                pDst = SrcFeaturePaths.findNodeByPath(pDst, "../" + vPrefix + '_' + vCount + vSuffix, false);
                ++vCount;
            } while (pDst.getContentStatus() != -1);
        }
        return pDst;
    }

    protected ISrcNode xLookForFreeDst(ISrcNode pFolder, String pDefaultFileName, List pFolderHistory) throws Exception {
        String vNameFile = pDefaultFileName;
        String vKeyName = vNameFile.toLowerCase();
        if (pFolderHistory.indexOf(vKeyName) >= 0) {
            String vPrefix = vNameFile;
            String vSuffix = "";
            int vPoint = vPrefix.lastIndexOf(46);
            if (vPoint > 0) {
                vSuffix = vPrefix.substring(vPoint);
                vPrefix = vPrefix.substring(0, vPoint);
            }
            int vCount = 0;
            while (pFolderHistory.indexOf(vKeyName = (vNameFile = vPrefix + '_' + ++vCount + vSuffix).toLowerCase()) >= 0) {
            }
        }
        pFolderHistory.add(vKeyName);
        return pFolder.findNodeChild(vNameFile);
    }

    protected boolean xRemoveDst(ISrcContent pDst) throws Exception {
        if (!pDst.removeSrc()) {
            for (int vCount = 1; vCount < 10; ++vCount) {
                Thread.sleep(10L);
                if (pDst.getContentStatus() == -1) {
                    return true;
                }
                if (!pDst.removeSrc()) continue;
                return true;
            }
            throw new DestLockException("Impossible de supprimer d\u00e9finitivement " + SrcFeatureAlternateUrl.getFilePath(pDst));
        }
        return true;
    }

    protected static int searchExporteFilesOnSrc(List l, String pSrc) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            WFileIhmExported midVal = (WFileIhmExported)l.get(mid);
            int cmp = midVal.fUriSrc.compareTo(pSrc);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected static int searchExporteFilesOnDst(List l, String pUriDst) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            WFileIhmExported midVal = (WFileIhmExported)l.get(mid);
            int cmp = midVal.fUriDest.compareTo(pUriDst);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected static int searchExporteFiles(List l, String pSrc, String pUriDst) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            WFileIhmExported midVal = (WFileIhmExported)l.get(mid);
            int cmp = midVal.fUriSrc.compareTo(pSrc);
            if (cmp == 0) {
                cmp = midVal.fUriDest.compareTo(pUriDst);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public class XScriptableFunctions
    implements IScriptableFunctions {
        public String resultatAgent(String pUrl, Object pArgument) throws Exception {
            IWAgent vAgent;
            IWAgent iWAgent = vAgent = pUrl != null ? ((IWADialog)GeneratorBase.this.fCurrentDialog).hGoToAgent(pUrl) : ((IWADialog)GeneratorBase.this.fCurrentDialog).hGetAgent();
            if (vAgent != null && vAgent instanceof IWAgentComputor) {
                return ((IWAgentComputor)((Object)vAgent)).computeAsString(GeneratorBase.this.fCurrentDialog, pArgument);
            }
            return "";
        }

        public String resultatAgent(String pUrl, Object pArgument, String pPrefix, String pSuffix) throws Exception {
            IWAgent vAgent;
            IWAgent iWAgent = vAgent = pUrl != null ? ((IWADialog)GeneratorBase.this.fCurrentDialog).hGoToAgent(pUrl) : ((IWADialog)GeneratorBase.this.fCurrentDialog).hGetAgent();
            if (vAgent != null && vAgent instanceof IWAgentComputor) {
                StringWriter vWriter = new StringWriter();
                if (pPrefix != null) {
                    vWriter.write(pPrefix);
                }
                ((IWAgentComputor)((Object)vAgent)).computeAsData(GeneratorBase.this.fCurrentDialog, pArgument).writeValue(vWriter);
                if (pSuffix != null) {
                    vWriter.write(pSuffix);
                }
                vWriter.flush();
                return vWriter.getBuffer().toString();
            }
            return "";
        }

        public String resultatDialog(String pUrlDialog, Object pArgument) throws Exception {
            IWAgent vAgent;
            IHDialog vDialog;
            IHDialog iHDialog = vDialog = pUrlDialog != null ? (IWADialog)((IWADialog)GeneratorBase.this.fCurrentDialog).hGoTo(pUrlDialog) : GeneratorBase.this.fCurrentDialog;
            if (vDialog != null && vDialog instanceof IWADialog && (vAgent = ((IWADialog)vDialog).hGetAgent()) instanceof IWAgentComputor) {
                return ((IWAgentComputor)((Object)vAgent)).computeAsString(vDialog, pArgument);
            }
            return "";
        }

        public String executeXsl(String pUrlXsl, String pSource, Object pArgument) throws Exception {
            if (pSource == null || pSource.length() == 0) {
                return "";
            }
            Templates vTemplate = GeneratorBase.this.wGetXslFromSrcPath(pUrlXsl, GeneratorBase.this.fCurrentDialog);
            StringWriter vWriterSortie = new StringWriter();
            XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
            try {
                Transformer vTransformer = vTemplate.newTransformer();
                SrcFeaturePaths.SrcNodeResolver vResolver = SrcFeaturePaths.newSrcNodeResolver(GeneratorBase.this.wGetCurrentPubFile(), GeneratorBase.this);
                vTransformer.setURIResolver(vResolver);
                vTransformer.setParameter("vDialog", GeneratorBase.this.fCurrentDialog);
                if (GeneratorBase.this.fCurrentDialog instanceof IWADialog) {
                    vTransformer.setParameter("vAgent", new XAgent(((IWADialog)GeneratorBase.this.fCurrentDialog).hGetAgent()));
                }
                if (pArgument != null) {
                    vTransformer.setParameter("vArguments", pArgument);
                }
                SAXSource vSourceTransform = new SAXSource(vReader, new InputSource(new StringReader(pSource)));
                vTransformer.transform(vSourceTransform, new StreamResult(vWriterSortie));
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Echec lors du calcul d'une page du dialogue '" + GeneratorBase.this.fCurrentDialog + "'.", new String[0]);
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec lors de l'application de la XSL '" + pUrlXsl + "' sur le contenu : \n" + pSource, new String[0]);
            }
            finally {
                HPoolXmlReader.hGet().hFreeXmlReader(vReader);
            }
            return vWriterSortie.toString();
        }

        public Object getGeneratorProperty(String pKey) {
            Object vRes = GeneratorBase.this.getProperty(pKey);
            return vRes != null ? vRes : "";
        }

        public String getIdAgentHier() throws Exception {
            StringBuilder vBuf = new StringBuilder();
            IWAgent vAgent2 = null;
            for (IWAgent vAgent2 : ((IWADialog)GeneratorBase.this.fCurrentDialog).hGetHier()) {
                vBuf.append(GeneratorBase.this.wGetIdUnique(vAgent2));
                vBuf.append('_');
            }
            vBuf.append(GeneratorBase.this.wGetIdUnique(((IWADialog)GeneratorBase.this.fCurrentDialog).hGetAgent()));
            return vBuf.toString();
        }

        public String resolveDestUri2DestUrl(String pDestUri) throws Exception {
            return GeneratorBase.this.resolveDestUri2DestUrl(pDestUri);
        }

        public String translatePubPath2DestUrl(String pPubPath) throws Exception {
            return GeneratorBase.this.resolveDestUri2DestUrl(GeneratorBase.this.translatePubUri2DestUri(GeneratorBase.this.resolvePubPath2PubUri(pPubPath)));
        }

        public String translatePubUri2DestUrl(String pPubUri) throws Exception {
            return GeneratorBase.this.resolveDestUri2DestUrl(GeneratorBase.this.translatePubUri2DestUri(pPubUri));
        }

        public String getTitleAgent(IWAgent pAgent) throws Exception {
            if (pAgent == null) {
                pAgent = ((IWADialog)GeneratorBase.this.fCurrentDialog).hGetAgent();
            }
            return pAgent.hGetComposant().hGetIntitule().getString(GeneratorBase.this.fCurrentDialog, pAgent, null);
        }

        public String getTypeAgent(IWAgent pAgent) throws Exception {
            if (pAgent == null) {
                pAgent = ((IWADialog)GeneratorBase.this.fCurrentDialog).hGetAgent();
            }
            return pAgent.hGetComposant().hGetComposantType().hGetCode();
        }

        public String buildRelativeUrl(String pUrlFrom, String pUrlTo) throws Exception {
            return GeneratorBase.buildRelativeUrl(pUrlFrom, pUrlTo, GeneratorBase.this.fUrlEncoding);
        }

        public String getPathAgentRoot(String pSufffix) throws Exception {
            IWAgent vAgentRoot = ((IWADialog)GeneratorBase.this.fCurrentDialog).hGetAgent().hGetInstance().hGetAgentRoot();
            String vUri = vAgentRoot.hGetComposant().hGetDocSource().getSrcUri();
            String vPath = GeneratorBase.this.fCurrentDialog.hGetUnivers().hGetContenuMgr().hGetIdSrcFromUri(vUri, vAgentRoot);
            vPath = pSufffix != null && pSufffix.length() > 0 ? "@" + vPath + pSufffix : "@".concat(vPath);
            return vPath;
        }

        public String switchAxis(String pCdAgent, String pAxis) throws Exception {
            if (pCdAgent == null) {
                return "";
            }
            int vEnd = pCdAgent.indexOf("_A");
            if (pAxis != null && pAxis.length() > 0) {
                StringBuilder vBuf = new StringBuilder(pCdAgent.length() + pAxis.length() + "_A".length());
                vBuf.append(vEnd < 0 ? pCdAgent : pCdAgent.substring(0, vEnd));
                vBuf.append("_A");
                vBuf.append(pAxis);
                return vBuf.toString();
            }
            return vEnd < 0 ? pCdAgent : pCdAgent.substring(0, vEnd);
        }
    }

    public static class XxxUri
    implements IGenerator.IXxxUri {
        protected int fSpace = 0;
        protected String fUri = null;

        public XxxUri(int pSpace, String pUri) {
            this.fSpace = pSpace;
            this.fUri = pUri;
        }

        public int getSpace() {
            return this.fSpace;
        }

        public void setSpace(int pSpace) {
            this.fSpace = pSpace;
        }

        public String getUri() {
            return this.fUri;
        }

        public String getUriWoQS() {
            int vIdx = this.fUri.indexOf(63);
            if (vIdx >= 0) {
                return this.fUri.substring(0, vIdx);
            }
            return this.fUri;
        }

        public void setUri(String pUri) {
            this.fUri = pUri;
        }

        public int compareTo(Object pObj) {
            XxxUri vOther = (XxxUri)pObj;
            if (vOther.fSpace == this.fSpace) {
                return vOther.fUri.compareTo(this.fUri);
            }
            return vOther.fSpace - this.fSpace;
        }

        public boolean equals(Object pObj) {
            XxxUri vOther = (XxxUri)pObj;
            if (vOther.fSpace == this.fSpace) {
                return vOther.fUri.equals(this.fUri);
            }
            return false;
        }

        public int hashCode() {
            return this.fUri.hashCode();
        }
    }

    public static class WFileIhmExported
    implements Comparable {
        public String fUriSrc = null;
        public long fLastModifSrc = 0L;
        public String fUriDest = null;
        public boolean fReexported = false;

        public WFileIhmExported(String pUriSrc, long pLastModifSrc, String pUriDest) {
            this.fUriSrc = pUriSrc;
            this.fLastModifSrc = pLastModifSrc;
            this.fUriDest = pUriDest;
        }

        public int compareTo(Object pObj) {
            int vComp = this.fUriSrc.compareTo(((WFileIhmExported)pObj).fUriSrc);
            if (vComp != 0) {
                return vComp;
            }
            return this.fUriDest.compareTo(((WFileIhmExported)pObj).fUriDest);
        }
    }

    public class TemplatesListContentHandler
    extends DefaultHandler
    implements ContentHandler {
        protected ContentHandler fTemplateContentHandler = null;
        protected int fDepth = 0;

        public void startElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
            if (this.fTemplateContentHandler != null) {
                ++this.fDepth;
                this.fTemplateContentHandler.startElement(pUri, pLocalName, pQName, pAttributes);
            } else if (pLocalName.equals("template")) {
                String vClassName = pAttributes.getValue("className");
                String vUrn = pAttributes.getValue("code");
                IProducerPage vProducerPage = null;
                if (vClassName != null) {
                    try {
                        Class<?> vClass = Class.forName(vClassName);
                        vProducerPage = (IProducerPage)vClass.newInstance();
                    }
                    catch (Exception e) {
                        LogMgr.addMessage((Throwable)e, "Echec au chargement de la classe : " + vClassName, new String[0]);
                        throw new SAXException(e);
                    }
                }
                if (vProducerPage != null) {
                    try {
                        this.fTemplateContentHandler = vProducerPage.init(vUrn, GeneratorBase.this, pAttributes);
                        if (this.fTemplateContentHandler != null) {
                            this.fDepth = 1;
                            this.fTemplateContentHandler.startDocument();
                            this.fTemplateContentHandler.startElement(pUri, pLocalName, pQName, pAttributes);
                        }
                        GeneratorBase.this.wAddProducerPage(vProducerPage);
                    }
                    catch (Exception e) {
                        LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'initialisation de : " + vClassName, new String[0]);
                        throw new SAXException(e);
                    }
                }
            }
        }

        public void characters(char[] pArg0, int pArg1, int pArg2) throws SAXException {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.characters(pArg0, pArg1, pArg2);
            }
        }

        public void endDocument() throws SAXException {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.endDocument();
            }
        }

        public void endElement(String pArg0, String pArg1, String pArg2) throws SAXException {
            if (this.fTemplateContentHandler != null) {
                --this.fDepth;
                this.fTemplateContentHandler.endElement(pArg0, pArg1, pArg2);
                if (this.fDepth == 0) {
                    this.fTemplateContentHandler.endDocument();
                    this.fTemplateContentHandler = null;
                }
            }
        }

        public void endPrefixMapping(String pArg0) throws SAXException {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.endPrefixMapping(pArg0);
            }
        }

        public void ignorableWhitespace(char[] pArg0, int pArg1, int pArg2) throws SAXException {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.ignorableWhitespace(pArg0, pArg1, pArg2);
            }
        }

        public void processingInstruction(String pArg0, String pArg1) throws SAXException {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.processingInstruction(pArg0, pArg1);
            }
        }

        public void setDocumentLocator(Locator pArg0) {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.setDocumentLocator(pArg0);
            }
        }

        public void skippedEntity(String pArg0) throws SAXException {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.skippedEntity(pArg0);
            }
        }

        public void startDocument() throws SAXException {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.startDocument();
            }
        }

        public void startPrefixMapping(String pArg0, String pArg1) throws SAXException {
            if (this.fTemplateContentHandler != null) {
                this.fTemplateContentHandler.startPrefixMapping(pArg0, pArg1);
            }
        }
    }
}

