/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.generator.web;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.context.IHContextBuffers;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.ge.context.HContextGenerator;
import com.scenari.m.ge.generator.web.WebGenerator;
import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.s.fw.utils.HIntArrayList;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import eu.scenari.fw.log.LogMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CrossRefEntry {
    public static final String PREFIX_KEYBUFFER = "crossRef.";
    protected String fKeyRef;
    protected String fValueEntry;
    protected String fDestUriEntry;
    protected String fIdEntry;
    protected IWADialog fDialog;

    public static void addEntry(IWADialog pDialog, String pIdEntry, String pKeyRef, String pValueEntry) {
        String vKeyBuffer;
        IHContextBuffers vContextBuffers = (IHContextBuffers)((Object)pDialog.hGetContext());
        ArrayList<CrossRefEntry> vBuffer = (ArrayList<CrossRefEntry>)vContextBuffers.getBuffer(vKeyBuffer = PREFIX_KEYBUFFER.concat(pKeyRef));
        if (vBuffer == null) {
            vBuffer = new ArrayList<CrossRefEntry>();
            vContextBuffers.putBuffer(vKeyBuffer, vBuffer);
        }
        vBuffer.add(new CrossRefEntry(pDialog, CrossRefEntry.getDestUri(pDialog), pIdEntry, pKeyRef, pValueEntry));
    }

    public static String getDestUri(IHDialog pDialog) {
        WebGenerator vGen = (WebGenerator)((HContextGenerator)pDialog.hGetContext()).hGetGenerator();
        return vGen.getCurrentDestUri();
    }

    public static Document getIndexAsIdSrcNode(IWADialog pDialog, String pKeyRef, String pPathAgentSortKey, boolean pAddCallers, String pSortMode, String pCategMode, String pRegExpFilterCodeAgentHier) throws Exception {
        IHContextBuffers vContextBuffers = (IHContextBuffers)((Object)pDialog.hGetContext());
        String vKeyBuffer = PREFIX_KEYBUFFER.concat(pKeyRef);
        List vBuffer = (List)vContextBuffers.getBuffer(vKeyBuffer);
        WebGenerator vGen = (WebGenerator)((HContextGenerator)pDialog.hGetContext()).hGetGenerator();
        DocumentImpl vResult = new DocumentImpl(false);
        vResult.setComplete(true);
        Element vRoot = (Element)vResult.appendChild(vResult.createElement("index"));
        if (vBuffer != null) {
            Pattern vFilter = pRegExpFilterCodeAgentHier != null && pRegExpFilterCodeAgentHier.length() > 0 ? Pattern.compile(pRegExpFilterCodeAgentHier) : null;
            Element[] vEntries = new Element[vBuffer.size()];
            int vEntriesCount = 0;
            for (int i = 0; i < vBuffer.size(); ++i) {
                CrossRefEntry vCrossEntry = (CrossRefEntry)vBuffer.get(i);
                Element vEntry = null;
                for (int j = 0; j < vEntriesCount; ++j) {
                    if (!vEntries[j].getAttribute("idSrcNode").equals(vCrossEntry.fValueEntry)) continue;
                    vEntry = vEntries[j];
                    break;
                }
                if (vFilter != null && !vFilter.matcher(vCrossEntry.fDialog.hGetUrlInInstance()).matches()) continue;
                if (vEntry == null) {
                    vEntry = vResult.createElement("entry");
                    if (pSortMode != null && pSortMode.length() > 0) {
                        String vSortKey = "";
                        IWAgent vAgentSortKey = pDialog.hGoToAgent("@" + vCrossEntry.fValueEntry + pPathAgentSortKey);
                        if (vAgentSortKey != null) {
                            vSortKey = ((IWAgentComputor)((Object)vAgentSortKey)).computeAsString(pDialog, null);
                        }
                        vEntry.setAttribute("sortKey", ((Object)HCharSeqUtil.stringWithoutAccent(vSortKey)).toString());
                    }
                    vEntry.setAttribute("idSrcNode", vCrossEntry.fValueEntry);
                    vEntries[vEntriesCount++] = vEntry;
                }
                if (!pAddCallers) continue;
                CrossRefEntry.addCaller(vGen, vResult, vCrossEntry, vEntry);
            }
            CrossRefEntry.sortAndCategEntries(pSortMode, pCategMode, vResult, vRoot, vEntries, vEntriesCount);
        }
        return vResult;
    }

    public static Document getIndexAsString(IWADialog pDialog, String pKeyRef, boolean pAddCallers, String pSortMode, String pCategMode, String pRegExpFilterCodeAgentHier) throws Exception {
        IHContextBuffers vContextBuffers = (IHContextBuffers)((Object)pDialog.hGetContext());
        String vKeyBuffer = PREFIX_KEYBUFFER.concat(pKeyRef);
        List vBuffer = (List)vContextBuffers.getBuffer(vKeyBuffer);
        WebGenerator vGen = (WebGenerator)((HContextGenerator)pDialog.hGetContext()).hGetGenerator();
        DocumentImpl vResult = new DocumentImpl(false);
        Element vRoot = (Element)vResult.appendChild(vResult.createElement("index"));
        if (vBuffer != null) {
            Pattern vFilter = pRegExpFilterCodeAgentHier != null && pRegExpFilterCodeAgentHier.length() > 0 ? Pattern.compile(pRegExpFilterCodeAgentHier) : null;
            Element[] vEntries = new Element[vBuffer.size()];
            int vEntriesCount = 0;
            for (int i = 0; i < vBuffer.size(); ++i) {
                CrossRefEntry vCrossEntry = (CrossRefEntry)vBuffer.get(i);
                Element vEntry = null;
                for (int j = 0; j < vEntriesCount; ++j) {
                    if (!vEntries[j].getAttribute("value").equals(vCrossEntry.fValueEntry)) continue;
                    vEntry = vEntries[j];
                    break;
                }
                if (vFilter != null && !vFilter.matcher(vCrossEntry.fDialog.hGetUrlInInstance()).matches()) continue;
                if (vEntry == null) {
                    vEntry = vResult.createElement("entry");
                    if (pSortMode != null && pSortMode.length() > 0) {
                        vEntry.setAttribute("sortKey", ((Object)HCharSeqUtil.stringWithoutAccent(vCrossEntry.fValueEntry)).toString());
                    }
                    vEntry.setAttribute("value", vCrossEntry.fValueEntry);
                    vEntries[vEntriesCount++] = vEntry;
                }
                if (!pAddCallers) continue;
                CrossRefEntry.addCaller(vGen, vResult, vCrossEntry, vEntry);
            }
            CrossRefEntry.sortAndCategEntries(pSortMode, pCategMode, vResult, vRoot, vEntries, vEntriesCount);
        }
        return vResult;
    }

    protected static void addCaller(WebGenerator pGen, Document pResult, CrossRefEntry pCrossEntry, Element pEntry) throws Exception {
        Element vCaller = pResult.createElement("caller");
        String vUrl = pGen.resolveDestUri2DestUrl(pCrossEntry.fDestUriEntry);
        if (pCrossEntry.fIdEntry != null && pCrossEntry.fIdEntry.length() > 0) {
            vUrl = vUrl + "#" + pCrossEntry.fIdEntry;
        }
        vCaller.setAttribute("url", vUrl);
        vCaller.setAttribute("titlePage", pCrossEntry.fDialog.hGetAgent().hGetIntitule(pCrossEntry.fDialog));
        vCaller.setAttribute("dialog", pCrossEntry.fDialog.hGetUrlInInstance());
        pEntry.appendChild(vCaller);
    }

    protected static void sortAndCategEntries(String pSortMode, String pCategMode, Document pResult, Element pRoot, Element[] pEntries, int pEntriesCount) {
        block24: {
            block22: {
                block23: {
                    int vOffsMin;
                    if (pEntriesCount <= 0 || pSortMode == null || !pSortMode.equals("A")) break block22;
                    Arrays.sort(pEntries, 0, pEntriesCount, new Comparator(){

                        public int compare(Object p1, Object p2) {
                            return ((Element)p1).getAttribute("sortKey").compareToIgnoreCase(((Element)p2).getAttribute("sortKey"));
                        }
                    });
                    if (pCategMode == null || !pCategMode.startsWith("A")) break block23;
                    int i = 0;
                    while (i < pEntriesCount) {
                        String vNewChar;
                        String vSortKey = pEntries[i].getAttribute("sortKey");
                        String vChar = vSortKey != null && vSortKey.length() > 0 ? vSortKey.substring(0, 1).toUpperCase() : "";
                        Element vCateg = pResult.createElement("categ");
                        vCateg.setAttribute("from", vChar);
                        vCateg.setAttribute("to", vChar);
                        vCateg.setAttribute("label", vChar);
                        pRoot.appendChild(vCateg);
                        do {
                            vCateg.appendChild(pEntries[i]);
                        } while ((vNewChar = ++i < pEntriesCount ? ((vSortKey = pEntries[i].getAttribute("sortKey")) != null && vSortKey.length() > 0 ? vSortKey.substring(0, 1).toUpperCase() : "") : null) != null && vNewChar.equals(vChar));
                    }
                    int vOffsRange = pCategMode.indexOf("[range=");
                    while (vOffsRange > 0) {
                        CrossRefEntry.addEmptyCateg(pRoot, pCategMode.charAt(vOffsRange + 7), pCategMode.charAt(vOffsRange + 8));
                        vOffsRange = pCategMode.indexOf("[range=", vOffsRange + 8);
                    }
                    int vOffsOtherRanges = pCategMode.indexOf("[mergeOthersRanges=");
                    if (vOffsOtherRanges > 0) {
                        char vBasketCategChar = pCategMode.charAt(vOffsOtherRanges + 19);
                        CrossRefEntry.addEmptyCateg(pRoot, vBasketCategChar, vBasketCategChar);
                        HIntArrayList vRanges = new HIntArrayList();
                        vOffsRange = pCategMode.indexOf("[range=");
                        while (vOffsRange > 0) {
                            vRanges.addInt(pCategMode.charAt(vOffsRange + 7));
                            vRanges.addInt(pCategMode.charAt(vOffsRange + 8));
                            vOffsRange = pCategMode.indexOf("[range=", vOffsRange + 8);
                        }
                        Element vCurCateg = (Element)pRoot.getFirstChild();
                        ArrayList<Element> vCategsToRemove = new ArrayList<Element>();
                        Element vBasket = null;
                        block6: while (vCurCateg != null) {
                            char vFrom = vCurCateg.getAttribute("from").charAt(0);
                            if (vFrom == vBasketCategChar) {
                                vBasket = vCurCateg;
                            } else {
                                for (int i2 = 0; i2 < vRanges.size(); i2 += 2) {
                                    if (vFrom < vRanges.getInt(i2) || vFrom > vRanges.getInt(i2 + 1)) continue;
                                    vCurCateg = (Element)vCurCateg.getNextSibling();
                                    continue block6;
                                }
                                vCategsToRemove.add(vCurCateg);
                            }
                            vCurCateg = (Element)vCurCateg.getNextSibling();
                        }
                        for (int i3 = 0; i3 < vCategsToRemove.size(); ++i3) {
                            vCurCateg = (Element)vCategsToRemove.get(i3);
                            while (vCurCateg.hasChildNodes()) {
                                vBasket.appendChild(vCurCateg.getFirstChild());
                            }
                            pRoot.removeChild(vCurCateg);
                        }
                    }
                    if ((vOffsMin = pCategMode.indexOf("[min=")) > 0) {
                        int vMin = 0;
                        try {
                            int vLastOffs = pCategMode.indexOf("]", vOffsMin += 5);
                            vMin = Integer.parseInt(pCategMode.substring(vOffsMin, vLastOffs));
                        }
                        catch (Exception e) {
                            LogMgr.publishException((Throwable)e, "Echec \u00e0 la lecture du minimum d'entr\u00e9es dans une cat\u00e9gorie : " + pCategMode, new String[0]);
                        }
                        if (vMin > 0) {
                            Element vPrevCateg = null;
                            Element vCurCateg = (Element)pRoot.getFirstChild();
                            while (vCurCateg != null) {
                                Element vNextCateg = (Element)vCurCateg.getNextSibling();
                                int vCount = CrossRefEntry.countChildren(vCurCateg);
                                if (vCount < vMin) {
                                    int vCountNext;
                                    int vCountPrev = vPrevCateg != null ? CrossRefEntry.countChildren(vPrevCateg) : Integer.MAX_VALUE;
                                    int n = vCountNext = vNextCateg != null ? CrossRefEntry.countChildren(vNextCateg) : Integer.MAX_VALUE;
                                    if (vCountPrev > vCountNext) {
                                        CrossRefEntry.mergeCategs(vCurCateg, vNextCateg);
                                        continue;
                                    }
                                    if (vPrevCateg != null) {
                                        CrossRefEntry.mergeCategs(vPrevCateg, vCurCateg);
                                        vCurCateg = vPrevCateg;
                                        continue;
                                    }
                                }
                                vPrevCateg = vCurCateg;
                                vCurCateg = vNextCateg;
                            }
                        }
                    }
                    if (pCategMode.indexOf("[offIfOne]") <= 0 || CrossRefEntry.countChildren(pRoot) != 1) break block24;
                    Node vCateg = pRoot.getFirstChild();
                    Element vCh = (Element)vCateg.getFirstChild();
                    while (vCh != null) {
                        pRoot.appendChild(vCh);
                        vCh = (Element)vCateg.getFirstChild();
                    }
                    pRoot.removeChild(vCateg);
                    break block24;
                }
                for (int j = 0; j < pEntriesCount; ++j) {
                    pRoot.appendChild(pEntries[j]);
                }
                break block24;
            }
            for (int j = 0; j < pEntriesCount; ++j) {
                pRoot.appendChild(pEntries[j]);
            }
        }
    }

    protected static int countChildren(Node pNode) {
        int vCount = 0;
        for (Node vCh = pNode.getFirstChild(); vCh != null; vCh = vCh.getNextSibling()) {
            ++vCount;
        }
        return vCount;
    }

    protected static void mergeCategs(Element pCateg1, Element pCateg2) {
        Element vCh = (Element)pCateg2.getFirstChild();
        while (vCh != null) {
            pCateg1.appendChild(vCh);
            vCh = (Element)pCateg2.getFirstChild();
        }
        String vCateg1To = pCateg1.getAttribute("to");
        String vCateg2From = pCateg2.getAttribute("from");
        if (vCateg1To.length() > 0 && vCateg2From.length() > 0 && Character.isLetter(vCateg1To.charAt(0)) && Character.isLetter(vCateg2From.charAt(0))) {
            String vCateg2To = pCateg2.getAttribute("to");
            String vCateg1From = pCateg1.getAttribute("from");
            if (vCateg2To.length() > 0) {
                if (vCateg1From.length() > 0 && Character.isLetter(vCateg1From.charAt(0))) {
                    if (vCateg2To.length() > 0 && Character.isLetter(vCateg2To.charAt(0))) {
                        pCateg1.setAttribute("label", pCateg1.getAttribute("from") + "-" + pCateg2.getAttribute("to"));
                    } else {
                        pCateg1.setAttribute("label", pCateg1.getAttribute("from") + "-" + CrossRefEntry.extractEndLabel(pCateg2.getAttribute("label")));
                    }
                } else if (Character.isLetter(vCateg2To.charAt(0))) {
                    pCateg1.setAttribute("label", CrossRefEntry.extractStartLabel(pCateg1.getAttribute("label")) + "-" + pCateg2.getAttribute("to"));
                } else {
                    pCateg1.setAttribute("label", CrossRefEntry.extractStartLabel(pCateg1.getAttribute("label")) + "-" + CrossRefEntry.extractEndLabel(pCateg2.getAttribute("label")));
                }
            }
        } else if (pCateg2.getAttribute("label").length() > 0) {
            pCateg1.setAttribute("label", pCateg1.getAttribute("label") + " " + pCateg2.getAttribute("label"));
        }
        pCateg1.setAttribute("to", pCateg2.getAttribute("to"));
        pCateg2.getParentNode().removeChild(pCateg2);
    }

    protected static String extractStartLabel(String pLabel) {
        int vDash = pLabel.lastIndexOf(45);
        if (vDash > 0) {
            return pLabel.substring(0, vDash);
        }
        return pLabel;
    }

    protected static String extractEndLabel(String pLabel) {
        int vDash = pLabel.indexOf(45);
        if (vDash > 0) {
            return pLabel.substring(vDash + 1);
        }
        return pLabel;
    }

    protected static void addEmptyCateg(Element pRoot, char pFrom, char pTo) {
        int vCodeLetter = pFrom;
        String vLetter = Character.toString((char)pFrom);
        Element vCateg = (Element)pRoot.getFirstChild();
        int vPos = vCateg.getAttribute("from").compareTo(vLetter);
        while (true) {
            if (vPos < 0) {
                if ((vCateg = (Element)vCateg.getNextSibling()) == null) {
                    vPos = 1;
                    continue;
                }
                vPos = vCateg.getAttribute("from").compareTo(vLetter);
                continue;
            }
            if (vPos > 0) {
                Element vNewCateg = pRoot.getOwnerDocument().createElement("categ");
                vNewCateg.setAttribute("from", vLetter);
                vNewCateg.setAttribute("to", vLetter);
                vNewCateg.setAttribute("label", vLetter);
                pRoot.insertBefore(vNewCateg, vCateg);
                vCateg = vNewCateg;
            }
            if (++vCodeLetter > pTo) break;
            vLetter = Character.toString((char)vCodeLetter);
            vPos = -1;
        }
    }

    public CrossRefEntry(IWADialog pDialog, String pDestUriEntry, String pIdEntry, String pKeyRef, String pValueEntry) {
        this.fDialog = pDialog;
        this.fDestUriEntry = pDestUriEntry;
        this.fIdEntry = pIdEntry;
        this.fKeyRef = pKeyRef;
        this.fValueEntry = pValueEntry;
    }
}

