/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.generator.web;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.instance.IWInstFormation;
import com.scenari.m.co.user.IUser;
import com.scenari.m.ge.agent.IWADialogExport;
import com.scenari.m.ge.context.HContextGenerator;
import com.scenari.m.ge.generator.IDynamicFile;
import com.scenari.m.ge.generator.IFileModel;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.m.ge.generator.IScripter;
import com.scenari.m.ge.generator.ant.AntGenerator;
import com.scenari.m.ge.generator.ant.AntLogger;
import com.scenari.m.ge.generator.base.DynamicFile;
import com.scenari.m.ge.generator.base.GeneratorBase;
import com.scenari.m.ge.generator.web.ScripterUrl;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformerMgr;
import com.scenari.s.co.transform.IHTransformer;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.copymove.SrcFeatureCopyMove;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.transform.SrcFeatureTransform;
import com.scenari.src.feature.uris.SrcFeatureUris;
import com.scenari.xsldom.xalan.processor.TransformerFactoryImpl;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xpath.objects.XObject;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class WebGenerator
extends GeneratorBase {
    public static final String KEYPROPERTY_DYNAMICPAGES_FOLDERPATH = "destination.dynamicPages.folderPath";
    public static final String KEYPROPERTY_SKIN_FOLDERPATH = "destination.skin.folderPath";
    public static final String KEYPROPERTY_MUTABLEDST_FOLDERPATH = "destination.mutabledst.folderPath";
    public static final String KEYPROPERTY_SOURCE_SITE_FOLDERPATH = "source.site.folderPath";
    public static final String KEYPROPERTY_BUILDURIFROMSOURCE_EXCLUDE = "destination.buildUriFromSource.rootFoldersToExclude";
    public static final String KEYPROPERTY_POSTTASK_ANT = "postTask.ant";
    public static final String EXT_DYNXSL = ".dyn.xsl";
    protected ISrcNode fDestFolderCo = null;
    protected ISrcNode fDestFolderSkin = null;
    protected List<String> fHistoDestFolderCo = new ArrayList<String>();
    protected ISrcNode fDestFolderMutableDst = null;
    protected List<String> fHistoDestFolderMutableDst = new ArrayList<String>();
    protected Set fDestUriTreatedInCo = new HashSet();
    protected Map fSrcFilesCopiedInRes = new HashMap();
    protected Map fPubFilesCopied = new HashMap();
    protected String fEncoding = "ISO-8859-1";
    protected int fSrcUri2DestUriExcludeFolders = 1;
    protected String fPubUriRootSite = null;

    public void setDestRoot(ISrcNode pDocServeur) throws Exception {
        super.setDestRoot(pDocServeur);
        this.fDestFolderCo = SrcFeaturePaths.findNodeByPath(this.fDestRoot, this.xGetPathCo(), false);
        this.fDestFolderMutableDst = SrcFeaturePaths.findNodeByPath(this.fDestRoot, this.xGetPathMutableDst(), false);
        this.fDestFolderSkin = this.fMapSkins != null ? SrcFeaturePaths.findNodeByPath(this.fDestRoot, this.xGetPathSkin(), false) : null;
    }

    public void reset() throws Exception {
        super.reset();
        this.fDestFolderCo = null;
        this.fDestFolderMutableDst = null;
        this.fDestFolderSkin = null;
    }

    protected String xGetPathCo() {
        String vPathDynamicPagesFolder = (String)this.getProperty(KEYPROPERTY_DYNAMICPAGES_FOLDERPATH);
        if (vPathDynamicPagesFolder == null) {
            vPathDynamicPagesFolder = "co";
        }
        return vPathDynamicPagesFolder;
    }

    protected String xGetPathSkin() {
        String vSkinPath = (String)this.getProperty(KEYPROPERTY_SKIN_FOLDERPATH);
        if (vSkinPath == null) {
            vSkinPath = "skin";
        }
        return vSkinPath;
    }

    protected String xGetPathMutableDst() {
        String vPathReFolder = (String)this.getProperty(KEYPROPERTY_MUTABLEDST_FOLDERPATH);
        if (vPathReFolder == null) {
            vPathReFolder = "res";
        }
        return vPathReFolder;
    }

    protected void wDeleteDynamicFiles(IWInstFormation pInstance, IUser pActeur, String pMode, String pSupport, String pLangue) throws Exception {
        this.xRemoveDst(this.fDestFolderCo);
        this.xRemoveDst(this.fDestFolderMutableDst);
        if (this.fDestFolderSkin != null) {
            this.xRemoveDst(this.fDestFolderSkin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xGenerate(IWInstFormation pInstance, IUser pActeur, String pMode, String pSkin, String pLangue) throws Exception {
        this.fDestUriTreatedInCo.clear();
        this.fSrcFilesCopiedInRes.clear();
        this.fPubFilesCopied.clear();
        this.fHistoDestFolderCo.clear();
        this.fHistoDestFolderMutableDst.clear();
        try {
            this.fSrcUri2DestUriExcludeFolders = -1;
            HContextGenerator vContext = new HContextGenerator();
            vContext.wSetUser(pActeur);
            vContext.setSkin(pSkin);
            vContext.wSetGenerator(this);
            IWAgent vAgent = pInstance.hGetAgentRoot();
            if (vAgent == null) {
                throw LogMgr.newException("Le composant racine de la prescription '" + pInstance.hGetPrescription().hGetIdNoeudDepart() + "' est introuvable.", new String[0]);
            }
            IWADialog vRootDialog = pInstance.hGetAgentRoot().hNewDialog();
            this.fCurrentDialog = vRootDialog;
            ((IWADialogExport)this.fCurrentDialog).hSetHier(new ArrayList());
            this.fCurrentDialog.hSetContext(vContext);
            this.fPubUriRootSite = (String)this.getProperty(KEYPROPERTY_SOURCE_SITE_FOLDERPATH);
            if (this.fPubUriRootSite == null) {
                this.fPubUriRootSite = "/site";
            } else {
                if (this.fPubUriRootSite.endsWith("/")) {
                    this.fPubUriRootSite.substring(0, this.fPubUriRootSite.length() - 1);
                }
                if (!this.fPubUriRootSite.startsWith("/")) {
                    "/".concat(this.fPubUriRootSite);
                }
            }
            this.xCopyPubFolder2Dest(this.fPubRoot.findNodeByUri(this.fPubUriRootSite), "");
            this.xCopySkin2Dest();
            this.wTreatStackPages();
            String vPostTaskAnt = (String)this.getProperty(KEYPROPERTY_POSTTASK_ANT);
            if (vPostTaskAnt != null) {
                Project vProject = AntGenerator.createAntProject();
                vProject.init();
                vProject.setBasedir(SrcFeatureAlternateUrl.getFilePath(this.fPubRoot));
                vProject.setUserProperty("vFolderDest", SrcFeatureAlternateUrl.getFilePath(this.fDestRoot));
                vProject.addReference("vDialog", (Object)vRootDialog);
                vProject.addReference("vAgent", (Object)vRootDialog.hGetAgent());
                Iterator vIt = this.getProperties();
                while (vIt.hasNext()) {
                    Map.Entry vEntry = (Map.Entry)vIt.next();
                    if (vEntry.getValue() == null || !(vEntry.getValue() instanceof String)) continue;
                    vProject.setUserProperty((String)vEntry.getKey(), (String)vEntry.getValue());
                }
                String vPathFile = SrcFeatureAlternateUrl.getFilePath(SrcFeaturePaths.findNodeByPath(this.fPubRoot, vPostTaskAnt, false));
                ProjectHelper.getProjectHelper();
                vProject.addBuildListener((BuildListener)new AntLogger(this));
                ProjectHelper.configureProject((Project)vProject, (File)new File(vPathFile));
                vProject.executeTarget(vProject.getDefaultTarget());
                this.wTreatStackPages();
            }
        }
        finally {
            this.fDestUriTreatedInCo.clear();
            this.fSrcFilesCopiedInRes.clear();
            this.fPubFilesCopied.clear();
            this.fHistoDestFolderCo.clear();
            this.fHistoDestFolderMutableDst.clear();
            this.fPubUriRootSite = null;
        }
    }

    protected void xCopySkin2Dest() throws Exception {
        if (this.fSkin != null && this.fSkin.getSkinSrc() != null) {
            SrcFeatureCopyMove.copy(this.fSkin.getSkinSrc(), this.fDestFolderSkin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String copyXxxPath2DestUri(String pUrlLogique, IHDialog pDialog, Object pOwner) throws Exception {
        if (pUrlLogique == null) {
            return "";
        }
        try {
            String vUrlSrc = null;
            ISrcNode vSrc = null;
            String vDestUri = null;
            ISrcNode vDst = null;
            int vIdx = pUrlLogique.indexOf("dst=");
            if (vIdx < 0) {
                vDestUri = this.xCopySrcPath2DestUriNoDst(pUrlLogique, pDialog, pOwner);
            } else {
                int vIdx2 = pUrlLogique.indexOf(59, vIdx);
                vDestUri = WebGenerator.transformNameWithOneExt(((Object)HCharSeqUtil.stringWithoutAccent(vIdx2 > 0 ? pUrlLogique.substring(vIdx + 4, vIdx2) : pUrlLogique.substring(vIdx + 4))).toString());
                vDst = SrcFeaturePaths.findNodeByPath(this.fDestFolderCo, vDestUri, false);
                if (this.fDestUriTreatedInCo.contains(vDestUri = vDst.getSrcUri())) {
                    return vDestUri;
                }
                vIdx = pUrlLogique.indexOf("src=");
                if (vIdx < 0) {
                    throw new Exception("Les param\u00e8tres pour l'export d'une ressource ne sp\u00e9cifie pas de 'src' : " + pUrlLogique);
                }
                vIdx2 = pUrlLogique.indexOf(59, vIdx);
                vUrlSrc = vIdx2 > 0 ? pUrlLogique.substring(vIdx + 4, vIdx2) : pUrlLogique.substring(vIdx + 4);
                IGenerator.IXxxUri pXxxUri = this.resolveXxxPath(vUrlSrc, pDialog, pOwner);
                vSrc = this.getSourceFromXxxUri(pXxxUri, pDialog);
                if (vSrc.getContentStatus() <= -1) {
                    return "";
                }
                this.fDestUriTreatedInCo.add(vDestUri);
                vIdx = pUrlLogique.indexOf("transform=");
                if (vIdx < 0) {
                    if (pUrlLogique.indexOf(";copy=res") > 0) {
                        vSrc = vSrc.findNodeChild(vSrc.getSrcName());
                    }
                    try {
                        SrcFeatureCopyMove.copy(vSrc, vDst);
                    }
                    catch (Exception e) {
                        LogMgr.addMessage((Throwable)e, "Echec \u00e0 la copie de la ressource '" + pUrlLogique + "' d'Url '" + vUrlSrc + "' dans " + pDialog, new String[0]);
                        this.addTrace(ILogMsg.LogType.Warning, LogMgr.getMessage(e));
                        try {
                            this.xRemoveDst(vDst);
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                    int vIndex = pUrlLogique.indexOf(";folderIndex=");
                    if (vIndex > 0) {
                        vDst = this.xGetDstFolderIndex(vDst, pUrlLogique, vIndex);
                    }
                } else {
                    HTransformParams vTransform = HTransformParams.hNewParamsTransformByQueryString(pUrlLogique.substring(vIdx), null);
                    IByteStream vStream = SrcFeatureTransform.transformContent(vSrc, vTransform);
                    if (vStream == null) {
                        throw LogMgr.newException("La transformation '" + vTransform.toString() + "' est impossible ou n'existe pas.", new String[0]);
                    }
                    try {
                        OutputStream vOutputStream = vDst.newOutputStream(false);
                        try {
                            vStream.writeIn(vOutputStream);
                        }
                        finally {
                            if (vOutputStream != null) {
                                vOutputStream.close();
                            }
                        }
                    }
                    finally {
                        if (vStream != null) {
                            vStream.closeStream();
                        }
                    }
                }
            }
            return vDestUri;
        }
        catch (Exception e) {
            LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation de la ressource '" + pUrlLogique + "' dans " + pDialog + ".", new String[0]);
            this.addTrace(ILogMsg.LogType.Warning, LogMgr.getMessage(e));
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String xCopySrcPath2DestUriNoDst(String pUrlLogique, IHDialog pDialog, Object pOwner) throws Exception {
        int vEndDefaultName;
        boolean vGetOnlyRes;
        int vIdx = pUrlLogique.indexOf("src=");
        if (vIdx < 0) {
            throw new Exception("Les param\u00e8tres pour l'export d'une ressource ne sp\u00e9cifie pas de 'src' : " + pUrlLogique);
        }
        int vIdx2 = pUrlLogique.indexOf(59, vIdx);
        String vUrlSrc = vIdx2 > 0 ? pUrlLogique.substring(vIdx + 4, vIdx2) : pUrlLogique.substring(vIdx + 4);
        IGenerator.IXxxUri vXxxUri = this.resolveXxxPath(vUrlSrc, pDialog, pOwner);
        HTransformParams vTransform = null;
        vIdx = pUrlLogique.indexOf("transform=");
        if (vIdx >= 0) {
            vTransform = HTransformParams.hNewParamsTransformByQueryString(pUrlLogique.substring(vIdx), null);
        }
        boolean bl = vIdx2 > 0 ? pUrlLogique.indexOf("copy=res", vIdx2) > 0 : (vGetOnlyRes = false);
        KeyRes vKeyRes = new KeyRes(vXxxUri, vTransform != null ? vTransform.hGetQueryStringFromThis() : (vGetOnlyRes ? "copy=res" : null));
        String vDestUri = (String)this.fSrcFilesCopiedInRes.get(vKeyRes);
        if (vDestUri != null) {
            int vFolderIndex = pUrlLogique.indexOf(";folderIndex=");
            if (vFolderIndex > 0) {
                vDestUri = this.xGetDstFolderIndex(this.fDestRoot.findNodeByUri(vDestUri), pUrlLogique, vFolderIndex).getSrcUri();
            }
            return vDestUri;
        }
        ISrcNode vSrc = this.getSourceFromXxxUri(vXxxUri, pDialog);
        int vSrcStatus = vSrc.getContentStatus();
        if (vSrcStatus <= -1) {
            return "";
        }
        ISrcNode vDst = null;
        int vIdxDefaultName = pUrlLogique.indexOf(";defaultName=");
        String vFileName = vIdxDefaultName > 0 ? pUrlLogique.substring(vIdxDefaultName, (vEndDefaultName = pUrlLogique.indexOf(";", vIdxDefaultName += ";defaultName=".length())) > vIdxDefaultName ? vEndDefaultName : pUrlLogique.length()) : vSrc.getSrcName();
        if (vTransform != null) {
            IHTransformer vTr = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(vTransform.hGetLastTransform());
            String vExt = null;
            vExt = vTr != null ? vTr.hGetFileExtension(vTransform.hGetLastTransform()) : vTransform.hGetValueParam("fileExt");
            if (vExt != null && vExt.length() == 0) {
                vExt = null;
            }
            if (vExt != null && vExt != null && !vFileName.endsWith(vExt)) {
                int vOffsExt = vFileName.lastIndexOf(46);
                vFileName = vOffsExt > 0 ? vFileName.substring(0, vOffsExt).concat(vExt) : vFileName.concat(vExt);
            }
        }
        vDst = this.xLookForFreeDst(this.fDestFolderMutableDst, WebGenerator.transformNameWithOneExt(((Object)HCharSeqUtil.stringWithoutAccent(vFileName)).toString()), this.fHistoDestFolderMutableDst);
        this.fSrcFilesCopiedInRes.put(vKeyRes, vDst.getSrcUri());
        if (vTransform == null) {
            if (vGetOnlyRes && vSrcStatus == 2) {
                vSrc = vSrc.findNodeChild(vSrc.getSrcName());
            }
            try {
                SrcFeatureCopyMove.copy(vSrc, vDst);
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Echec \u00e0 la copie de la ressource '" + pUrlLogique + "' d'Url '" + vUrlSrc + "' dans " + pDialog, new String[0]);
                this.addTrace(ILogMsg.LogType.Warning, LogMgr.getMessage(e));
                try {
                    this.xRemoveDst(vDst);
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            int vFolderIndex = pUrlLogique.indexOf(";folderIndex=");
            if (vFolderIndex > 0) {
                vDst = this.xGetDstFolderIndex(vDst, pUrlLogique, vFolderIndex);
            }
        } else {
            IByteStream vStream = SrcFeatureTransform.transformContent(vSrc, vTransform);
            if (vStream == null) {
                throw LogMgr.newException("La transformation '" + vTransform.toString() + "' est impossible ou n'existe pas.", new String[0]);
            }
            try {
                OutputStream vOutputStream = vDst.newOutputStream(false);
                try {
                    vStream.writeIn(vOutputStream);
                }
                finally {
                    if (vOutputStream != null) {
                        vOutputStream.close();
                    }
                }
            }
            finally {
                if (vStream != null) {
                    vStream.closeStream();
                }
            }
        }
        return vDst.getSrcUri();
    }

    protected ISrcNode xGetDstFolderIndex(ISrcNode pDst, String pUrlLogique, int pFolderIndex) throws Exception {
        StringTokenizer vTok = new StringTokenizer(pUrlLogique.substring(pFolderIndex + ";folderIndex=".length()), ":");
        while (vTok.hasMoreTokens()) {
            ISrcNode vFileSrc;
            String vName = vTok.nextToken();
            if (vName.length() <= 0 || (vFileSrc = SrcFeaturePaths.findNodeByPath(pDst, vName, false)).getContentStatus() <= -1) continue;
            pDst = vFileSrc;
            break;
        }
        return pDst;
    }

    public IDynamicFile wNewDynamicFile(IWADialogExport pDialog, IFileModel pFileModel) throws Exception {
        DynamicFile vResult = new DynamicFile();
        vResult.fFileModel = pFileModel;
        String vPathFile = pDialog.getResultFileUrl();
        String vExt = pFileModel.hGetExtension(pDialog);
        boolean vIsFolder = false;
        if (vExt == null) {
            vExt = "";
        } else {
            vIsFolder = vExt.startsWith("/");
        }
        if (vPathFile == null) {
            String vNameFile = pDialog.hGetAgent().hGetComposant().hGetDocSource().getSrcName();
            int vLastPoint = vNameFile.lastIndexOf(46);
            if (vLastPoint > 0) {
                vNameFile = vNameFile.substring(0, vLastPoint);
            }
            if (!vIsFolder) {
                vNameFile = vNameFile.concat(vExt);
                ISrcNode vFile = this.xLookForFreeDst(this.fDestFolderCo, WebGenerator.transformNameWithOneExt(((Object)HCharSeqUtil.stringWithoutAccent(vNameFile)).toString()), this.fHistoDestFolderCo);
                vFile.createAsFile();
                vResult.fDocument = vFile;
            } else {
                ISrcNode vFile = this.xLookForFreeDst(this.fDestFolderCo, ((Object)HCharSeqUtil.stringWithoutAccent(vNameFile)).toString(), this.fHistoDestFolderCo);
                vFile.createAsFolder();
                vResult.fDocument = SrcFeaturePaths.findNodeByPath(vFile, vExt.substring(1), false);
            }
        } else {
            int vLastPoint = vPathFile.lastIndexOf(46);
            if (vLastPoint > 0 && vLastPoint > vPathFile.lastIndexOf(47)) {
                if (vIsFolder) {
                    vPathFile = vPathFile.substring(0, vLastPoint);
                } else if (vExt != null && vExt.length() > 0) {
                    vPathFile = vPathFile.substring(0, vLastPoint) + vExt;
                }
            }
            vResult.fDocument = vPathFile.startsWith("/") ? SrcFeaturePaths.findNodeByPath(this.fDestFolderCo, vPathFile.endsWith("/") ? vPathFile.substring(0, vPathFile.length() - 1) : vPathFile, false) : this.xLookForFreeDst(this.fDestFolderCo, WebGenerator.transformNameWithOneExt(((Object)HCharSeqUtil.stringWithoutAccent(vPathFile)).toString()), this.fHistoDestFolderCo);
            if (vIsFolder) {
                vResult.fDocument.createAsFolder();
                vResult.fDocument = SrcFeaturePaths.findNodeByPath(vResult.fDocument, vExt.substring(1), false);
            } else {
                vResult.fDocument.createAsFile();
            }
        }
        return vResult;
    }

    protected void xCopyPubFolder2Dest(ISrcNode pPubFolder, String pFolderDest) throws Exception {
        ArrayList<ISrcNode> vChilds = new ArrayList<ISrcNode>();
        pPubFolder.listChildrenNodes(vChilds);
        for (int i = 0; i < vChilds.size(); ++i) {
            this.fCurrentPubFile = (ISrcNode)vChilds.get(i);
            String vUri = this.fCurrentPubFile.getSrcUri();
            String vName = vUri.substring(vUri.lastIndexOf(47) + 1);
            this.fCurrentDestUri = new StringBuilder(pFolderDest.length() + 1 + vName.length()).append(pFolderDest).append('/').append(vName).toString();
            if (vName.charAt(0) == '_') continue;
            if (this.fCurrentPubFile.getContentStatus() == 2) {
                this.xCopyPubFolder2Dest(this.fCurrentPubFile, this.fCurrentDestUri);
                continue;
            }
            this.xCopyPubFile2Dest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xCopyPubFile2Dest() throws Exception {
        if (this.fCurrentDestUri.endsWith(EXT_DYNXSL)) {
            this.fCurrentDestUri = this.fCurrentDestUri.substring(0, this.fCurrentDestUri.length() - EXT_DYNXSL.length());
            GeneratorBase.WFileIhmExported vFile = this.wIsDestUriAlreadyExported(this.fCurrentDestUri);
            if (vFile != null) {
                vFile.fReexported = true;
            }
            SrcFeaturePaths.SrcNodeResolver vResolver = SrcFeaturePaths.newSrcNodeResolver(this.fCurrentPubFile, this);
            Templates vTemplate = (Templates)this.fTemplates.get(this.fCurrentPubFile.getSrcUri());
            if (vTemplate == null) {
                TransformerFactoryImpl vTransFact = new TransformerFactoryImpl();
                ((TransformerFactory)vTransFact).setURIResolver(vResolver);
                XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                vXmlReader.setEntityResolver(vResolver);
                InputStream vStream = vResolver.newInputStream(false);
                if (vStream == null) {
                    throw LogMgr.newException("Le fichier  XSL '" + vResolver + "' est introuvable.", new String[0]);
                }
                InputSource vInputSource = new InputSource(vStream);
                vInputSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vResolver));
                vTemplate = ((TransformerFactory)vTransFact).newTemplates(new SAXSource(vXmlReader, vInputSource));
                this.fTemplates.put(this.fCurrentPubFile.getSrcUri(), vTemplate);
                HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
            }
            IWAgent vAgent = ((IWADialog)this.fCurrentDialog).hGetAgent();
            TransformerImpl vTplTransformer = (TransformerImpl)vTemplate.newTransformer();
            vTplTransformer.setURIResolver(vResolver);
            vTplTransformer.setParameter("vDialog", (Object)this.fCurrentDialog);
            vTplTransformer.setParameter("vAgent", (Object)new XObject(vAgent));
            OutputStream vOutstream = SrcFeaturePaths.findContentByPath(this.fDestRoot, this.fCurrentDestUri, false).newOutputStream(false);
            try {
                vTplTransformer.transformNode(vAgent.hGetElementRoot(), new StreamResult(vOutstream));
            }
            finally {
                vOutstream.close();
            }
        } else {
            long vLastModifSrc = this.fCurrentPubFile.getLastModif();
            GeneratorBase.WFileIhmExported vFile = this.wIsFileAlreadyExported(this.fCurrentPubFile.getSrcUri(), this.fCurrentDestUri);
            if (vFile == null) {
                SrcFeatureCopyMove.copy(this.fCurrentPubFile, this.fDestRoot.findNodeByUri(this.fCurrentDestUri));
            } else {
                if (vLastModifSrc == -1L || vLastModifSrc != vFile.fLastModifSrc) {
                    SrcFeatureCopyMove.copy(this.fCurrentPubFile, this.fDestRoot.findNodeByUri(this.fCurrentDestUri));
                }
                vFile.fReexported = true;
            }
            this.wAddFileExported(this.fCurrentPubFile.getSrcUri(), vLastModifSrc, this.fCurrentDestUri);
        }
    }

    public String translatePubUri2DestUri(String pPubUri) throws Exception {
        if (SrcFeatureUris.isAncestorOrSameUri(this.fPubUriRootSite, pPubUri)) {
            return pPubUri.substring(this.fPubUriRootSite.length());
        }
        if (pPubUri.length() == 0 || pPubUri.equals("/")) {
            return "";
        }
        String vDestUri = (String)this.fPubFilesCopied.get(pPubUri);
        if (vDestUri != null) {
            return vDestUri;
        }
        vDestUri = "";
        ISrcNode vPubFile = this.fPubRoot.findNodeByUri(pPubUri);
        if (vPubFile.getContentStatus() > -1) {
            String vName = vPubFile.getSrcName();
            ISrcNode vDestFile = this.fDestFolderMutableDst.findNodeChild(vName);
            if (vDestFile.getContentStatus() != -1) {
                String vExt = "";
                int vLastPoint = vName.indexOf(46, 1);
                if (vLastPoint > 0) {
                    vExt = vName.substring(vLastPoint);
                    vName = vName.substring(0, vLastPoint);
                }
                while ((vDestFile = this.fDestFolderMutableDst.findNodeChild(vName + '_' + this.xEncodeId((int)(Math.random() * 456975.0)) + vExt)).getContentStatus() != -1) {
                }
            }
            SrcFeatureCopyMove.copy(vPubFile, vDestFile);
            vDestUri = vDestFile.getSrcUri();
        }
        this.fPubFilesCopied.put(pPubUri, vDestUri);
        return vDestUri;
    }

    public String translateSrcUri2DestUri(String pUriSource) throws Exception {
        String vResult = pUriSource;
        if (this.fSrcUri2DestUriExcludeFolders < 0) {
            this.fSrcUri2DestUriExcludeFolders = 1;
            String vProp = (String)this.getProperty(KEYPROPERTY_BUILDURIFROMSOURCE_EXCLUDE);
            if (vProp != null) {
                try {
                    this.fSrcUri2DestUriExcludeFolders = Integer.parseInt(vProp);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        int vIdx = vResult.startsWith("/") ? 1 : 0;
        for (int i = 0; i < this.fSrcUri2DestUriExcludeFolders; ++i) {
            vIdx = vResult.indexOf(47, vIdx) + 1;
        }
        if (vIdx > 0) {
            vResult = vResult.substring(vIdx);
        }
        return vResult;
    }

    public String resolveDestPath2DestUri(String pDestPath) throws Exception {
        if (pDestPath == null || pDestPath.length() == 0) {
            return "";
        }
        return SrcFeaturePaths.resolvePath2Uri(pDestPath, this.fDestFolderCo.getSrcUri(), false);
    }

    public IScripter wNewScripter() throws Exception {
        ScripterUrl vResult = new ScripterUrl();
        vResult.init(this);
        return vResult;
    }

    public String getCurrentDestUri() {
        return this.fCurrentDestUri;
    }

    protected static class KeyRes {
        protected IGenerator.IXxxUri fXxxUri = null;
        protected String fTransform = null;

        public KeyRes(IGenerator.IXxxUri pXxxUri, String pTransform) {
            this.fTransform = pTransform;
            this.fXxxUri = pXxxUri;
        }

        public boolean equals(Object pObj) {
            KeyRes vKey = (KeyRes)pObj;
            if (this.fTransform == null) {
                if (vKey.fTransform == null) {
                    return vKey.fXxxUri.equals(this.fXxxUri);
                }
                return false;
            }
            if (vKey.fTransform == null) {
                return false;
            }
            return vKey.fXxxUri.equals(this.fXxxUri) && vKey.fTransform.equals(this.fTransform);
        }

        public int hashCode() {
            return this.fXxxUri.hashCode();
        }
    }
}

