/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.pages;

import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.HDonneeUtils;
import com.scenari.m.co.donnee.IData;
import com.scenari.m.ge.agent.IWADialogExport;
import com.scenari.m.ge.agent.IWAgentOutline;
import com.scenari.m.ge.agent.pages.HDialogPages;
import com.scenari.m.ge.context.HContextGenerator;
import com.scenari.m.ge.generator.IDynamicFile;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.m.ge.pages.DynamicInclWriter;
import com.scenari.m.ge.pages.IProducerPage;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.mime.MimeMgr;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class BasePage
implements IProducerPage {
    public static final String BUFFER_NS = "ns";
    public static final String BUFFER_JS = "js";
    public static final String BUFFER_JS_LINK = "js.link";
    public static final String BUFFER_JS_POSTLINK = "js.postLink";
    public static final String BUFFER_CSS = "css";
    public static final String BUFFER_CSS_LINK = "css.link";
    protected IGenerator fGenerator = null;
    protected String fUrn = null;
    protected boolean fDialogHierContextual = false;
    protected int fPriority = 0;

    public ContentHandler init(String pUrn, IGenerator pGenerator, Attributes pAttributes) throws Exception {
        this.fGenerator = pGenerator;
        this.fUrn = pUrn;
        if (pAttributes != null) {
            this.fDialogHierContextual = HDonneeUtils.hGetBooleanEvalTrue(pAttributes.getValue("dialogHierContextual"));
            String vPriority = pAttributes.getValue("priority");
            if (vPriority != null && vPriority.length() > 0) {
                try {
                    this.fPriority = Integer.parseInt(vPriority);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void producePage(IWADialogExport pDialogPage) throws Exception {
        if (!(pDialogPage instanceof HDialogPages)) {
            return;
        }
        IDynamicFile vPageToBuild = pDialogPage.getResultFile();
        HDialogPages vDialogPage = (HDialogPages)pDialogPage;
        String vContentType = vDialogPage.hGetZone("content-type");
        String vEncoding = "UTF-8";
        if (vContentType != null && vContentType.length() > 0 && ((vEncoding = MimeMgr.extractCharsetFromContentType(vContentType)) == null || vEncoding.length() == 0)) {
            vEncoding = "UTF-8";
        }
        this.fGenerator.wSetCurrentPubFile(null);
        this.fGenerator.wSetCurrentDestUri(vPageToBuild.getDestUri());
        this.fGenerator.wSetCurrentDialog(vDialogPage);
        OutputStream vStream = vPageToBuild.getDestFile().newOutputStream(false);
        if (vStream != null) {
            DynamicInclWriter vWriter = null;
            try {
                vWriter = new DynamicInclWriter(new OutputStreamWriter(vStream, vEncoding), vDialogPage);
                this.fGenerator.wAddInclResolver(vWriter);
                this.xWritePage(vDialogPage, vWriter, vEncoding);
            }
            finally {
                if (vWriter != null) {
                    vWriter.close();
                } else {
                    vStream.close();
                }
                ((HContextGenerator)vDialogPage.hGetContext()).clearAllBuffers();
            }
        }
    }

    public int getStep() {
        return this.fPriority;
    }

    protected void xWritePage(HDialogPages pDialogPage, DynamicInclWriter pWriter, String pEncoding) throws Exception {
        pDialogPage.hGetPageCourante().hGetZone("mainZone").writeValue(pWriter, pDialogPage, pDialogPage.hGetAgent(), pDialogPage.hGetParam());
    }

    public void addInfo2NsBuffer(HDialogPages pDialogPage) throws Exception {
        Map vBuffer = (Map)((HContextGenerator)pDialogPage.hGetContext()).getBuffer(BUFFER_NS);
        Iterator vIt = pDialogPage.hGetPageCourante().hGetInfoEntries();
        while (vIt.hasNext()) {
            String vVal;
            int vIdx;
            Map.Entry vEntry = (Map.Entry)vIt.next();
            String vCode = (String)vEntry.getKey();
            if (vCode.length() <= BUFFER_NS.length() || vCode.charAt(BUFFER_NS.length()) != ':' || !vCode.startsWith(BUFFER_NS) || (vIdx = (vVal = ((IData)vEntry.getValue()).getString(pDialogPage, pDialogPage.hGetAgent(), null)).indexOf(61)) < 0) continue;
            vBuffer.put(vVal.substring(0, vIdx), vVal.substring(vIdx + 1));
        }
    }

    public void addInfo2XhtmlBuffers(HDialogPages pDialogPage) throws Exception {
        HContextGenerator vContext = (HContextGenerator)pDialogPage.hGetContext();
        Iterator vIt = pDialogPage.hGetPageCourante().hGetInfoEntries();
        while (vIt.hasNext()) {
            int vLenK;
            Map.Entry vEntry = (Map.Entry)vIt.next();
            String vCode = (String)vEntry.getKey();
            int vLen = vCode.length();
            if (vLen > (vLenK = BUFFER_JS.length()) && vCode.charAt(vLenK) == ':' && vCode.startsWith(BUFFER_JS)) {
                ((Map)vContext.getBuffer(BUFFER_JS)).put(vCode.substring(vLenK + 1), ((IData)vEntry.getValue()).getString(pDialogPage, pDialogPage.hGetAgent(), null));
                continue;
            }
            vLenK = BUFFER_CSS.length();
            if (vLen > vLenK && vCode.charAt(vLenK) == ':' && vCode.startsWith(BUFFER_CSS)) {
                ((Map)vContext.getBuffer(BUFFER_CSS)).put(vCode.substring(vLenK + 1), ((IData)vEntry.getValue()).getString(pDialogPage, pDialogPage.hGetAgent(), null));
                continue;
            }
            vLenK = BUFFER_JS_LINK.length();
            if (vLen > vLenK && vCode.charAt(vLenK) == ':' && vCode.startsWith(BUFFER_JS_LINK)) {
                ((Collection)vContext.getBuffer(BUFFER_JS_LINK)).add(((IData)vEntry.getValue()).getString(pDialogPage, pDialogPage.hGetAgent(), null));
                continue;
            }
            vLenK = BUFFER_JS_POSTLINK.length();
            if (vLen > vLenK && vCode.charAt(vLenK) == ':' && vCode.startsWith(BUFFER_JS_POSTLINK)) {
                ((Map)vContext.getBuffer(BUFFER_JS_POSTLINK)).put(vCode.substring(vLenK + 1), ((IData)vEntry.getValue()).getString(pDialogPage, pDialogPage.hGetAgent(), null));
                continue;
            }
            vLenK = BUFFER_CSS_LINK.length();
            if (vLen <= vLenK || vCode.charAt(vLenK) != ':' || !vCode.startsWith(BUFFER_CSS_LINK)) continue;
            ((Collection)vContext.getBuffer(BUFFER_CSS_LINK)).add(((IData)vEntry.getValue()).getString(pDialogPage, pDialogPage.hGetAgent(), null));
        }
    }

    public void addInfo2HtmlBuffers(HDialogPages pDialogPage) throws Exception {
    }

    public Map prepareNsBuffer(HDialogPages pDialogPage) {
        HContextGenerator vContext = (HContextGenerator)pDialogPage.hGetContext();
        HashMap vNsBuffer = (HashMap)vContext.getBuffer(BUFFER_NS);
        if (vNsBuffer == null) {
            vNsBuffer = new HashMap();
            vContext.putBuffer(BUFFER_NS, vNsBuffer);
        } else {
            vNsBuffer.clear();
        }
        return vNsBuffer;
    }

    public void prepareXhtmlBuffers(HDialogPages pDialogPage) {
        HContextGenerator vContext = (HContextGenerator)pDialogPage.hGetContext();
        Map vMapBuffer = (HashMap)vContext.getBuffer(BUFFER_JS);
        if (vMapBuffer == null) {
            vMapBuffer = new HashMap();
            vContext.putBuffer(BUFFER_JS, vMapBuffer);
        } else {
            vMapBuffer.clear();
        }
        vMapBuffer = (Map)vContext.getBuffer(BUFFER_CSS);
        if (vMapBuffer == null) {
            vMapBuffer = new HashMap();
            vContext.putBuffer(BUFFER_CSS, vMapBuffer);
        } else {
            vMapBuffer.clear();
        }
        Set vSetBuffer = (HashSet)vContext.getBuffer(BUFFER_JS_LINK);
        if (vSetBuffer == null) {
            vSetBuffer = new HashSet();
            vContext.putBuffer(BUFFER_JS_LINK, vSetBuffer);
        } else {
            vSetBuffer.clear();
        }
        vMapBuffer = (Map)vContext.getBuffer(BUFFER_JS_POSTLINK);
        if (vMapBuffer == null) {
            vMapBuffer = new HashMap();
            vContext.putBuffer(BUFFER_JS_POSTLINK, vMapBuffer);
        } else {
            vMapBuffer.clear();
        }
        vSetBuffer = (Set)vContext.getBuffer(BUFFER_CSS_LINK);
        if (vSetBuffer == null) {
            vSetBuffer = new HashSet();
            vContext.putBuffer(BUFFER_CSS_LINK, vSetBuffer);
        } else {
            vSetBuffer.clear();
        }
    }

    public void prepareHtmlBuffers(HDialogPages pDialogPage) {
    }

    public boolean resolveXhtmlInc(String pIncl, Writer pWriter, IHDialog pDialog) throws Exception {
        int vLenK;
        HContextGenerator vContext = (HContextGenerator)pDialog.hGetContext();
        int vLen = pIncl.length() - 4;
        if (vLen == (vLenK = BUFFER_JS.length()) && pIncl.regionMatches(4, BUFFER_JS, 0, vLenK)) {
            Map vBuffer = (Map)vContext.getBuffer(BUFFER_JS);
            if (vBuffer.size() > 0) {
                for (String vScript : vBuffer.values()) {
                    pWriter.write(vScript);
                    pWriter.write(10);
                }
            }
            return true;
        }
        vLenK = BUFFER_JS_LINK.length();
        if (vLen == vLenK && pIncl.regionMatches(4, BUFFER_JS_LINK, 0, vLenK)) {
            Map vMap;
            Set vBuffer = (Set)vContext.getBuffer(BUFFER_JS_LINK);
            if (vBuffer.size() > 0) {
                for (String vUrl : vBuffer) {
                    pWriter.write("<script src=\"");
                    pWriter.write(vUrl);
                    pWriter.write("\"/>");
                }
            }
            if ((vMap = (Map)vContext.getBuffer(BUFFER_JS_POSTLINK)).size() > 0) {
                for (String vScript : vMap.values()) {
                    pWriter.write(vScript);
                    pWriter.write(10);
                }
            }
            return true;
        }
        vLenK = BUFFER_CSS.length();
        if (vLen == vLenK && pIncl.regionMatches(4, BUFFER_CSS, 0, vLenK)) {
            Map vBuffer = (Map)vContext.getBuffer(BUFFER_CSS);
            if (vBuffer.size() > 0) {
                for (String vCss : vBuffer.values()) {
                    pWriter.write(vCss);
                    pWriter.write(10);
                }
            }
            return true;
        }
        vLenK = BUFFER_CSS_LINK.length();
        if (vLen == vLenK && pIncl.regionMatches(4, BUFFER_CSS_LINK, 0, vLenK)) {
            Set vBuffer = (Set)vContext.getBuffer(BUFFER_CSS_LINK);
            if (vBuffer.size() > 0) {
                for (String vUrl : vBuffer) {
                    pWriter.write("<link rel=\"stylesheet\" href=\"");
                    pWriter.write(vUrl);
                    pWriter.write("\" type=\"text/css\"/>");
                }
            }
            return true;
        }
        return false;
    }

    public boolean resolveHtmlInc(String pIncl, Writer pWriter, IHDialog pDialog) throws Exception {
        return this.resolveXhtmlInc(pIncl, pWriter, pDialog);
    }

    public String hGetUrn() {
        return this.fUrn;
    }

    public boolean hIsEqualExport(IWADialogExport pDialog1, IWADialogExport pDialog2) throws Exception {
        if (this.fDialogHierContextual) {
            List vHier1 = pDialog1.hGetHier();
            List vHier2 = pDialog2.hGetHier();
            if (vHier1.size() == vHier2.size()) {
                for (int i = 0; i < vHier1.size(); ++i) {
                    if (vHier1.get(i) == vHier2.get(i)) continue;
                    return this.xIsEqualIfCycle(pDialog1);
                }
            } else {
                return this.xIsEqualIfCycle(pDialog1);
            }
        }
        return true;
    }

    protected boolean xIsEqualIfCycle(IWADialogExport pDialog) throws Exception {
        IWAgent pAgent = pDialog.hGetAgent();
        List vListHier = pDialog.hGetHier();
        int vSizeHier = vListHier.size();
        if (vSizeHier > 0 && pAgent instanceof IWAgentOutline && ((IWAgentOutline)pAgent).isRejected(pDialog)) {
            pAgent = (IWAgent)vListHier.get(--vSizeHier);
        }
        for (int i = 0; i < vSizeHier; ++i) {
            IWAgent vAgent = (IWAgent)vListHier.get(i);
            if (vAgent != pAgent) continue;
            this.fGenerator.addTrace("Cycle detected in the page network at : " + pAgent.hGetComposant().hGetDocSource().getSrcUri(), ILogMsg.LogType.Warning, new String[0]);
            return true;
        }
        return false;
    }

    public String hGetExtension(IWADialogExport pDialog) {
        return null;
    }
}

