/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.pages;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.ge.pages.IInclResolver;
import eu.scenari.fw.log.LogMgr;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class DynamicInclWriter
extends Writer {
    protected static final int STATUS_TEXT = 0;
    protected static final int STATUS_TAGOPEN = 1;
    protected static final int STATUS_TAGIN = 2;
    protected static final int STATUS_TAGCLOSE = 3;
    protected static final char[] TAGOPEN_DEFAULT = new char[]{'(', '!', '('};
    protected static final char[] TAGCLOSE_DEFAULT = new char[]{')', '!', ')'};
    protected Writer fWriterDest = null;
    protected IHDialog fDialog = null;
    protected int fStatus = 0;
    protected int fPosTagCourant = 0;
    protected char[] fTagOpen = TAGOPEN_DEFAULT;
    protected char[] fTagClose = TAGCLOSE_DEFAULT;
    protected StringBuilder fBuff = null;
    protected List fResolvers = new ArrayList();

    public DynamicInclWriter(Writer pWriterDest, IHDialog pDialog) {
        this.fWriterDest = pWriterDest;
        this.fDialog = pDialog;
    }

    public void addInclResolver(IInclResolver pResolver) {
        if (pResolver != null) {
            this.fResolvers.add(pResolver);
        }
    }

    public int countResolvers() {
        return this.fResolvers == null ? 0 : this.fResolvers.size();
    }

    public void close() throws IOException {
        if (this.fStatus == 2 || this.fStatus == 3) {
            String vInc = this.fBuff.toString();
            this.fWriterDest.write(this.fTagOpen);
            this.fWriterDest.write(vInc);
            if (this.fStatus == 3) {
                this.fWriterDest.write(this.fTagClose, 0, this.fPosTagCourant);
            }
            LogMgr.publishException("Terminaison anormale d'une donn\u00e9e de type 'inclusion-dynamique' dans le dialogue : " + this.fDialog + ". L'inclusion '" + vInc + "' n'a pu \u00eatre ex\u00e9cut\u00e9e.", new String[0]);
        }
        this.fWriterDest.close();
    }

    public void flush() throws IOException {
        this.fWriterDest.flush();
    }

    public void write(char[] pBuf, int pOffset, int pLength) throws IOException {
        int vEnd = pOffset + pLength;
        for (int i = pOffset; i < vEnd; ++i) {
            this.write(pBuf[i]);
        }
    }

    public void write(int pChar) throws IOException {
        switch (this.fStatus) {
            case 0: {
                if (pChar == this.fTagOpen[0]) {
                    if (this.fTagOpen.length == 1) {
                        if (this.fBuff == null) {
                            this.fBuff = new StringBuilder(64);
                        }
                        this.fStatus = 2;
                        break;
                    }
                    this.fStatus = 1;
                    this.fPosTagCourant = 1;
                    break;
                }
                this.fWriterDest.write(pChar);
                break;
            }
            case 1: {
                if (pChar == this.fTagOpen[this.fPosTagCourant]) {
                    ++this.fPosTagCourant;
                    if (this.fTagOpen.length != this.fPosTagCourant) break;
                    if (this.fBuff == null) {
                        this.fBuff = new StringBuilder(64);
                    }
                    this.fStatus = 2;
                    break;
                }
                this.fWriterDest.write(this.fTagOpen, 0, this.fPosTagCourant);
                if (pChar == this.fTagOpen[0]) {
                    this.fPosTagCourant = 1;
                    break;
                }
                this.fStatus = 0;
                this.fWriterDest.write((char)pChar);
                break;
            }
            case 2: {
                if (pChar == this.fTagClose[0]) {
                    if (this.fTagClose.length == 1) {
                        this.xExecuteInclusion();
                        break;
                    }
                    this.fStatus = 3;
                    this.fPosTagCourant = 1;
                    break;
                }
                this.fBuff.append((char)pChar);
                break;
            }
            case 3: {
                if (pChar == this.fTagClose[this.fPosTagCourant]) {
                    ++this.fPosTagCourant;
                    if (this.fTagClose.length != this.fPosTagCourant) break;
                    this.xExecuteInclusion();
                    break;
                }
                this.fBuff.append(this.fTagClose, 0, this.fPosTagCourant);
                if (pChar == this.fTagClose[0]) {
                    this.fPosTagCourant = 1;
                    break;
                }
                this.fStatus = 2;
                this.fBuff.append((char)pChar);
            }
        }
    }

    public void write(String pStr) throws IOException {
        int vEnd = pStr.length();
        for (int i = 0; i < vEnd; ++i) {
            this.write(pStr.charAt(i));
        }
    }

    public void write(String pStr, int pOffset, int pLength) throws IOException {
        int vEnd = Math.min(pOffset + pLength, pStr.length());
        for (int i = pOffset; i < vEnd; ++i) {
            this.write(pStr.charAt(i));
        }
    }

    public void xExecuteInclusion() throws IOException {
        this.fStatus = 0;
        String vInc = this.fBuff.toString();
        if (vInc.equals("")) {
            this.fWriterDest.write(this.fTagOpen);
            return;
        }
        try {
            IInclResolver vResolver;
            int i;
            int vLen = this.fResolvers.size();
            for (i = 0; i < vLen && !(vResolver = (IInclResolver)this.fResolvers.get(i)).resolveIncl(vInc, this, this.fDialog); ++i) {
            }
            if (i == vLen) {
                this.write(vInc);
            }
        }
        catch (IOException e) {
            throw (IOException)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'insertion d'une inclusion : '" + vInc + "'.", new String[0]);
        }
        catch (Exception e) {
            throw (IOException)LogMgr.addMessage(new IOException("Echec \u00e0 l'insertion d'une inclusion : '" + vInc + "'."), LogMgr.getMessage(e));
        }
        finally {
            this.fBuff.setLength(0);
        }
    }
}

