/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.pages;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.ge.agent.IWADialogExport;
import com.scenari.m.ge.agent.pages.HDialogPages;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.m.ge.pages.DynamicInclWriter;
import com.scenari.m.ge.pages.ZipPage;
import com.scenari.s.co.transform.oo.OdFile;
import com.scenari.src.ISrcNode;
import com.scenari.src.helpers.util.SrcNodeOneShot;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OdPage
extends ZipPage {
    protected XOdContentHandler fOdContentHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void producePage(IWADialogExport pDialogPage) throws Exception {
        try {
            super.producePage(pDialogPage);
        }
        finally {
            if (this.fOdContentHandler != null) {
                this.fOdContentHandler.close();
            }
        }
    }

    protected ContentHandler xGetContentHandler(HDialogPages pDialogPage, ZipOutputStream pZipOutputStream) {
        this.fOdContentHandler = new XOdContentHandler(pDialogPage, pZipOutputStream);
        return this.fOdContentHandler;
    }

    protected class XOdContentHandler
    extends DefaultHandler {
        protected OdFile fOdFile = new OdFile();
        protected ZipOutputStream fOutput;
        protected HDialogPages fDialog;

        public XOdContentHandler(HDialogPages pDialogPage, ZipOutputStream pOutput) {
            this.fOutput = pOutput;
            this.fDialog = pDialogPage;
        }

        public void endElement(String pUri, String pLocalName, String pQName) throws SAXException {
            if (pLocalName == "od") {
                try {
                    this.fOdFile.export(this.fOutput);
                }
                catch (Exception e) {
                    throw (SAXException)LogMgr.addMessage(new SAXException(e), LogMgr.getMessage(e));
                }
            }
        }

        public void startElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
            try {
                if (pLocalName == "od") {
                    String vUrlSrc = pAttributes.getValue("fromSrc");
                    if (vUrlSrc != null) {
                        IGenerator.IXxxUri vXxxUri = OdPage.this.fGenerator.resolveXxxPath(vUrlSrc, this.fDialog, this.fDialog.hGetAgent());
                        ISrcNode vSrc = OdPage.this.fGenerator.getSourceFromXxxUri(vXxxUri, this.fDialog);
                        this.fOdFile.initFromOdFile(vSrc);
                    } else {
                        String vMime = pAttributes.getValue("mime");
                        this.fOdFile.initEmptyFile(vMime);
                    }
                } else if (pLocalName == "folder") {
                    String vName = pAttributes.getValue("pathInZip");
                    String vMime = pAttributes.getValue("mime");
                    this.fOdFile.addEmptyFolder(vName, vMime);
                } else if (pLocalName == "file") {
                    String vUrlSrc = pAttributes.getValue("src");
                    String vName = pAttributes.getValue("pathInZip");
                    String vMime = pAttributes.getValue("mime");
                    if (vUrlSrc != null) {
                        IGenerator.IXxxUri vXxxUri = OdPage.this.fGenerator.resolveXxxPath(vUrlSrc, this.fDialog, this.fDialog.hGetAgent());
                        ISrcNode vSrc = OdPage.this.fGenerator.getSourceFromXxxUri(vXxxUri, this.fDialog);
                        if (vXxxUri.getUri().length() > 0 && vSrc.getContentStatus() != -1) {
                            this.fOdFile.addFileOrFolder(vName, vSrc, vMime);
                        } else {
                            OdPage.this.fGenerator.addTrace("La source " + vSrc + " ne peut \u00eatre incluse dans le document OD. status=" + vSrc.getContentStatus(), ILogMsg.LogType.Warning, new String[0]);
                        }
                    } else {
                        IWAgent vAgent;
                        HDialogPages vDialog;
                        String vPathAgent = pAttributes.getValue("agent");
                        String vPathDialog = pAttributes.getValue("dialog");
                        IHDialog iHDialog = vDialog = vPathDialog != null ? this.fDialog.hGoTo(vPathDialog) : this.fDialog;
                        if (vDialog == null) {
                            vDialog = this.fDialog;
                        }
                        IWAgent iWAgent = vAgent = vPathAgent != null ? this.fDialog.hGetAgent().hGetAgentParRef(vPathAgent) : ((IWADialog)vDialog).hGetAgent();
                        while (vAgent != null && !(vAgent instanceof IWAgentComputor)) {
                            vAgent = vAgent.hGetAgentPere();
                        }
                        if (vAgent != null) {
                            String vEncoding = pAttributes.getValue("encoding");
                            if (vEncoding == null || vEncoding.length() == 0) {
                                vEncoding = "UTF-8";
                            }
                            OutputStreamBlob vBuf = new OutputStreamBlob();
                            Writer vWriter = new OutputStreamWriter((OutputStream)vBuf, vEncoding);
                            DynamicInclWriter vDynWriter = new DynamicInclWriter(vWriter, vDialog);
                            OdPage.this.fGenerator.wAddInclResolver(vDynWriter);
                            if (vDynWriter.countResolvers() > 0) {
                                vWriter = vDynWriter;
                            }
                            ((IWAgentComputor)((Object)vAgent)).computeAsData(vDialog, pAttributes.getValue("arguments")).writeValue(vWriter);
                            vWriter.close();
                            this.fOdFile.addFile(vName, new SrcNodeOneShot(vBuf.getInputStream(true)));
                        }
                    }
                } else if (pLocalName == "includeOd") {
                    String vUrlSrc = pAttributes.getValue("src");
                    String vName = pAttributes.getValue("pathInZip");
                    IGenerator.IXxxUri vXxxUri = OdPage.this.fGenerator.resolveXxxPath(vUrlSrc, this.fDialog, this.fDialog.hGetAgent());
                    ISrcNode vSrc = OdPage.this.fGenerator.getSourceFromXxxUri(vXxxUri, this.fDialog);
                    this.fOdFile.includeOd(vName, vSrc, pAttributes.getValue("removeSettings").equals("true"));
                }
            }
            catch (Exception e) {
                throw (SAXException)LogMgr.addMessage(new SAXException(e), LogMgr.getMessage(e));
            }
        }

        public void close() throws Exception {
            this.fOdFile.close();
        }
    }
}

