/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.pages;

import com.scenari.s.fw.utils.HCharSeqUtil;
import eu.scenari.fw.syntax.json.IJsonisable;
import eu.scenari.fw.syntax.json.JsonSerializer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchIndex {
    protected static final char[] INDEX_ENCODER = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '-', '*', ':', '!', '?', ',', '%', '#', '=', '@', '_', '[', ']', '(', ')', '|', '^', '~'};
    public static Pattern sDefaultWordPattern = Pattern.compile("[^\\u0000-/:-@\\[-`{-\\u00A0]+(?:[-][^\\u0000-/:-@\\[-`{-\\u00A0]+)?|\\d+(?:[,.]\\d+)?");
    protected Pattern fWordPattern;
    protected IWordFilter[] fFilters;
    protected boolean fDiscardCategories = false;
    protected Map<String, Target> fWords = new HashMap<String, Target>(2048);
    protected Map<String, String> fDestUris = new HashMap<String, String>(64);
    protected int fLastAliasDestUri = 0;
    protected List<String> fCategs = new ArrayList<String>(12);

    protected static String encodeIndex(int pIndex) {
        int vVal = pIndex;
        int LEN = INDEX_ENCODER.length;
        StringBuilder vBuf = new StringBuilder(5);
        do {
            vBuf.append(INDEX_ENCODER[vVal % LEN]);
        } while ((vVal /= LEN) != 0);
        return vBuf.toString();
    }

    public static Pattern getDefaultWordPattern() {
        return sDefaultWordPattern;
    }

    public static void setDefaultWordPattern(Pattern pWordPattern) {
        sDefaultWordPattern = pWordPattern;
    }

    public SearchIndex() {
    }

    public SearchIndex(Pattern pWordPattern, IWordFilter[] pFilters) {
        this.setWordPattern(pWordPattern);
        this.setFilters(pFilters);
    }

    public Pattern getWordPattern() {
        return this.fWordPattern;
    }

    public void setWordPattern(Pattern pWordPattern) {
        this.fWordPattern = pWordPattern != null ? pWordPattern : sDefaultWordPattern;
    }

    public IWordFilter[] getFilters() {
        return this.fFilters;
    }

    public void setFilters(IWordFilter[] pFilters) {
        this.fFilters = pFilters;
    }

    public void indexText(String pText, String pDestUri, String pCateg) {
        Scanner sc = new Scanner(pText);
        String vWord = null;
        int vIdxCateg = -1;
        String vAliasDestUri = null;
        block0: while ((vWord = sc.findWithinHorizon(this.fWordPattern, 0)) != null) {
            Target vTarget;
            if (this.fFilters != null) {
                for (int i = 0; i < this.fFilters.length; ++i) {
                    if ((vWord = this.fFilters[i].filter(vWord)) == null) continue block0;
                }
            }
            if (vAliasDestUri == null && (vAliasDestUri = this.fDestUris.get(pDestUri)) == null) {
                vAliasDestUri = SearchIndex.encodeIndex(this.fLastAliasDestUri++);
                this.fDestUris.put(pDestUri, vAliasDestUri);
            }
            Target vLastTarget = vTarget = this.fWords.get(vWord);
            while (vTarget != null && vTarget.fAliasDestUri != vAliasDestUri) {
                vLastTarget = vTarget;
                vTarget = vTarget.fNext;
            }
            if (vTarget == null) {
                vTarget = new Target(vAliasDestUri);
                if (vLastTarget == null) {
                    this.fWords.put(vWord, vTarget);
                } else {
                    vLastTarget.fNext = vTarget;
                }
            }
            if (vIdxCateg < 0 && (vIdxCateg = this.fCategs.indexOf(pCateg)) < 0) {
                vIdxCateg = this.fCategs.size();
                this.fCategs.add(pCateg);
            }
            vTarget.incrementOccurence(vIdxCateg, this.fCategs.size());
        }
    }

    public void serializeIndexAsText(Writer pWriter) throws Exception {
        JsonSerializer vJson = new JsonSerializer(pWriter);
        vJson.startObject();
        for (Map.Entry<String, String> vEntry : this.fDestUris.entrySet()) {
            vJson.key(vEntry.getValue());
            vJson.val(vEntry.getKey());
        }
        vJson.endObject();
        pWriter.append('\n');
        vJson = new JsonSerializer(pWriter);
        vJson.startArray();
        if (!this.fDiscardCategories) {
            for (String vCateg : this.fCategs) {
                vJson.val(vCateg);
            }
        }
        vJson.endArray();
        pWriter.append('\n');
        vJson = new JsonSerializer(pWriter);
        vJson.startObject();
        vJson.key("wordPattern").val(this.fWordPattern.pattern());
        vJson.key("filters");
        vJson.startArray();
        for (int i = 0; i < this.fFilters.length; ++i) {
            vJson.val(this.fFilters[i]);
        }
        vJson.endArray();
        vJson.endObject();
        pWriter.append('\n');
        int vCountTotalCateg = this.fCategs.size();
        for (Map.Entry<String, Target> vEntry : this.fWords.entrySet()) {
            pWriter.append(vEntry.getKey());
            Target vTarget = vEntry.getValue();
            while (vTarget != null) {
                pWriter.append('\t');
                pWriter.append(vTarget.fAliasDestUri);
                if (!this.fDiscardCategories) {
                    int i;
                    pWriter.append('.');
                    int vCountCategs = vTarget.fOccurenceByCateg.length;
                    for (i = 0; i < vCountCategs; ++i) {
                        int vOcc = Math.min(vTarget.fOccurenceByCateg[i], 9);
                        pWriter.append((char)(48 + vOcc));
                    }
                    for (i = vCountCategs; i < vCountTotalCateg; ++i) {
                        pWriter.append('0');
                    }
                }
                vTarget = vTarget.fNext;
            }
            pWriter.append('\n');
        }
    }

    public void setDiscardCategories(boolean pDiscardCategories) {
        this.fDiscardCategories = true;
    }

    public static class Target {
        protected String fAliasDestUri;
        protected byte[] fOccurenceByCateg;
        protected Target fNext = null;

        public Target(String pAliasDestUri) {
            this.fAliasDestUri = pAliasDestUri;
        }

        public void incrementOccurence(int pCateg, int pCountTotalCategs) {
            if (this.fOccurenceByCateg == null) {
                this.fOccurenceByCateg = new byte[pCountTotalCategs];
            } else if (this.fOccurenceByCateg.length < pCateg + 1) {
                byte[] vNewOccurenceByCateg = new byte[pCountTotalCategs];
                System.arraycopy(this.fOccurenceByCateg, 0, vNewOccurenceByCateg, 0, this.fOccurenceByCateg.length);
                this.fOccurenceByCateg = vNewOccurenceByCateg;
            }
            if (this.fOccurenceByCateg[pCateg] < 127) {
                int n = pCateg;
                this.fOccurenceByCateg[n] = (byte)(this.fOccurenceByCateg[n] + 1);
            }
        }
    }

    public static class CutLongWordsFilter
    implements IWordFilter {
        protected int fMax;
        protected Pattern fForWords;

        public CutLongWordsFilter(int pMax) {
            this.fMax = pMax;
            this.fForWords = null;
        }

        public CutLongWordsFilter(int pMax, Pattern pForWords) {
            this.fMax = pMax;
            this.fForWords = pForWords;
        }

        public String filter(String pWord) {
            if (this.fForWords == null || this.fForWords.matcher(pWord).matches()) {
                return pWord.length() > this.fMax ? pWord.substring(0, this.fMax) : pWord;
            }
            return pWord;
        }

        public void writeJson(JsonSerializer pJson) throws Exception {
            pJson.startObject();
            pJson.key("type").valString("cutLongWords");
            if (this.fForWords != null) {
                pJson.key("forWords").valString(this.fForWords.pattern());
            }
            pJson.key("max").valNumber(this.fMax);
            pJson.endObject();
        }
    }

    public static class ExcludeShortWords
    implements IWordFilter {
        protected int fMin;
        protected Pattern fForWords;

        public ExcludeShortWords(int pMin) {
            this.fMin = pMin;
            this.fForWords = null;
        }

        public ExcludeShortWords(int pMin, Pattern pForWords) {
            this.fMin = pMin;
            this.fForWords = pForWords;
        }

        public String filter(String pWord) {
            if (this.fForWords == null || this.fForWords.matcher(pWord).matches()) {
                return pWord.length() < this.fMin ? null : pWord;
            }
            return pWord;
        }

        public void writeJson(JsonSerializer pJson) throws Exception {
            pJson.startObject();
            pJson.key("type").valString("excludeShortWords");
            if (this.fForWords != null) {
                pJson.key("forWords").valString(this.fForWords.pattern());
            }
            pJson.key("min").valNumber(this.fMin);
            pJson.endObject();
        }
    }

    public static class IgnoreWordsFilter
    implements IWordFilter {
        public static Pattern sIgnoreWordsSeparator = Pattern.compile("\\s");
        protected Set<CharSequence> fIgnoreWords = new HashSet<CharSequence>();

        public IgnoreWordsFilter(String pIgnoredWords) {
            Matcher vMatcher = sIgnoreWordsSeparator.matcher(pIgnoredWords);
            int vIndex = 0;
            while (vMatcher.find()) {
                this.fIgnoreWords.add(pIgnoredWords.substring(vIndex, vMatcher.start()));
                vIndex = vMatcher.end();
            }
            if (vIndex == 0) {
                this.fIgnoreWords.add(pIgnoredWords);
            } else {
                this.fIgnoreWords.add(pIgnoredWords.substring(vIndex, pIgnoredWords.length()));
            }
        }

        public String filter(String pWord) {
            if (this.fIgnoreWords.contains(pWord)) {
                return null;
            }
            return pWord;
        }

        public void writeJson(JsonSerializer pJson) throws Exception {
            pJson.startObject();
            pJson.key("type").valString("ignoreWords");
            pJson.key("words").startObject();
            for (CharSequence vWord : this.fIgnoreWords) {
                pJson.key(vWord).valNumber(1);
            }
            pJson.endObject();
            pJson.endObject();
        }
    }

    public static class FilterAccentedLatinLetters
    implements IWordFilter {
        public String filter(String pWord) {
            return ((Object)HCharSeqUtil.stringWithoutAccent(pWord)).toString();
        }

        public void writeJson(JsonSerializer pJson) throws Exception {
            pJson.startObject().key("type").valString("filterAccentedLatinLetters").endObject();
        }
    }

    public static class LowerCaseFilter
    implements IWordFilter {
        protected Locale fLocale = Locale.getDefault();

        public LowerCaseFilter() {
        }

        public LowerCaseFilter(Locale pLocale) {
            if (pLocale != null) {
                this.fLocale = pLocale;
            }
        }

        public String filter(String pWord) {
            return pWord.toString().toLowerCase(this.fLocale);
        }

        public void writeJson(JsonSerializer pJson) throws Exception {
            pJson.startObject().key("type").valString("lowerCase").endObject();
        }
    }

    public static interface IWordFilter
    extends IJsonisable {
        public String filter(String var1);
    }
}

