/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.pages;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.context.IHContextBuffers;
import com.scenari.m.ge.agent.IWADialogExport;
import com.scenari.m.ge.agent.pages.HDialogPages;
import com.scenari.m.ge.context.HContextGenerator;
import com.scenari.m.ge.generator.IDynamicFile;
import com.scenari.m.ge.generator.IFileModel;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.m.ge.generator.web.WebGenerator;
import com.scenari.m.ge.pages.BasePage;
import com.scenari.m.ge.pages.SearchIndex;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SearchIndexPage
extends BasePage {
    protected SearchIndex.IWordFilter[] fFilters = null;
    protected Pattern fWordPattern = null;
    protected boolean fDiscardCategories = false;

    public static SearchIndex createIndex(IWADialog pDialog, String pKeyBufferIndex, String pLocale, boolean pLowerCase, String pWordsToIgnore) {
        int vSizeFilters = 0;
        if (pLowerCase) {
            ++vSizeFilters;
        }
        if (pWordsToIgnore != null) {
            ++vSizeFilters;
        }
        SearchIndex.IWordFilter[] vFilters = null;
        if (vSizeFilters > 0) {
            Locale vLocale = SearchIndexPage.getLocale(pLocale);
            vFilters = new SearchIndex.IWordFilter[vSizeFilters];
            int vIdxFilter = 0;
            if (pLowerCase) {
                vFilters[vIdxFilter++] = new SearchIndex.LowerCaseFilter(vLocale);
            }
            if (pWordsToIgnore != null) {
                vFilters[vIdxFilter++] = new SearchIndex.IgnoreWordsFilter(pWordsToIgnore);
            }
        }
        return SearchIndexPage.createIndex(pDialog, pKeyBufferIndex, null, vFilters);
    }

    public static SearchIndex createIndex(IWADialog pDialog, String pKeyBufferIndex, String pWordPattern, SearchIndex.IWordFilter ... pFilters) {
        IHContextBuffers vContextBuffers = (IHContextBuffers)((Object)pDialog.hGetContext());
        Pattern vWordPattern = null;
        if (pWordPattern != null && pWordPattern.length() > 0) {
            vWordPattern = Pattern.compile(pWordPattern);
        }
        SearchIndex vSearchIndex = new SearchIndex(vWordPattern, pFilters);
        vContextBuffers.putBuffer(pKeyBufferIndex, vSearchIndex);
        return vSearchIndex;
    }

    public static void deleteIndex(IWADialog pDialog, String pKeyBufferIndex) {
        IHContextBuffers vContextBuffers = (IHContextBuffers)((Object)pDialog.hGetContext());
        vContextBuffers.removeBuffer(pKeyBufferIndex);
    }

    public static void indexText(IWADialog pDialog, String pSearchIndexTemplate, String pKeyBufferIndex, String pCateg, String pText) {
        try {
            WebGenerator vGen = (WebGenerator)((HContextGenerator)pDialog.hGetContext()).hGetGenerator();
            SearchIndex vSearchIndex = SearchIndexPage.lookForSearchIndex(pDialog, vGen, pSearchIndexTemplate, pKeyBufferIndex);
            if (vSearchIndex != null) {
                String vDestUri = vGen.getCurrentDestUri();
                vSearchIndex.indexText(pText, vDestUri, pCateg);
            }
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "indexText failed", ILogMsg.LogType.Warning, new String[0]);
        }
    }

    public static void indexDomText(IWADialog pDialog, String pSearchIndexTemplate, String pKeyBufferIndex, String pCateg, Node pContent) {
        try {
            WebGenerator vGen = (WebGenerator)((HContextGenerator)pDialog.hGetContext()).hGetGenerator();
            SearchIndex vSearchIndex = SearchIndexPage.lookForSearchIndex(pDialog, vGen, pSearchIndexTemplate, pKeyBufferIndex);
            if (vSearchIndex != null) {
                String vDestUri = vGen.getCurrentDestUri();
                SearchIndexPage.indexNode(vSearchIndex, vDestUri, pCateg, pContent);
            }
        }
        catch (Exception e) {
            LogMgr.publishException("indexText failed", ILogMsg.LogType.Warning, new String[0]);
        }
    }

    public static void indexDomText(IWADialog pDialog, String pSearchIndexTemplate, String pKeyBufferIndex, String pCateg, NodeIterator pContent) {
        try {
            WebGenerator vGen = (WebGenerator)((HContextGenerator)pDialog.hGetContext()).hGetGenerator();
            SearchIndex vSearchIndex = SearchIndexPage.lookForSearchIndex(pDialog, vGen, pSearchIndexTemplate, pKeyBufferIndex);
            if (vSearchIndex != null) {
                String vDestUri = vGen.getCurrentDestUri();
                Node vNode = pContent.nextNode();
                while (vNode != null) {
                    SearchIndexPage.indexNode(vSearchIndex, vDestUri, pCateg, vNode);
                    vNode = pContent.nextNode();
                }
            }
        }
        catch (Exception e) {
            LogMgr.publishException("indexText failed", ILogMsg.LogType.Warning, new String[0]);
        }
    }

    protected static void indexNode(SearchIndex pSearchIndex, String pDestUri, String pCateg, Node pContent) {
        Node vNode = pContent;
        while (vNode != null) {
            if (vNode.getNodeType() == 1 && vNode.hasChildNodes()) {
                vNode = vNode.getFirstChild();
                continue;
            }
            if (vNode.getNodeType() == 2) {
                pSearchIndex.indexText(vNode.getNodeValue(), pDestUri, pCateg);
                vNode = null;
                continue;
            }
            if (vNode.getNodeType() == 3 || vNode.getNodeType() == 4) {
                pSearchIndex.indexText(vNode.getNodeValue(), pDestUri, pCateg);
            }
            if (vNode.equals(pContent)) {
                vNode = null;
                continue;
            }
            if (vNode.getNextSibling() != null) {
                vNode = vNode.getNextSibling();
                continue;
            }
            while (vNode != null && vNode.getNextSibling() == null) {
                if ((vNode = vNode.getParentNode()) == null || !vNode.equals(pContent)) continue;
                vNode = null;
            }
            if (vNode == null) continue;
            vNode = vNode.getNextSibling();
        }
    }

    protected static SearchIndex lookForSearchIndex(IWADialog pDialog, WebGenerator pGen, String pSearchIndexTemplate, String pKeyBufferIndex) throws Exception {
        IFileModel vTemplate;
        SearchIndex vSearchIndex = null;
        IHContextBuffers vContextBuffers = (IHContextBuffers)((Object)pDialog.hGetContext());
        Object vObj = vContextBuffers.getBuffer(pKeyBufferIndex);
        if (vObj != null && vObj instanceof SearchIndex) {
            vSearchIndex = (SearchIndex)vObj;
        } else if (pSearchIndexTemplate != null && pSearchIndexTemplate.length() > 0 && (vTemplate = pGen.wGetFileModel(pSearchIndexTemplate)) != null && vTemplate instanceof SearchIndexPage) {
            vSearchIndex = ((SearchIndexPage)vTemplate).createSearchIndex(pDialog);
            vContextBuffers.putBuffer(pKeyBufferIndex, vSearchIndex);
        }
        return vSearchIndex;
    }

    protected static Locale getLocale(String pDef) {
        if (pDef == null || pDef.length() == 0) {
            return Locale.getDefault();
        }
        try {
            String vLang = pDef;
            String vCountry = "";
            String vVariant = "";
            int vCountrySep = pDef.indexOf(45);
            if (vCountrySep > 0) {
                vCountry = vLang.substring(vCountrySep + 1);
                vLang = vLang.substring(0, vCountrySep);
                int vVariantSep = vCountry.indexOf(45);
                if (vVariantSep > 0) {
                    vVariant = vCountry.substring(vVariantSep + 1);
                    vCountry = vCountry.substring(0, vVariantSep);
                }
            }
            return new Locale(vLang, vCountry, vVariant);
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Parse Locale failed : " + pDef, ILogMsg.LogType.Info, new String[0]);
            return Locale.getDefault();
        }
    }

    protected SearchIndex createSearchIndex(IWADialog pDialog) {
        SearchIndex vSearchIndex = new SearchIndex(this.fWordPattern, this.fFilters);
        vSearchIndex.setDiscardCategories(this.fDiscardCategories);
        return vSearchIndex;
    }

    public ContentHandler init(String pUrn, IGenerator pGenerator, Attributes pAtts) throws Exception {
        super.init(pUrn, pGenerator, pAtts);
        return new ParamsContentHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void producePage(IWADialogExport pDialogPage) throws Exception {
        HDialogPages vDialogPage = (HDialogPages)pDialogPage;
        this.fGenerator.wSetCurrentDialog(vDialogPage);
        IDynamicFile vPageToBuild = (IDynamicFile)vDialogPage.getDialogResult(null);
        this.fGenerator.wSetCurrentPubFile(null);
        this.fGenerator.wSetCurrentDestUri(vPageToBuild.getDestUri());
        String vKeyBufferIndex = vDialogPage.hGetPageCourante().hGetZone("mainZone").getString(pDialogPage, pDialogPage.hGetAgent(), null);
        if (vKeyBufferIndex == null || vKeyBufferIndex.length() == 0) {
            throw LogMgr.newException("The 'mainZone' in the searchIndex template must specify the key buffer to use.", new String[0]);
        }
        IHContextBuffers vContextBuffers = (IHContextBuffers)((Object)pDialogPage.hGetContext());
        SearchIndex vIndex = (SearchIndex)vContextBuffers.getBuffer(vKeyBufferIndex);
        if (vIndex != null) {
            OutputStreamWriter vWriter = new OutputStreamWriter(vPageToBuild.getDestFile().newOutputStream(false), "UTF-8");
            try {
                vIndex.serializeIndexAsText(vWriter);
            }
            finally {
                ((Writer)vWriter).close();
            }
        }
    }

    protected class ParamsContentHandler
    extends DefaultHandler {
        protected List<SearchIndex.IWordFilter> fDeclaredFilters = new ArrayList<SearchIndex.IWordFilter>();

        protected ParamsContentHandler() {
        }

        public void startElement(String pUri, String pLocalName, String pQName, Attributes pAtts) throws SAXException {
            if (pLocalName == "lowerCase") {
                Locale vLocale = SearchIndexPage.getLocale(pAtts.getValue("locale"));
                this.fDeclaredFilters.add(new SearchIndex.LowerCaseFilter(vLocale));
            } else if (pLocalName == "ignoreWords") {
                this.fDeclaredFilters.add(new SearchIndex.IgnoreWordsFilter(pAtts.getValue("words")));
            } else if (pLocalName == "excludeShortWords") {
                String vForWords = pAtts.getValue("forWords");
                Pattern vForWordsP = vForWords != null && vForWords.length() > 0 ? Pattern.compile(vForWords) : null;
                this.fDeclaredFilters.add(new SearchIndex.ExcludeShortWords(Integer.parseInt(pAtts.getValue("minChars")), vForWordsP));
            } else if (pLocalName == "cutLongWords") {
                String vForWords = pAtts.getValue("forWords");
                Pattern vForWordsP = vForWords != null && vForWords.length() > 0 ? Pattern.compile(vForWords) : null;
                this.fDeclaredFilters.add(new SearchIndex.CutLongWordsFilter(Integer.parseInt(pAtts.getValue("maxChars")), vForWordsP));
            } else if (pLocalName == "filterAccentedLatinLetters") {
                this.fDeclaredFilters.add(new SearchIndex.FilterAccentedLatinLetters());
            } else if (pLocalName == "wordPattern") {
                SearchIndexPage.this.fWordPattern = Pattern.compile(pAtts.getValue("regExp"));
            } else if (pLocalName == "discardCategories") {
                SearchIndexPage.this.fDiscardCategories = true;
            }
        }

        public void endElement(String pUri, String pLocalName, String pQName) throws SAXException {
            if (pLocalName == "template" && this.fDeclaredFilters.size() > 0) {
                SearchIndexPage.this.fFilters = new SearchIndex.IWordFilter[this.fDeclaredFilters.size()];
                this.fDeclaredFilters.toArray(SearchIndexPage.this.fFilters);
            }
        }
    }
}

