/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.pages;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.IData;
import com.scenari.m.ge.agent.pages.HDialogPages;
import com.scenari.m.ge.context.HContextGenerator;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.m.ge.pages.BasePage;
import com.scenari.m.ge.pages.DynamicInclWriter;
import com.scenari.m.ge.pages.IInclResolver;
import eu.scenari.fw.stream.chars.WriterClob;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class XslPage
extends BasePage
implements IInclResolver {
    public static final String BUFFER_XSL_EXCLUDE_PREFIX = "xslExcludePrefix";
    public static final String BUFFER_XSL_EXTENSION_PREFIX = "xslExtensionPrefix";
    WriterClob fWriterBuf = new WriterClob();
    boolean fXhtmlInc = false;
    boolean fHtmlInc = false;

    public ContentHandler init(String pUrn, IGenerator pGenerator, Attributes pAttributs) throws Exception {
        super.init(pUrn, pGenerator, pAttributs);
        if (pUrn.indexOf("xhtml") >= 0) {
            this.fXhtmlInc = true;
        } else if (pUrn.indexOf("html") >= 0) {
            this.fHtmlInc = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xWritePage(HDialogPages pDialogPage, DynamicInclWriter pWriter, String pEncoding) throws Exception {
        Map vNsBuffer = this.prepareNsBuffer(pDialogPage);
        Collection vXslExcludePrefixBuffer = this.prepareXslExcludePrefixBuffer(pDialogPage);
        Collection vXslExtensionPrefixBuffer = this.prepareXslExtensionPrefixBuffer(pDialogPage);
        if (this.fXhtmlInc || this.fHtmlInc) {
            pWriter.addInclResolver(this);
            if (this.fXhtmlInc) {
                this.prepareXhtmlBuffers(pDialogPage);
            } else if (this.fHtmlInc) {
                this.prepareHtmlBuffers(pDialogPage);
            }
        }
        this.fWriterBuf.closeStream();
        try {
            pDialogPage.hGetPageCourante().hGetZone("mainZone").writeValue(this.fWriterBuf, pDialogPage, pDialogPage.hGetAgent(), pDialogPage.hGetParam());
            this.addInfo2NsBuffer(pDialogPage);
            this.addInfo2XslExcludePrefixBuffer(pDialogPage);
            this.addInfo2XslExtensionPrefixBuffer(pDialogPage);
            if (this.fXhtmlInc) {
                this.addInfo2XhtmlBuffers(pDialogPage);
            } else if (this.fHtmlInc) {
                this.addInfo2HtmlBuffers(pDialogPage);
            }
            pWriter.write("<?xml version=\"1.0\" encoding=\"");
            pWriter.write(pEncoding);
            pWriter.write("\"?>\n");
            pWriter.write("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" ");
            for (Map.Entry vEntry : vNsBuffer.entrySet()) {
                String vP = vEntry.getKey().toString();
                if (vP.equals("#default")) {
                    vP = "";
                }
                if (vP.length() > 0) {
                    pWriter.write("xmlns:");
                    pWriter.write(vP);
                } else {
                    pWriter.write("xmlns");
                }
                pWriter.write("=\"");
                pWriter.write(vEntry.getValue().toString());
                pWriter.write("\" ");
            }
            if (!vXslExcludePrefixBuffer.isEmpty()) {
                pWriter.write("exclude-result-prefixes=\"");
                for (String vPrefix : vXslExcludePrefixBuffer) {
                    pWriter.write(vPrefix);
                    pWriter.write(32);
                }
                pWriter.write("\" ");
            }
            if (!vXslExtensionPrefixBuffer.isEmpty()) {
                pWriter.write("extension-element-prefixes=\"");
                for (String vPrefix : vXslExcludePrefixBuffer) {
                    pWriter.write(vPrefix);
                    pWriter.write(32);
                }
                pWriter.write("\" ");
            }
            pWriter.write(">\n");
            this.fWriterBuf.writeIn(pWriter);
            pWriter.write("</xsl:stylesheet>");
        }
        finally {
            this.fWriterBuf.closeStream();
        }
    }

    public void addInfo2XslExcludePrefixBuffer(HDialogPages pDialogPage) throws Exception {
        Collection vBuffer = (Collection)((HContextGenerator)pDialogPage.hGetContext()).getBuffer(BUFFER_XSL_EXCLUDE_PREFIX);
        Iterator vIt = pDialogPage.hGetPageCourante().hGetInfoEntries();
        while (vIt.hasNext()) {
            Map.Entry vEntry = (Map.Entry)vIt.next();
            String vCode = (String)vEntry.getKey();
            if (vCode.length() <= BUFFER_XSL_EXCLUDE_PREFIX.length() || vCode.charAt(BUFFER_XSL_EXCLUDE_PREFIX.length()) != ':' || !vCode.startsWith(BUFFER_XSL_EXCLUDE_PREFIX)) continue;
            vBuffer.add(((IData)vEntry.getValue()).getString(pDialogPage, pDialogPage.hGetAgent(), null));
        }
    }

    public void addInfo2XslExtensionPrefixBuffer(HDialogPages pDialogPage) throws Exception {
        Collection vBuffer = (Collection)((HContextGenerator)pDialogPage.hGetContext()).getBuffer(BUFFER_XSL_EXTENSION_PREFIX);
        Iterator vIt = pDialogPage.hGetPageCourante().hGetInfoEntries();
        while (vIt.hasNext()) {
            Map.Entry vEntry = (Map.Entry)vIt.next();
            String vCode = (String)vEntry.getKey();
            if (vCode.length() <= BUFFER_XSL_EXTENSION_PREFIX.length() || vCode.charAt(BUFFER_XSL_EXTENSION_PREFIX.length()) != ':' || !vCode.startsWith(BUFFER_XSL_EXTENSION_PREFIX)) continue;
            vBuffer.add(((IData)vEntry.getValue()).getString(pDialogPage, pDialogPage.hGetAgent(), null));
        }
    }

    public Collection prepareXslExcludePrefixBuffer(HDialogPages pDialogPage) {
        HContextGenerator vContext = (HContextGenerator)pDialogPage.hGetContext();
        HashSet vBuffer = (HashSet)vContext.getBuffer(BUFFER_XSL_EXCLUDE_PREFIX);
        if (vBuffer == null) {
            vBuffer = new HashSet();
            vContext.putBuffer(BUFFER_XSL_EXCLUDE_PREFIX, vBuffer);
        } else {
            vBuffer.clear();
        }
        return vBuffer;
    }

    public Collection prepareXslExtensionPrefixBuffer(HDialogPages pDialogPage) {
        HContextGenerator vContext = (HContextGenerator)pDialogPage.hGetContext();
        HashSet vBuffer = (HashSet)vContext.getBuffer(BUFFER_XSL_EXTENSION_PREFIX);
        if (vBuffer == null) {
            vBuffer = new HashSet();
            vContext.putBuffer(BUFFER_XSL_EXTENSION_PREFIX, vBuffer);
        } else {
            vBuffer.clear();
        }
        return vBuffer;
    }

    public boolean resolveIncl(String pIncl, Writer pWriter, IHDialog pDialog) throws Exception {
        if (pIncl.startsWith("inc=")) {
            if (this.fXhtmlInc) {
                return this.resolveXhtmlInc(pIncl, pWriter, pDialog);
            }
            if (this.fHtmlInc) {
                return this.resolveHtmlInc(pIncl, pWriter, pDialog);
            }
        }
        return false;
    }
}

