/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.xpath.dom;

import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.m.ge.agent.IWADialogExport;
import com.scenari.src.ISrcNode;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XObject;
import eu.scenari.fw.log.LogMgr;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ZXPathScanFolder
extends ZXPath {
    protected Expression fArg = null;

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum != 1) {
            throw new WrongNumberArgsException("1");
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        if (0 != pArgNum) {
            throw new WrongNumberArgsException("1");
        }
        this.fArg = pArg;
    }

    public XObject xExecute(XPathContext pCtx) throws Exception {
        String vPathFolder = this.fArg.execute(pCtx).str().trim();
        try {
            IWADialogExport vDialog = (IWADialogExport)this.wGetDialogFromCtx(pCtx);
            ISrcNode vSrc = vDialog.hGetGenerateur().getSourceFromXxxUri(vDialog.hGetGenerateur().resolveXxxPath(vPathFolder, vDialog, this.wGetAgentFromCtx(pCtx)), vDialog);
            if (vSrc != null) {
                DocumentImpl vDoc = new DocumentImpl(false);
                ZXPathScanFolder.xPublishSource(vSrc, vDoc, vDoc);
                return new XNodeSet(vDoc);
            }
            return null;
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la construction du contenu d'un dossier.", new String[0]);
        }
    }

    public static void xPublishSource(ISrcNode pSrc, Document pDoc, Node pParent) throws Exception {
        int vSt = pSrc.getContentStatus();
        switch (vSt) {
            case 1: {
                Element vFile = pDoc.createElement("file");
                vFile.setAttribute("name", pSrc.getSrcName());
                pParent.appendChild(vFile);
                break;
            }
            case 2: {
                Element vFolder = pDoc.createElement("folder");
                vFolder.setAttribute("name", pSrc.getSrcName());
                ArrayList<ISrcNode> vList = new ArrayList<ISrcNode>();
                pSrc.listChildrenNodes(vList);
                for (int i = 0; i < vList.size(); ++i) {
                    ISrcNode vCh = (ISrcNode)vList.get(i);
                    ZXPathScanFolder.xPublishSource(vCh, pDoc, vFolder);
                }
                pParent.appendChild(vFolder);
            }
        }
    }
}

