/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.xpath.dom;

import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformerMgr;
import com.scenari.s.co.transform.IHTransformer;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XString;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;

public class ZXPathTransform
extends ZXPath {
    protected Expression fTypeSrc = null;
    protected Expression fSrc = null;
    protected Expression fParams = null;

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum != 3) {
            throw new WrongNumberArgsException("3");
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        if (pArgNum == 0) {
            this.fTypeSrc = pArg;
        } else if (pArgNum == 1) {
            this.fSrc = pArg;
        } else if (pArgNum == 2) {
            this.fParams = pArg;
        } else {
            throw new WrongNumberArgsException("3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject xExecute(XPathContext pCtx) throws Exception {
        String vTypeSrc = this.fTypeSrc.execute(pCtx).str();
        XObject vObjSrc = this.fSrc.execute(pCtx);
        XObject vStrParams = this.fParams.execute(pCtx);
        HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString(vStrParams.str(), "UTF-8");
        IHTransformer vTransformer = null;
        Closeable vRes = null;
        Object vSrc = null;
        XString vXRes = null;
        try {
            if (vTypeSrc.equals("content")) {
                vTransformer = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(vParams);
                if (vTransformer != null) {
                    vSrc = vObjSrc.str();
                } else {
                    vTransformer = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(vParams);
                    if (vTransformer != null) {
                        if (vTransformer.hIsSrcAllowed(String.class, vParams)) {
                            vSrc = vObjSrc.str();
                        } else if (vTransformer.hIsSrcAllowed(Reader.class, vParams)) {
                            vSrc = new StringReader(vObjSrc.str());
                        }
                    }
                }
            } else {
                if (vTypeSrc.equals("file")) {
                    vSrc = new FileInputStream(vObjSrc.str());
                } else if (vTypeSrc.equals("url")) {
                    vSrc = new URL(vObjSrc.str()).openStream();
                }
                vTransformer = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(vParams);
                if (vTransformer != null) {
                    vRes = vTransformer.hIsResAllowed(Writer.class, vParams) ? new StringWriter() : new ByteArrayOutputStream();
                }
            }
            if (vTransformer == null) {
                throw new Exception("Impossible de trouver une transformation avec les param\u00e8tres :" + vStrParams);
            }
            vTransformer.hTransform(vSrc, vRes, vParams);
            if (vRes instanceof ByteArrayOutputStream) {
                throw new Exception("Transformation en flux de caract\u00e8res \u00e0 g\u00e9rer.");
            }
            vXRes = new XString(((StringWriter)vRes).toString());
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Echec lors d'une transformation.", ILogMsg.LogType.Warning, new String[0]);
        }
        finally {
            if (vSrc != null) {
                if (vSrc instanceof Reader) {
                    ((Reader)vSrc).close();
                } else if (vSrc instanceof InputStream) {
                    ((InputStream)vSrc).close();
                }
            }
        }
        return vXRes;
    }
}

