/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.ge.xpath.dtm;

import com.scenari.m.co.xpath.dtm.ZXPath;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformerMgr;
import com.scenari.s.co.transform.IHTransformer;
import com.scenari.xsldtm.xpath.Expression;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldtm.xpath.objects.XObject;
import com.scenari.xsldtm.xpath.objects.XString;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Vector;

public class ZXPathTransform
extends ZXPath {
    private static final long serialVersionUID = -852933096723343532L;
    protected Expression fTypeSrc = null;
    protected Expression fSrc = null;
    protected Expression fParams = null;

    public boolean canTraverseOutsideSubtree() {
        return this.fTypeSrc.canTraverseOutsideSubtree() || this.fSrc.canTraverseOutsideSubtree() || this.fParams.canTraverseOutsideSubtree();
    }

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum != 3) {
            throw new WrongNumberArgsException("3");
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        if (pArgNum == 0) {
            this.fTypeSrc = pArg;
        } else if (pArgNum == 1) {
            this.fSrc = pArg;
        } else if (pArgNum == 2) {
            this.fParams = pArg;
        } else {
            throw new WrongNumberArgsException("3");
        }
    }

    public void fixupVariables(Vector pVars, int pGlobalsSize) {
        super.fixupVariables(pVars, pGlobalsSize);
        this.fTypeSrc.fixupVariables(pVars, pGlobalsSize);
        this.fSrc.fixupVariables(pVars, pGlobalsSize);
        this.fParams.fixupVariables(pVars, pGlobalsSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject xExecute(XPathContext pCtx) throws Exception {
        String vTypeSrc = this.fTypeSrc.execute(pCtx).str();
        XObject vObjSrc = this.fSrc.execute(pCtx);
        XObject vStrParams = this.fParams.execute(pCtx);
        HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString(vStrParams.str(), "UTF-8");
        IHTransformer vTransformer = null;
        Closeable vRes = null;
        Object vSrc = null;
        XString vXRes = null;
        try {
            if (vTypeSrc.equals("content")) {
                vTransformer = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(vParams);
                if (vTransformer != null) {
                    vSrc = vObjSrc.str();
                    vRes = new StringWriter();
                } else {
                    vTransformer = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(vParams);
                    if (vTransformer != null) {
                        vSrc = new StringReader(vObjSrc.str());
                        vRes = new StringWriter();
                    }
                }
            } else {
                if (vTypeSrc.equals("file")) {
                    vSrc = new FileInputStream(vObjSrc.str());
                } else if (vTypeSrc.equals("url")) {
                    vSrc = new URL(vObjSrc.str()).openStream();
                }
                vTransformer = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(vParams);
                if (vTransformer != null) {
                    vRes = vTransformer.hIsResAllowed(Writer.class, vParams) ? new StringWriter() : new ByteArrayOutputStream();
                }
            }
            if (vTransformer == null) {
                throw new Exception("Impossible de trouver une transformation avec les param\u00e8tres :" + vStrParams);
            }
            vTransformer.hTransform(vSrc, vRes, vParams);
            if (vRes instanceof ByteArrayOutputStream) {
                throw new Exception("Transformation en flux de caract\u00e8res \u00e0 g\u00e9rer.");
            }
            vXRes = new XString(((StringWriter)vRes).toString());
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Echec lors d'une transformation.", ILogMsg.LogType.Warning, new String[0]);
        }
        finally {
            if (vSrc != null) {
                if (vSrc instanceof Reader) {
                    ((Reader)vSrc).close();
                } else if (vSrc instanceof InputStream) {
                    ((InputStream)vSrc).close();
                }
            }
        }
        return vXRes;
    }
}

