/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.sourcerel.fs;

import com.scenari.src.ISrcContent;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.IFieldsProviderAspect;
import com.scenari.src.feature.rights.IAccessRightsAspect;
import com.scenari.src.feature.streams.IStreamsAspect;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WSourceElemFs
extends File
implements ISrcContent,
IAccessRightsAspect,
IStreamsAspect,
IFieldsProviderAspect {
    public static int sElapseMsBetweenScanUpdates = 1500;
    protected long fLastUpdate = -1L;
    protected long fLastScan = -1L;

    public WSourceElemFs(String pPathname) {
        super(pPathname);
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IAccessRightsAspect.TYPE) {
            return this;
        }
        if (pDefinition == IStreamsAspect.TYPE) {
            return this;
        }
        if (pDefinition == SrcFeatureAlternateUrl.FILEPATH_ASPECT_TYPE) {
            return this.getAbsolutePath();
        }
        if (pDefinition == IFieldsProviderAspect.TYPE) {
            return this;
        }
        return pDefinition == ISrcContent.TYPE ? this : null;
    }

    public WSourceElemFs(File pParent, String pChild) {
        super(pParent, pChild);
    }

    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        if (this.isFile() && this.canRead()) {
            return pEnsureBuffered ? new BufferedInputStream(new FileInputStream(this)) : new FileInputStream(this);
        }
        return null;
    }

    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        this.fLastScan = -1L;
        if (!this.exists()) {
            this.getParentFile().mkdirs();
            this.createNewFile();
        }
        if (pEnsureBuffered) {
            return new BufferedOutputStream(new FileOutputStream(this, false));
        }
        return new FileOutputStream(this, false);
    }

    public OutputStream newOutputStreamAppend(boolean pEnsureBuffered) throws Exception {
        this.fLastScan = -1L;
        if (!this.exists()) {
            this.getParentFile().mkdirs();
            this.createNewFile();
        }
        if (pEnsureBuffered) {
            return new BufferedOutputStream(new FileOutputStream(this, true));
        }
        return new FileOutputStream(this, true);
    }

    public Reader newReader(String pEncoding) throws Exception {
        if (this.isFile() && this.canRead()) {
            if (pEncoding == null) {
                return new InputStreamReader(new FileInputStream(this));
            }
            return new InputStreamReader((InputStream)new FileInputStream(this), pEncoding);
        }
        return null;
    }

    public Writer newWriter(String pEncoding) throws Exception {
        this.fLastScan = -1L;
        if (!this.exists()) {
            this.getParentFile().mkdirs();
            this.createNewFile();
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this, false), pEncoding);
    }

    public Writer newWriterAppend(String pEncoding) throws Exception {
        this.fLastScan = -1L;
        if (!this.exists()) {
            this.getParentFile().mkdirs();
            this.createNewFile();
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this, true), pEncoding);
    }

    public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
        List<String> vResult;
        block6: {
            block5: {
                vResult = null;
                if (pStatusChilds != 0) break block5;
                String[] vFiles = this.list();
                if (vFiles == null) break block6;
                vResult = Arrays.asList(vFiles);
                break block6;
            }
            File[] vFiles = this.listFiles();
            if (vFiles != null) {
                vResult = new ArrayList<String>(vFiles.length);
                if (pStatusChilds == 2) {
                    for (int i = 0; i < vFiles.length; ++i) {
                        if (!vFiles[i].isDirectory()) continue;
                        vResult.add(vFiles[i].getName());
                    }
                } else {
                    for (int i = 0; i < vFiles.length; ++i) {
                        if (!vFiles[i].isFile()) continue;
                        vResult.add(vFiles[i].getName());
                    }
                }
            }
        }
        return vResult;
    }

    public long getLastModif() throws Exception {
        return this.lastModified();
    }

    public synchronized long getLastModifWithChildren() throws Exception {
        if (this.fLastScan > 0L && this.fLastScan + (long)sElapseMsBetweenScanUpdates >= System.currentTimeMillis()) {
            return this.fLastUpdate;
        }
        this.fLastUpdate = this.xGetLastModifWithChilds(this, 0L);
        this.fLastScan = System.currentTimeMillis();
        return this.fLastUpdate;
    }

    public int getContentSize() throws Exception {
        return (int)this.length();
    }

    public int getContentStatus() throws Exception {
        if (this.isDirectory()) {
            return 2;
        }
        if (this.isFile()) {
            return 1;
        }
        return -1;
    }

    public int getRights() throws Exception {
        return this.canWrite() ? 511 : 3;
    }

    public boolean createAsFile() throws Exception {
        this.getParentFile().mkdirs();
        return this.createNewFile();
    }

    public boolean createAsFolder() throws Exception {
        return this.mkdirs();
    }

    public boolean removeSrc() throws Exception {
        this.fLastScan = -1L;
        return this.xDelete(this);
    }

    protected long xGetLastModifWithChilds(File pFile, long pMostRecentModif) {
        if (pFile.isDirectory()) {
            if (!pFile.getName().equals(".svn")) {
                pMostRecentModif = Math.max(pMostRecentModif, this.lastModified());
                File[] vFiles = pFile.listFiles();
                for (int i = 0; i < vFiles.length; ++i) {
                    pMostRecentModif = Math.max(pMostRecentModif, vFiles[i].lastModified());
                    pMostRecentModif = this.xGetLastModifWithChilds(vFiles[i], pMostRecentModif);
                }
            }
            return pMostRecentModif;
        }
        return Math.max(pMostRecentModif, pFile.lastModified());
    }

    protected boolean xDelete(File pFile) throws Exception {
        if (pFile.isDirectory()) {
            File[] vChilds = pFile.listFiles();
            for (int i = 0; i < vChilds.length; ++i) {
                this.xDelete(vChilds[i]);
            }
            return pFile.delete();
        }
        return pFile.delete();
    }

    public void fillFields(IFieldsCollector pFieldsToCollect) throws Exception {
        SrcFeatureAlternateUrl.fillFields(this, pFieldsToCollect);
    }

    public String getContentType() throws Exception {
        return null;
    }
}

