/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform;

import com.scenari.s.fw.utils.HParamsQueryString;
import com.scenari.s.fw.utils.HUrl;
import eu.scenari.fw.log.LogMgr;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTransformParams {
    public static final String PARAM_TRANSFORM = "transform";
    protected static final String PARAM_TRANSFORM_EQ = "transform=";
    protected String fTransformType = null;
    protected ArrayList fParams = null;
    protected HTransformParams fPrevTransform = null;
    protected HTransformParams fNextTransform = null;

    protected HTransformParams() {
    }

    protected HTransformParams(String pTransformType) {
        this.fTransformType = pTransformType;
    }

    public HTransformParams hClone(boolean pDeep) throws Exception {
        HTransformParams vClone = new HTransformParams(this.fTransformType);
        if (this.fParams != null) {
            vClone.fParams = (ArrayList)this.fParams.clone();
        }
        if (pDeep && this.fNextTransform != null) {
            vClone.hSetNextTransform(this.fNextTransform.hClone(pDeep));
        }
        return vClone;
    }

    public static final HTransformParams hNewParamsTransformOfType(String pTransformType) {
        return new HTransformParams(pTransformType);
    }

    public static final HTransformParams hNewParamsTransformByQueryString(String pQueryString, String pEncoding) throws Exception {
        HTransformParams vRootResult = new HTransformParams();
        HTransformParams.parseQs(vRootResult, pQueryString, pEncoding);
        if (vRootResult.fTransformType == null) {
            return null;
        }
        return vRootResult;
    }

    public static final HTransformParams hNewParamsTransformByQueryString(String pQueryString, String pEncoding, String pDefaultTransformType) throws Exception {
        HTransformParams vRootResult = new HTransformParams();
        HTransformParams.parseQs(vRootResult, pQueryString, pEncoding);
        if (vRootResult.fTransformType == null) {
            vRootResult.fTransformType = pDefaultTransformType;
        }
        return vRootResult;
    }

    protected static void parseQs(HTransformParams pRootResult, String pQueryString, String pEncoding) throws Exception {
        HParam vParam;
        HTransformParams vNextResult;
        String vQSPart;
        HTransformParams vCurrResult = pRootResult;
        char vFirst = pQueryString.charAt(0);
        int vOffsBegin = vFirst == '?' || vFirst == '&' ? 1 : 0;
        int vOffsEnd = pQueryString.indexOf(38);
        while (vOffsEnd > 0) {
            if (vOffsEnd > vOffsBegin) {
                vQSPart = pQueryString.substring(vOffsBegin, vOffsEnd);
                if (vQSPart.startsWith(PARAM_TRANSFORM_EQ)) {
                    if (vCurrResult.fTransformType != null) {
                        vNextResult = new HTransformParams();
                        vCurrResult.hSetNextTransform(vNextResult);
                        vCurrResult = vNextResult;
                    }
                    vCurrResult.fTransformType = vQSPart.substring(PARAM_TRANSFORM_EQ.length());
                } else {
                    vParam = new HParam();
                    vParam.hSetQS(vQSPart, pEncoding);
                    vCurrResult.xAddParam(vParam);
                }
            }
            vOffsBegin = vOffsEnd + 1;
            vOffsEnd = pQueryString.indexOf(38, vOffsBegin);
        }
        if (vOffsBegin < pQueryString.length()) {
            vQSPart = pQueryString.substring(vOffsBegin);
            if (vQSPart.startsWith(PARAM_TRANSFORM_EQ)) {
                if (vCurrResult.fTransformType != null) {
                    vNextResult = new HTransformParams();
                    vCurrResult.hSetNextTransform(vNextResult);
                    vCurrResult = vNextResult;
                }
                vCurrResult.fTransformType = vQSPart.substring(PARAM_TRANSFORM_EQ.length());
            } else {
                vParam = new HParam();
                vParam.hSetQS(vQSPart, pEncoding);
                vCurrResult.xAddParam(vParam);
            }
        }
    }

    public static final HTransformParams hNewParamsTransformByUrl(HUrl pUrl) throws Exception {
        HTransformParams vRootResult;
        HTransformParams vCurrResult = vRootResult = new HTransformParams();
        HParamsQueryString.ParamsIterator vIt = pUrl.hGetParamNames();
        if (vIt != null) {
            while (vIt.hasNext()) {
                String vName = (String)vIt.next();
                if (PARAM_TRANSFORM.equals(vName)) {
                    if (vCurrResult.fTransformType != null) {
                        HTransformParams vNextResult = new HTransformParams();
                        vCurrResult.hSetNextTransform(vNextResult);
                        vCurrResult = vNextResult;
                    }
                    vCurrResult.fTransformType = vIt.getValue();
                    continue;
                }
                vCurrResult.xAddParam(new HParam(vName, vIt.getValue()));
            }
        }
        if (vRootResult.fTransformType == null) {
            vRootResult = null;
        }
        return vRootResult;
    }

    public static final HTransformParams hNewParamsTransformByQueryString(HParamsQueryString pQS) throws Exception {
        HTransformParams vRootResult;
        HTransformParams vCurrResult = vRootResult = new HTransformParams();
        HParamsQueryString.ParamsIterator vIt = pQS.hGetParamNames();
        if (vIt != null) {
            while (vIt.hasNext()) {
                String vName = (String)vIt.next();
                if (PARAM_TRANSFORM.equals(vName)) {
                    if (vCurrResult.fTransformType != null) {
                        HTransformParams vNextResult = new HTransformParams();
                        vCurrResult.hSetNextTransform(vNextResult);
                        vCurrResult = vNextResult;
                    }
                    vCurrResult.fTransformType = vIt.getValue();
                    continue;
                }
                vCurrResult.xAddParam(new HParam(vName, vIt.getValue()));
            }
        }
        if (vRootResult.fTransformType == null) {
            vRootResult = null;
        }
        return vRootResult;
    }

    public final int hCountParams() {
        return this.fParams != null ? this.fParams.size() : 0;
    }

    public final List hGetParams() {
        return this.fParams;
    }

    public final String hGetTransformType() {
        return this.fTransformType;
    }

    public final HTransformParams hGetPrevTransform() {
        return this.fPrevTransform;
    }

    public final HTransformParams hGetNextTransform() {
        return this.fNextTransform;
    }

    public final HTransformParams hGetLastTransform() {
        HTransformParams vTransform = this;
        while (vTransform.fNextTransform != null) {
            vTransform = vTransform.fNextTransform;
        }
        return vTransform;
    }

    public final void hSetNextTransform(HTransformParams pTransform) throws Exception {
        this.fNextTransform = pTransform;
        pTransform.fPrevTransform = this;
        HTransformParams.xControlCycle(this);
    }

    public final void hAddNextTransformAtEnd(HTransformParams pTransform) throws Exception {
        HTransformParams vLastTransform = this;
        while (vLastTransform.fNextTransform != null) {
            vLastTransform = vLastTransform.fNextTransform;
        }
        vLastTransform.fNextTransform = pTransform;
        pTransform.fPrevTransform = vLastTransform;
        HTransformParams.xControlCycle(vLastTransform);
    }

    private static void xControlCycle(HTransformParams pTransform) throws Exception {
        HTransformParams vNext = pTransform.fNextTransform;
        int i = 0;
        while (vNext != null) {
            if (++i > 100) {
                pTransform.fNextTransform.fPrevTransform = null;
                pTransform.fNextTransform = null;
                throw LogMgr.newException("L'ajout de cette transformation aurait entrain\u00e9e une boucle inifinie.", new String[0]);
            }
            vNext = vNext.fNextTransform;
        }
    }

    public final String hGetQueryStringFromTop() {
        StringBuilder vBuf = new StringBuilder(256);
        this.hGetQueryStringBuilderFromTop(vBuf);
        return vBuf.toString();
    }

    public final String hGetQueryStringFromThis() {
        StringBuilder vBuf = new StringBuilder(256);
        this.hGetQueryStringBuilderFromThis(vBuf);
        return vBuf.toString();
    }

    public final void hGetQueryStringBuilderFromTop(StringBuilder pBuf) {
        if (this.fPrevTransform != null) {
            this.fPrevTransform.hGetQueryStringBuilderFromTop(pBuf);
            pBuf.append('&');
        }
        pBuf.append(PARAM_TRANSFORM_EQ);
        pBuf.append(this.fTransformType);
        if (this.fParams != null) {
            for (int i = 0; i < this.fParams.size(); ++i) {
                HParam vPar = (HParam)this.fParams.get(i);
                pBuf.append('&');
                pBuf.append(vPar.hGetQS());
            }
        }
    }

    public final void hGetQueryStringBuilderFromThis(StringBuilder pBuf) {
        pBuf.append(PARAM_TRANSFORM_EQ);
        pBuf.append(this.fTransformType);
        if (this.fParams != null) {
            for (int i = 0; i < this.fParams.size(); ++i) {
                HParam vPar = (HParam)this.fParams.get(i);
                pBuf.append('&');
                pBuf.append(vPar.hGetQS());
            }
        }
        if (this.fNextTransform != null) {
            pBuf.append('&');
            this.fNextTransform.hGetQueryStringBuilderFromThis(pBuf);
        }
    }

    public final String hGetValueParam(String pKeyParam) {
        if (pKeyParam == null || this.fParams == null) {
            return null;
        }
        if (pKeyParam.equals(PARAM_TRANSFORM)) {
            return this.fTransformType;
        }
        for (int i = 0; i < this.fParams.size(); ++i) {
            HParam vPar = (HParam)this.fParams.get(i);
            if (!vPar.hGetKey().equals(pKeyParam)) continue;
            return vPar.hGetValue();
        }
        return null;
    }

    public String[] hGetValues(String pKeyParam) throws Exception {
        if (pKeyParam == null || this.fParams == null) {
            return null;
        }
        if (pKeyParam.equals(PARAM_TRANSFORM)) {
            return new String[]{this.fTransformType};
        }
        int vStart = -1;
        int vEnd = -1;
        for (int i = 0; i < this.fParams.size(); ++i) {
            HParam vPar = (HParam)this.fParams.get(i);
            if (!vPar.hGetKey().equals(pKeyParam)) continue;
            if (vStart == -1) {
                vStart = i;
            }
            vEnd = i;
        }
        if (vStart == -1) {
            return null;
        }
        String[] vRes = new String[vEnd - vStart + 1];
        for (int i = 0; i < vRes.length; ++i) {
            vRes[i] = ((HParam)this.fParams.get(vStart + i)).hGetValue();
        }
        return vRes;
    }

    public final Map hGetMap() throws Exception {
        HashMap<String, String> vMap = new HashMap<String, String>((this.fParams != null ? this.fParams.size() : 0) + 1);
        vMap.put(PARAM_TRANSFORM, this.fTransformType);
        if (this.fParams != null) {
            for (int i = 0; i < this.fParams.size(); ++i) {
                int vNext;
                HParam vPar = (HParam)this.fParams.get(i);
                for (vNext = i + 1; vNext < this.fParams.size(); ++vNext) {
                    HParam vParNext = (HParam)this.fParams.get(vNext);
                    if (!vPar.hGetKey().equals(vParNext.hGetKey())) break;
                }
                if (vNext - i > 1) {
                    throw new Exception("m\u00e9thode champs multivalu\u00e9s non implement\u00e9e...");
                }
                vMap.put(vPar.hGetKey(), vPar.hGetValue());
            }
        }
        return vMap;
    }

    public final void hPut(String pKey, String pValue) {
        this.xAddParam(new HParam(pKey, pValue));
    }

    protected final void xAddParam(HParam pParam) {
        if (this.fParams == null) {
            this.fParams = new ArrayList();
            this.fParams.add(pParam);
        } else {
            int vOffs = Collections.binarySearch(this.fParams, pParam);
            if (vOffs >= 0) {
                this.fParams.add(vOffs + 1, pParam);
            } else {
                this.fParams.add(-vOffs - 1, pParam);
            }
        }
    }

    public String toString() {
        return this.hGetQueryStringFromTop();
    }

    public static class HParam
    implements Comparable {
        protected String fKey = null;
        protected String fValue = null;
        protected String fQueryString = null;

        public HParam(String pKey, String pValue) {
            this.fKey = pKey;
            this.fValue = pValue;
        }

        public HParam() {
        }

        public final void hSetQS(String pQueryString, String pEncoding) {
            String vEncoding = pEncoding != null ? pEncoding : "UTF-8";
            int vOffsVal = pQueryString.indexOf(61);
            if (vOffsVal >= 0) {
                this.fKey = pQueryString.substring(0, vOffsVal);
            }
            if (pQueryString.indexOf(43, ++vOffsVal) >= 0 || pQueryString.indexOf(37, vOffsVal) >= 0) {
                try {
                    this.fValue = URLDecoder.decode(pQueryString.substring(vOffsVal), vEncoding);
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            } else {
                this.fValue = pQueryString.substring(vOffsVal);
            }
            if (vEncoding.equals("UTF-8")) {
                this.fQueryString = pQueryString;
            }
        }

        public final String hGetKey() {
            return this.fKey;
        }

        public final String hGetValue() {
            return this.fValue;
        }

        public final String hGetQS() {
            if (this.fQueryString == null) {
                try {
                    String vVal = HUrl.hEncodeParam(this.fValue, "UTF-8");
                    this.fQueryString = new StringBuilder(this.fKey.length() + 1 + vVal.length()).append(this.fKey).append('=').append(vVal).toString();
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            }
            return this.fQueryString;
        }

        public final boolean equals(Object pObject) {
            if (pObject == null || !(pObject instanceof HParam)) {
                return false;
            }
            HParam vObj = (HParam)pObject;
            return vObj.hGetKey().equals(this.hGetKey()) && vObj.hGetValue().equals(this.hGetValue());
        }

        public final int compareTo(Object pObject) {
            if (pObject == null) {
                return -1;
            }
            if (!(pObject instanceof HParam)) {
                throw new ClassCastException();
            }
            HParam vObj = (HParam)pObject;
            int vRes = this.hGetKey().compareTo(vObj.hGetKey());
            if (vRes == 0) {
                vRes = this.hGetValue().compareTo(vObj.hGetValue());
            }
            return vRes;
        }
    }
}

