/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.flash;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.co.transform.flash.parser.FlashHeader;
import com.scenari.s.co.transform.flash.parser.FlvHeader;
import com.scenari.s.co.transform.flash.parser.SwfHeader;
import com.scenari.s.co.transform.img.IImgSrc;
import com.scenari.s.co.transform.img.ImgSrcBase;
import com.scenari.s.co.transform.img.ImgUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;

public class HTransformerFlashDims
extends HTransformer {
    public static final int SWFUNIT_PER_PX = 20;
    public static final String PARAM_SIZERULES = "sizeRules";
    public static final String PARAM_OUTPUT_RULES = "outRules";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        IImgSrc vSrc = ImgSrcBase.createImgSrc(pSrc);
        try {
            int vRead2;
            vSrc.setWidthDpi(72);
            vSrc.setHeightDpi(72);
            InputStream vStream = vSrc.getInputStream();
            byte[] vData = new byte[4096];
            for (int vRead = vStream.read(vData); vRead != -1 && vRead < vData.length && (vRead2 = vStream.read(vData, vRead, vData.length - vRead)) != -1; vRead += vRead2) {
            }
            FlashHeader vHeader = FlashHeader.buildHeader(vData, vStream);
            if (vHeader instanceof SwfHeader) {
                SwfHeader vSwf = (SwfHeader)vHeader;
                vSrc.setWidth((vSwf.getMaxX() - vSwf.getMinX()) / 20);
                vSrc.setHeight((vSwf.getMaxY() - vSwf.getMinY()) / 20);
            } else if (vHeader instanceof FlvHeader) {
                FlvHeader vFlv = (FlvHeader)vHeader;
                vSrc.setWidth(vFlv.getWidth());
                vSrc.setHeight(vFlv.getHeight());
            }
            String vSizeRules = pParams.hGetValueParam(PARAM_SIZERULES);
            ImgUtil.ResultSize vNewSize = ImgUtil.getSizeFromRules(vSrc, vSizeRules);
            ImgUtil.getPropsFromRules(vSrc, vNewSize, pParams.hGetValueParam(PARAM_OUTPUT_RULES), pRes);
        }
        finally {
            vSrc.close();
        }
    }

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ImgSrcBase.isSrcAllowed(pClassSrc, pParams);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes) || OutputStream.class.isAssignableFrom(pClassRes) || Appendable.class.isAssignableFrom(pClassRes);
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        return "text/plain";
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        return ".txt";
    }

    public static void main(String[] args) {
        try {
            HTransformerFlashDims vTr = new HTransformerFlashDims();
            StringWriter vRes = new StringWriter();
            vTr.hTransform(new File("C:\\test.swf"), vRes, HTransformParams.hNewParamsTransformByQueryString("transform=swf2dims&outRules=Str(pattern'$wpx,$hpx')", "UTF-8"));
            System.out.println(vRes.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

