/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.flash;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.co.transform.flash.parser.FlashHeader;
import com.scenari.s.co.transform.flash.parser.FlvHeader;
import com.scenari.s.co.transform.flash.parser.SwfHeader;
import com.scenari.s.co.transform.img.IImgSrc;
import com.scenari.s.co.transform.img.ImgSrcBase;
import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.serializer.simple.XmlWriterAppendable;
import eu.scenari.fw.log.LogMgr;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;

public class HTransformerFlashProps
extends HTransformer {
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        Closeable vXmlWriter = null;
        IImgSrc vImgSrc = ImgSrcBase.createImgSrc(pSrc);
        try {
            int vRead2;
            byte[] vData = new byte[4096];
            InputStream vStream = vImgSrc.getInputStream();
            for (int vRead = vStream.read(vData); vRead != -1 && vRead < vData.length && (vRead2 = vStream.read(vData, vRead, vData.length - vRead)) != -1; vRead += vRead2) {
            }
            FlashHeader vHeader = FlashHeader.buildHeader(vData, vStream);
            Writer vResult = null;
            if (pRes instanceof OutputStream) {
                vResult = new OutputStreamWriter((OutputStream)pRes, "UTF-8");
            } else if (pRes instanceof File) {
                vResult = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream((File)pRes)), "UTF-8");
            } else if (pRes instanceof Writer) {
                vResult = (Writer)pRes;
            }
            vXmlWriter = new XmlWriterAppendable(vResult);
            vXmlWriter.writeHeaderXml("utf-8");
            if (vHeader instanceof SwfHeader) {
                SwfHeader vSwfHeader = (SwfHeader)vHeader;
                vXmlWriter.writeStartTag("swfHeader");
                vXmlWriter.writeAttribute("signature", vSwfHeader.getSignature());
                vXmlWriter.writeAttribute("version", HCharSeqUtil.hGetIntToString(vSwfHeader.getVersion()));
                vXmlWriter.writeAttribute("frameRate", String.valueOf(vSwfHeader.getFrameRate()));
                vXmlWriter.writeAttribute("numberOfFrames", String.valueOf(vSwfHeader.getNumberOfFrames()));
                vXmlWriter.writeAttribute("x1", HCharSeqUtil.hGetIntToString(vSwfHeader.getMinX()));
                vXmlWriter.writeAttribute("y1", HCharSeqUtil.hGetIntToString(vSwfHeader.getMinY()));
                vXmlWriter.writeAttribute("x2", HCharSeqUtil.hGetIntToString(vSwfHeader.getMaxX()));
                vXmlWriter.writeAttribute("y2", HCharSeqUtil.hGetIntToString(vSwfHeader.getMaxY()));
                vXmlWriter.writeEndEmptyTag();
            } else if (vHeader instanceof FlvHeader) {
                FlvHeader vFlvHeader = (FlvHeader)vHeader;
                vXmlWriter.writeStartTag("flvHeader");
                vXmlWriter.writeAttribute("version", HCharSeqUtil.hGetIntToString(vFlvHeader.getVersion()));
                vXmlWriter.writeAttribute("hasAudio", String.valueOf(vFlvHeader.getHasAudio()));
                vXmlWriter.writeAttribute("hasVideo", String.valueOf(vFlvHeader.getHasVideo()));
                vXmlWriter.writeAttribute("duration", String.valueOf(vFlvHeader.getDuration()));
                vXmlWriter.writeAttribute("audioCodec", vFlvHeader.getAudioCodec());
                vXmlWriter.writeAttribute("audioSampleRate", String.valueOf(vFlvHeader.getAudioCodec()));
                vXmlWriter.writeAttribute("audioSampleSize", String.valueOf(vFlvHeader.getAudioSampleSize()));
                vXmlWriter.writeAttribute("audioType", vFlvHeader.getAudioType());
                vXmlWriter.writeAttribute("videoCodec", vFlvHeader.getVideoCodec());
                vXmlWriter.writeAttribute("frameType", vFlvHeader.getFrameType());
                vXmlWriter.writeAttribute("width", HCharSeqUtil.hGetIntToString(vFlvHeader.getWidth()));
                vXmlWriter.writeAttribute("height", HCharSeqUtil.hGetIntToString(vFlvHeader.getHeight()));
                vXmlWriter.writeEndEmptyTag();
            } else {
                vXmlWriter.writeEmptyTag("formatUnknown");
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'extraction des propri\u00e9t\u00e9s d'une image.", new String[0]);
        }
        finally {
            try {
                if (vXmlWriter != null) {
                    vXmlWriter.close();
                }
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            vImgSrc.close();
        }
    }

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ImgSrcBase.isSrcAllowed(pClassSrc, pParams);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes) || OutputStream.class.isAssignableFrom(pClassRes) || Writer.class.isAssignableFrom(pClassRes);
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        return "text/xml";
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        return ".xml";
    }

    public static void main(String[] args) {
        try {
            HTransformerFlashProps vTr = new HTransformerFlashProps();
            StringWriter vRes = new StringWriter();
            vTr.hTransform(new File("C:\\test2.swf"), vRes, HTransformParams.hNewParamsTransformOfType("swf2props"));
            System.out.println(vRes.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

