/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.flash.parser;

import com.scenari.s.co.transform.flash.parser.FSCoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class AmfReader {
    private FSCoder fCoder;
    private int fStart;
    private int fLength;

    public AmfReader(FSCoder coder, int length) {
        this.fCoder = coder;
        this.fLength = length;
        this.fStart = coder.getPointer();
    }

    public Object readData() throws Exception {
        if ((this.fCoder.getPointer() - this.fStart) / 8 > this.fLength) {
            throw new Exception("AMF overflow");
        }
        int type = this.fCoder.readWord(1, false);
        switch (type) {
            case 0: {
                return this.readDouble();
            }
            case 1: {
                return this.readBoolean();
            }
            case 2: {
                return this.readString();
            }
            case 3: {
                return this.readObject();
            }
            case 5: 
            case 6: {
                return null;
            }
            case 8: {
                return this.readMixedArray();
            }
            case 10: {
                return this.readArray();
            }
            case 11: {
                return this.readDate();
            }
            case 12: {
                return this.readLongString();
            }
        }
        throw new Exception("Unsupported AMF Type");
    }

    public Boolean readBoolean() {
        return new Boolean(this.fCoder.readWord(1, false) == 1);
    }

    public Integer readInt() {
        return new Integer(this.fCoder.readWord(2, false));
    }

    public Integer readLong() {
        return new Integer(this.fCoder.readWord(4, false));
    }

    public Double readDouble() {
        return new Double(this.fCoder.readDouble());
    }

    public String readString() {
        int length = this.fCoder.readWord(2, false);
        return this.fCoder.readString(length);
    }

    public String readLongString() {
        return this.readString();
    }

    public HashMap readObject() throws Exception {
        String key;
        HashMap<String, Object> map = new HashMap<String, Object>();
        while ((key = this.readString()) != null && (key.length() != 0 || this.fCoder.readWord(1, false) != 9)) {
            Object data = this.readData();
            map.put(key, data);
        }
        return map;
    }

    public HashMap readMixedArray() throws Exception {
        String key;
        int length = this.fCoder.readWord(4, false);
        HashMap<String, Object> map = new HashMap<String, Object>(length);
        if (length == 0 && this.fCoder.readWord(1, false) == 9) {
            return map;
        }
        while ((key = this.readString()) != null && (key.length() != 0 || this.fCoder.readWord(1, false) != 9)) {
            Object data = this.readData();
            map.put(key, data);
        }
        return map;
    }

    public Vector readArray() throws Exception {
        int length = this.fCoder.readWord(4, false);
        Vector<Object> array = new Vector<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object data = this.readData();
            array.add(data);
        }
        return array;
    }

    public Date readDate() {
        double vTimestamp = this.fCoder.readDouble();
        this.fCoder.readWord(2, true);
        return new Date((long)vTimestamp);
    }
}

