/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.flash.parser;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class FSCoder {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    String encoding = "UTF8";
    private int byteOrder = 0;
    private byte[] data = null;
    private int ptr = 0;
    private int end = 0;
    public static final int TransparentColors = 0;
    static final int Action = 1;
    public static final int Version = 2;
    static final int Type = 3;
    static final int Empty = 4;
    static final int Identifier = 5;
    static final int NumberOfFillBits = 6;
    static final int NumberOfLineBits = 7;
    static final int NumberOfAdvanceBits = 8;
    static final int NumberOfGlyphBits = 9;
    static final int NumberOfShapeBits = 10;
    static final int ArrayCountExtended = 11;
    static final int WideCodes = 12;
    static final int Delta = 13;
    static final int CodingError = 14;
    static final int TypeInError = 15;
    static final int StartOfError = 16;
    static final int ExpectedLength = 17;
    static final int DecodeActions = 18;
    static final int DecodeShapes = 19;
    static final int DecodeGlyphs = 20;

    static int size(int value, boolean signed) {
        int size = 0;
        int i = 0;
        int mask = Integer.MIN_VALUE;
        if (signed) {
            value = value < 0 ? -value : value;
            for (i = 32; (value & mask) == 0 && i > 0; --i) {
                mask >>>= 1;
            }
            size = i < 32 ? i + 1 : i;
        } else {
            for (i = 32; (value & mask) == 0 && i > 0; --i) {
                mask >>>= 1;
            }
            size = i;
        }
        return size;
    }

    static int size(int[] values, boolean signed) {
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            size = Math.max(size, FSCoder.size(values[i], signed));
        }
        return size;
    }

    static int fixedShortSize(float aNumber) {
        float floatValue = aNumber * 256.0f;
        return FSCoder.size((int)floatValue, true);
    }

    static int fixedShortSize(float[] values) {
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            size = Math.max(size, FSCoder.fixedShortSize(values[i]));
        }
        return size;
    }

    static int fixedSize(float aNumber) {
        float floatValue = aNumber * 65536.0f;
        return FSCoder.size((int)floatValue, true);
    }

    static int fixedSize(float[] values) {
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            size = Math.max(size, FSCoder.fixedSize(values[i]));
        }
        return size;
    }

    static int strlen(String string, String encoding, boolean appendNull) {
        int length = 0;
        if (string != null) {
            try {
                length += string.getBytes(encoding).length;
                length += appendNull ? 1 : 0;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return length;
    }

    static int strlen(String string, boolean appendNull) {
        int length = 0;
        if (string != null) {
            try {
                length += string.getBytes("UTF8").length;
                length += appendNull ? 1 : 0;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return length;
    }

    public FSCoder(int order, int size) {
        this.byteOrder = order;
        this.data = new byte[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = 0;
        }
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public FSCoder(int order, byte[] bytes) {
        this.byteOrder = order;
        this.data = bytes;
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public byte[] getData() {
        int length = this.ptr + 7 >> 3;
        byte[] bytes = new byte[length];
        System.arraycopy(this.data, 0, bytes, 0, length);
        return bytes;
    }

    public void setData(int order, byte[] bytes) {
        this.byteOrder = order;
        this.data = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.data, 0, bytes.length);
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public void addCapacity(int size) {
        int length = (this.end >>> 3) + size;
        byte[] bytes = new byte[length];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        this.data = bytes;
        this.end = this.data.length << 3;
    }

    public int getCapacity() {
        return this.end >>> 3;
    }

    public int getPointer() {
        return this.ptr;
    }

    public void setPointer(int location) {
        if (location < 0 || location > this.end) {
            throw new IllegalArgumentException();
        }
        this.ptr = location;
    }

    public void adjustPointer(int offset) {
        this.ptr += offset;
        if (this.ptr < 0) {
            this.ptr = 0;
        } else if (this.ptr >= this.end) {
            this.ptr = this.end;
        }
    }

    public void alignToByte() {
        this.ptr = this.ptr + 7 & 0xFFFFFFF8;
    }

    public boolean eof() {
        return this.ptr >= this.end;
    }

    public int readBits(int numberOfBits, boolean signed) {
        int value = 0;
        if (numberOfBits < 0 || numberOfBits > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        if (numberOfBits == 0) {
            return 0;
        }
        int index = this.ptr >> 3;
        int base = this.data.length - index > 4 ? 0 : (4 - (this.data.length - index)) * 8;
        int i = 32;
        while (i > base) {
            value |= (this.data[index] & 0xFF) << i - 8;
            i -= 8;
            ++index;
        }
        value <<= this.ptr % 8;
        value = signed ? (value >>= 32 - numberOfBits) : (value >>>= 32 - numberOfBits);
        this.ptr += numberOfBits;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
        return value;
    }

    public void writeBits(int value, int numberOfBits) {
        if (numberOfBits < 0 || numberOfBits > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        if (this.ptr + 32 > this.end) {
            this.addCapacity(this.data.length / 2 + 4);
        }
        int index = this.ptr >> 3;
        value <<= 32 - numberOfBits;
        value >>>= this.ptr % 8;
        value |= this.data[index] << 24;
        int i = 24;
        while (i >= 0) {
            this.data[index] = (byte)(value >>> i);
            i -= 8;
            ++index;
        }
        this.ptr += numberOfBits;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
    }

    public int readWord(int numberOfBytes, boolean signed) {
        int value = 0;
        if (numberOfBytes < 0 || numberOfBytes > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        int index = this.ptr >> 3;
        if (index + numberOfBytes > this.data.length) {
            numberOfBytes = this.data.length - index;
        }
        int numberOfBits = numberOfBytes * 8;
        if (this.byteOrder == 0) {
            int i = 0;
            while (i < numberOfBits) {
                value += (this.data[index] & 0xFF) << i;
                i += 8;
                this.ptr += 8;
                ++index;
            }
        } else {
            int i = 0;
            while (i < numberOfBits) {
                value <<= 8;
                value += this.data[index] & 0xFF;
                i += 8;
                this.ptr += 8;
                ++index;
            }
        }
        if (signed) {
            value <<= 32 - numberOfBits;
            value >>= 32 - numberOfBits;
        }
        return value;
    }

    public void writeWord(int value, int numberOfBytes) {
        if (numberOfBytes < 0 || numberOfBytes > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        int numberOfBits = numberOfBytes * 8;
        if (this.ptr + numberOfBits > this.end) {
            this.addCapacity(this.data.length / 2 + numberOfBytes);
        }
        if (this.byteOrder == 0) {
            int index = this.ptr >>> 3;
            int i = 0;
            while (i < numberOfBits) {
                this.data[index] = (byte)value;
                i += 8;
                this.ptr += 8;
                value >>>= 8;
                ++index;
            }
        } else {
            int index = this.ptr + numberOfBits - 8 >>> 3;
            int i = 0;
            while (i < numberOfBits) {
                this.data[index] = (byte)value;
                i += 8;
                this.ptr += 8;
                value >>>= 8;
                --index;
            }
        }
    }

    public int readBytes(byte[] bytes) {
        int bytesRead = 0;
        if (bytes == null || bytes.length == 0) {
            return bytesRead;
        }
        int index = this.ptr >>> 3;
        int numberOfBytes = bytes.length;
        if (index + numberOfBytes > this.data.length) {
            numberOfBytes = this.data.length - index;
        }
        int i = 0;
        while (i < numberOfBytes) {
            bytes[i] = this.data[index];
            ++i;
            this.ptr += 8;
            ++index;
            ++bytesRead;
        }
        return bytesRead;
    }

    public int writeBytes(byte[] bytes) {
        int bytesWritten = 0;
        if (this.ptr + (bytes.length << 3) > this.end) {
            this.addCapacity(this.data.length / 2 + bytes.length);
        }
        if (bytes == null || bytes.length == 0) {
            return bytesWritten;
        }
        int index = this.ptr >>> 3;
        int numberOfBytes = bytes.length;
        int i = 0;
        while (i < numberOfBytes) {
            this.data[index] = bytes[i];
            ++i;
            this.ptr += 8;
            ++index;
            ++bytesWritten;
        }
        return bytesWritten;
    }

    public int scanBits(int numberOfBits, boolean signed) {
        int start = this.ptr;
        int value = this.readBits(numberOfBits, signed);
        this.ptr = start;
        return value;
    }

    public int scanWord(int numberOfBytes, boolean signed) {
        int start = this.ptr;
        int value = this.readWord(numberOfBytes, signed);
        this.ptr = start;
        return value;
    }

    public float readFixedBits(int numberOfBits, int fractionSize) {
        float divisor = 1 << fractionSize;
        float value = (float)this.readBits(numberOfBits, true) / divisor;
        return value;
    }

    public void writeFixedBits(float value, int numberOfBits, int fractionSize) {
        float multiplier = 1 << fractionSize;
        this.writeBits((int)(value * multiplier), numberOfBits);
    }

    public float readFixedWord(int mantissaSize, int fractionSize) {
        float divisor = 1 << fractionSize * 8;
        int fraction = this.readWord(fractionSize, false);
        int mantissa = this.readWord(mantissaSize, true) << fractionSize * 8;
        return (float)(mantissa + fraction) / divisor;
    }

    public void writeFixedWord(float value, int mantissaSize, int fractionSize) {
        float multiplier = 1 << fractionSize * 8;
        int fraction = (int)(value * multiplier);
        int mantissa = (int)value;
        this.writeWord(fraction, fractionSize);
        this.writeWord(mantissa, mantissaSize);
    }

    public double readDouble() {
        int upperInt = this.readWord(4, false);
        int lowerInt = this.readWord(4, false);
        long longValue = (long)upperInt << 32;
        return Double.longBitsToDouble(longValue |= (long)lowerInt & 0xFFFFFFFFL);
    }

    public void writeDouble(double value) {
        long longValue = Double.doubleToLongBits(value);
        int lowerInt = (int)longValue;
        int upperInt = (int)(longValue >>> 32);
        this.writeWord(upperInt, 4);
        this.writeWord(lowerInt, 4);
    }

    public String readString(int length) {
        return this.readString(length, this.encoding);
    }

    public String readString(int length, String enc) {
        if (length == 0) {
            return "";
        }
        String value = null;
        byte[] str = new byte[length];
        int len = this.readBytes(str);
        try {
            value = new String(str, 0, len, enc);
        }
        catch (UnsupportedEncodingException e) {
            value = "";
        }
        return value;
    }

    public String readString() {
        return this.readString(this.encoding);
    }

    public String readString(String enc) {
        String value = null;
        int start = this.ptr >> 3;
        int length = 0;
        while (start < this.data.length && this.data[start++] != 0) {
            ++length;
        }
        byte[] str = new byte[length];
        int len = this.readBytes(str);
        try {
            value = new String(str, 0, len, enc);
        }
        catch (UnsupportedEncodingException e) {
            value = "";
        }
        this.readWord(1, false);
        ++len;
        return value;
    }

    public int writeString(String str) {
        return this.writeString(str, this.encoding);
    }

    public int writeString(String str, String enc) {
        int bytesWritten = 0;
        try {
            bytesWritten = this.writeBytes(str.getBytes(enc));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return bytesWritten;
    }

    public boolean findBits(int value, int numberOfBits, int step) {
        boolean found = false;
        int start = this.ptr;
        while (this.ptr < this.end) {
            if (this.scanBits(numberOfBits, false) == value) {
                found = true;
                break;
            }
            this.ptr += step;
        }
        if (!found) {
            this.ptr = start;
        }
        return found;
    }

    public boolean findWord(int value, int numberOfBytes, int step) {
        boolean found = false;
        while (this.ptr < this.end) {
            if (this.scanWord(numberOfBytes, false) == value) {
                found = true;
                break;
            }
            this.ptr += step;
        }
        return found;
    }

    public boolean gotoNextBlock(int pByteOffset, InputStream pStreamForMoreData) throws Exception {
        int vRead;
        int vOffset = pByteOffset;
        this.alignToByte();
        int vByteRemainder = this.end - this.ptr >>> 3;
        if (vOffset > vByteRemainder) {
            vOffset -= vByteRemainder;
            vByteRemainder = 0;
        } else if (vOffset > 0) {
            vByteRemainder -= vOffset;
            vOffset = 0;
        }
        if (vByteRemainder > 0) {
            System.arraycopy(this.data, this.data.length - vByteRemainder, this.data, 0, vByteRemainder);
        } else if (vOffset > 0 && pStreamForMoreData != null) {
            pStreamForMoreData.skip(vOffset);
        }
        this.ptr = 0;
        if (pStreamForMoreData != null) {
            int vRead2;
            for (vRead = vByteRemainder; vRead != -1 && vRead < this.data.length && (vRead2 = pStreamForMoreData.read(this.data, vRead, this.data.length - vRead)) != -1; vRead += vRead2) {
            }
        }
        for (int i = vRead; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        return vRead > 0;
    }

    public boolean ensureSizeBlock(int pBytes, InputStream pStreamForMoreData) throws Exception {
        int vRead;
        if (pBytes <= this.data.length) {
            return true;
        }
        if (pStreamForMoreData == null) {
            return false;
        }
        byte[] vNewData = new byte[pBytes];
        System.arraycopy(this.data, 0, vNewData, 0, this.data.length);
        this.data = vNewData;
        this.end = this.data.length << 3;
        for (vRead = this.data.length; vRead != -1 && vRead < pBytes; vRead += pStreamForMoreData.read(vNewData, vRead, pBytes - vRead)) {
        }
        return vRead == vNewData.length;
    }
}

