/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.flash.parser;

import com.scenari.s.co.transform.flash.parser.FlvHeader;
import com.scenari.s.co.transform.flash.parser.SwfHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public abstract class FlashHeader {
    protected String fSignature = null;
    protected int fVersion = 0;

    public static void main(String[] args) {
        try {
            StringBuffer vBuffer = new StringBuffer();
            vBuffer.append("File: ").append(args[0]).append("\n");
            vBuffer.append(FlashHeader.buildHeader(args[0]).toString());
            System.out.println(vBuffer.toString());
        }
        catch (Exception e) {
            System.err.println("Could not read file: " + args[0]);
            e.printStackTrace();
        }
    }

    public static FlashHeader buildHeader(InputStream pStream) throws Exception {
        int vRead2;
        byte[] vBytes = new byte[4096];
        for (int vRead = pStream.read(vBytes); vRead != -1 && vRead < vBytes.length && (vRead2 = pStream.read(vBytes, vRead, vBytes.length - vRead)) != -1; vRead += vRead2) {
        }
        return FlashHeader.buildHeader(vBytes, pStream);
    }

    public static FlashHeader buildHeader(byte[] pBytes, InputStream pStreamForMoreData) throws Exception {
        FlashHeader vResult = null;
        if (SwfHeader.isSwf(pBytes)) {
            vResult = new SwfHeader(pBytes, pStreamForMoreData);
        } else if (FlvHeader.isFlv(pBytes)) {
            vResult = new FlvHeader(pBytes, pStreamForMoreData);
        }
        return vResult;
    }

    public static FlashHeader buildHeader(String pFileName) throws Exception {
        File vFile = new File(pFileName);
        return FlashHeader.buildHeader(new FileInputStream(vFile));
    }

    public String getSignature() {
        return this.fSignature;
    }

    public int getVersion() {
        return this.fVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeFromFile(String pFileName) throws Exception {
        File vFile = new File(pFileName);
        FileInputStream vStream = new FileInputStream(vFile);
        byte[] vData = null;
        try {
            int vRead2;
            vData = new byte[Math.min((int)vFile.length(), 4096)];
            for (int vRead = vStream.read(vData); vRead != -1 && vRead < vData.length && (vRead2 = vStream.read(vData, vRead, vData.length - vRead)) != -1; vRead += vRead2) {
            }
            this.decodeFromData(vData, vStream);
        }
        finally {
            vStream.close();
        }
    }

    public void decodeFromData(InputStream pStream) throws Exception {
        int vRead2;
        byte[] vBytes = new byte[4096];
        for (int vRead = pStream.read(vBytes); vRead != -1 && vRead < vBytes.length && (vRead2 = pStream.read(vBytes, vRead, vBytes.length - vRead)) != -1; vRead += vRead2) {
        }
        this.decodeFromData(vBytes, pStream);
    }

    public abstract void decodeFromData(byte[] var1, InputStream var2) throws Exception;
}

