/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.flash.parser;

import com.scenari.s.co.transform.flash.parser.AmfReader;
import com.scenari.s.co.transform.flash.parser.FSCoder;
import com.scenari.s.co.transform.flash.parser.FlashHeader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.DataFormatException;

public class FlvHeader
extends FlashHeader {
    public static final int FLV_FLAG_HASAUDIO = 4;
    public static final int FLV_FLAG_HASVIDEO = 1;
    public static final int FLV_TAG_AUDIO = 8;
    public static final int FLV_TAG_VIDEO = 9;
    public static final int FLV_TAG_META = 18;
    public static final int FLV_VIDEO_H263 = 2;
    public static final int FLV_VIDEO_SCREEN = 3;
    public static final int FLV_VIDEO_VP6 = 4;
    public static final int FLV_VIDEO_VP6ALPHA = 5;
    public static final int FLV_VIDEO_SCREENV2 = 6;
    protected boolean fHasAudio = false;
    protected boolean fHasVideo = false;
    protected double fDuration = 0.0;
    protected int fAudioCodecId = 0;
    protected int fAudioSampleRateId = 0;
    protected int fAudioSampleSizeId = 0;
    protected int fAudioTypeId = 0;
    protected int fVideoCodecId = 0;
    protected int fFrameTypeId = 0;
    protected int fWidth = 0;
    protected int fHeight = 0;

    public static void main(String[] args) {
        try {
            FlvHeader vProps = new FlvHeader(args[0]);
            System.out.println(vProps.toXmlString());
        }
        catch (Exception e) {
            System.err.println("Could not read file: " + args[0]);
        }
    }

    public FlvHeader(String pFilename) throws Exception {
        this.decodeFromFile(pFilename);
    }

    public FlvHeader(byte[] pData) throws Exception {
        this.decodeFromData(pData, null);
    }

    public FlvHeader(byte[] pData, InputStream pStreamForMoreData) throws Exception {
        this.decodeFromData(pData, pStreamForMoreData);
    }

    public String toString() {
        StringBuffer vBuffer = new StringBuffer();
        vBuffer.append("version=").append(this.getVersion()).append("\n");
        vBuffer.append("hasAudio=").append(this.getHasAudio()).append("\n");
        vBuffer.append("hasVideo=").append(this.getHasVideo()).append("\n");
        vBuffer.append("duration=").append(this.getDuration()).append("\n");
        vBuffer.append("audioCodec=").append(this.getAudioCodec()).append("\n");
        vBuffer.append("audioSampleRate=").append(this.getAudioSampleRate()).append("\n");
        vBuffer.append("audioSampleSize=").append(this.getAudioSampleSize()).append("\n");
        vBuffer.append("audioType=").append(this.getAudioType()).append("\n");
        vBuffer.append("videoCodec=").append(this.getVideoCodec()).append("\n");
        vBuffer.append("frameType=").append(this.getFrameType()).append("\n");
        vBuffer.append("width=").append(this.getWidth()).append("\n");
        vBuffer.append("height=").append(this.getHeight()).append("\n");
        return vBuffer.toString();
    }

    public String toXmlString() {
        StringBuffer vBuffer = new StringBuffer();
        vBuffer.append("<flv>\n");
        vBuffer.append("  <version>").append(this.getVersion()).append("</version>\n");
        vBuffer.append("  <hasAudio>").append(this.getHasAudio()).append("</hasAudio>\n");
        vBuffer.append("  <hasVideo>").append(this.getHasVideo()).append("</hasVideo>\n");
        vBuffer.append("  <duration>").append(this.getDuration()).append("</duration>\n");
        vBuffer.append("  <audioCodec>").append(this.getAudioCodec()).append("</audioCodec>\n");
        vBuffer.append("  <audioSampleRate>").append(this.getAudioSampleRate()).append("</audioSampleRate>\n");
        vBuffer.append("  <audioSampleSize>").append(this.getAudioSampleSize()).append("</audioSampleSize>\n");
        vBuffer.append("  <audioType>").append(this.getAudioType()).append("</audioType>\n");
        vBuffer.append("  <videoCodec>").append(this.getVideoCodec()).append("</videoCodec>\n");
        vBuffer.append("  <frameType>").append(this.getFrameType()).append("</frameType>\n");
        vBuffer.append("  <width>").append(this.getWidth()).append("</width>\n");
        vBuffer.append("  <height>").append(this.getHeight()).append("</height>\n");
        vBuffer.append("</flv>\n");
        return vBuffer.toString();
    }

    public boolean hasAudio() {
        return this.fHasAudio;
    }

    public boolean getHasAudio() {
        return this.fHasAudio;
    }

    public boolean hasVideo() {
        return this.fHasVideo;
    }

    public boolean getHasVideo() {
        return this.fHasVideo;
    }

    public double getDuration() {
        return this.fDuration;
    }

    public int getAudioCodecId() {
        return this.fAudioCodecId;
    }

    public String getAudioCodec() {
        switch (this.fAudioCodecId) {
            case 0: {
                return "uncompressed";
            }
            case 1: {
                return "ADPCM";
            }
            case 2: {
                return "MP3";
            }
            case 5: {
                return "Nellymoser 8kHz mono";
            }
            case 6: {
                return "Nellymoser";
            }
        }
        return "(unknown audio codec)";
    }

    public int getAudioSampleRateId() {
        return this.fAudioSampleRateId;
    }

    public int getAudioSampleRate() {
        switch (this.fAudioSampleRateId) {
            case 0: {
                return 5500;
            }
            case 1: {
                return 11000;
            }
            case 2: {
                return 22000;
            }
            case 3: {
                return 44000;
            }
        }
        return 0;
    }

    public int getAudioSampleSizeId() {
        return this.fAudioSampleSizeId;
    }

    public int getAudioSampleSize() {
        switch (this.fAudioSampleSizeId) {
            case 0: {
                return 8;
            }
            case 1: {
                return 16;
            }
        }
        return 0;
    }

    public int getAudioTypeId() {
        return this.fAudioTypeId;
    }

    public String getAudioType() {
        switch (this.fAudioTypeId) {
            case 0: {
                return "mono";
            }
            case 1: {
                return "stereo";
            }
        }
        return "(unknown audio type)";
    }

    public int getVideoCodecId() {
        return this.fVideoCodecId;
    }

    public String getVideoCodec() {
        switch (this.fVideoCodecId) {
            case 2: {
                return "Sorenson H.263";
            }
            case 3: {
                return "Screen video";
            }
            case 4: {
                return "On2 VP6";
            }
            case 5: {
                return "On2 VP6 with alpha channel";
            }
            case 6: {
                return "Screen video version 2";
            }
        }
        return "(unknown video codec)";
    }

    public int getFrameTypeId() {
        return this.fFrameTypeId;
    }

    public String getFrameType() {
        switch (this.fFrameTypeId) {
            case 1: {
                return "keyframe";
            }
            case 2: {
                return "inter frame";
            }
            case 3: {
                return "disposable inter frame";
            }
        }
        return "(unknown frame type)";
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeight;
    }

    protected static boolean isFlv(byte[] pBytes) throws DataFormatException {
        if (pBytes == null || pBytes.length < 8) {
            return false;
        }
        return pBytes[0] == 70 && pBytes[1] == 76 && pBytes[2] == 86;
    }

    public void decodeFromData(byte[] pBytes, InputStream pStreamForMoreData) throws Exception {
        FSCoder vCoder = null;
        if (!FlvHeader.isFlv(pBytes)) {
            throw new DataFormatException("Data does not start with a valid Flash (FLV) signature.");
        }
        vCoder = new FSCoder(1, pBytes);
        this.fSignature = vCoder.readString(3);
        this.fVersion = vCoder.readWord(1, false);
        vCoder.readBits(5, false);
        this.fHasAudio = vCoder.readBits(1, false) == 1;
        vCoder.readBits(1, false);
        this.fHasVideo = vCoder.readBits(1, false) == 1;
        int vHeaderLength = vCoder.readWord(4, false);
        if (vHeaderLength > 9) {
            vCoder.adjustPointer((vHeaderLength - 9) * 8);
        }
        int vOffsetBlock = vHeaderLength > 9 ? vHeaderLength - 9 : 0;
        boolean vAudioTag = false;
        boolean vVideoTag = false;
        boolean vMetaTag = false;
        boolean vDurationDefined = false;
        this.fDuration = 0.0;
        while ((!vDurationDefined || this.fHasAudio && !vAudioTag || this.fHasVideo && !vVideoTag) && vCoder.gotoNextBlock(vOffsetBlock, pStreamForMoreData)) {
            double vDuration;
            vCoder.readWord(4, false);
            int vTagType = vCoder.readWord(1, false);
            vOffsetBlock = vCoder.readWord(3, false);
            if (vOffsetBlock <= 0) break;
            int vTimestamp = vCoder.readWord(3, false);
            vCoder.adjustPointer(32);
            int vDataStart = vCoder.getPointer();
            if (vTagType == 8 && !vAudioTag) {
                this.fAudioCodecId = vCoder.readBits(4, false);
                this.fAudioSampleRateId = vCoder.readBits(2, false);
                this.fAudioSampleSizeId = vCoder.readBits(1, false);
                this.fAudioTypeId = vCoder.readBits(1, false);
                vAudioTag = true;
            } else if (vTagType == 9 && !vVideoTag) {
                this.fFrameTypeId = vCoder.readBits(4, false);
                this.fVideoCodecId = vCoder.readBits(4, false);
                if (this.fVideoCodecId == 2) {
                    vCoder.readBits(30, false);
                    int vSizeType = vCoder.readBits(3, false);
                    switch (vSizeType) {
                        case 0: {
                            this.fWidth = vCoder.readBits(8, false);
                            this.fHeight = vCoder.readBits(8, false);
                            break;
                        }
                        case 1: {
                            this.fWidth = vCoder.readBits(16, false);
                            this.fHeight = vCoder.readBits(16, false);
                            break;
                        }
                        case 2: {
                            this.fWidth = 352;
                            this.fHeight = 288;
                            break;
                        }
                        case 3: {
                            this.fWidth = 176;
                            this.fHeight = 144;
                            break;
                        }
                        case 4: {
                            this.fWidth = 128;
                            this.fHeight = 96;
                            break;
                        }
                        case 5: {
                            this.fWidth = 320;
                            this.fHeight = 240;
                            break;
                        }
                        case 6: {
                            this.fWidth = 160;
                            this.fHeight = 120;
                        }
                    }
                } else if (this.fVideoCodecId == 3 || this.fVideoCodecId == 6) {
                    vCoder.readBits(4, false);
                    this.fWidth = vCoder.readBits(12, false);
                    vCoder.readBits(4, false);
                    this.fHeight = vCoder.readBits(12, false);
                } else if (this.fVideoCodecId == 4 || this.fVideoCodecId == 5) {
                    // empty if block
                }
                vVideoTag = true;
            } else if (vTagType == 18 && !vMetaTag) {
                try {
                    vCoder.ensureSizeBlock((vDataStart >>> 3) + vOffsetBlock, pStreamForMoreData);
                    AmfReader vAmfReader = new AmfReader(vCoder, vOffsetBlock);
                    String vTagName = (String)vAmfReader.readData();
                    if (vTagName.equals("onMetaData")) {
                        HashMap vMetas = (HashMap)vAmfReader.readData();
                        if (vMetas.containsKey("duration")) {
                            vDurationDefined = true;
                            this.fDuration = (Double)vMetas.get("duration");
                        }
                        if (vMetas.containsKey("width")) {
                            this.fWidth = ((Double)vMetas.get("width")).intValue();
                        }
                        if (vMetas.containsKey("height")) {
                            this.fHeight = ((Double)vMetas.get("height")).intValue();
                        }
                        vMetaTag = true;
                    }
                }
                catch (Exception e) {
                    vCoder.setPointer(vDataStart);
                }
            }
            if (!vDurationDefined && (vTagType == 8 || vTagType == 9) && (vDuration = (double)(vTimestamp / 1000)) > this.fDuration) {
                this.fDuration = vDuration;
            }
            vCoder.alignToByte();
            vOffsetBlock -= (vCoder.getPointer() - vDataStart) / 8;
        }
    }
}

