/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.flash.parser;

import com.scenari.s.co.transform.flash.parser.FSCoder;
import com.scenari.s.co.transform.flash.parser.FlashHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class SwfHeader
extends FlashHeader {
    protected int fMinX = 0;
    protected int fMinY = 0;
    protected int fMaxX = 0;
    protected int fMaxY = 0;
    protected int fLength = 0;
    protected float fFrameRate = 0.0f;
    protected int fFrameCount = 0;

    public static void main(String[] args) {
        try {
            SwfHeader header = new SwfHeader(args[0]);
            StringBuffer buffer = new StringBuffer();
            buffer.append("File: ").append(args[0]).append("\n");
            buffer.append("Signature: ").append(header.getSignature()).append("\n");
            buffer.append("Version: ").append(header.getVersion()).append("\n");
            buffer.append("Frame: ");
            buffer.append("(").append(header.getMinX()).append(",").append(header.getMinY()).append(") ");
            buffer.append("(").append(header.getMaxX()).append(",").append(header.getMaxY()).append(")\n");
            buffer.append("Length: ").append(header.getLength() + " bytes").append("\n");
            buffer.append("FrameRate: ").append(header.getFrameRate() + " per second").append("\n");
            buffer.append("Number Of Frames: ").append(header.getNumberOfFrames()).append("\n");
            System.out.println(buffer.toString());
        }
        catch (Exception e) {
            System.err.println("Could not read file: " + args[0]);
        }
    }

    public SwfHeader(String filename) throws Exception {
        this.decodeFromFile(filename);
    }

    public SwfHeader(byte[] pData) throws IOException, DataFormatException {
        this.decodeFromData(pData, null);
    }

    public SwfHeader(byte[] pData, InputStream pStreamForMoreData) throws IOException, DataFormatException {
        this.decodeFromData(pData, pStreamForMoreData);
    }

    public int getLength() {
        return this.fLength;
    }

    public int getMinX() {
        return this.fMinX;
    }

    public int getMaxX() {
        return this.fMaxX;
    }

    public int getMinY() {
        return this.fMinY;
    }

    public int getMaxY() {
        return this.fMaxY;
    }

    public float getFrameRate() {
        return this.fFrameRate;
    }

    public float getNumberOfFrames() {
        return this.fFrameCount;
    }

    public void decodeFromData(byte[] pBytes, InputStream pStreamForMoreData) throws DataFormatException, IOException {
        FSCoder vCoder = null;
        if (!SwfHeader.isSwf(pBytes)) {
            throw new DataFormatException("Data does not start with a valid Flash (SWF) signature.");
        }
        vCoder = pBytes[0] == 67 ? new FSCoder(0, this.unzip(pBytes, pStreamForMoreData)) : new FSCoder(0, pBytes);
        this.fSignature = vCoder.readString(3, "UTF8");
        this.fVersion = vCoder.readWord(1, false);
        this.fLength = vCoder.readWord(4, false);
        vCoder.alignToByte();
        int vFieldSize = vCoder.readBits(5, false);
        this.fMinX = vCoder.readBits(vFieldSize, true);
        this.fMaxX = vCoder.readBits(vFieldSize, true);
        this.fMinY = vCoder.readBits(vFieldSize, true);
        this.fMaxY = vCoder.readBits(vFieldSize, true);
        vCoder.alignToByte();
        this.fFrameRate = vCoder.readFixedWord(1, 1);
        this.fFrameCount = vCoder.readWord(2, false);
    }

    protected static boolean isSwf(byte[] pBytes) throws DataFormatException {
        if (pBytes == null || pBytes.length < 8) {
            return false;
        }
        return (pBytes[0] == 67 || pBytes[0] == 70) && pBytes[1] == 87 && pBytes[2] == 83;
    }

    private byte[] unzip(byte[] pBytes, InputStream pStreamForMoreData) throws DataFormatException {
        int movieLength = 0;
        for (int i = 0; i < 4; ++i) {
            movieLength += (pBytes[i + 4] & 0xFF) << i * 8;
        }
        movieLength = Math.min(movieLength, 512);
        byte[] data = new byte[movieLength];
        for (int i = 0; i < 8; ++i) {
            data[i] = pBytes[i];
        }
        int vRead = 0;
        Inflater inflater = new Inflater();
        inflater.setInput(pBytes, 8, pBytes.length - 8);
        vRead = inflater.inflate(data, 8, movieLength - 8) + 8;
        if (pStreamForMoreData != null) {
            while (vRead < data.length && !inflater.finished()) {
                try {
                    int vBytesRead = pStreamForMoreData.read(pBytes);
                    inflater.setInput(pBytes, 0, vBytesRead);
                    vRead += inflater.inflate(data, vRead, movieLength - vRead);
                }
                catch (Exception e) {}
            }
        }
        inflater.end();
        return data;
    }

    public String toString() {
        StringBuffer vBuffer = new StringBuffer();
        vBuffer.append("Signature: ").append(this.getSignature()).append("\n");
        vBuffer.append("Version: ").append(this.getVersion()).append("\n");
        vBuffer.append("Frame: ");
        vBuffer.append("(").append(this.getMinX()).append(",").append(this.getMinY()).append(") ");
        vBuffer.append("(").append(this.getMaxX()).append(",").append(this.getMaxY()).append(")\n");
        vBuffer.append("Length: ").append(this.getLength() + " bytes").append("\n");
        vBuffer.append("FrameRate: ").append(this.getFrameRate() + " per second").append("\n");
        vBuffer.append("Number Of Frames: ").append(this.getNumberOfFrames()).append("\n");
        return vBuffer.toString();
    }
}

