/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.img;

import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.serializer.simple.XmlWriterAppendable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ExtraImgProps
extends DefaultHandler {
    public static final String IMGPROPS_TAG = "imgProps";
    public static final String CHARSIZE_STANDARD_ATT = "standardCharSize";
    public static final String CHARSIZE_LIMIT_ATT = "limitCharSize";
    public static final String ROTATEFORBIDDEN_ATT = "rotateForbidden";
    public static String sPropsImgFileName = "props.xml";
    protected float fStandardCharSize = -1.0f;
    protected float fLimitCharSize = -1.0f;
    protected boolean fRotateForbidden = true;
    protected boolean fRotateForbiddenDefined = false;

    public float getLimitCharSize() {
        return this.fLimitCharSize;
    }

    public float getStandardCharSize() {
        return this.fStandardCharSize;
    }

    public boolean isRotateForbidden() {
        return this.fRotateForbidden;
    }

    public boolean isRotateForbiddenDefined() {
        return this.fRotateForbiddenDefined;
    }

    public boolean isRotateForbidden(boolean pValueIfNotDefined) {
        return this.fRotateForbiddenDefined ? this.fRotateForbidden : pValueIfNotDefined;
    }

    public void setLimitCharSize(float pLimitCharSize) {
        this.fLimitCharSize = pLimitCharSize <= 0.0f ? -1.0f : pLimitCharSize;
    }

    public void setStandardCharSize(float pStandardCharSize) {
        if (pStandardCharSize <= 0.0f) {
            this.fLimitCharSize = -1.0f;
        } else {
            this.fStandardCharSize = pStandardCharSize;
        }
    }

    public void setRotateForbidden(boolean pRotateForbidden) {
        this.fRotateForbidden = pRotateForbidden;
    }

    public void setRotateForbiddenDefined(boolean pRotateForbiddenDefined) {
        this.fRotateForbiddenDefined = pRotateForbiddenDefined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXmlImgProps(InputStream pStream) throws Exception {
        this.fStandardCharSize = -1.0f;
        this.fLimitCharSize = -1.0f;
        XMLReader vParser = HPoolXmlReader.hGet().hGetXmlReader(false, false);
        try {
            vParser.setContentHandler(this);
            vParser.parse(new InputSource(pStream));
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vParser);
        }
    }

    public void writeXmlImgProps(OutputStream pStream) throws Exception {
        XmlWriterAppendable vWriter = new XmlWriterAppendable(new OutputStreamWriter(pStream, "UTF8"));
        vWriter.writeHeaderXml("UTF-8");
        vWriter.writeStartTag(IMGPROPS_TAG);
        vWriter.writeAttribute(CHARSIZE_STANDARD_ATT, Float.toString(this.fStandardCharSize));
        vWriter.writeAttribute(CHARSIZE_LIMIT_ATT, Float.toString(this.fLimitCharSize));
        vWriter.writeAttribute(ROTATEFORBIDDEN_ATT, Boolean.toString(this.fRotateForbidden));
        vWriter.writeEndEmptyTag();
        vWriter.close();
    }

    public void startElement(String pUri, String pLocalName, String pName, Attributes pAttributes) throws SAXException {
        if (pName == IMGPROPS_TAG) {
            String vVal = pAttributes.getValue(CHARSIZE_STANDARD_ATT);
            if (vVal != null && vVal.length() > 0) {
                this.setStandardCharSize(Float.parseFloat(vVal));
            }
            if ((vVal = pAttributes.getValue(CHARSIZE_LIMIT_ATT)) != null && vVal.length() > 0) {
                this.setLimitCharSize(Float.parseFloat(vVal));
            }
            boolean bl = this.fRotateForbiddenDefined = (vVal = pAttributes.getValue(ROTATEFORBIDDEN_ATT)) != null;
            if (vVal != null) {
                this.setRotateForbidden(Boolean.parseBoolean(vVal));
            }
        }
    }
}

