/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.img;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.co.transform.img.IImgSrc;
import com.scenari.s.co.transform.img.ImageMagick;
import com.scenari.s.co.transform.img.ImgSrcBase;
import com.scenari.src.fs.mini.FsMiniFactory;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.transform.util.ProcessPipeStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTransformerImageMagick
extends HTransformer {
    public static final String PARAM_COMMAND = "command";
    public static final String COMMAND_SRC = "$src";
    public static final String COMMAND_DST = "$dst";
    public static final String COMMAND_TMP = "$tmp";
    public static final String PARAM_OUTPUT_TYPE = "outType";
    public static final String OUTTYPE_PNG = "PNG";
    public static final String OUTTYPE_GIF = "GIF";
    public static final String OUTTYPE_JPEG = "JPEG";

    @Override
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        HashMap<String, File> vMap = new HashMap<String, File>();
        String[] vArgs = null;
        try {
            String vOutType = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
            if (vOutType == null || vOutType.length() == 0) {
                vOutType = OUTTYPE_JPEG;
            }
            String vArgDestFile = vOutType + ':' + ((File)pRes).getCanonicalPath();
            String vCommand = pParams.hGetValueParam(PARAM_COMMAND);
            StringTokenizer vTok = new StringTokenizer(vCommand, "\"' ", true);
            while (vTok.hasMoreTokens()) {
                vArgs = this.xParseCommand(vCommand, pSrc, vArgDestFile, vTok, vMap);
                Process vProcess = Runtime.getRuntime().exec(vArgs, null, null);
                Future<StringBuilder> vPipeErr = ProcessPipeStream.pipeStream(vProcess.getErrorStream(), new StringBuilder());
                vProcess.waitFor();
                StringBuilder vErr = vPipeErr.get();
                if (vProcess.exitValue() == 0 && vErr.length() <= 0) continue;
                throw LogMgr.newException("ImageMagick process failed : " + vProcess.exitValue() + "\n" + vErr, new String[0]);
            }
        }
        catch (Exception e) {
            if (vArgs != null) {
                StringBuilder vDebug = new StringBuilder(256);
                vDebug.append("ImageMagick transform failed ");
                vDebug.append(pParams);
                vDebug.append("\nCommand : \n");
                for (int i = 0; i < vArgs.length; ++i) {
                    vDebug.append((String)vArgs[i]);
                    vDebug.append('\n');
                }
                throw (Exception)LogMgr.addMessage((Throwable)e, vDebug.toString(), new String[0]);
            }
            throw (Exception)LogMgr.addMessage((Throwable)e, "ImageMagick transform failed " + pParams, new String[0]);
        }
        finally {
            Iterator vIt = vMap.values().iterator();
            while (vIt.hasNext()) {
                try {
                    ((File)vIt.next()).delete();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ImgSrcBase.isSrcAllowed(pClassSrc, pParams);
    }

    @Override
    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes);
    }

    @Override
    public String hGetMimeType(HTransformParams pParams) throws Exception {
        String vFormat = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
        if (vFormat == null || vFormat.length() == 0) {
            vFormat = OUTTYPE_JPEG;
        }
        if (vFormat.equals(OUTTYPE_JPEG)) {
            return "image/jpeg";
        }
        if (vFormat.equals(OUTTYPE_PNG)) {
            return "image/png";
        }
        if (vFormat.equals(OUTTYPE_GIF)) {
            return "image/gif";
        }
        return "image";
    }

    @Override
    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        String vType = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
        if (vType == null || vType.length() == 0) {
            vType = OUTTYPE_JPEG;
        }
        if (vType.equals(OUTTYPE_JPEG)) {
            return ".jpg";
        }
        if (vType.equals(OUTTYPE_PNG)) {
            return ".png";
        }
        if (vType.equals(OUTTYPE_GIF)) {
            return ".gif";
        }
        return "";
    }

    public String[] xParseCommand(String pCommand, Object pSrc, String pPathDest, StringTokenizer pTok, Map<String, File> pTmpFiles) throws Exception {
        boolean ST_NORMAL = false;
        boolean ST_INQUOTE = true;
        int ST_INDBLQUOTE = 2;
        int vStatus = 0;
        ArrayList<String> vListArgs = new ArrayList<String>();
        StringBuilder vBuf = new StringBuilder();
        boolean vLastTokenHasBeenQuoted = false;
        block4: while (pTok.hasMoreTokens()) {
            String vNextTok = pTok.nextToken();
            switch (vStatus) {
                case 1: {
                    if ("'".equals(vNextTok)) {
                        vLastTokenHasBeenQuoted = true;
                        vStatus = 0;
                        continue block4;
                    }
                    vBuf.append(vNextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(vNextTok)) {
                        vLastTokenHasBeenQuoted = true;
                        vStatus = 0;
                        continue block4;
                    }
                    vBuf.append(vNextTok);
                    continue block4;
                }
            }
            if (vNextTok.length() == 1) {
                char vChar = vNextTok.charAt(0);
                if (vChar == '\'') {
                    vStatus = 1;
                } else if (vChar == '\"') {
                    vStatus = 2;
                } else if (vChar == ' ') {
                    if (vLastTokenHasBeenQuoted || vBuf.length() != 0) {
                        vListArgs.add(vBuf.toString());
                        vBuf.setLength(0);
                    }
                } else {
                    if (vChar == '|') break;
                    vBuf.append(vChar);
                }
            } else {
                vBuf.append(vNextTok);
            }
            vLastTokenHasBeenQuoted = false;
        }
        if (vLastTokenHasBeenQuoted || vBuf.length() != 0) {
            vListArgs.add(vBuf.toString());
        }
        if (vStatus == 1 || vStatus == 2) {
            throw new Exception("Unbalanced quotes in " + pCommand);
        }
        String[] vResult = vListArgs.toArray(new String[vListArgs.size()]);
        vResult[0] = ImageMagick.getCommand(vResult[0]);
        for (int i = 1; i < vResult.length; ++i) {
            if (vResult[i].equals(COMMAND_SRC)) {
                vResult[i] = this.xGetPathSrc(pSrc, pTmpFiles);
                continue;
            }
            if (vResult[i].equals(COMMAND_DST)) {
                vResult[i] = pPathDest;
                continue;
            }
            if (!vResult[i].startsWith(COMMAND_TMP)) continue;
            File vTmp = pTmpFiles.get(vResult[i]);
            if (vTmp != null) {
                vResult[i] = vTmp.getAbsolutePath();
                continue;
            }
            vTmp = File.createTempFile("imagick", ".miff");
            pTmpFiles.put(vResult[i], vTmp);
            vResult[i] = vTmp.getAbsolutePath();
        }
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String xGetPathSrc(Object pSrc, Map<String, File> pTmpFiles) throws Exception {
        File vSrcFile = pTmpFiles.get(COMMAND_SRC);
        if (vSrcFile != null) {
            return vSrcFile.getAbsolutePath();
        }
        IImgSrc vSrc = ImgSrcBase.createImgSrc(pSrc);
        try {
            vSrcFile = vSrc.getFile();
            if (vSrcFile == null) {
                vSrcFile = File.createTempFile("imagickSrc", "");
                pTmpFiles.put(COMMAND_SRC, vSrcFile);
                InputStream vSrcStream = vSrc.getInputStream();
                try {
                    FileOutputStream vOut = new FileOutputStream(vSrcFile);
                    try {
                        StreamUtils.write(vSrcStream, vOut);
                    }
                    finally {
                        ((OutputStream)vOut).close();
                    }
                }
                finally {
                    vSrcStream.close();
                }
            }
            String string = vSrcFile.getAbsolutePath();
            return string;
        }
        finally {
            vSrc.close();
        }
    }

    public static void main(String[] pArgs) {
        try {
            LogMgr.subscribeAsString(System.out, false);
            HTransformerImageMagick vTrsf = new HTransformerImageMagick();
            System.out.println("CurrentPath : " + new File(".").getCanonicalPath());
            ImageMagick.setImBinFolderPath("../Lib_Java/imagemagick/WINNT_x86/im");
            String vPar = "transform=imageMagick&outType=PNG";
            HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString(vPar, "UTF-8");
            vParams.hPut(PARAM_COMMAND, "convert $src -fill '#0008' -draw 'rectangle 5,5,114,145' -fill white -annotate +10+20 'Faerie Dragon' $dst");
            vTrsf.hTransform(FsMiniFactory.newNodeFromPath("C:\\splash.png", true), new File("C:\\testResult.png"), vParams);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
    }
}

