/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.img;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.co.transform.img.IImgSrc;
import com.scenari.s.co.transform.img.ImageMagick;
import com.scenari.s.co.transform.img.ImgSrcBase;
import com.scenari.s.co.transform.img.ImgUtil;
import com.scenari.src.fs.mini.FsMiniFactory;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.transform.util.ProcessPipeStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.Future;

public class HTransformerScale
extends HTransformer {
    public static final String PARAM_OUTPUT_TYPE = "outType";
    public static final String OUTTYPE_PNG = "PNG";
    public static final String OUTTYPE_GIF = "GIF";
    public static final String OUTTYPE_JPEG = "JPEG";
    public static final String OUTTYPE_DIMS = "DIMS";
    public static final String PARAM_SIZERULES = "sizeRules";
    public static final String PARAM_OUTPUT_RULES = "outRules";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        block17: {
            IImgSrc vSrc = ImgSrcBase.createImgSrc(pSrc);
            try {
                String vRules = pParams.hGetValueParam(PARAM_SIZERULES);
                ImgUtil.ResultSize vNewSize = ImgUtil.getSizeFromRules(vSrc, vRules);
                String vOutType = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
                if (vOutType == null || vOutType.length() == 0) {
                    vOutType = OUTTYPE_JPEG;
                }
                if (vOutType.equals(OUTTYPE_DIMS)) {
                    this.xPropsTransform(vSrc, vNewSize, pRes, pParams);
                    break block17;
                }
                File vSrcFile = vSrc.getFile();
                if (vSrcFile == null) {
                    vSrcFile = File.createTempFile("convert", "");
                    try {
                        InputStream vSrcStream = vSrc.getInputStream();
                        try {
                            FileOutputStream vOut = new FileOutputStream(vSrcFile);
                            try {
                                StreamUtils.write(vSrcStream, vOut);
                            }
                            finally {
                                ((OutputStream)vOut).close();
                            }
                        }
                        finally {
                            vSrcStream.close();
                        }
                        this.xConvertTransform(vSrcFile, vNewSize, pRes, vOutType, pParams);
                        break block17;
                    }
                    finally {
                        vSrcFile.delete();
                    }
                }
                this.xConvertTransform(vSrcFile, vNewSize, pRes, vOutType, pParams);
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation d'echelle d'une ressource image.", new String[0]);
            }
            finally {
                vSrc.close();
            }
        }
    }

    protected void xPropsTransform(IImgSrc pSrc, ImgUtil.ResultSize pNewSize, Object pRes, HTransformParams pParams) throws Exception {
        String vRules = pParams.hGetValueParam(PARAM_OUTPUT_RULES);
        ImgUtil.getPropsFromRules(pSrc, pNewSize, vRules, pRes);
    }

    protected void xConvertTransform(File pSrcFile, ImgUtil.ResultSize pNewSize, Object pRes, String pOutputType, HTransformParams pParams) throws Exception {
        File vResFile = (File)pRes;
        ArrayList<String> vCmds = new ArrayList<String>(8);
        vCmds.add(ImageMagick.getCommand("convert"));
        vCmds.add(pSrcFile.getCanonicalPath());
        if (pNewSize.getScale() > 0.0f && (double)pNewSize.getScale() != 1.0) {
            vCmds.add("-scale");
            vCmds.add(Math.round(pNewSize.getWidth()) + "x" + Math.round(pNewSize.getHeight()) + "!");
        }
        if (pNewSize.isWithRotate()) {
            vCmds.add("-rotate");
            vCmds.add("-90");
        }
        vCmds.add(pOutputType + ":" + vResFile.getCanonicalPath());
        try {
            String[] vCommands = vCmds.toArray(new String[vCmds.size()]);
            Process vProcess = Runtime.getRuntime().exec(vCommands, null, null);
            Future<StringBuilder> vPipeErr = ProcessPipeStream.pipeStream(vProcess.getErrorStream(), new StringBuilder());
            vProcess.waitFor();
            StringBuilder vErr = vPipeErr.get();
            if (vProcess.exitValue() != 0 || vErr.length() > 0) {
                throw LogMgr.newException("ImageMagick process failed : " + vProcess.exitValue() + "\n" + vErr, new String[0]);
            }
        }
        catch (IOException e) {
            LogMgr.publishException((Throwable)e, "ImageMagick not found.", ILogMsg.LogType.Warning, new String[0]);
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "ImageMagick convert failed.", ILogMsg.LogType.Warning, new String[0]);
        }
    }

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ImgSrcBase.isSrcAllowed(pClassSrc, pParams);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes);
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        String vFormat = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
        if (vFormat == null || vFormat.length() == 0) {
            vFormat = OUTTYPE_JPEG;
        }
        if (vFormat.equals(OUTTYPE_JPEG)) {
            return "image/jpeg";
        }
        if (vFormat.equals(OUTTYPE_PNG)) {
            return "image/png";
        }
        if (vFormat.equals(OUTTYPE_GIF)) {
            return "image/gif";
        }
        if (vFormat.equals(OUTTYPE_DIMS)) {
            return "text/plain";
        }
        return "image";
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        String vFormat = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
        if (vFormat == null || vFormat.length() == 0) {
            vFormat = OUTTYPE_JPEG;
        }
        if (vFormat.equals(OUTTYPE_JPEG)) {
            return ".jpg";
        }
        if (vFormat.equals(OUTTYPE_PNG)) {
            return ".png";
        }
        if (vFormat.equals(OUTTYPE_GIF)) {
            return ".gif";
        }
        if (vFormat.equals(OUTTYPE_DIMS)) {
            return ".txt";
        }
        return "";
    }

    public static void main(String[] pArgs) {
        try {
            LogMgr.subscribeAsString(System.out, false);
            HTransformerScale vTrsf = new HTransformerScale();
            ImageMagick.setImBinFolderPath("../Lib_Java/imagemagick/WINNT_x86/im");
            String vPar = "transform=imgScale&outType=DIMS&sizeRules=Dim(minDpi'96' maxDpi'96' ScSCS(fontPt'10') Bounds(unit'mm' maxW'10' Rotate() ))&outRules=Str(pattern'wpx:$wpx, wmm:$wmm, hpx:$hpx, dpi:$dpi, rot:$rot(yes,no), scs:$scs, lcs:$lcs')";
            HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString(vPar, "UTF-8");
            vTrsf.hTransform(FsMiniFactory.newNodeFromPath("C:\\splash.png", true), new File("C:\\testResult.txt"), vParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

