/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.img;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.img.IImgSrc;
import com.scenari.s.co.transform.img.ImgSrcFromSource;
import com.scenari.s.co.transform.img.ImgSrcFromStream;
import com.scenari.src.ISrcNode;
import com.scenari.src.fs.mini.FsMiniFactory;
import eu.scenari.fw.log.LogMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ImgSrcBase
implements IImgSrc {
    protected File fFile = null;
    protected InputStream fInput = null;
    protected boolean fRotateForbidden = false;
    protected boolean fRotateForbiddenDefined = false;
    protected int fFormat = -1;
    protected float fHeight = -1.0f;
    protected float fWidth = -1.0f;
    protected int fHeightDpi = -1;
    protected int fWidthDpi = -1;
    protected long fWeight = -1L;
    protected float fStandardCharSize = -1.0f;
    protected float fLimitCharSize = -1.0f;

    public static IImgSrc createImgSrc(Object pSrc) throws Exception {
        IImgSrc vSrc = pSrc instanceof ISrcNode ? new ImgSrcFromSource((ISrcNode)pSrc) : (pSrc instanceof File ? (((File)pSrc).isDirectory() ? new ImgSrcFromSource(FsMiniFactory.newNodeFromCanonicalFile((File)pSrc, true)) : new ImgSrcFromStream((File)pSrc, null, -1)) : (pSrc instanceof InputStream ? new ImgSrcFromStream(null, (InputStream)pSrc, -1) : (IImgSrc)pSrc));
        return vSrc;
    }

    public static boolean isSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ISrcNode.class.isAssignableFrom(pClassSrc) || File.class.isAssignableFrom(pClassSrc) || InputStream.class.isAssignableFrom(pClassSrc) || IImgSrc.class.isAssignableFrom(pClassSrc);
    }

    public ImgSrcBase() {
    }

    public ImgSrcBase(File pFile, InputStream pInput, int pFormat, int pHeight, int pWidth, int pHeightDpi, int pWidthDpi, int pWeight, float pStandardCharSize, float pLimitCharSize) {
        this.fInput = pInput;
        this.fFile = pFile;
        this.fFormat = pFormat;
        this.fHeight = pHeight;
        this.fWidth = pWidth;
        this.fHeightDpi = pHeightDpi;
        this.fWidthDpi = pWidthDpi;
        this.fWeight = pWeight;
        this.fStandardCharSize = pStandardCharSize;
        this.fLimitCharSize = pLimitCharSize;
    }

    public float getHeight() throws Exception {
        return this.fHeight;
    }

    public int getHeightDpi() throws Exception {
        return this.fHeightDpi;
    }

    public InputStream getInputStream() throws Exception {
        if (this.fInput == null && this.fFile != null) {
            this.fInput = new FileInputStream(this.fFile);
        }
        return this.fInput;
    }

    public void close() {
        if (this.fInput != null) {
            try {
                this.fInput.close();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            this.fInput = null;
        }
        this.fFile = null;
    }

    public File getFile() throws Exception {
        return this.fFile;
    }

    public float getLimitCharSize() throws Exception {
        return this.fLimitCharSize;
    }

    public float getStandardCharSize() throws Exception {
        return this.fStandardCharSize;
    }

    public long getWeight() throws Exception {
        return this.fWeight;
    }

    public float getWidth() throws Exception {
        return this.fWidth;
    }

    public int getWidthDpi() throws Exception {
        return this.fWidthDpi;
    }

    public int getFormat() throws Exception {
        return this.fFormat;
    }

    public boolean isRotateForbidden(boolean pValueIfNotDefined) throws Exception {
        return this.fRotateForbiddenDefined ? this.fRotateForbidden : pValueIfNotDefined;
    }

    public void setFormat(int pFormat) {
        this.fFormat = pFormat;
    }

    public void setHeight(float pHeight) {
        this.fHeight = pHeight;
    }

    public void setHeightDpi(int pHeightDpi) {
        this.fHeightDpi = pHeightDpi;
    }

    public void setLimitCharSize(float pLimitCharSize) {
        this.fLimitCharSize = pLimitCharSize;
    }

    public void setRotateForbidden(boolean pRotateForbidden) {
        this.fRotateForbidden = pRotateForbidden;
    }

    public void setStandardCharSize(float pStandardCharSize) {
        this.fStandardCharSize = pStandardCharSize;
    }

    public void setWeight(long pWeight) {
        this.fWeight = pWeight;
    }

    public void setWidth(float pWidth) {
        this.fWidth = pWidth;
    }

    public void setWidthDpi(int pWidthDpi) {
        this.fWidthDpi = pWidthDpi;
    }
}

