/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.img;

import com.scenari.s.co.transform.img.ImageInfo;
import com.scenari.s.co.transform.img.ImgSrcBase;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.stream.bytes.FullBufferedInputStream;
import eu.scenari.fw.stream.bytes.OutputStreamCounter;
import java.io.File;
import java.io.InputStream;
import java.io.SequenceInputStream;

public class ImgSrcFromStream
extends ImgSrcBase {
    protected FullBufferedInputStream fInputMem = null;

    public ImgSrcFromStream() {
    }

    public ImgSrcFromStream(File pFile, InputStream pInput, int pWeight) {
        this.fInput = pInput;
        this.fFile = pFile;
        this.fWeight = pWeight;
    }

    public ImgSrcFromStream(File pFile, InputStream pInput, int pWeight, float pStandardCharSize, float pLimitCharSize, boolean pRotateForbidden) {
        this.fFile = pFile;
        this.fInput = pInput;
        this.fWeight = pWeight;
        this.fStandardCharSize = pStandardCharSize;
        this.fLimitCharSize = pLimitCharSize;
        this.fRotateForbidden = pRotateForbidden;
    }

    public float getHeight() throws Exception {
        if (this.fHeight == -1.0f) {
            this.xSearchProps();
        }
        return this.fHeight;
    }

    public int getHeightDpi() throws Exception {
        if (this.fHeightDpi == -1) {
            this.xSearchProps();
        }
        return this.fHeightDpi;
    }

    public InputStream getInputStream() throws Exception {
        if (this.fInputMem != null) {
            InputStream vEndStream = this.fInputMem.disconnectSubInputStream();
            if (vEndStream != null) {
                return new SequenceInputStream(this.fInputMem, vEndStream);
            }
            return this.fInputMem;
        }
        return super.getInputStream();
    }

    public void close() {
        super.close();
        if (this.fInputMem != null) {
            this.fInputMem.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWeight() throws Exception {
        if (this.fWeight == -1L) {
            if (this.fFile != null) {
                this.fWeight = this.fFile.length();
            } else {
                this.xSearchProps();
                OutputStreamCounter vCounter = new OutputStreamCounter();
                try {
                    StreamUtils.write(this.fInputMem, vCounter);
                }
                finally {
                    this.fInputMem.rewind();
                }
                this.fWeight = vCounter.getLength();
            }
        }
        return this.fWeight;
    }

    public float getWidth() throws Exception {
        if (this.fWidth == -1.0f) {
            this.xSearchProps();
        }
        return this.fWidth;
    }

    public int getWidthDpi() throws Exception {
        if (this.fWidthDpi == -1) {
            this.xSearchProps();
        }
        return this.fWidthDpi;
    }

    public int getFormat() throws Exception {
        if (this.fFormat == -1) {
            this.xSearchProps();
        }
        return this.fFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xSearchProps() throws Exception {
        if (this.fInputMem == null) {
            this.fInputMem = new FullBufferedInputStream(super.getInputStream());
            try {
                ImageInfo vImgInfo = new ImageInfo();
                vImgInfo.setCollectComments(false);
                vImgInfo.setInput(this.fInputMem);
                vImgInfo.check();
                this.fFormat = vImgInfo.getFormat();
                this.fWidth = vImgInfo.getWidth();
                this.fHeight = vImgInfo.getHeight();
                this.fWidthDpi = vImgInfo.getPhysicalWidthDpi();
                this.fHeightDpi = vImgInfo.getPhysicalHeightDpi();
            }
            finally {
                this.fInputMem.rewind();
            }
        }
    }
}

