/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.img;

import com.scenari.s.co.transform.img.IImgSrc;
import com.scenari.s.fw.utils.HCharSeqUtil;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.syntax.cdm.CdmParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ImgUtil {
    public static final float CHAR_INCH_PER_PX = 0.01043f;
    public static final float DEFAULT_DPI = 72.0f;

    private ImgUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSize getSizeFromRules(IImgSrc pSrc, String pRules) throws Exception {
        ResultSize vResult = new ResultSize(pSrc.getWidth(), pSrc.getHeight(), 1.0f, false, pSrc.getWidthDpi());
        if (pRules != null && pRules.length() > 0) {
            CdmParser vCdmParser = CdmParser.getPooledParser();
            try {
                vCdmParser.setSource(pRules);
                if (vCdmParser.gotoFirstChildData() == 4) {
                    if (vCdmParser.currNameEquals("Px")) {
                        ImgUtil.computePxRules(pSrc, vCdmParser, vResult);
                    } else if (HCharSeqUtil.equals(vCdmParser.getCurrName(), "Dim")) {
                        ImgUtil.computeDimRules(pSrc, vCdmParser, vResult);
                    }
                }
            }
            finally {
                CdmParser.freePooledParser(vCdmParser);
            }
        }
        return vResult;
    }

    protected static void computePxRules(IImgSrc pSrc, CdmParser pCdmParser, ResultSize pResult) throws Exception {
        float originalScale = 1.0f;
        float vNewScale = 1.0f;
        while ((pCdmParser.gotoNextData() & 0x54) != 0) {
            float vIfDiff;
            float vFontPt;
            if (pCdmParser.currNameEquals("ScSCS")) {
                float vSCS = pSrc.getStandardCharSize();
                if (vSCS != -1.0f) {
                    vFontPt = 10.0f;
                    vIfDiff = 0.0f;
                    while ((pCdmParser.gotoNextData() & 0x54) != 0) {
                        if (pCdmParser.getCurrStatus() == 16) {
                            if (pCdmParser.currNameEquals("fontPt")) {
                                vFontPt = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                continue;
                            }
                            if (!pCdmParser.currNameEquals("ifDiff")) continue;
                            vIfDiff = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        pCdmParser.gotoEnd();
                    }
                    vNewScale = vFontPt / vSCS;
                    if (!(vIfDiff > 0.0f) || !(Math.abs(1.0f - vNewScale) < vIfDiff)) break;
                    vNewScale = 1.0f;
                    break;
                }
                pCdmParser.gotoEnd();
                continue;
            }
            if (pCdmParser.currNameEquals("ScLCS")) {
                float vLCS = pSrc.getLimitCharSize();
                if (vLCS != -1.0f) {
                    float vSCS;
                    vFontPt = 10.0f;
                    float vDistToSCS = 0.0f;
                    float vIfDiff2 = 0.0f;
                    while (pCdmParser.gotoNextData() != 8) {
                        if (pCdmParser.getCurrStatus() == 16) {
                            if (pCdmParser.currNameEquals("fontPt")) {
                                vFontPt = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                continue;
                            }
                            if (pCdmParser.currNameEquals("distToSCS")) {
                                vDistToSCS = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                continue;
                            }
                            if (!pCdmParser.currNameEquals("ifDiff")) continue;
                            vIfDiff2 = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        pCdmParser.gotoEnd();
                    }
                    if (vDistToSCS != 0.0f && (vSCS = pSrc.getStandardCharSize()) != -1.0f) {
                        vLCS += (vSCS - vLCS) * vDistToSCS;
                    }
                    vNewScale = vFontPt / vLCS;
                    if (!(vIfDiff2 > 0.0f) || !(Math.abs(1.0f - vNewScale) < vIfDiff2)) break;
                    vNewScale = 1.0f;
                    break;
                }
                pCdmParser.gotoEnd();
                continue;
            }
            if (pCdmParser.currNameEquals("ScDpi")) {
                float vSrcDpi = pSrc.getWidthDpi();
                if (vSrcDpi != -1.0f && vSrcDpi > 0.0f) {
                    float vTargetDpi = 0.0f;
                    vIfDiff = 0.0f;
                    while (pCdmParser.gotoNextData() != 8) {
                        if (pCdmParser.getCurrStatus() == 16) {
                            if (pCdmParser.currNameEquals("targetDpi")) {
                                vTargetDpi = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                continue;
                            }
                            if (!pCdmParser.currNameEquals("ifDiff")) continue;
                            vIfDiff = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        pCdmParser.gotoEnd();
                    }
                    if (!(vTargetDpi > 0.0f)) break;
                    vNewScale = vTargetDpi / vSrcDpi;
                    if (!(vIfDiff > 0.0f) || !(Math.abs(1.0f - vNewScale) < vIfDiff)) break;
                    vNewScale = 1.0f;
                    break;
                }
                pCdmParser.gotoEnd();
                continue;
            }
            if (pCdmParser.currNameEquals("Sc")) {
                float vRatio = 1.0f;
                while (pCdmParser.gotoNextData() != 8) {
                    if (pCdmParser.getCurrStatus() == 16) {
                        if (!pCdmParser.currNameEquals("ratio")) continue;
                        vRatio = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                        continue;
                    }
                    pCdmParser.gotoEnd();
                }
                vNewScale = vRatio;
                break;
            }
            pCdmParser.rewindBeforeCurrentData();
            break;
        }
        pResult.fScale = vNewScale;
        pResult.fWidth = pSrc.getWidth() * vNewScale;
        pResult.fHeight = pSrc.getHeight() * vNewScale;
        while ((pCdmParser.gotoNextData() & 0x54) != 0) {
            if (pCdmParser.currNameEquals("Bounds")) {
                float vLCS;
                float vMinH = 0.0f;
                float vMaxH = Float.MAX_VALUE;
                float vMinW = 0.0f;
                float vMaxW = Float.MAX_VALUE;
                boolean vRotate = false;
                float vRotateIfDiff = 0.1f;
                float vRotateIfLessLCS = 0.0f;
                while (pCdmParser.gotoNextData() != 8) {
                    if (pCdmParser.getCurrStatus() == 16) {
                        if (pCdmParser.currNameEquals("minH")) {
                            vMinH = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        if (pCdmParser.currNameEquals("maxH")) {
                            vMaxH = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        if (pCdmParser.currNameEquals("minW")) {
                            vMinW = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        if (!pCdmParser.currNameEquals("maxW")) continue;
                        vMaxW = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                        continue;
                    }
                    if (pCdmParser.currNameEquals("Rotate")) {
                        boolean vIfExplicitlyAllowed = false;
                        while (pCdmParser.gotoNextData() != 8) {
                            if (pCdmParser.getCurrStatus() == 16) {
                                if (pCdmParser.currNameEquals("ifDiff")) {
                                    vRotateIfDiff = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                    continue;
                                }
                                if (pCdmParser.currNameEquals("ifLessLCS")) {
                                    vRotateIfLessLCS = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                    continue;
                                }
                                if (!pCdmParser.currNameEquals("ifExplicitlyAllowed")) continue;
                                vIfExplicitlyAllowed = Boolean.parseBoolean(((Object)pCdmParser.getCurrValue()).toString());
                                continue;
                            }
                            pCdmParser.gotoEnd();
                        }
                        vRotate = !pSrc.isRotateForbidden(vIfExplicitlyAllowed);
                        continue;
                    }
                    pCdmParser.gotoEnd();
                }
                if (vRotate && vRotateIfLessLCS > 0.0f && (vLCS = pSrc.getLimitCharSize()) != -1.0f && pResult.fScale >= vRotateIfLessLCS / vLCS) {
                    vRotate = false;
                }
                ResultSize vNewSize = ImgUtil.getSize(pResult.fWidth, pResult.fHeight, 1.0f, vMinW, vMinH, vMaxW, vMaxH, vRotate, vRotateIfDiff);
                pResult.fScale = vNewSize.fWidth / pSrc.getWidth();
                pResult.fWidth = vNewSize.fWidth;
                pResult.fHeight = vNewSize.fHeight;
                continue;
            }
            if (pCdmParser.getCurrStatus() != 4) continue;
            pCdmParser.gotoEnd();
        }
    }

    protected static void computeDimRules(IImgSrc pSrc, CdmParser pCdmParser, ResultSize pResult) throws Exception {
        int vMinDpi = 0;
        int vMaxDpi = Integer.MAX_VALUE;
        float vWidthInch = -1.0f;
        while ((pCdmParser.gotoNextData() & 0x54) != 0) {
            float vFontPt;
            if (pCdmParser.currNameEquals("minDpi")) {
                vMinDpi = Math.max(0, Integer.parseInt(((Object)pCdmParser.getCurrValue()).toString()));
                continue;
            }
            if (pCdmParser.currNameEquals("maxDpi")) {
                vMaxDpi = Math.max(0, Integer.parseInt(((Object)pCdmParser.getCurrValue()).toString()));
                continue;
            }
            if (pCdmParser.currNameEquals("ScSCS")) {
                float vSCS = pSrc.getStandardCharSize();
                if (vSCS != -1.0f) {
                    vFontPt = 10.0f;
                    while ((pCdmParser.gotoNextData() & 0x54) != 0) {
                        if (pCdmParser.getCurrStatus() == 16) {
                            if (!pCdmParser.currNameEquals("fontPt")) continue;
                            vFontPt = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        pCdmParser.gotoEnd();
                    }
                    vWidthInch = pSrc.getWidth() * vFontPt / vSCS * 0.01043f;
                    break;
                }
                pCdmParser.gotoEnd();
                continue;
            }
            if (pCdmParser.currNameEquals("ScLCS")) {
                float vLCS = pSrc.getLimitCharSize();
                if (vLCS != -1.0f) {
                    float vSCS;
                    vFontPt = 10.0f;
                    float vDistToSCS = 0.0f;
                    while (pCdmParser.gotoNextData() != 8) {
                        if (pCdmParser.getCurrStatus() == 16) {
                            if (pCdmParser.currNameEquals("fontPt")) {
                                vFontPt = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                continue;
                            }
                            if (!pCdmParser.currNameEquals("distToSCS")) continue;
                            vDistToSCS = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        pCdmParser.gotoEnd();
                    }
                    if (vDistToSCS != 0.0f && (vSCS = pSrc.getStandardCharSize()) != -1.0f) {
                        vLCS += (vSCS - vLCS) * vDistToSCS;
                    }
                    vWidthInch = pSrc.getWidth() * vFontPt / vLCS * 0.01043f;
                    break;
                }
                pCdmParser.gotoEnd();
                continue;
            }
            if (pCdmParser.currNameEquals("Sc")) {
                float vRatio = 1.0f;
                float vSrcDpi = -1.0f;
                float vSrcDefDpi = 72.0f;
                while (pCdmParser.gotoNextData() != 8) {
                    if (pCdmParser.getCurrStatus() == 16) {
                        if (pCdmParser.currNameEquals("ratio")) {
                            vRatio = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        if (pCdmParser.currNameEquals("srcDpi")) {
                            vSrcDpi = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        if (!pCdmParser.currNameEquals("srcDefDpi")) continue;
                        vSrcDefDpi = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                        continue;
                    }
                    pCdmParser.gotoEnd();
                }
                if (vSrcDpi == -1.0f && (vSrcDpi = (float)pSrc.getWidthDpi()) == -1.0f) {
                    vSrcDpi = vSrcDefDpi;
                }
                vWidthInch = pSrc.getWidth() / vSrcDpi * vRatio;
                break;
            }
            pCdmParser.rewindBeforeCurrentData();
            break;
        }
        if (vWidthInch == -1.0f) {
            float vSrcDpi = pSrc.getWidthDpi();
            if (vSrcDpi == -1.0f) {
                vSrcDpi = 72.0f;
            }
            vWidthInch = pSrc.getWidth() / vSrcDpi;
        }
        pResult.fScale = 1.0f;
        pResult.fWidth = pSrc.getWidth();
        pResult.fHeight = pSrc.getHeight();
        pResult.fDpi = pResult.fWidth / vWidthInch;
        while ((pCdmParser.gotoNextData() & 0x54) != 0) {
            if (pCdmParser.currNameEquals("Bounds")) {
                float vLimitWidthInch;
                float vCurrWidthInch;
                float vLCS;
                DistUnit vUnit = null;
                float vMinH = 0.0f;
                float vMaxH = Float.MAX_VALUE;
                float vMinW = 0.0f;
                float vMaxW = Float.MAX_VALUE;
                boolean vRotate = false;
                float vRotateIfDiff = 0.1f;
                float vRotateIfLessLCS = 0.0f;
                while (pCdmParser.gotoNextData() != 8) {
                    if (pCdmParser.getCurrStatus() == 16) {
                        if (pCdmParser.currNameEquals("unit")) {
                            try {
                                vUnit = DistUnit.valueOf(((Object)pCdmParser.getCurrValue()).toString());
                            }
                            catch (IllegalArgumentException e) {
                                LogMgr.publishException((Throwable)e, "unit unknown", ILogMsg.LogType.Warning, new String[0]);
                            }
                            continue;
                        }
                        if (pCdmParser.currNameEquals("minH")) {
                            vMinH = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        if (pCdmParser.currNameEquals("maxH")) {
                            vMaxH = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        if (pCdmParser.currNameEquals("minW")) {
                            vMinW = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                            continue;
                        }
                        if (!pCdmParser.currNameEquals("maxW")) continue;
                        vMaxW = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                        continue;
                    }
                    if (pCdmParser.currNameEquals("Rotate")) {
                        boolean vIfExplicitlyAllowed = false;
                        while (pCdmParser.gotoNextData() != 8) {
                            if (pCdmParser.getCurrStatus() == 16) {
                                if (pCdmParser.currNameEquals("ifDiff")) {
                                    vRotateIfDiff = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                    continue;
                                }
                                if (pCdmParser.currNameEquals("ifLessLCS")) {
                                    vRotateIfLessLCS = Float.parseFloat(((Object)pCdmParser.getCurrValue()).toString());
                                    continue;
                                }
                                if (!pCdmParser.currNameEquals("ifExplicitlyAllowed")) continue;
                                vIfExplicitlyAllowed = Boolean.parseBoolean(((Object)pCdmParser.getCurrValue()).toString());
                                continue;
                            }
                            pCdmParser.gotoEnd();
                        }
                        vRotate = !pSrc.isRotateForbidden(vIfExplicitlyAllowed);
                        continue;
                    }
                    pCdmParser.gotoEnd();
                }
                if (vUnit == null) {
                    vUnit = DistUnit.cm;
                }
                if (vRotate && vRotateIfLessLCS > 0.0f && (vLCS = pSrc.getLimitCharSize()) != -1.0f && (vCurrWidthInch = pResult.fWidth / pResult.fDpi) >= (vLimitWidthInch = pSrc.getWidth() * vRotateIfLessLCS / vLCS * 0.01043f)) {
                    vRotate = false;
                }
                ResultSize vNewSize = ImgUtil.getSize(pResult.fWidth, pResult.fHeight, 1.0f, vUnit.toInch(vMinW) * pResult.fDpi, vUnit.toInch(vMinH) * pResult.fDpi, vUnit.toInch(vMaxW) * pResult.fDpi, vUnit.toInch(vMaxH) * pResult.fDpi, vRotate, vRotateIfDiff);
                if (vNewSize.fScale != 1.0f) {
                    pResult.fDpi /= vNewSize.fScale;
                }
                if (!vNewSize.isWithRotate()) continue;
                pResult.setWithRotate(true);
                float vW = pResult.getWidth();
                pResult.setWidth(pResult.getHeight());
                pResult.setHeight(vW);
                continue;
            }
            if (pCdmParser.getCurrStatus() != 4) continue;
            pCdmParser.gotoEnd();
        }
        if (pResult.fDpi < (float)vMinDpi) {
            pResult.fScale = (float)vMinDpi / pResult.fDpi;
            pResult.fWidth *= pResult.fScale;
            pResult.fHeight *= pResult.fScale;
            pResult.fDpi = vMinDpi;
        }
        if (pResult.fDpi > (float)vMaxDpi) {
            pResult.fScale = (float)vMaxDpi / pResult.fDpi;
            pResult.fWidth *= pResult.fScale;
            pResult.fHeight *= pResult.fScale;
            pResult.fDpi = vMaxDpi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getPropsFromRules(IImgSrc pSrc, ResultSize pNewSize, String pOutputRules, Object pResult) throws Exception {
        block33: {
            CdmParser vCdmParser = CdmParser.getPooledParser();
            try {
                if (pOutputRules == null || pOutputRules.length() == 0) {
                    throw new Exception("OutRules not specified.");
                }
                vCdmParser.setSource(pOutputRules);
                if (vCdmParser.gotoFirstChildData() != 4 || !vCdmParser.currNameEquals("Str")) break block33;
                String vEncod = "UTF-8";
                while ((vCdmParser.gotoNextData() & 0x54) != 0) {
                    if (vCdmParser.getCurrStatus() == 16) {
                        if (vCdmParser.currNameEquals("pattern")) {
                            Appendable vOut;
                            if (pResult instanceof File) {
                                File vResFile = (File)pResult;
                                vOut = new OutputStreamWriter((OutputStream)new FileOutputStream(vResFile), vEncod);
                            } else {
                                vOut = (Appendable)pResult;
                            }
                            try {
                                CharSequence vPattern = vCdmParser.getCurrValue();
                                int l = vPattern.length();
                                for (int i = 0; i < l; ++i) {
                                    char vC = vPattern.charAt(i);
                                    if (vC == '!') {
                                        char vC1 = vPattern.charAt(i + 1);
                                        if (vC1 == '!') {
                                            vOut.append(vC);
                                            ++i;
                                            continue;
                                        }
                                        char vC2 = vPattern.charAt(i + 2);
                                        char vC3 = vPattern.charAt(i + 3);
                                        if (vC1 == 'w' || vC1 == 'h') {
                                            float vVal;
                                            float f = vVal = vC1 == 'w' ? pNewSize.getWidth() : pNewSize.getHeight();
                                            if (vC2 != 'p' || vC3 != 'x') {
                                                float vDpi = pNewSize.getDpi();
                                                if (vDpi == -1.0f) {
                                                    vDpi = 72.0f;
                                                }
                                                vVal = ImgUtil.getDistUnit(vC2, vC3).fromInch(vVal / vDpi);
                                            }
                                            vOut.append(Float.toString(vVal));
                                            i += 3;
                                            continue;
                                        }
                                        if (vC1 == 'd' && vC2 == 'p' && vC3 == 'i') {
                                            float vDpi = pNewSize.getDpi();
                                            if (vDpi != -1.0f) {
                                                vOut.append(Integer.toString((int)vDpi));
                                            }
                                            i += 3;
                                            continue;
                                        }
                                        if (vC1 == 's' && vC2 == 'c' && vC3 == 's') {
                                            float vScs = pSrc.getStandardCharSize();
                                            if (vScs != -1.0f) {
                                                vOut.append(Float.toString(vScs));
                                            }
                                            i += 3;
                                            continue;
                                        }
                                        if (vC1 == 'l' && vC2 == 'c' && vC3 == 's') {
                                            float vLcs = pSrc.getLimitCharSize();
                                            if (vLcs != -1.0f) {
                                                vOut.append(Float.toString(vLcs));
                                            }
                                            i += 3;
                                            continue;
                                        }
                                        if (vC1 == 'r' && vC2 == 'o' && vC3 == 't') {
                                            try {
                                                int j;
                                                if (pNewSize.isWithRotate()) {
                                                    char vNewC;
                                                    for (j = i + 5; j < l && (vNewC = vPattern.charAt(j)) != ','; ++j) {
                                                        vOut.append(vNewC);
                                                    }
                                                    while (vPattern.charAt(j) != ')') {
                                                        ++j;
                                                    }
                                                } else {
                                                    char vNewC;
                                                    while (vPattern.charAt(j) != ',') {
                                                        ++j;
                                                    }
                                                    ++j;
                                                    while (j < l && (vNewC = vPattern.charAt(j)) != ')') {
                                                        vOut.append(vNewC);
                                                        ++j;
                                                    }
                                                }
                                                i = j;
                                                continue;
                                            }
                                            catch (Exception e) {
                                                throw LogMgr.newException("Variable de type !rot(true,false) mal form\u00e9e dans le pattern : " + vPattern, new String[0]);
                                            }
                                        }
                                        throw LogMgr.newException("Variable inconue !" + vC1 + vC2 + vC3 + " dans le pattern : " + vPattern, new String[0]);
                                    }
                                    vOut.append(vC);
                                }
                                continue;
                            }
                            finally {
                                if (!(pResult instanceof File)) continue;
                                ((Writer)vOut).close();
                                continue;
                            }
                        }
                        if (!vCdmParser.currNameEquals("encod")) continue;
                        vEncod = ((Object)vCdmParser.getCurrValue()).toString();
                        continue;
                    }
                    vCdmParser.gotoEnd();
                }
            }
            finally {
                CdmParser.freePooledParser(vCdmParser);
            }
        }
    }

    protected static DistUnit getDistUnit(char pC1, char pC2) {
        switch (pC1) {
            case 'c': {
                return pC2 == 'm' ? DistUnit.cm : null;
            }
            case 'm': {
                return pC2 == 'm' ? DistUnit.mm : null;
            }
            case 'p': {
                return pC2 == 't' ? DistUnit.pt : (pC2 == 'c' ? DistUnit.pc : null);
            }
            case 'i': {
                return pC2 == 'n' ? DistUnit.in : null;
            }
        }
        return null;
    }

    public static float getWidth(float pOriginalWidth, float pOriginalHeight, float pScale, float pMinWidth, float pMinHeight, float pMaxWidth, float pMaxHeight) {
        return ImgUtil.getSize(pOriginalWidth, pOriginalHeight, pScale, pMinWidth, pMinHeight, pMaxWidth, pMaxHeight).getWidth();
    }

    public static float getHeight(float pOriginalWidth, float pOriginalHeight, float pScale, float pMinWidth, float pMinHeight, float pMaxWidth, float pMaxHeight) {
        return ImgUtil.getSize(pOriginalWidth, pOriginalHeight, pScale, pMinWidth, pMinHeight, pMaxWidth, pMaxHeight).getHeight();
    }

    public static ResultSize getSize(float pOriginalWidth, float pOriginalHeight, float pScale, float pMinWidth, float pMinHeight, float pMaxWidth, float pMaxHeight, boolean pRotateAllowed) {
        return ImgUtil.getSize(pOriginalWidth, pOriginalHeight, pScale, pMinWidth, pMinHeight, pMaxWidth, pMaxHeight, pRotateAllowed, 0.1f);
    }

    public static ResultSize getSize(float pOriginalWidth, float pOriginalHeight, float pScale, float pMinWidth, float pMinHeight, float pMaxWidth, float pMaxHeight, boolean pRotateAllowed, float pRotateIfDiffMoreThan) {
        boolean vWithRotate;
        float vWidth = pOriginalWidth;
        float vHeight = pOriginalHeight;
        float vOriginalWidth = pOriginalWidth;
        float vOriginalHeight = pOriginalHeight;
        boolean bl = vWithRotate = pRotateAllowed && ImgUtil.isRotatePrefered(vOriginalWidth, vOriginalHeight, pScale, pMinWidth, pMinHeight, pMaxWidth, pMaxHeight, pRotateIfDiffMoreThan);
        if (vWithRotate) {
            float vTmpWidth = vWidth;
            vWidth = vHeight;
            vHeight = vTmpWidth;
            vTmpWidth = vOriginalWidth;
            vOriginalWidth = vOriginalHeight;
            vOriginalHeight = vTmpWidth;
        }
        if (pScale != 1.0f && pScale > 0.0f) {
            vHeight *= pScale;
            vWidth *= pScale;
        }
        if (vWidth < pMinWidth) {
            vHeight = vHeight / vWidth * pMinWidth;
            vWidth = pMinWidth;
        }
        if (vHeight < pMinHeight) {
            vWidth = vWidth / vHeight * pMinHeight;
            vHeight = pMinHeight;
        }
        if (pMaxWidth > 0.0f && vWidth > pMaxWidth) {
            vHeight = vHeight / vWidth * pMaxWidth;
            vWidth = pMaxWidth;
        }
        if (pMaxHeight > 0.0f && vHeight > pMaxHeight) {
            vWidth = vWidth / vHeight * pMaxHeight;
            vHeight = pMaxHeight;
        }
        return new ResultSize(vWidth, vHeight, vWidth / vOriginalWidth, vWithRotate);
    }

    public static ResultSize getSize(float pOriginalWidth, float pOriginalHeight, float pScale, float pMinWidth, float pMinHeight, float pMaxWidth, float pMaxHeight) {
        return ImgUtil.getSize(pOriginalWidth, pOriginalHeight, pScale, pMinWidth, pMinHeight, pMaxWidth, pMaxHeight, false);
    }

    public static ResultSize getOriginalSize(float pOriginalWidth, float pOriginalHeight, float pScale, float pMinWidth, float pMinHeight, float pMaxWidth, float pMaxHeight, String pUnit, int pDpi, boolean pRotateAllowed) {
        return new ResultSize(pOriginalWidth, pOriginalHeight, 1.0f, false, pDpi);
    }

    public static boolean isRotatePrefered(float pOriginalWidth, float pOriginalHeight, float pScale, float pMinWidth, float pMinHeight, float pMaxWidth, float pMaxHeight) {
        return ImgUtil.isRotatePrefered(pOriginalWidth, pOriginalHeight, pScale, pMinWidth, pMinHeight, pMaxWidth, pMaxHeight, 0.1f);
    }

    public static boolean isRotatePrefered(float pOriginalWidth, float pOriginalHeight, float pScale, float pMinWidth, float pMinHeight, float pMaxWidth, float pMaxHeight, float pRotateIfDiffMoreThan) {
        if ((pOriginalHeight / pOriginalWidth - 1.0f) * (pMaxHeight / pMaxWidth - 1.0f) < 0.0f) {
            float vWidth = pOriginalWidth;
            float vHeight = pOriginalHeight;
            if (pScale != 1.0f && pScale > 0.0f) {
                vHeight *= pScale;
                vWidth *= pScale;
            }
            if ((vWidth > pMaxWidth || vHeight > pMaxHeight) && Math.min(pMaxWidth / vWidth, pMaxHeight / vHeight) * (1.0f + pRotateIfDiffMoreThan) < Math.min(Math.min(pMaxWidth / vHeight, pMaxHeight / vWidth), 1.0f)) {
                return true;
            }
        }
        return false;
    }

    public static float pxToCm(float pSize, int pDpi) {
        return (float)((double)pSize * 2.54 / (double)pDpi);
    }

    public static float cmToPx(float pSize, int pDpi) {
        return (float)((double)pSize / 2.54 * (double)pDpi);
    }

    public static class ResultSize {
        public float fWidth = 0.0f;
        public float fHeight = 0.0f;
        public float fDpi = -1.0f;
        public float fScale = 1.0f;
        public boolean fWithRotate = false;

        public ResultSize(float pWidth, float pHeight, float pScale, boolean pWithRotate) {
            this.fWidth = pWidth;
            this.fHeight = pHeight;
            this.fScale = pScale;
            this.fWithRotate = pWithRotate;
        }

        public ResultSize(float pWidth, float pHeight, float pScale, boolean pWithRotate, float pDpi) {
            this.fWidth = pWidth;
            this.fHeight = pHeight;
            this.fScale = pScale;
            this.fWithRotate = pWithRotate;
            this.fDpi = pDpi;
        }

        public float getHeight() {
            return this.fHeight;
        }

        public void setHeight(float pHeight) {
            this.fHeight = pHeight;
        }

        public float getWidth() {
            return this.fWidth;
        }

        public void setWidth(float pWidth) {
            this.fWidth = pWidth;
        }

        public float getScale() {
            return this.fScale;
        }

        public void setScale(float pScale) {
            this.fScale = pScale;
        }

        public boolean isWithRotate() {
            return this.fWithRotate;
        }

        public void setWithRotate(boolean pWithRotate) {
            this.fWithRotate = pWithRotate;
        }

        public float getDpi() {
            return this.fDpi;
        }

        public void setDpi(float pDpi) {
            this.fDpi = pDpi;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistUnit {
        in(1.0f),
        mm(25.4f),
        cm(2.54f),
        pt(72.0f),
        pc(6.0f);

        private final float fPerInch;

        private DistUnit(float pPerInch) {
            this.fPerInch = pPerInch;
        }

        public float toInch(float pValue) {
            return pValue / this.fPerInch;
        }

        public float fromInch(float pValue) {
            return pValue * this.fPerInch;
        }

        public float translate(float pValue, DistUnit pUnit) {
            if (pUnit == this) {
                return pValue;
            }
            return pValue / this.fPerInch * pUnit.fPerInch;
        }
    }
}

