/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.latex;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.co.transform.ProxyTransform;
import com.scenari.s.co.transform.latex.Latex;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.fs.mini.FsMiniFactory;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.syntax.cdm.CdmParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;

public class HTransformerLatex2Img
extends HTransformer {
    public static final String PARAM_CONTENT = "content";
    public static final String PARAM_SRCENCODING = "srcEncoding";
    public static final String PARAM_FILE_EXTENSION = "fileExt";
    public static final String PARAM_RESOLUTION = "resolution";
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_OUTPUT_TYPE = "outType";
    public static final String OUTTYPE_PNG = "PNG";
    public static final String OUTTYPE_DIMS = "DIMS";
    public static final String PARAM_OUTPUT_RULES = "outRules";
    public static final String PARAM_BG = "backgroundColor";
    public static String sTexPreamble = "\\documentclass{article}\n\\usepackage[utf8x]{inputenc}\n\\usepackage{amssymb,amsmath}\n\\usepackage{color}\n\\usepackage{txfonts}\n\\renewcommand{\\frac}{\\dfrac}\n\\IfFileExists{scenaricustom.sty} { \\usepackage{scenaricustom} }{}\n\\usepackage[active]{preview}\n\\pagestyle{empty}\n\\begin{document}\n\\begin{preview}";
    public static String sTexPostamble = "\\end{preview}\n\\end{document}\n";
    public static String sProxyUrl = null;
    protected ProxyTransform fProxy = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        String vSrcLatex;
        String vOutType = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
        if (vOutType == null || vOutType.length() == 0) {
            vOutType = OUTTYPE_PNG;
        }
        if (sProxyUrl != null) {
            if (this.fProxy == null) {
                this.fProxy = new ProxyTransform();
            }
            this.fProxy.setUrlDistantService(sProxyUrl);
        }
        if ((vSrcLatex = pParams.hGetValueParam(PARAM_CONTENT)) == null) {
            Object vSrc;
            if (pSrc == null) {
                throw LogMgr.newException("Latex transform error: the transformation was called with a \"null\" pSrc object", new String[0]);
            }
            if (pSrc instanceof InputStream) {
                vSrcLatex = StreamUtils.buildString(new InputStreamReader((InputStream)pSrc, this.xGetSrcEncoding(pParams)));
            } else if (pSrc instanceof ISrcNode) {
                vSrc = (ISrcNode)pSrc;
                int vStatus = vSrc.getContentStatus();
                if (vStatus <= -1) {
                    return;
                }
                InputStream vInput = vStatus == 2 ? SrcFeaturePaths.findContentByPath((ISrcNode)vSrc, vSrc.getSrcName(), false).newInputStream(false) : vSrc.newInputStream(false);
                if (vInput == null) {
                    return;
                }
                try {
                    vSrcLatex = StreamUtils.buildString(new InputStreamReader(vInput, this.xGetSrcEncoding(pParams)));
                }
                finally {
                    vInput.close();
                    if (vSrcLatex == null) {
                        throw LogMgr.newException("Latex transform error: could not read source from item: ", new String[0]);
                    }
                }
            } else if (pSrc instanceof File) {
                vSrc = (File)pSrc;
                if (((File)vSrc).isDirectory()) {
                    vSrc = new File((File)vSrc, ((File)vSrc).getName());
                }
                if (!((File)vSrc).canRead()) {
                    throw LogMgr.newException("Latex transform error: source file does not exists or is unreadable: " + ((File)vSrc).getName(), new String[0]);
                }
                BufferedInputStream vInput = new BufferedInputStream(new FileInputStream((File)vSrc));
                try {
                    vSrcLatex = StreamUtils.buildString(new InputStreamReader((InputStream)vInput, this.xGetSrcEncoding(pParams)));
                }
                finally {
                    ((InputStream)vInput).close();
                    if (vSrcLatex == null) {
                        throw LogMgr.newException("Latex transform error: could not read source from file: " + ((File)vSrc).getName(), new String[0]);
                    }
                }
            } else {
                vSrcLatex = pSrc instanceof Reader ? StreamUtils.buildString((Reader)pSrc) : pSrc.toString();
            }
            if (vSrcLatex == null) {
                throw LogMgr.newException("Latex transform error: internal error: vSrcLatex is null after trying every possible source type", new String[0]);
            }
        }
        String vSrcLatexIni = vSrcLatex;
        vSrcLatex = vSrcLatex.trim();
        File vTexFile = null;
        File vTmpDir = null;
        FileOutputStream vResStream = null;
        try {
            try {
                block59: {
                    String vTexFileName;
                    PrintWriter vPw = null;
                    try {
                        try {
                            vTexFile = File.createTempFile("latexres", ".tex");
                            vTexFileName = vTexFile.getName().substring(0, vTexFile.getName().indexOf("."));
                            vTmpDir = new File(vTexFile.getParentFile().getCanonicalPath(), vTexFileName);
                            vTmpDir.mkdir();
                            vPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(vTexFile), this.xGetSrcEncoding(pParams))));
                            String vSrcLatexNormalized = vSrcLatex.toLowerCase();
                            String[] vBeginList = new String[]{"\\begin{math}", "\\begin{displaymath}", "\\begin{equation}", "\\begin{equation*}", "\\begin{gather}", "\\begin{gather*}", "\\begin{align}", "\\begin{align*}", "\\begin{flalign}", "\\begin{flalign*}", "\\begin{multline}", "\\begin{multline*}", "\\begin{alignat}", "\\begin{alignat*}", "\\begin{split}", "\\begin{eqnarray}", "\\begin{eqnarray*}", "\\begin{table}", "\\begin{center}", "\\begin{figure}", "\\begin{list}", "\\begin{verbatim}", "\\begin{theorem}"};
                            boolean vStartWithBeginCmd = false;
                            for (int ii = 0; ii < vBeginList.length; ++ii) {
                                if (!vSrcLatexNormalized.startsWith(vBeginList[ii])) continue;
                                vStartWithBeginCmd = true;
                                break;
                            }
                            if (!vStartWithBeginCmd) {
                                vSrcLatex = "\\begin{math}" + vSrcLatex + "\\end{math}\n";
                            }
                            vPw.write("" + sTexPreamble + vSrcLatex + sTexPostamble);
                        }
                        catch (IOException e) {
                            throw LogMgr.newException("failed to create a temporary .tex file with a formula : '" + vSrcLatexIni + "'", new String[0]);
                        }
                        Object var17_27 = null;
                        if (vPw != null) {
                            vPw.close();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_28 = null;
                        if (vPw == null) throw throwable;
                        vPw.close();
                        throw throwable;
                    }
                    StreamGobbler eg = null;
                    StreamGobbler ig = null;
                    try {
                        String[] vCommands = new String[]{Latex.getCommand("latex"), "-halt-on-error", "-interaction=nonstopmode", "-output-directory=" + vTmpDir.getCanonicalPath(), vTexFile.getCanonicalPath()};
                        Process vProcess = Runtime.getRuntime().exec(vCommands, null, vTexFile.getParentFile());
                        eg = new StreamGobbler(vProcess.getErrorStream());
                        ig = new StreamGobbler(vProcess.getInputStream());
                        eg.start();
                        ig.start();
                        vProcess.waitFor();
                        String vErrorMsg = ig.getOutput();
                        if (vErrorMsg.contains("\n<inserted text>")) {
                            vErrorMsg = vErrorMsg.substring(0, vErrorMsg.lastIndexOf("\n<inserted text>"));
                        }
                        if (vErrorMsg.contains("\n!")) {
                            vErrorMsg = vErrorMsg.substring(vErrorMsg.indexOf("\n!"));
                        }
                        if (vProcess.exitValue() != 0) {
                            throw LogMgr.newException("Latex error : " + vErrorMsg, new String[0]);
                        }
                    }
                    catch (Exception e) {
                        if (eg == null) throw (Exception)LogMgr.addMessage((Throwable)e, "Latex transform error with '" + vSrcLatexIni + "'. No output.", new String[0]);
                        if (eg.getOutput() != null) throw (Exception)LogMgr.addMessage((Throwable)e, "Latex transform error with '" + vSrcLatexIni + "' : " + eg.getOutput(), new String[0]);
                        throw (Exception)LogMgr.addMessage((Throwable)e, "Latex transform error with '" + vSrcLatexIni + "'. No output.", new String[0]);
                    }
                    try {
                        File vOutFile = pRes instanceof File ? (File)pRes : new File(vTmpDir.getCanonicalPath() + "/" + vTexFileName + ".dat");
                        String[] vCommands = new String[]{Latex.getCommand("dvipng"), "-T", "tight", "-z", "9", "-bg", this.xGetBgColor(pParams), "-D", Integer.toString(this.xGetResolution(pParams)), vTmpDir.getCanonicalPath() + "/" + vTexFileName, "-q0", "-v0", "--depth", "--height", "--strict", "-o", vOutFile.getCanonicalPath()};
                        Process vProcess = Runtime.getRuntime().exec(vCommands, null, vTexFile.getParentFile());
                        eg = new StreamGobbler(vProcess.getErrorStream());
                        ig = new StreamGobbler(vProcess.getInputStream());
                        eg.start();
                        ig.start();
                        vProcess.waitFor();
                        String vOutput = eg.getOutput();
                        if (vOutput.contains("warning:")) {
                            throw LogMgr.newException("dvipng (LaTeX) : " + vOutput.substring(vOutput.indexOf("warning:")), new String[0]);
                        }
                        if (vOutType.equals(OUTTYPE_DIMS)) {
                            this.xPropsTransform(pSrc, ig.getOutput(), pRes, pParams);
                            break block59;
                        }
                        if (pRes instanceof OutputStream) {
                            StreamUtils.write(new FileInputStream(vOutFile), (OutputStream)pRes);
                        }
                    }
                    catch (Exception e) {
                        if (eg == null) throw (Exception)LogMgr.addMessage((Throwable)e, "Dvipng transform error with '" + vSrcLatexIni + "'. No output.", new String[0]);
                        if (eg.getOutput() != null) throw (Exception)LogMgr.addMessage((Throwable)e, "Dvipng transform error with '" + vSrcLatexIni + "' : " + eg.getOutput(), new String[0]);
                        throw (Exception)LogMgr.addMessage((Throwable)e, "Dvipng transform error with '" + vSrcLatexIni + "'. No output.", new String[0]);
                    }
                }
                Object var19_31 = null;
                File vAuxFile = new File(vTexFile.getCanonicalPath().substring(0, vTexFile.getCanonicalPath().length() - 4) + ".aux");
                if (vAuxFile != null && vAuxFile.exists()) {
                    vAuxFile.delete();
                }
            }
            catch (Exception e) {
                block62: {
                    block61: {
                        if (this.fProxy == null) break block61;
                        if (!pParams.hGetMap().containsKey(PARAM_CONTENT)) {
                            pParams.hPut(PARAM_CONTENT, vSrcLatexIni);
                        }
                        InputStream vProxyIs = this.fProxy.executeTransform(pParams);
                        if (pRes instanceof OutputStream) {
                            StreamUtils.write(vProxyIs, (OutputStream)pRes);
                            break block62;
                        } else if (pRes instanceof File) {
                            vResStream = new FileOutputStream((File)pRes);
                            StreamUtils.write(vProxyIs, vResStream);
                        }
                        break block62;
                    }
                    LogMgr.publishException(e);
                }
                Object var19_32 = null;
                File vAuxFile = new File(vTexFile.getCanonicalPath().substring(0, vTexFile.getCanonicalPath().length() - 4) + ".aux");
                if (vAuxFile != null && vAuxFile.exists()) {
                    vAuxFile.delete();
                }
                if (vTexFile != null && vTexFile.exists()) {
                    vTexFile.delete();
                }
                if (vTmpDir != null && vTmpDir.exists()) {
                    this.xDelete(vTmpDir);
                }
                if (vResStream == null) return;
                ((OutputStream)vResStream).close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_33 = null;
            File vAuxFile = new File(vTexFile.getCanonicalPath().substring(0, vTexFile.getCanonicalPath().length() - 4) + ".aux");
            if (vAuxFile != null && vAuxFile.exists()) {
                vAuxFile.delete();
            }
            if (vTexFile != null && vTexFile.exists()) {
                vTexFile.delete();
            }
            if (vTmpDir != null && vTmpDir.exists()) {
                this.xDelete(vTmpDir);
            }
            if (vResStream == null) throw throwable;
            ((OutputStream)vResStream).close();
            throw throwable;
        }
        if (vTexFile != null && vTexFile.exists()) {
            vTexFile.delete();
        }
        if (vTmpDir != null && vTmpDir.exists()) {
            this.xDelete(vTmpDir);
        }
        if (vResStream == null) return;
        ((OutputStream)vResStream).close();
    }

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ISrcNode.class.isAssignableFrom(pClassSrc) || File.class.isAssignableFrom(pClassSrc) || InputStream.class.isAssignableFrom(pClassSrc);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes) || OutputStream.class.isAssignableFrom(pClassRes);
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        String vFormat = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
        if (vFormat == null || vFormat.length() == 0) {
            vFormat = OUTTYPE_PNG;
        }
        if (vFormat.equals(OUTTYPE_PNG)) {
            return "image/png";
        }
        if (vFormat.equals(OUTTYPE_DIMS)) {
            return "text/plain";
        }
        return "image";
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        String vExt = pParams.hGetValueParam(PARAM_FILE_EXTENSION);
        String vFormat = pParams.hGetValueParam(PARAM_OUTPUT_TYPE);
        if (vFormat == null || vFormat.length() == 0) {
            vFormat = OUTTYPE_PNG;
        }
        if (vExt != null) {
            return vExt;
        }
        if (vFormat.equals(OUTTYPE_PNG)) {
            return ".png";
        }
        if (vFormat.equals(OUTTYPE_DIMS)) {
            return ".txt";
        }
        return "";
    }

    public void wSetProperty(String pKey, String pValue) {
        if (this.fProxy == null) {
            this.fProxy = new ProxyTransform();
        }
        if (pKey.equals("urlDistantService")) {
            this.fProxy.setUrlDistantService(pValue);
        } else if (pKey.startsWith("headerDistantService.")) {
            this.fProxy.addHeader(pKey.substring("headerDistantService.".length()), pValue);
        }
    }

    protected int xGetResolution(HTransformParams pParams) throws Exception {
        String vResolution = pParams.hGetValueParam(PARAM_RESOLUTION);
        int vIntResolution = 300;
        if (vResolution != null && vResolution.length() > 0) {
            try {
                vIntResolution = new Integer(vResolution);
            }
            catch (NumberFormatException e) {
                throw LogMgr.newException("Resolution parameter incorrectly set for latex2png transformation (must be an integer greater than 10, lower than 6000)", new String[0]);
            }
            if (vIntResolution < 10 || vIntResolution > 6000) {
                throw LogMgr.newException("Resolution parameter incorrectly set for latex2png transformation (must be an integer greater than 10, lower than 6000)", new String[0]);
            }
        }
        return Math.round((float)vIntResolution * this.xGetScale(pParams));
    }

    protected String xGetBgColor(HTransformParams pParams) throws Exception {
        String vBgColor = pParams.hGetValueParam(PARAM_BG);
        if (vBgColor != null && vBgColor.length() > 0) {
            return vBgColor;
        }
        return "Transparent";
    }

    protected String xGetSrcEncoding(HTransformParams pParams) throws Exception {
        String vSrcEnc = pParams.hGetValueParam(PARAM_SRCENCODING);
        if (vSrcEnc != null && vSrcEnc.length() > 0) {
            return vSrcEnc;
        }
        return "UTF-8";
    }

    protected float xGetScale(HTransformParams pParams) {
        String pScale = pParams.hGetValueParam(PARAM_SCALE);
        if (pScale != null && pScale.length() > 0) {
            try {
                return Float.parseFloat(pScale);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Parsing scale failed : " + pScale, new String[0]);
            }
        }
        return 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xPropsTransform(Object pSrc, String pOutTransform, Object pRes, HTransformParams pParams) throws Exception {
        String vRules = pParams.hGetValueParam(PARAM_OUTPUT_RULES);
        CdmParser vCdmParser = CdmParser.getPooledParser();
        try {
            if (vRules == null || vRules.length() == 0) {
                throw new Exception("OutRules not specified.");
            }
            vCdmParser.setSource(vRules);
            if (vCdmParser.gotoFirstChildData() == 4 && vCdmParser.currNameEquals("Str")) {
                while ((vCdmParser.gotoNextData() & 0x54) != 0) {
                    if (vCdmParser.getCurrStatus() == 16) {
                        Object var23_22;
                        if (!vCdmParser.currNameEquals("pattern")) continue;
                        OutputStream vOut = pRes instanceof File ? new FileOutputStream((File)pRes) : (OutputStream)pRes;
                        try {
                            CharSequence vPattern = vCdmParser.getCurrValue();
                            int l = vPattern.length();
                            for (int i = 0; i < l; ++i) {
                                char vC = vPattern.charAt(i);
                                if (vC == '!') {
                                    char vC1 = vPattern.charAt(i + 1);
                                    if (vC1 == '!') {
                                        vOut.write(vC);
                                        ++i;
                                        continue;
                                    }
                                    char vC2 = vPattern.charAt(i + 2);
                                    char vC3 = vPattern.charAt(i + 3);
                                    if (vC1 == 'd' || vC1 == 'h') {
                                        int vPosD = pOutTransform.indexOf("depth=");
                                        int vPosH = pOutTransform.indexOf(" height=");
                                        if (vPosD > 0 && vPosH > 0) {
                                            String vDepth = pOutTransform.substring(vPosD + 6);
                                            float vDepthInt = Integer.valueOf(vDepth.substring(0, vDepth.indexOf(32))).intValue();
                                            String vHeight = pOutTransform.substring(vPosH + 8);
                                            float vHeightInt = Integer.valueOf(vHeight.substring(0, vHeight.indexOf(93))).intValue();
                                            if (vC1 == 'd' && vC2 == 'p' && vC3 == 'x') {
                                                vOut.write(Float.toString(vDepthInt).getBytes());
                                            } else if (vC1 == 'd' && vC2 == 'p' && vC3 == 'c') {
                                                float vFactor = vDepthInt / (vDepthInt + vHeightInt);
                                                vOut.write(Float.toString(vFactor).getBytes());
                                            } else if (vC1 == 'h' && vC2 == 'p' && vC3 == 'x') {
                                                vOut.write(Float.toString(vDepthInt + vHeightInt).getBytes());
                                            } else {
                                                throw LogMgr.newException("Unit\u00e9 inconue !" + vC2 + vC3, new String[0]);
                                            }
                                        }
                                        i += 3;
                                        continue;
                                    }
                                    throw LogMgr.newException("Variable inconue !" + vC1 + vC2 + vC3 + " dans le pattern : " + vPattern, new String[0]);
                                }
                                vOut.write(vC);
                            }
                            var23_22 = null;
                            if (vOut == null) continue;
                        }
                        catch (Throwable throwable) {
                            var23_22 = null;
                            if (vOut != null) {
                                vOut.close();
                            }
                            throw throwable;
                        }
                        vOut.close();
                        {
                            continue;
                        }
                    }
                    vCdmParser.gotoEnd();
                }
            }
            Object var25_24 = null;
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            CdmParser.freePooledParser(vCdmParser);
            throw throwable;
        }
        CdmParser.freePooledParser(vCdmParser);
    }

    protected boolean xDelete(File pFile) throws Exception {
        if (pFile.isDirectory()) {
            File[] vChilds = pFile.listFiles();
            for (int i = 0; i < vChilds.length; ++i) {
                this.xDelete(vChilds[i]);
            }
            return pFile.delete();
        }
        return pFile.delete();
    }

    public static void main(String[] pArgs) {
        try {
            LogMgr.subscribeAsString(System.out, true);
            HTransformerLatex2Img vTrsf = new HTransformerLatex2Img();
            String vPar = "transform=latex";
            HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString(vPar, "UTF-8");
            vParams.hPut(PARAM_BG, "Transparent");
            vParams.hPut(PARAM_RESOLUTION, "300");
            vParams.hPut(PARAM_SCALE, "1");
            vParams.hPut(PARAM_CONTENT, "90\u00b0");
            vTrsf.hTransform(FsMiniFactory.newNodeFromPath("C:\\test.mtex", true), new File("C:\\test.mtex.png"), vParams);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
    }

    private static final class StreamGobbler
    extends Thread {
        InputStream fInStream;
        StringBuffer fSb = new StringBuffer();

        StreamGobbler(InputStream pInStream) {
            this.fInStream = pInStream;
        }

        public void run() {
            try {
                String vLine;
                BufferedReader vBuf = new BufferedReader(new InputStreamReader(this.fInStream));
                while ((vLine = vBuf.readLine()) != null) {
                    this.fSb.append(vLine).append("\n");
                }
                vBuf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getOutput() {
            return this.fSb.toString();
        }
    }
}

