/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.latex;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.co.transform.latex.Latex2MathML;
import com.scenari.s.co.transform.xml.HTransformerXml;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.xerces.serialize.impl.XMLSerializer;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HTransformerLatex2MathMl
extends HTransformer {
    public static final String PARAM_CONTENT = "content";
    public static final String PARAM_FONTCOLOR = "fontColor";
    public static final String PARAM_FONTFAMILY = "fontFamily";
    public static final String PARAM_SRCENCODING = "srcEncoding";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_INDENT = "indent";
    public static final String PARAM_OMIT_XML_DECLARATION = "omitXmlDeclaration";
    public static final String PARAM_OMIT_DOCTYPE = "omitDoctype";
    public static final String PARAM_DOCTYPE_SYSTEM = "doctypeSystem";
    public static final String PARAM_DOCTYPE_PUBLIC = "doctypePublic";
    public static final String PARAM_FILE_EXTENSION = "fileExt";
    public static final String PARAM_MIME_TYPE = "mimeType";
    public static final String VALUE_YES = "yes";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        String vSrcLatex = pParams.hGetValueParam(PARAM_CONTENT);
        if (vSrcLatex == null) {
            Object vSrc;
            if (pSrc instanceof InputStream) {
                vSrcLatex = StreamUtils.buildString(new InputStreamReader((InputStream)pSrc, this.xGetSrcEncoding(pParams)));
            } else if (pSrc instanceof ISrcNode) {
                vSrc = (ISrcNode)pSrc;
                int vStatus = vSrc.getContentStatus();
                if (vStatus <= -1) {
                    return;
                }
                InputStream vInput = vStatus == 2 ? SrcFeaturePaths.findContentByPath((ISrcNode)vSrc, vSrc.getSrcName(), false).newInputStream(false) : vSrc.newInputStream(false);
                if (vInput == null) {
                    return;
                }
                try {
                    vSrcLatex = StreamUtils.buildString(new InputStreamReader(vInput, this.xGetSrcEncoding(pParams)));
                    Object var9_11 = null;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    vInput.close();
                    throw throwable;
                }
                vInput.close();
            } else if (pSrc instanceof File) {
                vSrc = (File)pSrc;
                if (((File)vSrc).isDirectory()) {
                    vSrc = new File((File)vSrc, ((File)vSrc).getName());
                }
                BufferedInputStream vInput = new BufferedInputStream(new FileInputStream((File)vSrc));
                try {
                    vSrcLatex = StreamUtils.buildString(new InputStreamReader((InputStream)vInput, this.xGetSrcEncoding(pParams)));
                    Object var11_15 = null;
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    ((InputStream)vInput).close();
                    throw throwable;
                }
                ((InputStream)vInput).close();
            } else {
                vSrcLatex = pSrc instanceof Reader ? StreamUtils.buildString((Reader)pSrc) : pSrc.toString();
            }
        }
        OutputStream vResultStream = null;
        try {
            try {
                String vFontFamily;
                XMLSerializer vSer = null;
                if (pRes instanceof OutputStream) {
                    vSer = new XMLSerializer((OutputStream)pRes, HTransformerXml.xCreateOuputFormat(pParams));
                } else if (pRes instanceof File) {
                    vResultStream = new BufferedOutputStream(new FileOutputStream((File)pRes));
                    vSer = new XMLSerializer(vResultStream, HTransformerXml.xCreateOuputFormat(pParams));
                } else {
                    vSer = new XMLSerializer((Writer)pRes, HTransformerXml.xCreateOuputFormat(pParams));
                }
                Document vDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Latex2MathML vTransf = new Latex2MathML();
                String vFontColor = pParams.hGetValueParam(PARAM_FONTCOLOR);
                if (vFontColor != null && vFontColor.length() > 0) {
                    vTransf.setColor(vFontColor);
                }
                if ((vFontFamily = pParams.hGetValueParam(PARAM_FONTFAMILY)) != null && vFontFamily.length() > 0) {
                    vTransf.setFontFamily(vFontFamily);
                }
                Element vElt = vTransf.transformAsDom(vSrcLatex, vDoc);
                vDoc.appendChild(vElt);
                vSer.setNamespaces(true);
                vSer.serialize(vDoc);
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation d'une formule Latex en MathML : " + vSrcLatex, new String[0]);
            }
            Object var13_19 = null;
            if (vResultStream == null) return;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            if (vResultStream == null) throw throwable;
            try {
                vResultStream.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        vResultStream.close();
        return;
    }

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ISrcNode.class.isAssignableFrom(pClassSrc) || File.class.isAssignableFrom(pClassSrc) || InputStream.class.isAssignableFrom(pClassSrc);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes) || OutputStream.class.isAssignableFrom(pClassRes) || Writer.class.isAssignableFrom(pClassRes);
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        String vMime = pParams.hGetValueParam(PARAM_MIME_TYPE);
        if (vMime != null) {
            return vMime;
        }
        return "text/mathml+xml";
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        String vExt = pParams.hGetValueParam(PARAM_FILE_EXTENSION);
        if (vExt != null) {
            return vExt;
        }
        return ".xml";
    }

    protected String xGetSrcEncoding(HTransformParams pParams) throws Exception {
        String vSrcEnc = pParams.hGetValueParam(PARAM_SRCENCODING);
        if (vSrcEnc != null && vSrcEnc.length() > 0) {
            return vSrcEnc;
        }
        return "UTF-8";
    }
}

