/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.latex;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Latex2MathML {
    public static final int CONST = 0;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int INFIX = 3;
    public static final int LEFTBRACKET = 4;
    public static final int RIGHTBRACKET = 5;
    public static final int SPACE = 6;
    public static final int UNDEROVER = 7;
    public static final int DEFINITION = 8;
    public static final int TEXT = 10;
    public static final int BIG = 11;
    public static final int LONG = 12;
    public static final int STRETCHY = 13;
    public static final int MATRIX = 14;
    public static final String MATHML_NS = "http://www.w3.org/1998/Math/MathML";
    protected static Symbol[] sSymbols = null;
    protected String fColor = null;
    protected String fFontFamily = "serif";

    public static void main(String[] args) {
        try {
            StringBuffer vBuffer = new StringBuffer();
            vBuffer.append("Latex expression : ").append(args[0]).append("\n");
            vBuffer.append(new Latex2MathML().transformAsXml(args[0], null).toString());
            System.out.println(vBuffer.toString());
        }
        catch (Exception e) {
            System.err.println("Could not read file: " + args[0]);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void initSymbols() throws Exception {
        if (sSymbols == null) {
            String vSymbolsFileName = "symbols.xml";
            InputStream vSymbols = Latex2MathML.class.getResourceAsStream(vSymbolsFileName);
            if (vSymbols == null) {
                throw new Exception("Symbols file '" + vSymbolsFileName + "' not found.");
            }
            SymbolHandler vHandler = new SymbolHandler();
            try {
                SAXParser vParser = SAXParserFactory.newInstance().newSAXParser();
                try {
                    vParser.getXMLReader().setFeature("http://xml.org/sax/features/validation", false);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                try {
                    vParser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                vParser.parse(vSymbols, (DefaultHandler)vHandler);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                vSymbols.close();
                throw throwable;
            }
            vSymbols.close();
            Symbol[] vSymbolsResult = vHandler.fList.toArray(new Symbol[vHandler.fList.size()]);
            Arrays.sort(vSymbolsResult, new Comparator(){

                public int compare(Object pO1, Object pO2) {
                    return ((Symbol)pO1).fInput.compareTo(((Symbol)pO2).fInput);
                }
            });
            sSymbols = vSymbolsResult;
        }
    }

    public Element transformAsDom(String pLatexExpr, Document pDoc) throws Exception {
        Latex2MathML.initSymbols();
        Element vStyleElt = pDoc.createElementNS(MATHML_NS, "mstyle");
        if (this.fColor != null) {
            vStyleElt.setAttribute("mathcolor", this.fColor);
        }
        if (this.fFontFamily != null) {
            vStyleElt.setAttribute("fontfamily", this.fFontFamily);
        }
        DocumentFragment vFrag = pDoc.createDocumentFragment();
        this.parseExpr(new StringIterator(pLatexExpr), false, false, vFrag);
        vStyleElt.appendChild(vFrag);
        this.removeInternalAtts(vStyleElt);
        Element vRootElt = pDoc.createElementNS(MATHML_NS, "math");
        vRootElt.appendChild(vStyleElt);
        return vRootElt;
    }

    protected void removeInternalAtts(Element pElt) {
        if (pElt.hasAttribute("internalType")) {
            pElt.removeAttribute("internalType");
        }
        for (Node vCh = pElt.getFirstChild(); vCh != null; vCh = vCh.getNextSibling()) {
            if (vCh.getNodeType() != 1) continue;
            this.removeInternalAtts((Element)vCh);
        }
    }

    public String transformAsXml(String pLatexExpr, Properties pOutputProperties) throws Exception {
        Document vDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element vMathMl = this.transformAsDom(pLatexExpr, vDoc);
        vDoc.appendChild(vMathMl);
        Transformer vSerializer = TransformerFactory.newInstance().newTransformer();
        if (pOutputProperties != null) {
            vSerializer.setOutputProperties(pOutputProperties);
        }
        StringWriter vWriter = new StringWriter();
        vSerializer.transform(new DOMSource(vDoc), new StreamResult(vWriter));
        return vWriter.toString();
    }

    public String normalizeLatexExp(String pLatexExpr) throws Exception {
        return pLatexExpr.trim();
    }

    public String getColor() {
        return this.fColor;
    }

    public void setColor(String pColor) {
        this.fColor = pColor;
    }

    public String getFontFamily() {
        return this.fFontFamily;
    }

    public void setFontFamily(String pFontFamily) {
        this.fFontFamily = pFontFamily;
    }

    protected void removeBlanks(StringIterator pStr) {
        if (pStr.current() <= ' ') {
            while (pStr.next() <= ' ') {
            }
        }
    }

    protected Symbol getSymbolAndMove(StringIterator pStr) {
        Symbol vResult = null;
        this.removeBlanks(pStr);
        int vStartIdx = pStr.getIndex();
        char vFirstChar = pStr.current();
        if (vFirstChar == '\uffff') {
            return null;
        }
        Symbol[] vSymbols = this.getSymbols();
        int vMin = -1;
        int vIdxSymbol = vSymbols.length;
        while (vMin + 1 < vIdxSymbol) {
            int vPos = vMin + vIdxSymbol >> 1;
            String vInput = vSymbols[vPos].fInput;
            if (vInput.charAt(0) < vFirstChar) {
                vMin = vPos;
                continue;
            }
            vIdxSymbol = vPos;
        }
        block1: while (vIdxSymbol < vSymbols.length) {
            String vInput = vSymbols[vIdxSymbol].fInput;
            char vStrC = vFirstChar;
            for (int i = 0; i < vInput.length(); ++i) {
                char vInputC = vInput.charAt(i);
                if (vStrC == '\uffff' || vInputC > vStrC) {
                    pStr.setIndex(vStartIdx);
                    break block1;
                }
                if (vInputC < vStrC) {
                    ++vIdxSymbol;
                    pStr.setIndex(vStartIdx);
                    continue block1;
                }
                vStrC = pStr.next();
            }
            vResult = vSymbols[vIdxSymbol];
            ++vIdxSymbol;
            pStr.setIndex(vStartIdx);
        }
        if (vResult == null) {
            vResult = new Symbol(0);
            vResult.fInput = vResult.fOutput = Character.toString(vFirstChar);
            pStr.next();
            vResult.fTag = '0' <= vFirstChar && vFirstChar <= '9' ? "mn" : (!('A' <= vFirstChar && vFirstChar <= 'Z' || 'a' <= vFirstChar && vFirstChar <= 'z') ? "mo" : "mi");
        } else {
            pStr.setIndex(vStartIdx + vResult.fInput.length());
        }
        return vResult;
    }

    protected Symbol getSymbol(StringIterator pStr) {
        int vPos = pStr.getIndex();
        Symbol vResult = this.getSymbolAndMove(pStr);
        pStr.setIndex(vPos);
        return vResult;
    }

    protected Element appendElt(Node pParent, String pNodeName) {
        return (Element)pParent.appendChild(pParent.getOwnerDocument().createElementNS(MATHML_NS, pNodeName));
    }

    protected Element wrapWithElt(String pNodeName, Node pChild) {
        Element vResult = pChild.getOwnerDocument().createElementNS(MATHML_NS, pNodeName);
        vResult.appendChild(pChild);
        return vResult;
    }

    protected Symbol[] getSymbols() {
        return sSymbols;
    }

    protected Element parseSExpr(StringIterator pStr, Document pDoc) {
        Symbol vSymbol = this.getSymbolAndMove(pStr);
        if (vSymbol == null) {
            return null;
        }
        if (vSymbol.fType == 8) {
            pStr.replaceText(pStr.getIndex() - vSymbol.fInput.length(), pStr.getIndex(), vSymbol.fOutput);
            vSymbol = this.getSymbolAndMove(pStr);
            if (vSymbol == null) {
                return null;
            }
        }
        switch (vSymbol.fType) {
            case 5: {
                pStr.setIndex(pStr.getIndex() - vSymbol.fInput.length());
                return null;
            }
            case 6: {
                Element vResult = pDoc.createElementNS(MATHML_NS, vSymbol.fTag);
                vResult.setAttribute(vSymbol.fAtName, vSymbol.fAtVal);
                return vResult;
            }
            case 7: {
                return this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput));
            }
            case 0: {
                return this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput));
            }
            case 12: {
                Element vEltLong = this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput));
                vEltLong.setAttribute("minsize", "1.5");
                vEltLong.setAttribute("maxsize", "1.5");
                Element vResult = this.wrapWithElt("mover", vEltLong);
                vResult.appendChild(pDoc.createElementNS(MATHML_NS, "mspace"));
                return vResult;
            }
            case 13: {
                Element vResult = this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput));
                if (vSymbol.fInput.equals("|") || vSymbol.fInput.equals("\\vert") || vSymbol.fInput.equals("\\|") || vSymbol.fInput.equals("\\Vert")) {
                    vResult.setAttribute("lspace", "0em");
                    vResult.setAttribute("rspace", "0em");
                }
                vResult.setAttribute("maxsize", vSymbol.fAtVal);
                return vResult;
            }
            case 11: {
                vSymbol = this.getSymbolAndMove(pStr);
                if (vSymbol == null) {
                    return null;
                }
                Element vResult = this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput));
                vResult.setAttribute("minsize", vSymbol.fAtVal);
                vResult.setAttribute("maxsize", vSymbol.fAtVal);
                return vResult;
            }
            case 4: {
                Element vResult;
                if (vSymbol.fInput.equals("\\left") && (vSymbol = this.getSymbolAndMove(pStr)) != null && vSymbol.fInput.equals(".")) {
                    vSymbol.fInvisible = true;
                }
                DocumentFragment vFrag = pDoc.createDocumentFragment();
                this.parseExpr(pStr, true, false, vFrag);
                if (vSymbol == null || vSymbol.fInvisible) {
                    vResult = this.wrapWithElt("mrow", vFrag);
                } else {
                    vResult = pDoc.createElementNS(MATHML_NS, "mrow");
                    Element vMo = pDoc.createElementNS(MATHML_NS, "mo");
                    vMo.appendChild(pDoc.createTextNode(vSymbol.fOutput));
                    vResult.appendChild(vMo);
                    vResult.appendChild(vFrag);
                }
                return vResult;
            }
            case 14: {
                if (vSymbol.fInput.equals("\\begin{array}")) {
                    ArrayList<String> vMask = new ArrayList<String>();
                    vSymbol = this.getSymbolAndMove(pStr);
                    if (vSymbol == null) {
                        vMask.add("l");
                    } else if (!vSymbol.fInput.equals("{")) {
                        vMask.add("l");
                    } else {
                        do {
                            if ((vSymbol = this.getSymbolAndMove(pStr)) == null || vSymbol.fInput.equals("}")) continue;
                            vMask.add(vSymbol.fInput);
                        } while (vSymbol != null && vSymbol.fInput.length() > 0 && !vSymbol.fInput.equals("}"));
                    }
                    pStr.replaceText(pStr.getIndex() - vSymbol.fInput.length(), pStr.getIndex(), "{");
                    DocumentFragment vFrag = pDoc.createDocumentFragment();
                    this.parseExpr(pStr, true, true, vFrag);
                    Element vTable = this.wrapWithElt("mtable", vFrag);
                    StringBuffer vMaskStr = new StringBuffer(vMask.size() * 7);
                    block21: for (int i = 0; i < vMask.size(); ++i) {
                        String vM = (String)vMask.get(i);
                        switch (vM.charAt(0)) {
                            case 'l': {
                                vMaskStr.append("left ");
                                continue block21;
                            }
                            case 'r': {
                                vMaskStr.append("right ");
                                continue block21;
                            }
                            case 'c': {
                                vMaskStr.append("center ");
                            }
                        }
                    }
                    vTable.setAttribute("columnalign", vMaskStr.toString());
                    vTable.setAttribute("displaystyle", "false");
                    Element vLspace = pDoc.createElementNS(MATHML_NS, "mspace");
                    vLspace.setAttribute("width", "0.167em");
                    Element vRspace = pDoc.createElementNS(MATHML_NS, "mspace");
                    vRspace.setAttribute("width", "0.167em");
                    Element vResult = pDoc.createElementNS(MATHML_NS, "mrow");
                    vResult.appendChild(vLspace);
                    vResult.appendChild(vTable);
                    vResult.appendChild(vRspace);
                    return vResult;
                }
                pStr.replaceText(pStr.getIndex() - vSymbol.fInput.length(), pStr.getIndex(), "{");
                DocumentFragment vFrag = pDoc.createDocumentFragment();
                this.parseExpr(pStr, true, true, vFrag);
                Element vTable = this.wrapWithElt("mtable", vFrag);
                vTable.setAttribute("columnspacing", "0.167em");
                vTable.setAttribute("columnalign", "right center left");
                vTable.setAttribute("displaystyle", "true");
                return this.wrapWithElt("mrow", vTable);
            }
            case 10: {
                Element vResult = pDoc.createElementNS(MATHML_NS, "mrow");
                this.removeBlanks(pStr);
                StringBuffer vText = new StringBuffer();
                if (pStr.current() == '{') {
                    char vC = pStr.next();
                    while (vC != '}' && vC != '\uffff') {
                        vText.append(vC);
                        vC = pStr.next();
                    }
                    pStr.next();
                } else {
                    vText.append(pStr.current());
                    pStr.next();
                }
                if (vText.length() > 0 && vText.charAt(0) == ' ') {
                    Element vSp = this.appendElt(vResult, "mspace");
                    vSp.setAttribute("width", "0.33em");
                }
                Element vTextTag = this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vText.toString()));
                vResult.appendChild(vTextTag);
                if (vText.length() > 1 && vText.charAt(vText.length() - 1) == ' ') {
                    Element vSp = this.appendElt(vResult, "mspace");
                    vSp.setAttribute("width", "0.33em");
                }
                return vResult;
            }
            case 1: {
                this.removeBlanks(pStr);
                Element vElt = this.parseSExpr(pStr, pDoc);
                if (vElt == null) {
                    return this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput));
                }
                if (vSymbol.fFunc) {
                    char vFirstChar = pStr.current();
                    if (vFirstChar == '^' || vFirstChar == '_' || vFirstChar == ',') {
                        return this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput));
                    }
                    Element vResult = pDoc.createElementNS(MATHML_NS, "mrow");
                    vResult.appendChild(this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput)));
                    vResult.appendChild(vElt);
                    return vResult;
                }
                if (vSymbol.fInput.equals("\\sqrt")) {
                    return this.wrapWithElt(vSymbol.fTag, vElt);
                }
                if (vSymbol.fAcc) {
                    Element vResult = this.wrapWithElt(vSymbol.fTag, vElt);
                    Element vNode1 = this.wrapWithElt("mo", pDoc.createTextNode(vSymbol.fOutput));
                    if (vSymbol.fInput.equals("\\check")) {
                        vNode1.setAttribute("maxsize", "1.2");
                    }
                    if (vSymbol.fInput.equals("\\underbrace") || vSymbol.fInput.equals("\\underline")) {
                        vNode1.setAttribute("accentunder", "true");
                    } else {
                        vNode1.setAttribute("accent", "true");
                    }
                    if (vSymbol.fInput.equals("\\overbrace") || vSymbol.fInput.equals("\\underbrace")) {
                        vResult.setAttribute("internalType", "UNDEROVER");
                    }
                    vResult.appendChild(vNode1);
                    return vResult;
                }
                if (vSymbol.fCodes != null) {
                    Node vCh = vElt.getFirstChild();
                    Node vNext = null;
                    while (vCh != null) {
                        vNext = vCh.getNextSibling();
                        if (vCh.getNodeName().equals("mi") || vElt.getNodeName().equals("mi")) {
                            String vSt = vElt.getNodeName().equals("mi") ? vElt.getFirstChild().getNodeValue() : vCh.getFirstChild().getNodeValue();
                            StringBuffer vBuf = new StringBuffer(vSt.length());
                            int l = vSt.length();
                            for (int i = 0; i < l; ++i) {
                                char vCar = vSt.charAt(i);
                                if (vCar > '@' && vCar < '[') {
                                    int index = vSymbol.fCodes.offsetByCodePoints(0, vCar - 65);
                                    vBuf.append(Character.toChars(vSymbol.fCodes.codePointAt(index)));
                                    continue;
                                }
                                vBuf.append(vCar);
                            }
                            if (vElt.getNodeName().equals("mi")) {
                                vElt = this.wrapWithElt("mo", pDoc.createTextNode(vBuf.toString()));
                            } else {
                                vElt.replaceChild(this.wrapWithElt("mo", pDoc.createTextNode(vBuf.toString())), vCh);
                            }
                        }
                        vCh = vNext;
                    }
                }
                Element vResult = this.wrapWithElt(vSymbol.fTag, vElt);
                vResult.setAttribute(vSymbol.fAtName, vSymbol.fAtVal);
                if (vSymbol.fInput.equals("\\scriptstyle") || vSymbol.fInput.equals("\\scriptscriptstyle")) {
                    vResult.setAttribute("displaystyle", "false");
                }
                return vResult;
            }
            case 2: {
                Element vElt = this.parseSExpr(pStr, pDoc);
                if (vElt == null) {
                    return this.wrapWithElt("mo", pDoc.createTextNode(vSymbol.fInput));
                }
                Element vElt2 = this.parseSExpr(pStr, pDoc);
                if (vElt2 == null) {
                    return this.wrapWithElt("mo", pDoc.createTextNode(vSymbol.fInput));
                }
                Element vResult = pDoc.createElementNS(MATHML_NS, vSymbol.fTag);
                if (vSymbol.fInput.equals("\\root") || vSymbol.fInput.equals("\\stackrel") || vSymbol.fInput.equals("\\substack")) {
                    vResult.appendChild(vElt2);
                }
                vResult.appendChild(vElt);
                if (vSymbol.fInput.equals("\\frac")) {
                    vResult.appendChild(vElt2);
                }
                return vResult;
            }
            case 3: {
                return this.wrapWithElt("mo", pDoc.createTextNode(vSymbol.fOutput));
            }
        }
        return this.wrapWithElt(vSymbol.fTag, pDoc.createTextNode(vSymbol.fOutput));
    }

    protected Element parseIExpr(StringIterator pStr, Document pDoc) {
        Element vResult = null;
        Symbol vSym1 = this.getSymbol(pStr);
        Element vExp = this.parseSExpr(pStr, pDoc);
        int vPos = pStr.getIndex();
        Symbol vSymbol = this.getSymbolAndMove(pStr);
        if (vSymbol != null && vSymbol.fType == 3) {
            Element vExp2 = this.parseSExpr(pStr, pDoc);
            if (vExp2 == null) {
                vExp2 = this.wrapWithElt("mo", pDoc.createTextNode("\u25a1"));
            }
            if (vSymbol.fInput.equals("_") || vSymbol.fInput.equals("^")) {
                boolean vIsUnderover;
                vPos = pStr.getIndex();
                Symbol vSym2 = this.getSymbolAndMove(pStr);
                boolean bl = vIsUnderover = vSym1.fType == 7 || vExp.getAttribute("internalType") == "UNDEROVER";
                if (vSymbol.fInput.equals("_") && vSym2 != null && vSym2.fInput.equals("^")) {
                    Element vExp3 = this.parseSExpr(pStr, pDoc);
                    vResult = pDoc.createElementNS(MATHML_NS, vIsUnderover ? "munderover" : "msubsup");
                    vResult.appendChild(vExp);
                    vResult.appendChild(vExp2);
                    vResult.appendChild(vExp3);
                } else if (vSymbol.fInput.equals("^") && vSym2 != null && vSym2.fInput.equals("_")) {
                    Element vExp3 = this.parseSExpr(pStr, pDoc);
                    vResult = pDoc.createElementNS(MATHML_NS, vIsUnderover ? "munderover" : "msubsup");
                    vResult.appendChild(vExp);
                    vResult.appendChild(vExp3);
                    vResult.appendChild(vExp2);
                } else {
                    pStr.setIndex(vPos);
                    if (vSymbol.fInput.equals("_")) {
                        vResult = pDoc.createElementNS(MATHML_NS, vIsUnderover ? "munder" : "msub");
                        vResult.appendChild(vExp);
                        vResult.appendChild(vExp2);
                    } else {
                        vResult = pDoc.createElementNS(MATHML_NS, vIsUnderover ? "mover" : "msup");
                        vResult.appendChild(vExp);
                        vResult.appendChild(vExp2);
                    }
                }
                vResult = this.wrapWithElt("mrow", vResult);
            } else {
                vResult = this.wrapWithElt(vSymbol.fTag, vExp);
                if (vSymbol.fInput.equals("\\atop") || vSymbol.fInput.equals("\\choose")) {
                    vResult.setAttribute("linethickness", "0ex");
                }
                vResult.appendChild(vExp2);
                if (vSymbol.fInput.equals("\\choose")) {
                    vResult = this.wrapWithElt("mfenced", vResult);
                }
            }
        } else {
            pStr.setIndex(vPos);
            vResult = vExp;
        }
        return vResult;
    }

    protected void parseExpr(StringIterator pStr, boolean pRightbracket, boolean pMatrix, DocumentFragment pFrag) {
        Symbol vSymbol;
        Document vDoc = pFrag.getOwnerDocument();
        do {
            Element vIExpr;
            if ((vIExpr = this.parseIExpr(pStr, vDoc)) == null) continue;
            pFrag.appendChild(vIExpr);
        } while ((vSymbol = this.getSymbol(pStr)) != null && vSymbol.fType != 5 && (vSymbol.fOutput == null || vSymbol.fOutput.length() > 0));
        if (vSymbol != null && vSymbol.fType == 5) {
            this.getSymbolAndMove(pStr);
            if (vSymbol.fInput.equals("\\right") && (vSymbol = this.getSymbolAndMove(pStr)) != null && vSymbol.fInput.equals(".")) {
                vSymbol.fInvisible = true;
            }
            if (pMatrix && pFrag.getLastChild() != null && pFrag.getLastChild().getNodeName().equals("mrow") && pFrag.getLastChild().getPreviousSibling() != null && pFrag.getLastChild().getPreviousSibling().getNodeName().equals("mo") && pFrag.getLastChild().getPreviousSibling().getFirstChild().getNodeValue().equals("&")) {
                Element vMrow = (Element)pFrag.getFirstChild();
                while (vMrow != null) {
                    Element vTrow = vDoc.createElementNS(MATHML_NS, "mtr");
                    Element vTd = vDoc.createElementNS(MATHML_NS, "mtd");
                    vTrow.appendChild(vTd);
                    while (vMrow.hasChildNodes()) {
                        Element vCh = (Element)vMrow.getFirstChild();
                        if (vCh.hasChildNodes() && vCh.getFirstChild().getNodeType() == 3 && vCh.getFirstChild().getNodeValue().equals("&")) {
                            vTd = vDoc.createElementNS(MATHML_NS, "mtd");
                            vTrow.appendChild(vTd);
                            vMrow.removeChild(vCh);
                            continue;
                        }
                        vTd.appendChild(vCh);
                    }
                    pFrag.replaceChild(vTrow, vMrow);
                    if (vTrow.getNextSibling() != null) {
                        pFrag.removeChild(vTrow.getNextSibling());
                    }
                    vMrow = (Element)vTrow.getNextSibling();
                }
            } else if (vSymbol != null && !vSymbol.fInvisible) {
                pFrag.appendChild(this.wrapWithElt("mo", vDoc.createTextNode(vSymbol.fOutput)));
            }
        }
    }

    public static class StringIterator {
        private String fText;
        private int fEnd;
        private int fPos;

        public StringIterator(String pText) {
            this.fText = pText;
            this.fEnd = pText.length();
        }

        public void replaceText(int pOffsetStart, int pOffsetEnd, String pText) {
            if (pText != null) {
                int i;
                StringBuffer vBuf = new StringBuffer(pOffsetStart + pText.length() + this.fEnd - pOffsetEnd);
                for (i = 0; i < pOffsetStart; ++i) {
                    vBuf.append(this.fText.charAt(i));
                }
                int l = pText.length();
                for (i = 0; i < l; ++i) {
                    vBuf.append(pText.charAt(i));
                }
                for (i = pOffsetEnd; i < this.fEnd; ++i) {
                    vBuf.append(this.fText.charAt(i));
                }
                this.fText = vBuf.toString();
                this.fEnd = this.fText.length();
                this.setIndex(pOffsetStart);
            }
        }

        public char setIndex(int p) {
            if (p < 0 || p > this.fEnd) {
                throw new IllegalArgumentException("Invalid index");
            }
            this.fPos = p;
            return this.current();
        }

        public char current() {
            if (this.fPos >= 0 && this.fPos < this.fEnd) {
                return this.fText.charAt(this.fPos);
            }
            return '\uffff';
        }

        public char next() {
            if (this.fPos < this.fEnd - 1) {
                ++this.fPos;
                return this.fText.charAt(this.fPos);
            }
            this.fPos = this.fEnd;
            return '\uffff';
        }

        public char previous() {
            if (this.fPos > 0) {
                --this.fPos;
                return this.fText.charAt(this.fPos);
            }
            return '\uffff';
        }

        public int getIndex() {
            return this.fPos;
        }
    }

    public static class SymbolHandler
    extends DefaultHandler {
        public List fList = new ArrayList(250);

        public void startElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
            Symbol vSymbol = null;
            if (pQName.equals("const")) {
                vSymbol = new Symbol(0);
                vSymbol.fInput = pAttributes.getValue("input");
                vSymbol.fTag = pAttributes.getValue("tag");
                vSymbol.fOutput = pAttributes.getValue("output");
                this.fList.add(vSymbol);
            } else if (pQName.equals("unary")) {
                vSymbol = new Symbol(1);
                vSymbol.fInput = pAttributes.getValue("input");
                vSymbol.fTag = pAttributes.getValue("tag");
                String vCodes = pAttributes.getValue("codes");
                if (vCodes != null) {
                    vSymbol.fCodes = vCodes;
                } else {
                    vSymbol.fOutput = pAttributes.getValue("output");
                }
                vSymbol.fFunc = pAttributes.getIndex("func") >= 0;
                vSymbol.fAcc = pAttributes.getIndex("acc") >= 0;
                vSymbol.fAtName = pAttributes.getValue("atname");
                vSymbol.fAtVal = pAttributes.getValue("atval");
                this.fList.add(vSymbol);
            } else {
                if (pQName.equals("binary")) {
                    vSymbol = new Symbol(2);
                } else if (pQName.equals("infix")) {
                    vSymbol = new Symbol(3);
                } else if (pQName.equals("leftbracket")) {
                    vSymbol = new Symbol(4);
                } else if (pQName.equals("rightbracket")) {
                    vSymbol = new Symbol(5);
                } else if (pQName.equals("space")) {
                    vSymbol = new Symbol(6);
                } else if (pQName.equals("underover")) {
                    vSymbol = new Symbol(7);
                } else if (pQName.equals("definition")) {
                    vSymbol = new Symbol(8);
                } else if (pQName.equals("text")) {
                    vSymbol = new Symbol(10);
                } else if (pQName.equals("big")) {
                    vSymbol = new Symbol(11);
                } else if (pQName.equals("long")) {
                    vSymbol = new Symbol(12);
                } else if (pQName.equals("stretchy")) {
                    vSymbol = new Symbol(13);
                } else if (pQName.equals("matrix")) {
                    vSymbol = new Symbol(14);
                }
                if (vSymbol != null) {
                    vSymbol.fInput = pAttributes.getValue("input");
                    vSymbol.fTag = pAttributes.getValue("tag");
                    vSymbol.fOutput = pAttributes.getValue("output");
                    vSymbol.fInvisible = pAttributes.getIndex("invisible") >= 0;
                    vSymbol.fAtName = pAttributes.getValue("atname");
                    vSymbol.fAtVal = pAttributes.getValue("atval");
                    this.fList.add(vSymbol);
                }
            }
        }
    }

    public static class Symbol {
        int fType;
        String fInput = null;
        String fTag = null;
        String fOutput = null;
        String fAtName = null;
        String fAtVal = null;
        String fCodes = null;
        boolean fFunc = false;
        boolean fAcc = false;
        boolean fInvisible = false;

        public Symbol(int pType) {
            this.fType = pType;
        }
    }
}

