/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.oo;

import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.serializer.simple.XmlWriterAppendable;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.helpers.base.SrcContentFileBase;
import eu.scenari.fw.mime.MimeMgr;
import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OdFile {
    public static final String MIME_ODT = "application/vnd.oasis.opendocument.text";
    public static final String MIME_ODS = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String MIME_ODP = "application/vnd.oasis.opendocument.presentation";
    public static final String MIME_ODG = "application/vnd.oasis.opendocument.graphics";
    public static final String MIME_ODF = "application/vnd.oasis.opendocument.formula";
    public static final String MIME_CONFIG_FOLDER = "application/vnd.sun.xml.ui.configuration";
    public static final String ODPATH_METAINF = "META-INF/";
    public static final String ODPATH_MANIFEST = "META-INF/manifest.xml";
    public static final String ODPATH_THUMBNAILS = "Thumbnails/";
    public static final String ODPATH_SETTINGS = "settings.xml";
    public static final String ODPATH_MIMETYPE = "mimetype";
    public static final String ODPATH_META = "meta.xml";
    private static final long EMPTY_CRC = 0L;
    protected String fMainMime = null;
    protected HashMap fEntries = new HashMap();
    protected List fZipFilesToClose = null;

    public void initEmptyFile(String pMimeType) throws Exception {
        this.close();
        this.fMainMime = pMimeType;
    }

    public void initFromOdFile(ISrcContent pSource) throws Exception {
        this.close();
        if (pSource.getContentStatus() == 1) {
            ZipFile vZipFile = this.getZipFile(pSource);
            this.initFromZip(vZipFile);
        }
    }

    public void initFromOdFile(File pSource) throws Exception {
        this.close();
        if (pSource.isFile()) {
            ZipFile vZipFile = this.getZipFile(pSource);
            this.initFromZip(vZipFile);
        }
    }

    protected void initFromZip(ZipFile pZipFile) throws IOException, SAXException, Exception, UnsupportedEncodingException {
        ManifestSaxHandler vManifest = this.getManifest(pZipFile);
        this.fMainMime = vManifest.getMime("/");
        Enumeration<? extends ZipEntry> vEnum = pZipFile.entries();
        while (vEnum.hasMoreElements()) {
            String vMime;
            ZipEntry vEntry = vEnum.nextElement();
            String vOdPath = vEntry.getName();
            if (vOdPath.charAt(0) == '/') {
                vOdPath = vOdPath.substring(1);
            }
            if (vOdPath.equals(ODPATH_MANIFEST) || vOdPath.startsWith(ODPATH_THUMBNAILS)) continue;
            if (vOdPath.equals(ODPATH_MIMETYPE)) {
                if (this.fMainMime != null && this.fMainMime.length() != 0) continue;
                this.fMainMime = StreamUtils.buildString(new InputStreamReader(pZipFile.getInputStream(vEntry), "UTF-8"), 50);
                continue;
            }
            if (vOdPath.charAt(vOdPath.length() - 1) == '/') {
                vMime = vManifest.getMime(vOdPath);
                this.fEntries.put(vOdPath, vMime);
                continue;
            }
            vMime = vManifest.getMime(vOdPath);
            this.fEntries.put(vOdPath, new FileFromOdZip(pZipFile, vEntry, vMime));
        }
    }

    protected ZipFile getZipFile(ISrcContent pSource) throws IOException, Exception {
        ZipFile vZipFile = new ZipFile(SrcFeatureAlternateUrl.getFilePath(pSource));
        if (this.fZipFilesToClose == null) {
            this.fZipFilesToClose = new ArrayList();
        }
        this.fZipFilesToClose.add(vZipFile);
        return vZipFile;
    }

    protected ZipFile getZipFile(File pSource) throws IOException, Exception {
        ZipFile vZipFile = new ZipFile(pSource.getPath());
        if (this.fZipFilesToClose == null) {
            this.fZipFilesToClose = new ArrayList();
        }
        this.fZipFilesToClose.add(vZipFile);
        return vZipFile;
    }

    protected ManifestSaxHandler getManifest(ZipFile pZipFile) throws Exception {
        ManifestSaxHandler vManifest = new ManifestSaxHandler();
        ZipEntry vManifestEntry = pZipFile.getEntry(ODPATH_MANIFEST);
        if (vManifestEntry != null) {
            XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
            vXmlReader.setContentHandler(vManifest);
            vXmlReader.parse(new InputSource(pZipFile.getInputStream(vManifestEntry)));
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
        return vManifest;
    }

    public void removeFile(String pOdPath) throws Exception {
        if (pOdPath.startsWith("/")) {
            pOdPath = pOdPath.substring(1);
        }
        this.fEntries.remove(pOdPath);
    }

    public void removeFolder(String pOdPath) throws Exception {
        if (pOdPath.startsWith("/")) {
            pOdPath = pOdPath.substring(1);
        }
        if (!pOdPath.endsWith("/")) {
            pOdPath = pOdPath.concat("/");
        }
        this.fEntries.remove(pOdPath);
        Iterator vIt = this.fEntries.keySet().iterator();
        while (vIt.hasNext()) {
            String vPath = (String)vIt.next();
            if (!vPath.startsWith(pOdPath)) continue;
            vIt.remove();
        }
    }

    public void addFile(String pOdPath, ISrcContent pFile) throws Exception {
        if (pOdPath.startsWith("/")) {
            pOdPath = pOdPath.substring(1);
        }
        this.fEntries.put(pOdPath, pFile);
    }

    public void addFileOrFolder(String pOdPath, ISrcNode pFile, String pMimeType) throws Exception {
        int vStatus;
        if (pOdPath.startsWith("/")) {
            pOdPath = pOdPath.substring(1);
        }
        if ((vStatus = pFile.getContentStatus()) == 2) {
            if (pOdPath.length() > 0) {
                if (!pOdPath.endsWith("/")) {
                    pOdPath = pOdPath.concat("/");
                }
                this.fEntries.put(pOdPath, pMimeType == null ? "" : pMimeType);
            }
            ArrayList<ISrcNode> vChilds = new ArrayList<ISrcNode>();
            pFile.listChildrenNodes(vChilds);
            for (int i = 0; i < vChilds.size(); ++i) {
                ISrcNode vCh = vChilds.get(i);
                this.addFileOrFolder(pOdPath.concat(vCh.getSrcName()), vCh, null);
            }
        } else if (vStatus == 1) {
            if (pOdPath.endsWith("/")) {
                pOdPath = pOdPath.substring(0, pOdPath.length() - 1);
            }
            this.fEntries.put(pOdPath, pFile);
        }
    }

    public void addEmptyFolder(String pOdPath, String pMimeType) throws Exception {
        if (!pOdPath.endsWith("/")) {
            pOdPath = pOdPath.concat("/");
        }
        this.fEntries.put(pOdPath, pMimeType == null ? "" : pMimeType);
    }

    public void includeOd(String pOdPath, ISrcContent pSource, boolean pRemoveSettings) throws Exception {
        if (pSource.getContentStatus() == 1) {
            if (!pOdPath.endsWith("/")) {
                pOdPath = pOdPath.concat("/");
            }
            ZipFile vZipFile = this.getZipFile(pSource);
            ManifestSaxHandler vManifest = this.getManifest(vZipFile);
            String vMainMime = vManifest.getMime("/");
            Enumeration<? extends ZipEntry> vEnum = vZipFile.entries();
            while (vEnum.hasMoreElements()) {
                String vMime;
                ZipEntry vEntry = vEnum.nextElement();
                String vOdPath = vEntry.getName();
                if (vOdPath.charAt(0) == '/') {
                    vOdPath = vOdPath.substring(1);
                }
                if (!(vOdPath.startsWith(ODPATH_METAINF) || vOdPath.startsWith(ODPATH_THUMBNAILS) || pRemoveSettings && vOdPath.startsWith(ODPATH_SETTINGS))) {
                    if (vOdPath.equals(ODPATH_MIMETYPE)) {
                        if (vMainMime == null || vMainMime.length() == 0) {
                            vMainMime = StreamUtils.buildString(new InputStreamReader(vZipFile.getInputStream(vEntry), "UTF-8"), 50);
                        }
                    } else if (vOdPath.charAt(vOdPath.length() - 1) == '/') {
                        vMime = vManifest.getMime(vOdPath);
                        this.fEntries.put(pOdPath.concat(vOdPath), vMime);
                    } else {
                        vMime = vManifest.getMime(vOdPath);
                        this.fEntries.put(pOdPath.concat(vOdPath), new FileFromOdZip(vZipFile, vEntry, vMime));
                    }
                }
                while (vOdPath.indexOf(47) > 0) {
                    if (vOdPath.charAt(vOdPath.length() - 1) == '/') {
                        vMime = vManifest.getMime(vOdPath);
                        if (vMime != null) {
                            this.fEntries.put(pOdPath.concat(vOdPath), vMime);
                        }
                        vOdPath = vOdPath.substring(0, vOdPath.substring(0, vOdPath.length() - 1).lastIndexOf(47) + 1);
                        continue;
                    }
                    vOdPath = vOdPath.substring(0, vOdPath.lastIndexOf(47) + 1);
                }
            }
            if (vMainMime != null) {
                this.fEntries.put(pOdPath, vMainMime);
            }
        }
    }

    public void includeOd(String pOdPath, OdFile pSubOd, boolean pRemoveSettings) throws Exception {
        if (pSubOd != null) {
            if (!pOdPath.endsWith("/")) {
                pOdPath = pOdPath.concat("/");
            }
            String vMainMime = pSubOd.getMainMime();
            for (Map.Entry vEntry : pSubOd.fEntries.entrySet()) {
                String vOdPath = (String)vEntry.getKey();
                if (vOdPath.startsWith(ODPATH_METAINF) || vOdPath.startsWith(ODPATH_THUMBNAILS) || pRemoveSettings && vOdPath.startsWith(ODPATH_SETTINGS)) continue;
                if (vOdPath.equals(ODPATH_MIMETYPE)) {
                    if (vMainMime != null && vMainMime.length() != 0) continue;
                    ISrcContent vEntryContent = (ISrcContent)vEntry.getValue();
                    vMainMime = StreamUtils.buildString(new InputStreamReader(vEntryContent.newInputStream(false), "UTF-8"), 50);
                    continue;
                }
                if (vOdPath.charAt(vOdPath.length() - 1) == '/') {
                    this.fEntries.put(pOdPath.concat(vOdPath), vEntry.getValue());
                    continue;
                }
                this.fEntries.put(pOdPath.concat(vOdPath), vEntry.getValue());
            }
            if (vMainMime != null) {
                this.fEntries.put(pOdPath, vMainMime);
            }
        }
    }

    public ISrcContent getSourceEntry(String pOdPath) {
        if (pOdPath.startsWith("/")) {
            pOdPath = pOdPath.substring(1);
        }
        if (pOdPath.endsWith("/")) {
            return null;
        }
        return (ISrcContent)this.fEntries.get(pOdPath);
    }

    public String getMainMime() {
        return this.fMainMime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(ISrcContent pDest) throws Exception {
        ZipOutputStream vOut = null;
        try {
            vOut = new ZipOutputStream(pDest.newOutputStream(false));
            this.export(vOut);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            vOut.close();
            throw throwable;
        }
        vOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(File pDest) throws Exception {
        ZipOutputStream vOut = null;
        try {
            vOut = new ZipOutputStream(new FileOutputStream(pDest));
            this.export(vOut);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            vOut.close();
            throw throwable;
        }
        vOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(OutputStream pDest) throws Exception {
        ZipOutputStream vOut = null;
        try {
            vOut = new ZipOutputStream(pDest);
            this.export(vOut);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            vOut.close();
            throw throwable;
        }
        vOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(ZipOutputStream pOut) throws Exception {
        try {
            long vTime = System.currentTimeMillis();
            OutputStreamBlob vManifestBuffer = new OutputStreamBlob();
            XmlWriterAppendable vManifestWriter = new XmlWriterAppendable(new OutputStreamWriter((OutputStream)vManifestBuffer, "UTF-8"));
            vManifestWriter.writeHeaderXml("UTF-8");
            vManifestWriter.writeXmlFragment("<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\">\n");
            vManifestWriter.writeStartTag("manifest:manifest");
            vManifestWriter.writeAttribute("xmlns:manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
            vManifestWriter.writeEndOpenTag();
            this.fEntries.remove(ODPATH_METAINF);
            this.addFolderInDstZip(pOut, ODPATH_METAINF, vTime);
            this.fEntries.remove(ODPATH_MANIFEST);
            this.addManifestEntryInDst(vManifestWriter, "/", this.fMainMime);
            this.fEntries.remove(ODPATH_MIMETYPE);
            byte[] vMimeBytes = this.fMainMime.getBytes();
            ByteArrayInputStream vMimeStream = new ByteArrayInputStream(vMimeBytes);
            long vCrc = this.getCrc(vMimeStream);
            vMimeStream = new ByteArrayInputStream(vMimeBytes);
            this.addFileStoredInDstZip(pOut, ODPATH_MIMETYPE, vMimeStream, vMimeBytes.length, vTime, vCrc);
            this.addManifestEntryInDst(vManifestWriter, ODPATH_META, "text/xml");
            ISrcContent vMetaSrc = (ISrcContent)this.fEntries.remove(ODPATH_META);
            if (vMetaSrc != null) {
                InputStream vMetaStream = vMetaSrc.newInputStream(false);
                try {
                    this.addFileInDstZip(pOut, ODPATH_META, vMetaSrc.newInputStream(false), vTime);
                    Object var13_10 = null;
                }
                catch (Throwable throwable) {
                    Object var13_11 = null;
                    vMetaStream.close();
                    throw throwable;
                }
                vMetaStream.close();
                {
                }
            }
            for (Map.Entry vMapEntry : this.fEntries.entrySet()) {
                String vOdPath = (String)vMapEntry.getKey();
                if (vOdPath.charAt(vOdPath.length() - 1) == '/') {
                    this.addManifestEntryInDst(vManifestWriter, vOdPath, (String)vMapEntry.getValue());
                    this.addFolderInDstZip(pOut, vOdPath, vTime);
                    continue;
                }
                ISrcContent vSrc = (ISrcContent)vMapEntry.getValue();
                String vMime = MimeMgr.extractMimeFromContentType(vSrc.getContentType());
                if (vMime == null || vMime.length() == 0) {
                    vMime = MimeMgr.getDefaultMimeMgr().searchMimeFromUrl(vOdPath);
                }
                this.addManifestEntryInDst(vManifestWriter, vOdPath, vMime);
                this.addFileInDstZip(pOut, vOdPath, vSrc.newInputStream(false), vTime);
            }
            vManifestWriter.writeCloseTag("manifest:manifest");
            vManifestWriter.close();
            this.addFileInDstZip(pOut, ODPATH_MANIFEST, vManifestBuffer.getInputStream(false), vTime);
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            pOut.close();
            throw throwable;
        }
        pOut.close();
    }

    protected void addFolderInDstZip(ZipOutputStream pOut, String pOdPath, long pTime) throws Exception {
        ZipEntry vEntry = new ZipEntry(pOdPath);
        vEntry.setTime(pTime);
        vEntry.setSize(0L);
        vEntry.setMethod(0);
        vEntry.setCrc(0L);
        pOut.putNextEntry(vEntry);
    }

    protected void addManifestEntryInDst(IXmlWriter pManifestWriter, String pOdPath, String pMimeType) throws Exception {
        pManifestWriter.writeStartTag("manifest:file-entry");
        pManifestWriter.writeAttribute("manifest:media-type", pMimeType == null ? "" : pMimeType);
        pManifestWriter.writeAttribute("manifest:full-path", pOdPath);
        pManifestWriter.writeEndEmptyTag();
    }

    protected void addFileInDstZip(ZipOutputStream pOut, String pOdPath, InputStream pSource, long pTime) throws Exception {
        try {
            ZipEntry vEntry = new ZipEntry(pOdPath);
            vEntry.setTime(pTime);
            pOut.putNextEntry(vEntry);
            StreamUtils.write(pSource, pOut);
            pOut.closeEntry();
        }
        catch (Exception e) {
            pSource.close();
            throw e;
        }
    }

    protected void addFileStoredInDstZip(ZipOutputStream pOut, String pOdPath, InputStream pSource, long pSize, long pTime, long pCrc) throws Exception, IOException {
        try {
            ZipEntry vEntry = new ZipEntry(pOdPath);
            vEntry.setTime(pTime);
            vEntry.setMethod(0);
            vEntry.setSize(pSize);
            vEntry.setCrc(pCrc);
            pOut.putNextEntry(vEntry);
            StreamUtils.write(pSource, pOut);
            pOut.closeEntry();
        }
        catch (Exception e) {
            pSource.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCrc(InputStream pIn) throws Exception {
        CRC32 vCrc = new CRC32();
        byte[] vBuf = PoolBuffers.popBytes4096();
        try {
            while (true) {
                int vRead;
                if ((vRead = pIn.read(vBuf, 0, 4096)) > 0) {
                    vCrc.update(vBuf, 0, vRead);
                    continue;
                }
                if (vRead < 0) break;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            PoolBuffers.freeBytes(vBuf);
            throw throwable;
        }
        PoolBuffers.freeBytes(vBuf);
        return vCrc.getValue();
    }

    public void close() throws Exception {
        this.fEntries.clear();
        if (this.fZipFilesToClose != null) {
            for (int i = 0; i < this.fZipFilesToClose.size(); ++i) {
                ZipFile vZip = (ZipFile)this.fZipFilesToClose.get(i);
                vZip.close();
            }
            this.fZipFilesToClose = null;
        }
    }

    public static class FileFromOdZip
    extends SrcContentFileBase {
        protected ZipFile fZipFile = null;
        protected ZipEntry fZipEntry = null;
        protected String fMimeType = null;

        public FileFromOdZip(ZipFile pZipFile, ZipEntry pZipEntry, String pMimeType) {
            this.fZipFile = pZipFile;
            this.fZipEntry = pZipEntry;
            this.fMimeType = pMimeType;
        }

        public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
            return this.fZipFile.getInputStream(this.fZipEntry);
        }

        public int getContentSize() throws Exception {
            return (int)this.fZipEntry.getSize();
        }

        public String getContentType() throws Exception {
            return this.fMimeType;
        }
    }

    public static class ManifestSaxHandler
    extends DefaultHandler {
        HashMap fMap = new HashMap();

        public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAtts) throws SAXException {
            String vNs = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
            if (pLocalName.equals("file-entry")) {
                String vPath = pAtts.getValue("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "full-path");
                String vMime = pAtts.getValue("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "media-type");
                if (vPath != null && vMime != null && vPath.length() > 1 && vMime.length() > 0) {
                    this.fMap.put(vPath, vMime);
                }
            }
        }

        public String getMime(String pOdPath) {
            return (String)this.fMap.get(pOdPath);
        }
    }
}

