/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.oo;

import com.scenari.s.co.transform.oo.HTransformerOo;
import com.scenari.s.co.transform.oo.IOoConnection;
import com.scenari.s.co.transform.oo.IOoConnectionPool;
import com.scenari.s.fw.properties.loaders.xml.HInitAppSaxHandlerBase;
import eu.scenari.fw.initapp.SystemPropsParser;
import java.io.File;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;

public class OoConnectionPoolLoader
extends HInitAppSaxHandlerBase {
    public static final String TAG_CONNECTIONPOOL = "ooConnectionPool";
    public static final String TAG_CONNECTION = "ooConnection";
    public static final String TAG_CONN_ATT_HOST = "host";
    public static final String TAG_CONN_ATT_PORT = "port";
    public static final String TAG_CONN_ATT_PIPEMODE = "pipeMode";
    public static final String TAG_CONN_ATT_PIPENAME = "pipeName";
    public static final String TAG_CONN_ATT_AUTOLAUCNH = "autoLaunch";
    public static final String TAG_CONN_ATT_AUTOKILL = "autoKill";
    public static final String TAG_CONN_ATT_MAXCNXATTEMPTS = "maxCnxAttempts";
    public static final String TAG_CONN_ATT_RECHECKINTERVAL = "reCheckInterval";
    public static final String TAG_CONN_ATT_PROFILEPATH = "profilePath";
    public static final String TAG_CONN_ATT_PROFILEFILEPATH = "profileFilePath";
    public static final String TAG_CONN_ATT_HEADLESS = "headless";
    public static final String TAG_POOL_ATT_LOCALTEMPDIR = "localTempDir";
    public static final String TAG_POOL_ATT_LOCALTODISTPATHREGEX = "localToDistPathRegex";
    public static final String TAG_POOL_ATT_LOCALTODISTPATHREPL = "localToDistPathRepl";
    public static final String CLASS_CONNECTIONPOOL = "com.scenari.s.co.transform.oo.impl.OoConnectionPool";
    protected IOoConnectionPool fPool = null;

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        if (this.isRootElt()) {
            String vLocalToDistPathRepl;
            String vLocalToDistPathRegex;
            ClassLoader vClsLoader = HTransformerOo.getOoClassLoader();
            Class<?> vPoolCls = vClsLoader.loadClass(CLASS_CONNECTIONPOOL);
            this.fPool = (IOoConnectionPool)vPoolCls.getDeclaredMethod("get", null).invoke(null, (Object[])null);
            String vTempDir = pAttributes.getValue(TAG_POOL_ATT_LOCALTEMPDIR);
            if (vTempDir != null) {
                this.fPool.setLocaltempDir(SystemPropsParser.replaceProps(vTempDir));
            }
            if ((vLocalToDistPathRegex = pAttributes.getValue(TAG_POOL_ATT_LOCALTODISTPATHREGEX)) != null) {
                this.fPool.setLocalToDistPathRegex(vLocalToDistPathRegex);
            }
            if ((vLocalToDistPathRepl = pAttributes.getValue(TAG_POOL_ATT_LOCALTODISTPATHREPL)) != null) {
                this.fPool.setLocalToDistPathRepl(SystemPropsParser.replaceProps(vLocalToDistPathRepl));
            }
        } else if (pLocalName == TAG_CONNECTION) {
            String vProfilePath;
            String vReCheckInterval;
            String vMaxCnxAttempts;
            String vAutoKill;
            String vAutoLaunch;
            String vPipeMode;
            String vPipeName;
            String vPort;
            IOoConnection vCon = this.fPool.createConnection();
            String vHost = pAttributes.getValue(TAG_CONN_ATT_HOST);
            if (vHost != null) {
                vCon.setHost(vHost);
            }
            if ((vPort = pAttributes.getValue(TAG_CONN_ATT_PORT)) != null) {
                vCon.setPort(Integer.parseInt(vPort));
            }
            if ((vPipeName = pAttributes.getValue(TAG_CONN_ATT_PIPENAME)) != null) {
                vCon.setPipeName(vPipeName);
            }
            if ((vPipeMode = pAttributes.getValue(TAG_CONN_ATT_PIPEMODE)) != null) {
                vCon.setPipeMode(Boolean.parseBoolean(vPipeMode));
            }
            if ((vAutoLaunch = pAttributes.getValue(TAG_CONN_ATT_AUTOLAUCNH)) != null) {
                vCon.setAutoLaunch(Boolean.parseBoolean(vAutoLaunch));
            }
            if ((vAutoKill = pAttributes.getValue(TAG_CONN_ATT_AUTOLAUCNH)) != null) {
                vCon.setAutoKill(Boolean.parseBoolean(vAutoKill));
            }
            if ((vMaxCnxAttempts = pAttributes.getValue(TAG_CONN_ATT_MAXCNXATTEMPTS)) != null) {
                vCon.setMaxCnxAttempts(Integer.parseInt(vMaxCnxAttempts));
            }
            if ((vReCheckInterval = pAttributes.getValue(TAG_CONN_ATT_RECHECKINTERVAL)) != null) {
                vCon.setReCheckInterval(Long.parseLong(vReCheckInterval));
            }
            if ((vProfilePath = pAttributes.getValue(TAG_CONN_ATT_PROFILEPATH)) != null) {
                vCon.setProfilePath(vProfilePath);
            } else {
                String vProfileFilePath = pAttributes.getValue(TAG_CONN_ATT_PROFILEFILEPATH);
                if (vProfileFilePath != null) {
                    File vProfile = new File(SystemPropsParser.replaceProps(vProfileFilePath)).getCanonicalFile();
                    if (!vProfile.isDirectory()) {
                        vProfile.mkdirs();
                    }
                    String vOoPath = vProfile.toURI().toURL().toExternalForm();
                    vOoPath = Pattern.compile("^(file:/)").matcher(vOoPath).replaceFirst("file:///");
                    vCon.setProfilePath(vOoPath);
                }
            }
            String vHeadless = pAttributes.getValue(TAG_CONN_ATT_HEADLESS);
            if (vHeadless != null) {
                vCon.setHeadless(Boolean.parseBoolean(vHeadless));
            }
            this.fPool.addConnectionToPool(vCon);
        } else {
            return false;
        }
        return true;
    }
}

