/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.oo;

import com.sun.star.lib.loader.WinRegKey;
import com.sun.star.lib.loader.WinRegKeyException;
import eu.scenari.fw.initapp.SystemProps;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public final class OoFinder {
    private static final String SYSPROP_NAME = "com.sun.star.lib.loader.unopath";
    private static final String ENVVAR_NAME = "UNO_PATH";
    private static final String SOFFICE = "soffice";
    private static final String SOFFICEBIN = "soffice.bin";
    protected static String sOoPath = null;

    private OoFinder() {
    }

    public static String getPath() {
        if (sOoPath != null) {
            return sOoPath;
        }
        sOoPath = OoFinder.getPathFromProperty(SYSPROP_NAME);
        if (sOoPath == null && (sOoPath = OoFinder.getPathFromEnvVar(ENVVAR_NAME)) == null) {
            String vOsName = null;
            try {
                vOsName = System.getProperty("os.name").toLowerCase();
            }
            catch (SecurityException e) {
                return null;
            }
            if (vOsName != null) {
                if (vOsName.startsWith("windows")) {
                    sOoPath = OoFinder.getPathFromWindowsRegistry();
                } else if (vOsName.startsWith("mac os x")) {
                    sOoPath = OoFinder.getPathFromLaunchServices();
                    if (sOoPath == null) {
                        sOoPath = OoFinder.getPathFromCommonPlacesMac();
                    }
                } else {
                    sOoPath = OoFinder.getPathFromPathEnvVar();
                    if (sOoPath == null && (sOoPath = OoFinder.getPathFromWhich()) == null && (sOoPath = OoFinder.getPathFromLocate()) == null) {
                        sOoPath = OoFinder.getPathFromCommonPlacesUnix();
                    }
                }
            }
        }
        return sOoPath;
    }

    private static String getPathFromProperty(String prop) {
        String vPath = null;
        try {
            vPath = SystemProps.getProperty(prop);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (vPath != null) {
            LogMgr.publishTrace("OpenOffice defined by System property. '" + prop + "' in: " + vPath.toString(), ILogMsg.LogType.Info, new String[0]);
        }
        return vPath;
    }

    private static String getPathFromEnvVar(String var) {
        String vPath = null;
        try {
            vPath = System.getenv(var);
        }
        catch (SecurityException e) {
        }
        catch (Error error) {
            // empty catch block
        }
        if (vPath != null) {
            LogMgr.publishTrace("OpenOffice defined by env. var. '" + var + "' in: " + vPath.toString(), ILogMsg.LogType.Info, new String[0]);
        }
        return vPath;
    }

    private static String getPathFromWindowsRegistry() {
        String SUBKEYNAME = "Software\\OpenOffice.org\\UNO\\InstallPath";
        String vPath = null;
        try {
            WinRegKey vKey = new WinRegKey("HKEY_CURRENT_USER", "Software\\OpenOffice.org\\UNO\\InstallPath");
            vPath = vKey.getStringValue("");
        }
        catch (WinRegKeyException e) {
            try {
                WinRegKey vKey = new WinRegKey("HKEY_LOCAL_MACHINE", "Software\\OpenOffice.org\\UNO\\InstallPath");
                vPath = vKey.getStringValue("");
            }
            catch (WinRegKeyException we) {
                System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWindowsRegistry: reading key from Windows Registry failed: " + (Object)((Object)we));
            }
        }
        return vPath;
    }

    private static String getPathFromPathEnvVar() {
        String PATH_ENVVAR_NAME = "PATH";
        String vPath = null;
        String vStr = null;
        try {
            vStr = System.getenv("PATH");
        }
        catch (SecurityException e) {
            return null;
        }
        catch (Error err) {
            return null;
        }
        if (vStr != null) {
            StringTokenizer vTokens = new StringTokenizer(vStr, File.pathSeparator);
            while (vTokens.hasMoreTokens()) {
                File vSoffice = new File(vTokens.nextToken(), SOFFICE);
                try {
                    if (!vSoffice.exists()) continue;
                    try {
                        File vSofficeBin;
                        String vTmpPath = vSoffice.getCanonicalFile().getParent();
                        if (vTmpPath == null || !(vSofficeBin = new File(vTmpPath, SOFFICEBIN)).exists()) continue;
                        vPath = vTmpPath;
                        break;
                    }
                    catch (IOException e) {
                        System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromEnvVar: bad path: " + e);
                    }
                }
                catch (SecurityException e) {}
            }
        }
        if (vPath != null) {
            LogMgr.publishTrace("OpenOffice found by env. var. 'PATH' in: " + vPath.toString(), ILogMsg.LogType.Info, new String[0]);
        }
        return vPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPathFromWhich() {
        WHICH = "which";
        vPath = null;
        vCmdArray = new String[]{"which", "soffice"};
        vProc = null;
        vRt = Runtime.getRuntime();
        try {
            vProc = vRt.exec(vCmdArray);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (IOException e) {
            System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWhich: which command failed: " + e);
            return null;
        }
        vGobbler = new StreamGobbler(vProc.getErrorStream());
        vGobbler.start();
        vBr = new BufferedReader(new InputStreamReader(vProc.getInputStream()));
        vLine = null;
        block16: while (true) {
            try {
                try {}
                catch (IOException e) {
                    System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWhich: reading which command output failed: " + e);
                    var9_14 = null;
                    var15_22 = null;
                    if (vBr == null) return var9_14;
                    try {
                        vBr.close();
                        return var9_14;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return var9_14;
                }
            }
            catch (Throwable var14_28) {
                var15_23 = null;
                if (vBr == null) throw var14_28;
                ** try [egrp 4[TRYBLOCK] [9 : 311->319)] { 
lbl39:
                // 1 sources

                vBr.close();
                throw var14_28;
lbl41:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var14_28;
            }
            while (true) {
                if ((vLine = vBr.readLine()) != null) {
                    if (vPath != null || (vIndex = vLine.lastIndexOf("soffice")) == -1) continue;
                } else {
                    var15_21 = null;
                    if (vBr != null) {
                        try {}
                        catch (IOException e) {}
                        vBr.close();
                    }
                    try {
                        vProc.waitFor();
                    }
                    catch (InterruptedException e) {
                        vProc.destroy();
                        Thread.currentThread().interrupt();
                    }
                    if (vPath == null) return vPath;
                    LogMgr.publishTrace("OpenOffice found by 'which' in: " + vPath.toString(), ILogMsg.LogType.Info, new String[0]);
                    return vPath;
                }
                vEnd = vIndex + "soffice".length();
                i = 0;
                while (true) {
                    block23: {
                        if (i > vIndex) ** break;
                        vSoffice = new File(vLine.substring(i, vEnd));
                        try {
                            if (!vSoffice.exists() || (vTmpPath = vSoffice.getCanonicalFile().getParent()) == null || !(vSofficeBin = new File(vTmpPath, "soffice.bin")).exists()) break block23;
                            vPath = vTmpPath;
                            continue block16;
                        }
                        catch (SecurityException e) {
                            var13_19 = null;
                            var15_20 = null;
                            if (vBr == null) return var13_19;
                            ** try [egrp 4[TRYBLOCK] [9 : 311->319)] { 
lbl80:
                            // 1 sources

                            vBr.close();
                            return var13_19;
lbl82:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            return var13_19;
                        }
                    }
                    ++i;
                }
                break;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPathFromLocate() {
        LOCATE = "locate";
        vPath = null;
        vCmdArray = new String[]{"locate", "soffice.bin"};
        vProc = null;
        vRt = Runtime.getRuntime();
        try {
            vProc = vRt.exec(vCmdArray);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (IOException e) {
            System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromLocate: locate command failed: " + e);
            return null;
        }
        vGobbler = new StreamGobbler(vProc.getErrorStream());
        vGobbler.start();
        vBr = new BufferedReader(new InputStreamReader(vProc.getInputStream()));
        vLine = null;
        block16: while (true) {
            try {
                try {}
                catch (IOException e) {
                    System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromLocate: reading locate command output failed: " + e);
                    var9_14 = null;
                    var15_21 = null;
                    if (vBr == null) return var9_14;
                    try {
                        vBr.close();
                        return var9_14;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return var9_14;
                }
            }
            catch (Throwable var14_27) {
                var15_22 = null;
                if (vBr == null) throw var14_27;
                ** try [egrp 4[TRYBLOCK] [9 : 285->293)] { 
lbl39:
                // 1 sources

                vBr.close();
                throw var14_27;
lbl41:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var14_27;
            }
            while (true) {
                if ((vLine = vBr.readLine()) != null) {
                    if (vPath != null || (vIndex = vLine.lastIndexOf("soffice.bin")) == -1) continue;
                } else {
                    var15_20 = null;
                    if (vBr != null) {
                        try {}
                        catch (IOException e) {}
                        vBr.close();
                    }
                    try {
                        vProc.waitFor();
                    }
                    catch (InterruptedException e) {
                        vProc.destroy();
                        Thread.currentThread().interrupt();
                    }
                    if (vPath == null) return vPath;
                    LogMgr.publishTrace("OpenOffice found by 'locate' in: " + vPath.toString(), ILogMsg.LogType.Info, new String[0]);
                    return vPath;
                }
                vEnd = vIndex + "soffice.bin".length();
                i = 0;
                while (true) {
                    block23: {
                        if (i > vIndex) ** break;
                        vFile = new File(vLine.substring(i, vEnd));
                        try {
                            if (!vFile.exists() || (vPath = vFile.getCanonicalFile().getParent()) == null) break block23;
                            continue block16;
                        }
                        catch (SecurityException e) {
                            var13_18 = null;
                            var15_19 = null;
                            if (vBr == null) return var13_18;
                            ** try [egrp 4[TRYBLOCK] [9 : 285->293)] { 
lbl79:
                            // 1 sources

                            vBr.close();
                            return var13_18;
lbl81:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            return var13_18;
                        }
                    }
                    ++i;
                }
                break;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPathFromLaunchServices() {
        String vPath;
        block19: {
            String vLine;
            BufferedReader vBr;
            File vScriptFile;
            block18: {
                String LSREG_PATHS = "/System/Library/Frameworks/CoreServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support:/System/Library/Frameworks/ApplicationServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support";
                String LSREG_BIN = "lsregister";
                String LSREG_ARGS = " -dump | grep -B 2 org.openoffice.script | grep path: | grep -o /.*$ | sort -fr";
                vPath = null;
                File vLsregBin = null;
                StringTokenizer vLsregTokens = new StringTokenizer("/System/Library/Frameworks/CoreServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support:/System/Library/Frameworks/ApplicationServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support", File.pathSeparator);
                while (vLsregTokens.hasMoreTokens()) {
                    vLsregBin = new File(vLsregTokens.nextToken(), "lsregister");
                    try {
                        if (!vLsregBin.exists()) continue;
                        break;
                    }
                    catch (SecurityException e) {
                    }
                }
                if (vLsregBin.exists()) {
                    vScriptFile = null;
                    try {
                        vScriptFile = File.createTempFile("lsregister", "");
                        FileWriter vScriptWriter = new FileWriter(vScriptFile);
                        vScriptWriter.write(vLsregBin.getPath() + " -dump | grep -B 2 org.openoffice.script | grep path: | grep -o /.*$ | sort -fr");
                        vScriptWriter.close();
                    }
                    catch (IOException e) {
                        System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromLaunchServices: Cannot create temp file.: " + e);
                        return null;
                    }
                    String[] vCmdArray = new String[]{"/bin/sh", vScriptFile.getPath()};
                    Process vProc = null;
                    Runtime vRt = Runtime.getRuntime();
                    try {
                        vProc = vRt.exec(vCmdArray);
                    }
                    catch (Exception e) {
                        System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromLaunchServices: lsregister command failed: " + e);
                        return null;
                    }
                    StreamGobbler vGobbler = new StreamGobbler(vProc.getErrorStream());
                    vGobbler.start();
                    vBr = new BufferedReader(new InputStreamReader(vProc.getInputStream()));
                    vLine = null;
                    try {
                        try {}
                        catch (Exception e) {
                            System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromLaunchServices: Exception while testing paths : " + e);
                            String string = null;
                            Object var16_20 = null;
                            if (vScriptFile == null) return string;
                            vScriptFile.delete();
                            return string;
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var16_21 = null;
                        if (vScriptFile != null) {
                            vScriptFile.delete();
                        }
                        throw throwable;
                    }
                }
                System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromLaunchServices: lsregister cannot be found.");
                break block19;
            }
            while ((vLine = vBr.readLine()) != null) {
                if (vLine.startsWith("/Volumes") || vLine.indexOf("/.Trash/") != -1) continue;
                try {
                    File vOOBinPath = new File(vLine, "Contents/MacOS/soffice.bin");
                    if (!vOOBinPath.exists()) continue;
                    vPath = vOOBinPath.getParentFile().getPath();
                    break;
                }
                catch (Exception e) {
                    System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromLaunchServices: Exception while testing path " + vLine + " : " + e);
                }
            }
            Object var16_19 = null;
            if (vScriptFile != null) {
                vScriptFile.delete();
            }
        }
        if (vPath != null) {
            LogMgr.publishTrace("OpenOffice found by 'LaunchServices' in: " + vPath.toString(), ILogMsg.LogType.Info, new String[0]);
        }
        return vPath;
    }

    private static String getPathFromCommonPlaces(String pPath) {
        String vPath = null;
        StringTokenizer vTokens = new StringTokenizer(pPath, File.pathSeparator);
        while (vTokens.hasMoreTokens()) {
            File vFile = new File(vTokens.nextToken(), SOFFICEBIN);
            try {
                if (!vFile.exists()) continue;
                try {
                    vPath = vFile.getCanonicalFile().getParent();
                    if (vPath == null) continue;
                    break;
                }
                catch (IOException e) {
                    System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromEnvVar: bad path: " + e);
                }
            }
            catch (SecurityException e) {}
        }
        return vPath;
    }

    private static String getPathFromCommonPlacesUnix() {
        String vPath = null;
        String vPaths = "/opt/openoffice.org3/program:/opt/openoffice.org2.4/program:/opt/openoffice.org2.3/program:/opt/openoffice.org2.2/program:/opt/openoffice.org2.1/program:/opt/openoffice.org2.0/program";
        vPath = OoFinder.getPathFromCommonPlaces(vPaths);
        if (vPath == null) {
            vPaths = "/usr/lib/openoffice/program:/usr/lib/openoffice2/program:/usr/lib/openoffice.org/program:/usr/lib/openoffice.org3.0/program:/usr/lib/openoffice.org2.4/program:/usr/lib/openoffice.org2.3/program:/usr/lib/openoffice.org2.2/program:/usr/lib/openoffice.org2.1/program:/usr/lib/openoffice.org2.0/program";
            vPaths = vPaths + ":/usr/lib/ooo-3.0/program:/usr/lib/ooo-2.4/program:/usr/lib/ooo-2.3/program:/usr/lib/ooo-2.2/program:/usr/lib/ooo-2.1/program:/usr/lib/ooo-2.0/program";
            vPath = OoFinder.getPathFromCommonPlaces(vPaths);
        }
        if (vPath != null) {
            LogMgr.publishTrace("OpenOffice found by looking in common paths in: " + vPath.toString(), ILogMsg.LogType.Info, new String[0]);
        }
        return vPath;
    }

    private static String getPathFromCommonPlacesMac() {
        String vPath = null;
        String vPaths = "/Applications/OpenOffice.org.app/Contents/MacOS:/Applications/OpenOffice.org 3.0.app/Contents/MacOS:/Applications/OpenOffice.org 2.4.app/Contents/MacOS:/Applications/OpenOffice.org 2.3.app/Contents/MacOS:/Applications/OpenOffice.org 2.2.app/Contents/MacOS/program:/Applications/OpenOffice.org 2.1.app/Contents/MacOS/program:/Applications/OpenOffice.org 2.0.app/Contents/MacOS/program:/Applications/OpenOffice.org 2.0.app/Contents/openoffice.org/program:/Applications/NeoOffice.app/Contents/program";
        vPath = OoFinder.getPathFromCommonPlaces(vPaths);
        if (vPath != null) {
            LogMgr.publishTrace("OpenOffice found by looking in common paths in: " + vPath.toString(), ILogMsg.LogType.Info, new String[0]);
        }
        return vPath;
    }

    public static String getCanonicalPathFromFileURL(String oooUrl) {
        String ret;
        block23: {
            URL url;
            String host;
            String prefix = "file://";
            if (oooUrl.length() < prefix.length() || !oooUrl.substring(0, prefix.length()).toLowerCase().equals(prefix)) {
                return null;
            }
            StringBuffer buf = new StringBuffer(prefix);
            int n = oooUrl.indexOf(47, prefix.length());
            if (n < 0) {
                n = oooUrl.length();
            }
            if ((host = oooUrl.substring(prefix.length(), n)).length() != 0 && !host.toLowerCase().equals("localhost")) {
                return null;
            }
            buf.append(host);
            if (n == oooUrl.length()) {
                buf.append('/');
            } else {
                block12: while (n < oooUrl.length()) {
                    buf.append('/');
                    int n2 = oooUrl.indexOf(47, ++n);
                    if (n2 < 0) {
                        n2 = oooUrl.length();
                    }
                    while (n < n2) {
                        char c = oooUrl.charAt(n);
                        switch (c) {
                            case '%': {
                                String s;
                                byte[] bytes = new byte[(n2 - n) / 3];
                                int len = 0;
                                while (oooUrl.length() - n > 2 && oooUrl.charAt(n) == '%') {
                                    int d1 = Character.digit(oooUrl.charAt(n + 1), 16);
                                    int d2 = Character.digit(oooUrl.charAt(n + 2), 16);
                                    if (d1 < 0 || d2 < 0) break;
                                    int d = 16 * d1 + d2;
                                    if (d == 47) {
                                        return null;
                                    }
                                    bytes[len++] = (byte)d;
                                    n += 3;
                                }
                                try {
                                    s = new String(bytes, 0, len, "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    return null;
                                }
                                buf.append(s);
                                break;
                            }
                            case '#': {
                                break block12;
                            }
                            default: {
                                buf.append(c);
                                ++n;
                                break;
                            }
                        }
                    }
                }
            }
            try {
                url = new URL(buf.toString());
            }
            catch (MalformedURLException e) {
                return null;
            }
            String path = url.getFile();
            String fragment = url.getRef();
            if (fragment != null) {
                path = path + '#' + fragment;
            }
            ret = null;
            File file = new File(path, SOFFICE);
            try {
                if (!file.isAbsolute() || !file.exists()) break block23;
                try {
                    ret = file.getCanonicalFile().getParent();
                }
                catch (IOException e) {
                    return null;
                }
            }
            catch (SecurityException e) {
                return null;
            }
        }
        return ret;
    }

    private static final class StreamGobbler
    extends Thread {
        InputStream fInStream;

        StreamGobbler(InputStream pInStream) {
            this.fInStream = pInStream;
        }

        public void run() {
            try {
                BufferedReader vBuf = new BufferedReader(new InputStreamReader(this.fInStream));
                while (vBuf.readLine() != null) {
                }
                vBuf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

