/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.oo.impl;

import com.scenari.s.co.transform.oo.HTransformerOo;
import com.scenari.s.co.transform.oo.IOoConnection;
import com.scenari.s.co.transform.oo.OoFinder;
import com.scenari.s.co.transform.oo.impl.OoConnection;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.ExternalUriReferenceTranslator;
import com.sun.star.uri.XExternalUriReferenceTranslator;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Random;

/*
 * Exception performing whole class analysis ignored.
 */
public class OoConnection
implements IOoConnection,
XEventListener {
    protected static final String LOCALHOST = "localhost";
    protected static final String LOCALIP = "127.0.0.1";
    protected static final boolean ISMAC;
    protected static final boolean ISWIN;
    protected static final String OSVERSION;
    public static boolean sDebug;
    protected String fHost = "localhost";
    protected int fPort = 8100;
    protected String fPipeName = null;
    protected boolean fAutoLaunch = true;
    protected boolean fAutoKill = false;
    protected boolean fHeadless = false;
    protected boolean fPipeMode = true;
    protected String fProfilePath = null;
    protected int fMaxCnxAttempts = -1;
    protected long fReCheckInterval = 120000L;
    protected long fTimeLastFailed = -1L;
    protected String fConnectionParams = null;
    protected XComponentContext fComponentContext = null;
    protected XMultiComponentFactory fServiceMgr = null;
    protected XComponentLoader fComponentLoader = null;
    protected XComponent fBridgeComponent;
    protected XExternalUriReferenceTranslator fExternalUriReferenceTranslator;
    protected Process fOoProcess = null;
    protected int fUsageCount = 0;
    private static OoShutdownHook sOoShutdownHook;

    public OoConnection() {
    }

    protected static synchronized void addConnectionToShutdown(OoConnection pCon) {
        if (sOoShutdownHook == null) {
            sOoShutdownHook = new OoShutdownHook();
            Runtime.getRuntime().addShutdownHook((Thread)sOoShutdownHook);
        }
        OoConnection.sOoShutdownHook.fConnectionsToShutdown.add(pCon);
    }

    protected static synchronized void removeConnectionToShutdown(OoConnection pCon) {
        if (sOoShutdownHook != null) {
            OoConnection.sOoShutdownHook.fConnectionsToShutdown.remove(pCon);
        }
    }

    public OoConnection(String pHost, int pPort) {
        this.setPort(pPort);
        this.setHost(pHost);
    }

    public OoConnection(String pPipeName) {
        this.setPipeName(pPipeName);
    }

    public boolean isLocal() {
        return this.fPipeMode || this.fHost.equals("localhost") || this.fHost.equals("127.0.0.1");
    }

    public boolean isAutoLaunch() {
        return this.fAutoLaunch;
    }

    public void setAutoLaunch(boolean pAutoLaunch) {
        this.fAutoLaunch = pAutoLaunch;
    }

    public boolean isAutoKill() {
        return this.fAutoKill;
    }

    public void setAutoKill(boolean pAutoKill) {
        this.fAutoKill = pAutoKill;
    }

    public String getHost() {
        return this.fHost;
    }

    public void setHost(String pHost) {
        this.fHost = pHost;
        if (this.fHost != null) {
            if (!this.fHost.equals("localhost") && !this.fHost.equals("127.0.0.1")) {
                this.fAutoLaunch = false;
            }
            this.fPipeMode = false;
        }
    }

    public int getMaxCnxAttempts() {
        return this.fMaxCnxAttempts;
    }

    public void setMaxCnxAttempts(int pMaxCnxAttempts) {
        this.fMaxCnxAttempts = pMaxCnxAttempts;
    }

    public long getReCheckInterval() {
        return this.fReCheckInterval;
    }

    public void setReCheckInterval(long pReCheckInterval) {
        this.fReCheckInterval = pReCheckInterval;
    }

    public boolean isPipeMode() {
        return this.fPipeMode;
    }

    public void setPipeMode(boolean pPipeMode) {
        this.fPipeMode = pPipeMode;
        if (this.fPipeMode) {
            this.fHost = null;
        } else {
            this.fPipeName = null;
        }
    }

    public void setHeadless(boolean pHeadless) {
        this.fHeadless = pHeadless;
    }

    public int getPort() {
        return this.fPort;
    }

    public void setPort(int pPort) {
        this.fPort = pPort;
    }

    public String getPipeName() {
        return this.fPipeName;
    }

    public void setPipeName(String pPipeName) {
        this.fPipeName = pPipeName;
        if (this.fPipeName != null) {
            this.fPipeMode = true;
        }
    }

    public String getProfilePath() {
        return this.fProfilePath;
    }

    public void setProfilePath(String pProfilePath) {
        this.fProfilePath = pProfilePath;
    }

    public XComponentContext getComponentContext() throws Exception {
        if (this.fComponentContext == null) {
            this.xConnect();
        }
        return this.fComponentContext;
    }

    public XMultiComponentFactory getServiceMgr() throws Exception {
        if (this.fComponentContext == null) {
            this.xConnect();
        }
        return this.fServiceMgr;
    }

    public XComponentLoader getComponentLoader() throws Exception {
        if (this.fComponentContext == null) {
            this.xConnect();
        }
        return this.fComponentLoader;
    }

    public XExternalUriReferenceTranslator getExternalUriReferenceTranslator() throws Exception {
        if (this.fComponentContext == null) {
            this.xConnect();
        }
        if (this.fExternalUriReferenceTranslator == null) {
            this.fExternalUriReferenceTranslator = ExternalUriReferenceTranslator.create((XComponentContext)this.fComponentContext);
        }
        return this.fExternalUriReferenceTranslator;
    }

    public void checkConnection() throws Exception {
        if (this.fComponentContext == null) {
            this.xConnect();
        } else {
            try {
                XDesktop vDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)this.fComponentLoader);
                vDesktop.getComponents().hasElements();
            }
            catch (Exception e) {
                LogMgr.publishTrace("Reconnection OpenOffice...", ILogMsg.LogType.Info, new String[0]);
                this.xConnect();
            }
        }
    }

    public Object createService(String pService) throws Exception {
        if (this.fComponentContext == null) {
            this.xConnect();
        }
        return this.fServiceMgr.createInstanceWithContext(pService, this.fComponentContext);
    }

    void reservedInPool() {
        ++this.fUsageCount;
    }

    void freedInPool() throws Exception {
        if (this.fAutoLaunch && this.fHeadless && this.fOoProcess != null && this.fUsageCount >= 5) {
            this.killConnection();
        }
    }

    void killConnection() throws Exception {
        if (this.fComponentLoader != null) {
            try {
                XDesktop vDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)this.fComponentLoader);
                vDesktop.terminate();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
        this.fComponentContext = null;
        this.fServiceMgr = null;
        this.fComponentLoader = null;
        if (this.fBridgeComponent != null) {
            try {
                this.fBridgeComponent.dispose();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            this.fBridgeComponent = null;
        }
        this.fExternalUriReferenceTranslator = null;
        if (this.fOoProcess != null) {
            this.fOoProcess.destroy();
            this.fOoProcess = null;
            OoConnection.removeConnectionToShutdown((OoConnection)this);
        }
        this.fUsageCount = 0;
    }

    protected void xConnect() throws Exception {
        this.fComponentContext = null;
        this.fServiceMgr = null;
        this.fComponentLoader = null;
        this.fExternalUriReferenceTranslator = null;
        if (this.fBridgeComponent != null) {
            try {
                this.fBridgeComponent.dispose();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
        this.fBridgeComponent = null;
        this.xInitServer();
        XComponentContext vLocalContext = Bootstrap.createInitialComponentContext(null);
        this.fServiceMgr = vLocalContext.getServiceManager();
        if (this.fPipeMode) {
            XMultiComponentFactory vLocalServiceManager = vLocalContext.getServiceManager();
            if (vLocalServiceManager == null) {
                throw new Exception("no initial service manager!");
            }
            XUnoUrlResolver vUrlResolver = UnoUrlResolver.create((XComponentContext)vLocalContext);
            int vAttempt = 0;
            while (true) {
                try {
                    this.fComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)vUrlResolver.resolve(this.fConnectionParams));
                }
                catch (NoConnectException e) {
                    if (vAttempt == this.fMaxCnxAttempts) {
                        this.setMaxCnxAttempts(1);
                        throw LogMgr.newException("Connection to server failed : " + this.fConnectionParams, new String[0]);
                    }
                    Thread.sleep(500L);
                    ++vAttempt;
                    continue;
                }
                break;
            }
            this.fServiceMgr = this.fComponentContext.getServiceManager();
        } else {
            XConnection vConnection;
            XConnector vConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)this.fServiceMgr.createInstanceWithContext("com.sun.star.connection.Connector", vLocalContext));
            int vAttempt = 0;
            while (true) {
                try {
                    vConnection = vConnector.connect(this.fConnectionParams);
                }
                catch (NoConnectException e) {
                    if (vAttempt == this.fMaxCnxAttempts) {
                        throw LogMgr.newException("Connection to server failed : " + this.fConnectionParams, new String[0]);
                    }
                    Thread.sleep(500L);
                    ++vAttempt;
                    continue;
                }
                break;
            }
            XBridgeFactory vBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)this.fServiceMgr.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", vLocalContext));
            XBridge vBridge = vBridgeFactory.createBridge("", "urp", vConnection, null);
            this.fBridgeComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)vBridge);
            this.fBridgeComponent.addEventListener((XEventListener)this);
            this.fServiceMgr = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)vBridge.getInstance("StarOffice.ServiceManager"));
            XPropertySet vProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.fServiceMgr);
            this.fComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)vProperties.getPropertyValue("DefaultContext"));
        }
        this.fComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.createService("com.sun.star.frame.Desktop"));
    }

    protected void xInitServer() throws Exception {
        if (this.fAutoLaunch) {
            String[] vCmdArray;
            String vOfficeExePath = OoFinder.getPath() + "/" + (ISWIN ? "soffice.exe" : (ISMAC ? "soffice.bin" : "soffice"));
            File vOfficeExe = new File(vOfficeExePath);
            if (vOfficeExe == null || !vOfficeExe.canRead()) {
                throw new Exception("no OpenOffice executable found! (searching for '" + vOfficeExePath + "')");
            }
            if (this.fMaxCnxAttempts <= 0) {
                this.fMaxCnxAttempts = ISMAC ? (vOfficeExe.getPath().toLowerCase().indexOf("neooffice") > -1 ? 120 : 60) : 100;
            }
            if (ISMAC && HTransformerOo.getOoVersionMaj() < 3 || !this.fPipeMode) {
                LogMgr.publishTrace("Starting OpenOffice in socket mode.", ILogMsg.LogType.Info, new String[0]);
                this.fConnectionParams = "socket,host=" + this.fHost + ",port=" + this.fPort + (this.isLocal() ? ",tcpNoDelay=1" : "");
                if (ISMAC && this.fPort == 8100 && this.fProfilePath == null) {
                    vCmdArray = new String[]{"/usr/bin/open", vOfficeExe.getPath().substring(0, vOfficeExe.getPath().indexOf(".app") + 4)};
                } else {
                    if (ISMAC && OSVERSION.startsWith("10.4")) {
                        LogMgr.publishTrace("MacOSX 10.4 : pre-loading OpenOffice using open command.", ILogMsg.LogType.Info, new String[0]);
                        vCmdArray = new String[]{"/usr/bin/open", vOfficeExe.getPath().substring(0, vOfficeExe.getPath().indexOf(".app") + 4)};
                        Runtime.getRuntime().exec(vCmdArray);
                        Thread.sleep(5000L);
                    }
                    String vServerParams = "-accept=socket,host=" + this.fHost + ",port=" + this.fPort + ";urp;";
                    vCmdArray = new String[8 + (this.fProfilePath == null ? 0 : 1) + (this.fHeadless ? 1 : 0)];
                    int vIdx = 0;
                    vCmdArray[vIdx++] = vOfficeExe.getPath();
                    if (this.fProfilePath != null) {
                        vCmdArray[vIdx++] = "-env:UserInstallation=".concat(this.fProfilePath);
                    }
                    if (this.fHeadless) {
                        vCmdArray[vIdx++] = "-headless";
                    }
                    vCmdArray[vIdx++] = "-nologo";
                    vCmdArray[vIdx++] = "-nodefault";
                    vCmdArray[vIdx++] = "-norestore";
                    vCmdArray[vIdx++] = "-nocrashreport";
                    vCmdArray[vIdx++] = "-nolockcheck";
                    vCmdArray[vIdx++] = "-nofirststartwizard";
                    vCmdArray[vIdx++] = vServerParams;
                }
            } else {
                LogMgr.publishTrace("Starting OpenOffice in pipe mode.", ILogMsg.LogType.Info, new String[0]);
                if (ISMAC && OSVERSION.startsWith("10.4")) {
                    LogMgr.publishTrace("MacOSX 10.4 : pre-loading OpenOffice using open command.", ILogMsg.LogType.Info, new String[0]);
                    vCmdArray = new String[]{"/usr/bin/open", vOfficeExe.getPath().substring(0, vOfficeExe.getPath().indexOf(".app") + 4)};
                    Runtime.getRuntime().exec(vCmdArray);
                    Thread.sleep(5000L);
                }
                String vPipeName = this.fPipeName != null ? this.fPipeName : "sc" + Long.toString(new Random().nextLong() & Long.MAX_VALUE);
                String vServerParams = "-accept=pipe,name=" + vPipeName + ";urp;";
                this.fConnectionParams = "uno:pipe,name=" + vPipeName + ";urp;StarOffice.ComponentContext";
                vCmdArray = new String[8 + (this.fProfilePath == null ? 0 : 1) + (this.fHeadless ? 1 : 0)];
                int vIdx = 0;
                vCmdArray[vIdx++] = vOfficeExe.getPath();
                if (this.fProfilePath != null) {
                    vCmdArray[vIdx++] = "-env:UserInstallation=".concat(this.fProfilePath);
                }
                if (this.fHeadless) {
                    vCmdArray[vIdx++] = "-headless";
                }
                vCmdArray[vIdx++] = "-nologo";
                vCmdArray[vIdx++] = "-nodefault";
                vCmdArray[vIdx++] = "-norestore";
                vCmdArray[vIdx++] = "-nocrashreport";
                vCmdArray[vIdx++] = "-nolockcheck";
                vCmdArray[vIdx++] = "-nofirststartwizard";
                vCmdArray[vIdx++] = vServerParams;
            }
            if (sDebug) {
                for (int i = 0; i < vCmdArray.length; ++i) {
                    System.out.println(vCmdArray[i]);
                }
            }
            this.fOoProcess = Runtime.getRuntime().exec(vCmdArray);
            OoConnection.addConnectionToShutdown((OoConnection)this);
            if (sDebug) {
                OoConnection.pipe((InputStream)this.fOoProcess.getInputStream(), (PrintStream)System.out, (String)"CO> ");
                OoConnection.pipe((InputStream)this.fOoProcess.getErrorStream(), (PrintStream)System.err, (String)"CE> ");
            }
            this.fUsageCount = 0;
        } else {
            if (this.fMaxCnxAttempts <= 0) {
                this.fMaxCnxAttempts = 1;
            }
            this.fConnectionParams = ISMAC || !this.fPipeMode ? "socket,host=" + this.fHost + ",port=" + this.fPort + (this.isLocal() ? ",tcpNoDelay=1" : "") : "uno:pipe,name=" + this.fPipeName + ";urp;StarOffice.ComponentContext";
        }
    }

    protected static void pipe(InputStream in, PrintStream out, String prefix) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void disposing(EventObject pArg0) {
        LogMgr.publishTrace("Oo server shutdown.", new String[0]);
        this.fComponentContext = null;
        this.fServiceMgr = null;
        this.fComponentLoader = null;
        this.fBridgeComponent = null;
        this.fExternalUriReferenceTranslator = null;
    }

    public String toString() {
        return this.fPipeMode ? "OoConnection pipe mode : " + this.fPipeName : "OoConnection socket mode : " + this.fHost + ":" + this.fPort;
    }

    static {
        String vOs = System.getProperty("os.name").toLowerCase();
        ISMAC = vOs.startsWith("mac os x");
        ISWIN = vOs.startsWith("windows");
        OSVERSION = System.getProperty("os.version").toLowerCase();
        sDebug = false;
        sOoShutdownHook = null;
    }
}

