/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.oo.impl;

import com.scenari.s.co.transform.oo.IOoConnection;
import com.scenari.s.co.transform.oo.IOoConnectionPool;
import com.scenari.s.co.transform.oo.impl.OoConnection;
import com.scenari.s.fw.utils.HLinkedList;
import java.io.File;
import java.util.regex.Pattern;

public class OoConnectionPool
implements IOoConnectionPool {
    protected static OoConnectionPool sSingleton = new OoConnectionPool();
    protected File fLocalTempDir = null;
    protected Pattern fLocalToDistPathRegex = null;
    protected String fLocalToDistPathRepl = null;
    protected int fTotalConnections = 0;
    protected HLinkedList fPool = new HLinkedList();
    protected HLinkedList fPoolFailed = new HLinkedList();

    public static OoConnectionPool get() {
        return sSingleton;
    }

    public synchronized void addConnectionToPool(IOoConnection pConn) {
        this.fPool.addLast(pConn);
        ++this.fTotalConnections;
        this.notify();
    }

    public IOoConnection createConnection() {
        return new OoConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OoConnection getConnection() throws Exception {
        OoConnection vCon;
        block19: {
            vCon = null;
            OoConnectionPool ooConnectionPool = this;
            synchronized (ooConnectionPool) {
                if (this.fTotalConnections == 0) {
                    this.fPool.addLast(this.createConnection());
                    ++this.fTotalConnections;
                }
                while (this.fPool.size() == 0) {
                    HLinkedList hLinkedList = this.fPoolFailed;
                    synchronized (hLinkedList) {
                        if (this.fPoolFailed.size() > 0) {
                            long vCurrTime = System.currentTimeMillis();
                            for (int i = 0; i < this.fPoolFailed.size(); ++i) {
                                vCon = (OoConnection)this.fPoolFailed.get(i);
                                if (vCon.fTimeLastFailed + vCon.getReCheckInterval() >= vCurrTime) continue;
                                break block19;
                            }
                        }
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                vCon = (OoConnection)this.fPool.removeFirst();
            }
        }
        while (true) {
            try {
                vCon.checkConnection();
            }
            catch (Exception e) {
                int vCountFailed;
                vCon.fTimeLastFailed = System.currentTimeMillis();
                HLinkedList hLinkedList = this.fPoolFailed;
                synchronized (hLinkedList) {
                    this.fPoolFailed.addLast(vCon);
                    vCountFailed = this.fPoolFailed.size();
                }
                if (this.fTotalConnections > vCountFailed) {
                    vCon = this.getConnection();
                    continue;
                }
                throw e;
            }
            break;
        }
        vCon.reservedInPool();
        return vCon;
    }

    public synchronized void releaseConnection(OoConnection pConnection) throws Exception {
        pConnection.freedInPool();
        this.fPool.addLast(pConnection);
        this.notify();
    }

    public File getLocalTempDir() {
        return this.fLocalTempDir;
    }

    public void setLocaltempDir(String pLocalTempDir) throws Exception {
        this.fLocalTempDir = pLocalTempDir != null ? new File(pLocalTempDir).getCanonicalFile() : null;
    }

    public Pattern getLocalToDistPathRegex() {
        return this.fLocalToDistPathRegex;
    }

    public void setLocalToDistPathRegex(String pLocalToDistPathRegex) {
        this.fLocalToDistPathRegex = pLocalToDistPathRegex != null ? Pattern.compile(pLocalToDistPathRegex) : null;
    }

    public String getLocalToDistPathRepl() {
        return this.fLocalToDistPathRepl;
    }

    public void setLocalToDistPathRepl(String pLocalToDistPathRepl) {
        this.fLocalToDistPathRepl = pLocalToDistPathRepl;
    }
}

