/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.oo.impl;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.co.transform.oo.HTransformerOo;
import com.scenari.s.co.transform.oo.impl.OoConnection;
import com.scenari.s.co.transform.oo.impl.OoConnectionPool;
import com.scenari.s.co.transform.oo.impl.OoRes;
import com.scenari.s.co.transform.oo.impl.OoSrc;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloseable;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mime.MimeMgr;
import java.io.File;

public class TransformerExport
extends HTransformer {
    protected String fFilterName = null;
    protected String fMimeType = null;
    protected String fExtension = null;
    public static final String PARAM_FILTERPARAMS = "filterParams";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        XComponent vDocSrc = null;
        OoSrc vSrc = OoSrc.getOoSrc((Object)pSrc);
        OoRes vRes = new OoRes(pRes);
        OoConnection vCon = OoConnectionPool.get().getConnection();
        try {
            XComponentLoader vCompLoader = vCon.getComponentLoader();
            String vUrl = vSrc.getInternalOoUri(vCon);
            PropertyValue[] vProps = new PropertyValue[2];
            vProps[0] = new PropertyValue();
            vProps[0].Name = "Hidden";
            vProps[0].Value = Boolean.TRUE;
            vProps[1] = new PropertyValue();
            vProps[1].Name = "ReadOnly";
            vProps[1].Value = Boolean.TRUE;
            vDocSrc = vCompLoader.loadComponentFromURL(vUrl, "_blank", 0, vProps);
            long vOdFileSize = vSrc.getAsFile().length();
            long vTimeMs = vOdFileSize * (long)HTransformerOo.sOoLoadWaitFactor / 1000L;
            Thread.sleep(vTimeMs);
            XStorable vStorableDoc = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)vDocSrc);
            String vFilterParamsStr = this.getFilterParams(pParams);
            PropertyValue[] vFilterParams = this.xGetFilterParams(vFilterParamsStr);
            vProps = new PropertyValue[vFilterParams != null ? 3 : 2];
            vProps[0] = new PropertyValue();
            vProps[0].Name = "Overwrite";
            vProps[0].Value = Boolean.TRUE;
            vProps[1] = new PropertyValue();
            vProps[1].Name = "FilterName";
            vProps[1].Value = this.fFilterName;
            if (vFilterParams != null) {
                vProps[2] = new PropertyValue();
                vProps[2].Name = "FilterData";
                vProps[2].Value = vFilterParams;
            }
            vStorableDoc.storeToURL(vRes.getInternalOoUri(vCon), vProps);
        }
        catch (Exception e) {
            try {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation d'une ressource OpenDocument.", new String[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (vDocSrc == null) throw throwable;
                    XCloseable vCloseableDoc = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, vDocSrc);
                    if (vCloseableDoc != null) {
                        vCloseableDoc.close(false);
                        throw throwable;
                    }
                    XComponent vCompDoc = (XComponent)UnoRuntime.queryInterface(XComponent.class, vDocSrc);
                    vCompDoc.dispose();
                    throw throwable;
                }
                finally {
                    OoConnectionPool.get().releaseConnection(vCon);
                    vSrc.close();
                }
            }
        }
        try {
            if (vDocSrc == null) return;
            XCloseable vCloseableDoc = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)vDocSrc);
            if (vCloseableDoc != null) {
                vCloseableDoc.close(false);
                return;
            }
            XComponent vCompDoc = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)vDocSrc);
            vCompDoc.dispose();
            return;
        }
        finally {
            OoConnectionPool.get().releaseConnection(vCon);
            vSrc.close();
        }
    }

    private PropertyValue[] xGetFilterParams(String pParams) {
        if (pParams != null && pParams.length() > 0) {
            String[] vParamList = pParams.split("\\|");
            PropertyValue[] vParamListFilter = new PropertyValue[vParamList.length];
            for (int i = 0; i < vParamList.length; ++i) {
                String[] vParam = vParamList[i].split(":");
                if (vParam[2].compareTo("boolean") == 0) {
                    vParamListFilter[i] = new PropertyValue();
                    vParamListFilter[i].Name = vParam[0];
                    vParamListFilter[i].Value = Boolean.parseBoolean(vParam[1]);
                    continue;
                }
                if (vParam[2].compareTo("integer") == 0) {
                    vParamListFilter[i] = new PropertyValue();
                    vParamListFilter[i].Name = vParam[0];
                    vParamListFilter[i].Value = Integer.parseInt(vParam[1]);
                    continue;
                }
                if (vParam[2].compareTo("long") == 0) {
                    vParamListFilter[i] = new PropertyValue();
                    vParamListFilter[i].Name = vParam[0];
                    vParamListFilter[i].Value = Long.parseLong(vParam[1]);
                    continue;
                }
                vParamListFilter[i] = new PropertyValue();
                vParamListFilter[i].Name = vParam[0];
                vParamListFilter[i].Value = vParam[1];
            }
            return vParamListFilter;
        }
        return null;
    }

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return OoSrc.isSrcAllowed((Class)pClassSrc, (HTransformParams)pParams);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return OoRes.isResAllowed((Class)pClassRes, (HTransformParams)pParams);
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        if (this.fMimeType == null && this.fExtension != null) {
            this.fMimeType = MimeMgr.getDefaultMimeMgr().searchMimeFromExt(this.fExtension);
        }
        return this.fMimeType;
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        if (this.fExtension == null && this.fMimeType != null) {
            this.fExtension = MimeMgr.getDefaultMimeMgr().searchExtFromMime(this.fMimeType);
        }
        return this.fExtension;
    }

    protected String getFilterParams(HTransformParams pParams) {
        String pFilterParams = pParams.hGetValueParam(PARAM_FILTERPARAMS);
        if (pFilterParams != null && pFilterParams.length() > 0) {
            return pFilterParams;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] pArgs) {
        try {
            TransformerExport vTransf = new TransformerExport();
            vTransf.wSetProperty("filterName", pArgs[2]);
            vTransf.hTransform((Object)new File(pArgs[0]), (Object)new File(pArgs[1]), HTransformParams.hNewParamsTransformByQueryString("transform=od2x", "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public void wSetProperty(String pKey, String pValue) {
        if (pKey.equals("filterName")) {
            this.fFilterName = pValue;
        } else if (pKey.equals("mimeType")) {
            this.fMimeType = pValue;
        } else if (pKey.equals("extension")) {
            this.fExtension = pValue;
        }
    }
}

