/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.oo.impl;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.img.ImgUtil;
import com.scenari.s.co.transform.oo.impl.TransformerExport;
import com.sun.star.awt.Size;
import eu.scenari.fw.log.LogMgr;
import java.io.File;

public class TransformerExportImgBase
extends TransformerExport {
    public static final String PARAM_MAXWIDTH = "maxWidth";
    public static final String PARAM_MAXHEIGHT = "maxHeight";
    public static final String PARAM_MINWIDTH = "minWidth";
    public static final String PARAM_MINHEIGHT = "minHeight";
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_ALLOWROTATION = "allowRotation";
    public static final String PARAM_BG = "backgroundColor";
    protected int fMarginTop = 15;
    protected int fMarginRight = 15;
    protected int fMarginBottom = 15;
    protected int fMarginLeft = 15;

    protected int parseDim(String pDim, int pDefault) {
        if (pDim != null && pDim.length() > 0) {
            try {
                if (pDim.endsWith("cm")) {
                    return Math.round(Float.parseFloat(pDim.substring(0, pDim.length() - 2)) * 1000.0f);
                }
                if (pDim.endsWith("px")) {
                    return (int)Math.round((double)Float.parseFloat(pDim.substring(0, pDim.length() - 2)) * 26.4);
                }
                if (pDim.endsWith("mm")) {
                    return Math.round(Float.parseFloat(pDim.substring(0, pDim.length() - 2)) * 100.0f);
                }
                return (int)Math.round((double)Float.parseFloat(pDim) * 26.4);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Parsing maxHeight failed : " + pDim, new String[0]);
            }
        }
        return pDefault;
    }

    protected int getMaxWidth(HTransformParams pParams, int pSystemMax) {
        return Math.max(Math.min(this.parseDim(pParams.hGetValueParam(PARAM_MAXWIDTH), pSystemMax), pSystemMax), 1);
    }

    protected int getMaxHeight(HTransformParams pParams, int pSystemMax) {
        return Math.max(Math.min(this.parseDim(pParams.hGetValueParam(PARAM_MAXHEIGHT), pSystemMax), pSystemMax), 1);
    }

    protected int getMinWidth(HTransformParams pParams, int pSystemMax) {
        return Math.max(Math.min(this.parseDim(pParams.hGetValueParam(PARAM_MINWIDTH), 1), pSystemMax), 1);
    }

    protected int getMinHeight(HTransformParams pParams, int pSystemMax) {
        return Math.max(Math.min(this.parseDim(pParams.hGetValueParam(PARAM_MINHEIGHT), 1), pSystemMax), 1);
    }

    protected float getScale(HTransformParams pParams) {
        String pScale = pParams.hGetValueParam(PARAM_SCALE);
        if (pScale != null && pScale.length() > 0) {
            try {
                return Float.parseFloat(pScale);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Parsing scale failed : " + pScale, new String[0]);
            }
        }
        return 1.0f;
    }

    protected Integer getBg(HTransformParams pParams) {
        String pBg = pParams.hGetValueParam(PARAM_BG);
        if (pBg != null && pBg.length() > 0) {
            try {
                return Integer.decode(pBg);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Parsing backgound failed : " + pBg, new String[0]);
            }
        }
        return null;
    }

    protected boolean getAllowRotation(HTransformParams pParams) {
        String pAllowRotation = pParams.hGetValueParam(PARAM_ALLOWROTATION);
        return pAllowRotation != null && pAllowRotation.equalsIgnoreCase("true");
    }

    protected boolean applyScale(HTransformParams pParams, Size pSize, boolean pRotationImpl) {
        int vTmpW;
        float vScale = this.getScale(pParams);
        int vMinW = this.getMinWidth(pParams, 54067);
        int vMinH = this.getMinHeight(pParams, 54067);
        int vMaxW = this.getMaxWidth(pParams, 54067);
        int vMaxH = this.getMaxHeight(pParams, 54067);
        boolean vRotate = false;
        if (pRotationImpl && this.getAllowRotation(pParams) && ImgUtil.isRotatePrefered(pSize.Width, pSize.Height, vScale, vMinW, vMinH, vMaxW, vMaxH)) {
            vRotate = true;
            vTmpW = pSize.Width;
            pSize.Width = pSize.Height;
            pSize.Height = vTmpW;
        }
        if (vScale != 1.0f && vScale > 0.0f) {
            pSize.Height = Math.round((float)pSize.Height * vScale);
            pSize.Width = Math.round((float)pSize.Width * vScale);
        }
        if (pSize.Width < vMinW) {
            pSize.Height = (int)((double)pSize.Height * (double)vMinW) / pSize.Width;
            pSize.Width = vMinW;
        }
        if (pSize.Height < vMinH) {
            pSize.Width = (int)((double)pSize.Width * (double)vMinH) / pSize.Height;
            pSize.Height = vMinH;
        }
        if (pSize.Width > vMaxW) {
            pSize.Height = (int)((double)pSize.Height * (double)vMaxW) / pSize.Width;
            pSize.Width = vMaxW;
        }
        if (pSize.Height > vMaxH) {
            pSize.Width = (int)((double)pSize.Width * (double)vMaxH) / pSize.Height;
            pSize.Height = vMaxH;
        }
        if (vRotate) {
            vTmpW = pSize.Width;
            pSize.Width = pSize.Height;
            pSize.Height = vTmpW;
        }
        return vRotate;
    }

    public int getMarginBottom(HTransformParams pParams) {
        return this.fMarginBottom;
    }

    public int getMarginLeft(HTransformParams pParams) {
        return this.fMarginLeft;
    }

    public int getMarginRight(HTransformParams pParams) {
        return this.fMarginRight;
    }

    public int getMarginTop(HTransformParams pParams) {
        return this.fMarginTop;
    }

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassSrc);
    }
}

