/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.xml;

import com.bluecast.xml.Piccolo;
import com.scenari.entitymap.GeneralEntitiesMap;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.xerces.serialize.OutputFormat;
import com.scenari.xerces.serialize.impl.XMLSerializer;
import eu.scenari.fw.log.LogMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class HTransformerXml
extends HTransformer {
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_INDENT = "indent";
    public static final String PARAM_OMIT_XML_DECLARATION = "omitXmlDeclaration";
    public static final String PARAM_FORCE_DOCTYPE = "forceDoctype";
    public static final String PARAM_DOCTYPE_SYSTEM = "doctypeSystem";
    public static final String PARAM_DOCTYPE_PUBLIC = "doctypePublic";
    public static final String PARAM_OMIT_DOCTYPE = "omitDoctype";
    public static final String PARAM_FILE_EXTENSION = "fileExt";
    public static final String PARAM_MIME_TYPE = "mimeType";
    public static final String VALUE_YES = "yes";
    protected List fListEntitiesUrl = null;
    protected GeneralEntitiesMap fEntities = null;

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassSrc) || InputStream.class.isAssignableFrom(pClassSrc);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes) || OutputStream.class.isAssignableFrom(pClassRes);
    }

    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        InputStream vInput;
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        this.xAddEntities(vXmlReader);
        if (pSrc instanceof InputStream) {
            vInput = (InputStream)pSrc;
        } else {
            File vSrc = (File)pSrc;
            if (vSrc.isDirectory()) {
                vSrc = new File(vSrc, vSrc.getName());
            }
            vInput = new FileInputStream(vSrc);
        }
        try {
            try {
                OutputStream vResult = null;
                vResult = pRes instanceof OutputStream ? (OutputStream)pRes : new FileOutputStream((File)pRes);
                XMLSerializer vSer = new XMLSerializer(vResult, HTransformerXml.xCreateOuputFormat(pParams));
                boolean vForceDocType = false;
                String vVal = pParams.hGetValueParam(PARAM_FORCE_DOCTYPE);
                if (vVal != null && VALUE_YES.equals(vVal)) {
                    vForceDocType = true;
                }
                vXmlReader.setContentHandler(vSer);
                if (vForceDocType) {
                    vXmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", new XLexicalHandlerWithOutDtd(vSer));
                } else {
                    vXmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", vSer);
                    vXmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", vSer);
                }
                vXmlReader.parse(new InputSource(vInput));
            }
            catch (Exception e) {
                vInput.close();
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation XML.", new String[0]);
            }
            Object var11_11 = null;
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
            throw throwable;
        }
    }

    public static OutputFormat xCreateOuputFormat(HTransformParams pParams) {
        OutputFormat vOutputFormat = new OutputFormat("xml", "UTF-8", true);
        String vVal = pParams.hGetValueParam(PARAM_ENCODING);
        if (vVal != null) {
            vOutputFormat.setEncoding(vVal);
        }
        if ((vVal = pParams.hGetValueParam(PARAM_INDENT)) != null) {
            int vIndent = 4;
            try {
                vIndent = Integer.parseInt(vVal);
            }
            catch (Exception e) {
                // empty catch block
            }
            vOutputFormat.setIndent(vIndent);
        }
        if ((vVal = pParams.hGetValueParam(PARAM_OMIT_XML_DECLARATION)) != null && VALUE_YES.equals(vVal)) {
            vOutputFormat.setOmitXMLDeclaration(true);
        }
        if ((vVal = pParams.hGetValueParam(PARAM_OMIT_DOCTYPE)) != null && VALUE_YES.equals(vVal)) {
            vOutputFormat.setOmitDocumentType(true);
        }
        vVal = pParams.hGetValueParam(PARAM_DOCTYPE_PUBLIC);
        String vVal2 = pParams.hGetValueParam(PARAM_DOCTYPE_SYSTEM);
        if (vVal != null || vVal2 != null) {
            vOutputFormat.setDoctype(vVal, vVal2);
        }
        return vOutputFormat;
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        String vMime = pParams.hGetValueParam(PARAM_MIME_TYPE);
        if (vMime != null) {
            return vMime;
        }
        return "text/xml";
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        String vExt = pParams.hGetValueParam(PARAM_FILE_EXTENSION);
        if (vExt != null) {
            return vExt;
        }
        return ".xml";
    }

    protected void xAddEntities(XMLReader pReader) throws Exception {
        if (this.fEntities == null && this.fListEntitiesUrl != null) {
            if (this.fEntities == null) {
                this.fEntities = new GeneralEntitiesMap();
            }
            for (int i = 0; i < this.fListEntitiesUrl.size(); ++i) {
                this.fEntities.readMap(((URL)this.fListEntitiesUrl.get(i)).openStream());
            }
        }
        if (this.fEntities != null) {
            ((Piccolo)pReader).setDefaultGeneralEntityMap(this.fEntities);
        }
    }

    public void wSetProperty(String pKey, URL pUrl) {
        if (pKey.equals("entities")) {
            if (this.fListEntitiesUrl == null) {
                this.fListEntitiesUrl = new ArrayList(3);
            }
            this.fListEntitiesUrl.add(pUrl);
        }
    }

    public static void main(String[] pArgs) {
        try {
            HTransformerXml vTrsf = new HTransformerXml();
            vTrsf.wSetProperty("entities", new URL("file:///C:/entities.properties"));
            HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString("transform=xml&indent=0&omitDoctype=yes&encoding=ISO-8859-1", "UTF-8");
            vTrsf.hTransform(new File("C:\\entitiesSourceXml.xml"), new File("C:\\entitiesResultXml.xml"), vParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class XLexicalHandlerWithOutDtd
    implements LexicalHandler {
        LexicalHandler fDest = null;

        public XLexicalHandlerWithOutDtd(LexicalHandler pDest) {
            this.fDest = pDest;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.fDest.comment(ch, start, length);
        }

        public void endCDATA() throws SAXException {
            this.fDest.endCDATA();
        }

        public void endDTD() throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
            this.fDest.endEntity(name);
        }

        public void startCDATA() throws SAXException {
            this.fDest.startCDATA();
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
            this.fDest.startEntity(name);
        }
    }
}

